/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file YearDateAxisAttributes.cc
    \brief Implemtation of YearDateAxis Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Mon Oct 26 20:27:36 2009
*/    

#include "YearDateAxisAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


YearDateAxisAttributes::YearDateAxisAttributes():
	colour_(Translator<string, Colour>().magics("axis_years_label_colour")),
	quality_(ParameterManager::getString("axis_years_label_quality")),
	height_(ParameterManager::getDouble("axis_years_label_height"))
{
} 



YearDateAxisAttributes::~YearDateAxisAttributes()
{
}

    
void YearDateAxisAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	prefix[0] = "axis_years";
	prefix[1] = "axis";

	setAttribute(prefix, "axis_years_label_colour", colour_, params);
	setAttribute(prefix, "axis_years_label_quality", quality_, params);
	setAttribute(prefix, "axis_years_label_height", height_, params);
}

void YearDateAxisAttributes::copy(const YearDateAxisAttributes& other)
{
	setColour(other.colour_->clone());
	quality_ = other.quality_;
	height_ = other.height_;
} 


bool YearDateAxisAttributes::accept(const string& node)
{	
	if ( magCompare(node, "year")  )
		return true;
	return false;
}

void YearDateAxisAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "year") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void YearDateAxisAttributes::print(ostream& out)  const
{
	out << "YearDateAxisAttributes[";
	out << "colour = " << *colour_;
	out << ", quality = " << quality_;
	out << ", height = " << height_;
	out << "]" << "\n";
}


void YearDateAxisAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\taxis_years_label_colour = \'" << *colour_ << "\'\n";
	out << tab << "\taxis_years_label_quality = \'" << quality_ << "\'\n";
	out << tab << "\taxis_years_label_height = \'" << height_ << "\'\n";
	out << tab << ">";


	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<string> axis_years_label_colour("axis_years_label_colour", "automatic", " New Magics: Parameter axis_years_label_ colour sent to new Magics[XYSystem].  ");
static MagicsParameter<string> axis_years_label_quality("axis_years_label_quality", "medium ", " New Magics: Parameter axis_years_label_quality sent to new Magics[XYSystem].  ");
static MagicsParameter<double> axis_years_label_height("axis_years_label_height", 0.2, " New Magics: Parameter axis_hours_label_ height sent to new Magics[XYSystem].  ");
