/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file EpsGraphAttributes.cc
    \brief Implemtation of EpsGraph Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Mon Oct 26 20:27:33 2009
*/    

#include "EpsGraphAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


EpsGraphAttributes::EpsGraphAttributes():
	font_(ParameterManager::getString("eps_font")),
	font_size_(ParameterManager::getDouble("eps_font_size")),
	font_style_(ParameterManager::getString("eps_font_style")),
	font_colour_(Translator<string, Colour>().magics("eps_font_colour")),
	colour_(Translator<string, Colour>().magics("eps_box_colour")),
	right_colour_(Translator<string, Colour>().magics("eps_right_box_colour")),
	left_colour_(Translator<string, Colour>().magics("eps_left_box_colour")),
	border_colour_(Translator<string, Colour>().magics("eps_box_border_colour")),
	border_thickness_(ParameterManager::getInt("eps_box_border_thickness")),
	median_thickness_(ParameterManager::getInt("eps_box_median_thickness")),
	median_colour_(Translator<string, Colour>().magics("eps_box_median_colour")),
	max_(ParameterManager::getDouble("eps_maximum")),
	max_font_name_(ParameterManager::getString("eps_maximum_font_name")),
	max_font_style_(ParameterManager::getString("eps_maximum_font_style")),
	max_font_size_(ParameterManager::getDouble("eps_maximum_font_size")),
	max_font_colour_(Translator<string, Colour>().magics("eps_maximum_font_colour")),
	box_width_(ParameterManager::getDouble("eps_box_width")),
	whisker_(Translator<string, bool>().magics("eps_whisker")),
	deterministic_(Translator<string, bool>().magics("eps_deterministic")),
	legend_resolution_(ParameterManager::getString("eps_legend_resolution")),
	legend_control_text_(ParameterManager::getString("eps_legend_control_text")),
	legend_forecast_text_(ParameterManager::getString("eps_legend_forecast_text"))
{
} 



EpsGraphAttributes::~EpsGraphAttributes()
{
}

    
void EpsGraphAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	prefix[0] = "eps";

	setAttribute(prefix, "eps_font", font_, params);
	setAttribute(prefix, "eps_font_size", font_size_, params);
	setAttribute(prefix, "eps_font_style", font_style_, params);
	setAttribute(prefix, "eps_font_colour", font_colour_, params);
	setAttribute(prefix, "eps_box_colour", colour_, params);
	setAttribute(prefix, "eps_right_box_colour", right_colour_, params);
	setAttribute(prefix, "eps_left_box_colour", left_colour_, params);
	setAttribute(prefix, "eps_box_border_colour", border_colour_, params);
	setAttribute(prefix, "eps_box_border_thickness", border_thickness_, params);
	setAttribute(prefix, "eps_box_median_thickness", median_thickness_, params);
	setAttribute(prefix, "eps_box_median_colour", median_colour_, params);
	setAttribute(prefix, "eps_maximum", max_, params);
	setAttribute(prefix, "eps_maximum_font_name", max_font_name_, params);
	setAttribute(prefix, "eps_maximum_font_style", max_font_style_, params);
	setAttribute(prefix, "eps_maximum_font_size", max_font_size_, params);
	setAttribute(prefix, "eps_maximum_font_colour", max_font_colour_, params);
	setAttribute(prefix, "eps_box_width", box_width_, params);
	setAttribute(prefix, "eps_whisker", whisker_, params);
	setAttribute(prefix, "eps_deterministic", deterministic_, params);
	setAttribute(prefix, "eps_legend_resolution", legend_resolution_, params);
	setAttribute(prefix, "eps_legend_control_text", legend_control_text_, params);
	setAttribute(prefix, "eps_legend_forecast_text", legend_forecast_text_, params);
}

void EpsGraphAttributes::copy(const EpsGraphAttributes& other)
{
	font_ = other.font_;
	font_size_ = other.font_size_;
	font_style_ = other.font_style_;
	setFont_colour(other.font_colour_->clone());
	setColour(other.colour_->clone());
	setRight_colour(other.right_colour_->clone());
	setLeft_colour(other.left_colour_->clone());
	setBorder_colour(other.border_colour_->clone());
	border_thickness_ = other.border_thickness_;
	median_thickness_ = other.median_thickness_;
	setMedian_colour(other.median_colour_->clone());
	max_ = other.max_;
	max_font_name_ = other.max_font_name_;
	max_font_style_ = other.max_font_style_;
	max_font_size_ = other.max_font_size_;
	setMax_font_colour(other.max_font_colour_->clone());
	box_width_ = other.box_width_;
	whisker_ = other.whisker_;
	deterministic_ = other.deterministic_;
	legend_resolution_ = other.legend_resolution_;
	legend_control_text_ = other.legend_control_text_;
	legend_forecast_text_ = other.legend_forecast_text_;
} 


bool EpsGraphAttributes::accept(const string& node)
{	
	if ( magCompare(node, "epsgraph")  )
		return true;
	return false;
}

void EpsGraphAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "epsgraph") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void EpsGraphAttributes::print(ostream& out)  const
{
	out << "EpsGraphAttributes[";
	out << "font = " << font_;
	out << ", font_size = " << font_size_;
	out << ", font_style = " << font_style_;
	out << ", font_colour = " << *font_colour_;
	out << ", colour = " << *colour_;
	out << ", right_colour = " << *right_colour_;
	out << ", left_colour = " << *left_colour_;
	out << ", border_colour = " << *border_colour_;
	out << ", border_thickness = " << border_thickness_;
	out << ", median_thickness = " << median_thickness_;
	out << ", median_colour = " << *median_colour_;
	out << ", max = " << max_;
	out << ", max_font_name = " << max_font_name_;
	out << ", max_font_style = " << max_font_style_;
	out << ", max_font_size = " << max_font_size_;
	out << ", max_font_colour = " << *max_font_colour_;
	out << ", box_width = " << box_width_;
	out << ", whisker = " << whisker_;
	out << ", deterministic = " << deterministic_;
	out << ", legend_resolution = " << legend_resolution_;
	out << ", legend_control_text = " << legend_control_text_;
	out << ", legend_forecast_text = " << legend_forecast_text_;
	out << "]" << "\n";
}


void EpsGraphAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\teps_font = \'" << font_ << "\'\n";
	out << tab << "\teps_font_size = \'" << font_size_ << "\'\n";
	out << tab << "\teps_font_style = \'" << font_style_ << "\'\n";
	out << tab << "\teps_font_colour = \'" << *font_colour_ << "\'\n";
	out << tab << "\teps_box_colour = \'" << *colour_ << "\'\n";
	out << tab << "\teps_right_box_colour = \'" << *right_colour_ << "\'\n";
	out << tab << "\teps_left_box_colour = \'" << *left_colour_ << "\'\n";
	out << tab << "\teps_box_border_colour = \'" << *border_colour_ << "\'\n";
	out << tab << "\teps_box_border_thickness = \'" << border_thickness_ << "\'\n";
	out << tab << "\teps_box_median_thickness = \'" << median_thickness_ << "\'\n";
	out << tab << "\teps_box_median_colour = \'" << *median_colour_ << "\'\n";
	out << tab << "\teps_maximum = \'" << max_ << "\'\n";
	out << tab << "\teps_maximum_font_name = \'" << max_font_name_ << "\'\n";
	out << tab << "\teps_maximum_font_style = \'" << max_font_style_ << "\'\n";
	out << tab << "\teps_maximum_font_size = \'" << max_font_size_ << "\'\n";
	out << tab << "\teps_maximum_font_colour = \'" << *max_font_colour_ << "\'\n";
	out << tab << "\teps_box_width = \'" << box_width_ << "\'\n";
	out << tab << "\teps_whisker = \'" << whisker_ << "\'\n";
	out << tab << "\teps_deterministic = \'" << deterministic_ << "\'\n";
	out << tab << "\teps_legend_resolution = \'" << legend_resolution_ << "\'\n";
	out << tab << "\teps_legend_control_text = \'" << legend_control_text_ << "\'\n";
	out << tab << "\teps_legend_forecast_text = \'" << legend_forecast_text_ << "\'\n";
	out << tab << ">";


	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<string> eps_font("eps_font", "sansserif", "");
static MagicsParameter<double> eps_font_size("eps_font_size", 0.25, "");
static MagicsParameter<string> eps_font_style("eps_font_style", "", "");
static MagicsParameter<string> eps_font_colour("eps_font_colour", "blue", "");
static MagicsParameter<string> eps_box_colour("eps_box_colour", "cyan", "");
static MagicsParameter<string> eps_right_box_colour("eps_right_box_colour", "red", "");
static MagicsParameter<string> eps_left_box_colour("eps_left_box_colour", "blue", "");
static MagicsParameter<string> eps_box_border_colour("eps_box_border_colour", "black", "");
static MagicsParameter<int> eps_box_border_thickness("eps_box_border_thickness", 3, "");
static MagicsParameter<int> eps_box_median_thickness("eps_box_median_thickness", 3, "");
static MagicsParameter<string> eps_box_median_colour("eps_box_median_colour", "black", "");
static MagicsParameter<double> eps_maximum("eps_maximum", int_MAX, "");
static MagicsParameter<string> eps_maximum_font_name("eps_maximum_font_name", "sansserif", "");
static MagicsParameter<string> eps_maximum_font_style("eps_maximum_font_style", "normal", "");
static MagicsParameter<double> eps_maximum_font_size("eps_maximum_font_size", 0.25, "");
static MagicsParameter<string> eps_maximum_font_colour("eps_maximum_font_colour", "red", "");
static MagicsParameter<double> eps_box_width("eps_box_width", -1, "");
static MagicsParameter<string> eps_whisker("eps_whisker", "on", "");
static MagicsParameter<string> eps_deterministic("eps_deterministic", "on", "");
static MagicsParameter<string> eps_legend_resolution("eps_legend_resolution", "truncature", "");
static MagicsParameter<string> eps_legend_control_text("eps_legend_control_text", "", "");
static MagicsParameter<string> eps_legend_forecast_text("eps_legend_forecast_text", "", "");
