#ifndef MagPlus_H
#define MagPlus_H

#include <magics.h>
#include "DriverManager.h"
#include "OutputHandler.h"
#include "RootSceneNode.h"
#include "MagicsEvent.h"

#include "Metview.h" 

namespace magics {

class MagPlus : public stack<BasicSceneObject*>, 
	public OpenGLDriverObserver
{
public:
	MagPlus();
//	void serve(MvRequest&,MvRequest&, Widget, Widget);
	void serve(MvRequest&,MvRequest&);
        void execute(MvRequest&,MvRequest&);

        void registerObserver(MagicsObserver* observer) { observers_.push_back(observer); }
        void unregisterObserver(MagicsObserver* observer);
    
   	void tooltip(const SelectionMode& properties) { drivers_.dispatch(&BaseDriver::tooltip, properties); }
	//! Selection of Interactive mode: pointSelection : user callback called when a point is selected. 
	void pointSelection(const SelectionMode& properties) { drivers_.dispatch(&BaseDriver::pointSelection, properties);}
	//! Selection of Interactive mode: areaSelection : user callback called when an area is selected.
	void areaSelection(const SelectionMode& properties) { drivers_.dispatch(&BaseDriver::areaSelection, properties);}	
	//! Selection of Interactive mode: polygoneSelection : user callback called when a polygone is selected.
	void polygonSelection(const SelectionMode& properties) { drivers_.dispatch(&BaseDriver::polygonSelection, properties);}	
	//! Selection of Interactive mode: lineSelection : user callback called when a line is selected.
	void lineSelection(const SelectionMode& properties) { drivers_.dispatch(&BaseDriver::lineSelection, properties);}
	//! Selection of Interactive mode: polylineSelection : user callback called when a line is selected.
	void polylineSelection(const SelectionMode& properties) { drivers_.dispatch(&BaseDriver::polylineSelection, properties);}
	//! Selection of Interactive mode: polylineSelection : user callback called when a line is selected.
	void pickSelection(const SelectionMode& properties) { drivers_.dispatch(&BaseDriver::pickSelection, properties);}
	void noModes() {  drivers_.dispatch(&BaseDriver::noModes); }
			
	//! Input event handling
	void inputEvent(MtInputEvent* ev) { drivers_.dispatch(&BaseDriver::inputEvent,ev); }
	
	//! Notify drivers about an event (GUI -> OpenGL)
	void notifyDrivers(MagicsEvent& event) { drivers_.dispatch(&MagicsEvent::notify, event); }

	//! Notify the magicsobservers about an event in the OpenGLDriverObserver (OpenGL -> GUI)
	void notify(MagicsEvent&);

        // OpenGLObserver interface;
        //! Method called when the Widget is ready to receive and display
	// Graphical Object 
	virtual void ready();

	virtual void update();
	

	//! Method called when the Widget needs to receive the graphical tree again. 
	virtual void redraw();

	//! Method called in ToolTipMode :  x and y are in magics coordinates
	virtual void tooltip(SelectionObject*);
	//! Method called in PointSelectionMode  :  x and y are in magics coordinates
	virtual void pointSelection(SelectionObject*);
	//! Method called in AreaSelectionMode  :  x and y are in magics coordinates
	virtual void areaSelection(SelectionObject*);
	//! Method called in LineSelectionMode  :  x and y are in magics coordinates
	virtual void lineSelection(SelectionObject*);
	//! Method called in polygoneSelectionMode  :  x's and y's are in magics coordinates
	virtual void polygonSelection(SelectionObject*);
	//! Method called in polylineSelectionMode  :  x's and y's are in magics coordinates
	virtual void polylineSelection(SelectionObject*);
	virtual void selection(SelectionObject*);
        virtual void zoomSelection(SelectionObject*);
        virtual void zoomLevelSelection(SelectionObject*);
    
	//! Method called after input x and y are in user coordinates 
	//virtual void input(const string& area, float x, float y, BoxInfo* = 0);

	//! method called after a resize
	virtual void resize( float width, float height);	

protected:
    vector<MagicsObserver*> observers_;

    typedef bool (MagPlus::*ObjectCreator)(MvRequest&);
 
	static map<string,  ObjectCreator > driverCreators_;
    static map<string,  ObjectCreator > sceneCreators_;
	
    bool page(MvRequest&);
	bool superpage(MvRequest&);
	bool coastlines(MvRequest&);
	bool axis(MvRequest&);
	bool grib(MvRequest&);
    bool gribloop(MvRequest&);
	bool geonetcdf(MvRequest&);
	bool xynetcdf(MvRequest&);
	bool geopoints(MvRequest&);
	bool raster(MvRequest&);
	
	bool contour(MvRequest&);
  	bool symbol(MvRequest&);
    bool wind(MvRequest&);
    bool import(MvRequest&);
  	
  	bool text(MvRequest&);
  	bool device(MvRequest&);
  	
  	bool opengldriver(MvRequest&);
    bool pdfdriver(MvRequest&);
    bool pngdriver(MvRequest&);
    bool svgdriver(MvRequest&);
    bool kmldriver(MvRequest&);  
    bool psdriver(MvRequest&);
    
  	RootSceneNode* root_;
  	DriverManager  drivers_;
	OutputHandler  output_;
	int  superpage_;
	bool geographical_;

};

} // namespace magics

#endif
