/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLManagerWidget.cc
    \brief Implementation of the OpenGLManagerWidget class.
    \author Graphics Section, ECMWF

    Started: July 2008
*/
#ifndef _OpenGLManagerWidget_H
#define _OpenGLManagerWidget_H

#include <OpenGLBaseWidget.h>

namespace magics 
{

class OpenGLDriver;
class OpenGLInputEvent;

class OpenGLManagerWidget : public OpenGLBaseWidget
{

public:
	OpenGLManagerWidget(OpenGLDriver *driver,
		            string name, int x=0, int y=0, int width=0, int height=0) : 
			    OpenGLBaseWidget(driver,0,name,x,y,width,height) {};

	OpenGLBaseWidget* addChild(OpenGLBaseWidget*);
	void removeChild(OpenGLBaseWidget*);
	void render();
        void event(MtInputEvent *);	
	bool active();

	void setX(int);
	void setY(int);	
	void setPos(int,int);
	void setWidth(int);
	void setHeight(int);
	void resetGeometry();

protected:	
        virtual bool checkFocus(MtInputEvent *);

	mglWidgetList 	children_;
};	

}
#endif
