/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLDriverManager.h
    \brief Definition of OpenGLDriverManager
    \author Graphics Section, ECMWF

    Started: May 2004
*/

#ifndef OpenGLDriverManager_H
#define OpenGLDriverManager_H

#include <OpenGLDriverObserver.h>

namespace magics
{

class OpenGLDriver;
class OpenGLGui;
class OpenGLBaseTool;

typedef map<InteractiveMode,OpenGLBaseTool*> mglToolMap;
typedef map<string,OpenGLGui*> mglGuiMap;

class OpenGLDriverManager : public OpenGLDriverObserver
{
public:	
	OpenGLDriverManager() {};
	OpenGLDriverManager(OpenGLDriver*);
	OpenGLDriver* driver() {return driver_;};
	void show();
		
protected:
	void setInteractiveMode(InteractiveMode);
	void leaveMode(InteractiveMode);
	void enterMode(InteractiveMode);
	void zoomControlStatusForOpenGLGui(bool);
	void magnifierControlStatusForOpenGLGui(bool);
	void setGuiVisibility(OpenGLGui *,bool s);

	void inputEventDispatchFromDriver(MtInputEvent*);
	void currentFrameChanged();
	void update();

	void showTheRest(OpenGLGui*);
	void plotToFb();
	void swapFb();
	
        OpenGLDriver*           driver_;		
	InteractiveMode         interactiveMode_;		
	mglToolMap              tool_;
	mglGuiMap               gui_;			
	OpenGLBaseTool*         activeTool_;
	OpenGLGui*		focusedGui_;	
};

}

#endif
