/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*! \file OpenGLCellBarWidget.h
    \brief Definition of the OpenGLCellBarWidget.
    \author Graphics Section, ECMWF
    
    Started: May 2008    
*/

#ifndef OpenGLCellBarWidget_H
#define OpenGLCellBarWidget_H

#include <magics.h>
#include <OpenGLLabelWidget.h>


namespace magics {
	
class OpenGLDriver;

class OpenGLCellData
{
public:
	vector<string>& value() {return value_;}
	Colour colour() {return colour_;}	

	void setValue(vector<string>& s) {value_=s;}
	void setColour(Colour& c) {colour_=c;}
private:	
	vector<string> value_;
	Colour         colour_;
};	

class OpenGLCellBarWidget : public OpenGLBaseWidget
{
public:				
	OpenGLCellBarWidget(OpenGLDriver *driver,string name,int x=0, int y=0, int w=0, int h=0);
	~OpenGLCellBarWidget();

	void createCells(int,int);
	void setCellValue(int,vector<string>&);
	int  getCellNum() {return cellNum_;};
	void render();
	void event(MtInputEvent*);
	bool active();
	void setActCell(int i) {actCell_=i;};
	int  getActCell() {return actCell_;};
	vector<string>& getCellValue(int i) {assert(i>=0 && i < cell_.size());return cell_[i]->value();}
	bool shiftActCell(int);
	bool setActCellToFirst();
	bool setActCellToLast();
	void setCellColour(int, Colour&);
	void setCellWidth(int);
	void setCellHeight(int); 
	void setSliderPixmap(string,string);
	void setSliderStatus(bool b) {sliderStatus_=b;};
	void setHorizontalAlingment(bool b) {horizontalAlingment_=b;};
	void setHeight(int);

protected:	
	void clearCells();

	int textSize_;
	int textX_;
	int textY_;
	
	int cellWidth_;
	int cellHeight_;
	
	int barX_;
	int barY_;
	
	int prevX_;
	int prevY_;

	bool tickMarkBarStatus_;
	int tickMarkTextGap_;
	float tickMarkTextHeight_;
	int tickMarkBarGap_;
	int tickMarkBarHeight_;

	bool sliderStatus_;	
	bool horizontalAlingment_;

	int cellNum_;
	int actCell_;
	int focusedCell_;
	
	vector<OpenGLCellData*> cell_; 

	OpenGLLabelWidget *slider_;
	
	Colour tickMarkColour_;
	Colour cellColour_;
	Colour cellActColour_;
	Colour cellBorderColour_;		

	bool drag_;
	
	void setGeometry();
	void setSlider(int);
	void setSlider();
	bool checkSliderInBar();
	bool checkPointInSlider(int,int);
	int identifyCell(int,int);	
	
	void setActCell();	
	bool checkPointInCell(int,int);		
	
	void input(int,int);
	void sliderDrag_start(int,int);
	void sliderDrag(int,int);
	void sliderDrag_end(int,int);	
	void focusedCellInput(int,int);

	void getPosInWidget(int, int, int &, int &);
};	
	
}	
#endif	
