/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

typedef struct _odb     odb;
typedef struct _odb_stm odb_stm;

#define ODB_TYPE_REAL    0
#define ODB_TYPE_INTEGER 1
#define ODB_TYPE_STRING  2
#define ODB_TYPE_BITMAP  3
#define ODB_TYPE_BLOB    4

extern "C" {

odb*          odb_connect(const char* host,int port);
void          odb_destroy(odb* o);

void          odb_do(odb* o,const char* what);

odb_stm*      odb_prepare_statement(odb* o,const char* what);
void          odb_destroy_statement(odb_stm*);

int           odb_no_columns(odb_stm*);
const char*   odb_column_name(odb_stm*,int);
int           odb_column_type(odb_stm*,int);

void          odb_execute(odb_stm* o);
void          odb_execute_with_params(odb_stm* o,int,const double*);
void          odb_execute_with_vparams(odb_stm* o,...);

const double* odb_fetch_row(odb_stm*);


void          odb_clear_error(odb* o);
int           odb_get_error(odb* o);
const char*   odb_get_error_message(odb* o);

}
