/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

#ifndef machine_H
#include "magics.h"
#endif

#ifndef Timer_H
#include "Timer.h"
#endif

#ifndef Seconds_H
#include "Seconds.h"
#endif

#include "Log.h"

namespace magics {

timeval operator-(const timeval& a,const timeval& b)
{
	timeval diff;

	diff.tv_sec  = a.tv_sec  - b.tv_sec;
	diff.tv_usec = a.tv_usec - b.tv_usec;

	if (diff.tv_usec < 0)
	{
		diff.tv_sec--;
		diff.tv_usec += 1000000;
	}
	return diff;
}

}
using namespace magics;

Timer::Timer(const string& name):
	name_(name),
	cpu_(clock())
{
	gettimeofday(&start_,0);
}

Timer::~Timer()
{
	const double  s   = elapsed();
	clock_t cpu =  clock();
	const Seconds	sec1(s);
	const Seconds	sec2(double(cpu-cpu_)/CLOCKS_PER_SEC);
	Log::profile() << name_ << ": " 
		<< sec1 << " elapsed, " 
		<< sec2 << " cpu" << "\n";
}

double Timer::elapsed()
{
	timeval stop;
	gettimeofday(&stop,0);  
	timeval diff = stop - start_;
	return (double)diff.tv_sec + ((double)diff.tv_usec / 1000000.);
}
