/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file RootSceneNode.cc
    \brief Implementation of the Template class RootSceneNode.
    
    Magics Team - ECMWF 2007
    
    Started: Thu 1-Mar-2007
    
    Changes:
    
*/



#include "RootSceneNode.h"
//#include "DisplayManager.h"
#include "PaperDimension.h"
#include "SceneNode.h"
#include "Timer.h"
#include "LayoutManager.h"


using namespace magics;

RootSceneNode::RootSceneNode() : 
	absoluteWidth_(29.7), absoluteHeight_(21.), current_(0)
{
	name_ = "root";
	current_ = new RootScenePage();
	current_->root(this);
	current_->getReady();
			// current_ is a copy of the basic SceneNode with exactly the same dimensions as the Root!  
	current_->parent(this); 
	items_.push_back(current_);
}


RootSceneNode::~RootSceneNode() 
{
	delete layout_;
}

/*!
 Class information are given to the output-stream.
*/		
void RootSceneNode::print(ostream& out)  const
{
	out << "RootSceneNode[";
	out << "]";
}



FortranRootSceneNode::FortranRootSceneNode() 
{
}

void FortranRootSceneNode::getReady() 
{
	absoluteWidth_ = FortranRootSceneNodeAttributes::width_;
	absoluteHeight_ = FortranRootSceneNodeAttributes::height_;
	
	layout_ = new RootLayout(absoluteWidth_, absoluteHeight_);
	layout_->name(name_);
}



FortranRootSceneNode::~FortranRootSceneNode() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void FortranRootSceneNode::print(ostream& out)  const
{
	out << "FortranRootSceneNode[";
	FortranRootSceneNodeAttributes::print(out);
	out << "]";
}

XmlRootSceneNode::XmlRootSceneNode() 
{
	absoluteWidth_  = 21.;
	absoluteHeight_ = 29.7;
	ParameterManager::set(string("layout"), string("magml")); 
}


XmlRootSceneNode::~XmlRootSceneNode() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void XmlRootSceneNode::print(ostream& out)  const
{
	out << "RootSceneNode[";
	out << "]";
}

void XmlRootSceneNode::getReady()
{
	absoluteWidth_ = XmlRootNodeAttributes::width_;
	absoluteHeight_ = XmlRootNodeAttributes::height_;
	
	if ( absoluteWidth_ == -1 || absoluteWidth_ == -1 ) {
		PaperDimension* dimension = Translator<string, PaperDimension>()(format_);
    	dimension->setOrientation(orientation_);	
		absoluteWidth_ = dimension->getWidth();
		absoluteHeight_ = dimension->getHeight();
	}	
	if ( layout_ ) delete layout_; 
	layout_ = new RootLayout(absoluteWidth_, absoluteHeight_);	
	
	layout_->name(name_);
}


void  RootSceneNode::execute()
{
			Timer timer("Prepare Graphical Tree");
			// add the frame ...
			
			dispatch(*layout_); 
}

BasicSceneNode* RootSceneNode::insert(BasicPositionalObject* node) 
{
	    getReady();
	    BasicSceneNode* newnode = current_->insert(node);

	    return current_;
}


BasicSceneNode* RootScenePage::newNode(BasicPositionalObject* node)
{
	RootScenePage* page = new RootScenePage();
	page->manager_ = manager_->clone();
	
	assert(root_);
	page->getReady();
	page->root(root_);
	root_->push_back(page);
	root_->current(page);
	node->orphan();
	(*(page->manager_))(page, node);
	return page;
}

	
BasicSceneNode* RootSceneNode::clone() 
{ 
	current_->newNode(0);
	/*
    if ( !current_ ) 
    	getReady();
    else {
    	current_ = current_->clone(); 
    	current_->parent(this); 
    	items_.push_back(current_);
    }
	*/
	
	return current_;
}
/*
void  RootSceneNode::push_back(BasicSceneObject* item)
{
	assert(current_);
	current_->push_back(item);
}
*/
RootScenePage::RootScenePage() : root_(0) 
{
	static int i = 0;
		ostringstream n;
		n << "rootpage" << i;
		name_ = n.str();
		i++;
	    
		layout_ = new Layout();
		layout_->name(name_);
}

static SimpleObjectMaker<A4, PaperDimension> a4("a4");
static SimpleObjectMaker<A3, PaperDimension> a3("a3");
static SimpleObjectMaker<A5, PaperDimension> a5("a5");
static SimpleObjectMaker<A6, PaperDimension> a6("a6");
