/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file MarkerShadingTechniqueAttributes.h
    \brief Definition of MarkerShadingTechnique Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:37 2011
*/
   

#ifndef MarkerShadingTechniqueAttributes_H
#define MarkerShadingTechniqueAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class MarkerShadingTechniqueAttributes 
{
public:
//  --  constructor
    MarkerShadingTechniqueAttributes();
    
//  --  destructor
    virtual ~MarkerShadingTechniqueAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const MarkerShadingTechniqueAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Colour table to be used with MARKER shading technique 
    \param colour Setting contour_shade_colour_table - default=stringarray()
*/
	void setColour(stringarray colour) 
		{ colour_ =  colour; } 
	stringarray getColour() const 
		{ return colour_; } 
        
/*!
    Magics Information:
    \brief  Height table to be used with MARKER shading technique 
    \param height Setting contour_shade_height_table - default=floatarray()
*/
	void setHeight(floatarray height) 
		{ height_ =  height; } 
	floatarray getHeight() const 
		{ return height_; } 
        
/*!
    Magics Information:
    \brief  Marker table to be used with MARKER shading technique 
    \param marker Setting contour_shade_marker_table - default=intarray()
*/
	void setMarker(intarray marker) 
		{ marker_ =  marker; } 
	intarray getMarker() const 
		{ return marker_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	stringarray colour_;
	floatarray height_;
	intarray marker_;

private:
  
	friend ostream& operator<<(ostream& s,const MarkerShadingTechniqueAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
