/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file AxisTitle.h
    \brief Definition of the Template class AxisTitle.
    
    Magics Team - ECMWF 2005
    
    Started: Fri 7-Oct-2005
    
    Changes:
    
*/

#ifndef AxisTitle_H
#define AxisTitle_H

#include "magics.h"
#include "MagTranslator.h"
#include "Factory.h"


#include "AxisTitleAttributes.h"


namespace magics {


class Transformation;
class HorizontalAxisVisitor;
class VerticalAxisVisitor;

class AxisTitle: public AxisTitleAttributes {

public:
	AxisTitle();
	virtual ~AxisTitle();
    
    virtual void set(const XmlNode& node) {
       AxisTitleAttributes::set(node);
    }
    virtual void set(const map<string, string>& map) {
         AxisTitleAttributes::set(map);
    }
    virtual AxisTitle* clone() const {
    	AxisTitle* title = new AxisTitle();
    	title->copy(*this);
        MagLog::dev() << "(const map<string, string&)---> to be checked!...\n";
        return title;
    }
    
    virtual void horizontal(const Colour&, HorizontalAxisVisitor&);
    virtual void vertical(const Colour&, VerticalAxisVisitor&);
    
    
protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 

private:
    //! Copy constructor - No copy allowed
	AxisTitle(const AxisTitle&);
    //! Overloaded << operator to copy - No copy allowed
	AxisTitle& operator=(const AxisTitle&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const AxisTitle& p)
		{ p.print(s); return s; }

};


class NoAxisTitle :public AxisTitle
{
public:
	NoAxisTitle() {}
	~NoAxisTitle() {}
	void horizontal(const Colour&, HorizontalAxisVisitor&) {}
    void vertical(const Colour&, VerticalAxisVisitor&) {}
protected:
	AxisTitle* clone() const { return new NoAxisTitle(); }
};


template <>
class MagTranslator<string, AxisTitle> { 
public:
	AxisTitle* operator()(const string& val )
	{
		return SimpleObjectMaker<AxisTitle>::create(val);
	}     

	AxisTitle* magics(const string& param)
	{
		AxisTitle* object;
		ParameterManager::update(param, object);
		return object;
	}
};

} // namespace magics
#endif
