/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file MetgramCurveAttributes.cc
    \brief Implemtation of MetgramCurve Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Thu Jun 16 12:02:55 2011
*/    

#include "MetgramCurveAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


MetgramCurveAttributes::MetgramCurveAttributes():
	style_(Translator<string, LineStyle>().magics("metgram_curve_line_style")),
	style2_(Translator<string, LineStyle>().magics("metgram_curve2_line_style")),
	colour_(Translator<string, Colour>().magics("metgram_curve_colour")),
	colour2_(Translator<string, Colour>().magics("metgram_curve2_colour")),
	thickness_(ParameterManager::getInt("metgram_curve_thickness")),
	thickness2_(ParameterManager::getInt("metgram_curve2_thickness"))
{
} 



MetgramCurveAttributes::~MetgramCurveAttributes()
{
}

    
void MetgramCurveAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	prefix[0] = "metgram";

	setAttribute(prefix, "metgram_curve_line_style", style_, params);
	setAttribute(prefix, "metgram_curve2_line_style", style2_, params);
	setAttribute(prefix, "metgram_curve_colour", colour_, params);
	setAttribute(prefix, "metgram_curve2_colour", colour2_, params);
	setAttribute(prefix, "metgram_curve_thickness", thickness_, params);
	setAttribute(prefix, "metgram_curve2_thickness", thickness2_, params);
}

void MetgramCurveAttributes::copy(const MetgramCurveAttributes& other)
{
	style_ = other.style_;
	style2_ = other.style2_;
	setColour(other.colour_->clone());
	setColour2(other.colour2_->clone());
	thickness_ = other.thickness_;
	thickness2_ = other.thickness2_;
} 


bool MetgramCurveAttributes::accept(const string& node)
{	
	if ( magCompare(node, "metgraph")  )
		return true;
	return false;
}

void MetgramCurveAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "metgraph") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void MetgramCurveAttributes::print(ostream& out)  const
{
	out << "MetgramCurveAttributes[";
	out << "style = " << style_;
	out << ", style2 = " << style2_;
	out << ", colour = " << *colour_;
	out << ", colour2 = " << *colour2_;
	out << ", thickness = " << thickness_;
	out << ", thickness2 = " << thickness2_;
	out << "]" << "\n";
}


void MetgramCurveAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\tmetgram_curve_line_style = \'" << style_ << "\'\n";
	out << tab << "\tmetgram_curve2_line_style = \'" << style2_ << "\'\n";
	out << tab << "\tmetgram_curve_colour = \'" << *colour_ << "\'\n";
	out << tab << "\tmetgram_curve2_colour = \'" << *colour2_ << "\'\n";
	out << tab << "\tmetgram_curve_thickness = \'" << thickness_ << "\'\n";
	out << tab << "\tmetgram_curve2_thickness = \'" << thickness2_ << "\'\n";
	out << tab << ">";


	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<string> metgram_curve_line_style("metgram_curve_line_style", "solid", "");
static MagicsParameter<string> metgram_curve2_line_style("metgram_curve2_line_style", "solid", "");
static MagicsParameter<string> metgram_curve_colour("metgram_curve_colour", "red", "");
static MagicsParameter<string> metgram_curve2_colour("metgram_curve2_colour", "blue", "");
static MagicsParameter<int> metgram_curve_thickness("metgram_curve_thickness", 2, "");
static MagicsParameter<int> metgram_curve2_thickness("metgram_curve2_thickness", 2, "");
