/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file AxisTickAttributes.h
    \brief Definition of AxisTick Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Thu Jun 16 12:02:58 2011
*/
   

#ifndef AxisTickAttributes_H
#define AxisTickAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "Colour.h"

namespace magics {

class XmlNode;



class AxisTickAttributes 
{
public:
//  --  constructor
    AxisTickAttributes();
    
//  --  destructor
    virtual ~AxisTickAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const AxisTickAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Colour of ticks (Full choice of colours) 
    \param colour Setting axis_tick_colour - default=automatic
*/
	void setColour(Colour* colour) 
		{ auto_ptr<Colour> tmp(colour); colour_ = tmp; } 
	const Colour&  getColour() const 
		{ return *colour_; }
/*!
    Magics Information:
    \brief  Size of ticks 
    \param length Setting axis_tick_size - default=0.175
*/
	void setLength(double length) 
		{ length_ =  length; } 
	double getLength() const 
		{ return length_; } 
        
/*!
    Magics Information:
    \brief  Thickness of tick marks 
    \param thickness Setting axis_tick_thickness - default=2
*/
	void setThickness(int thickness) 
		{ thickness_ =  thickness; } 
	int getThickness() const 
		{ return thickness_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	auto_ptr<Colour> colour_;
	double length_;
	int thickness_;

private:
  
	friend ostream& operator<<(ostream& s,const AxisTickAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
