/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file MgQHistoNode.h
    \brief Definition of MgQHistoNode.
    \author Graphics Section, ECMWF

    Started: February 2011
*/

#ifndef _MgQHistoNode_H
#define _MgQHistoNode_H

#include <magics.h>

#include "MgQBaseNode.h"

class MgQHistoNode : public MgQBaseNode 
{
public:
	MgQHistoNode(QString);
	~MgQHistoNode();
	QPixmap pixmap() {return pixmap_;}
	void setPixmap(QPixmap p,QSize s) {pixmap_=p;requestedPixmapSize_=s;} 
	QSize requestedPixmapSize() {return requestedPixmapSize_;} 
	bool cached() {return cached_;}
	void    setCached(bool b) {cached_=b;}	

protected:
	QPixmap pixmap_;
	QSize requestedPixmapSize_;
	bool cached_;		
};

#endif
