/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file NetcdfGeoMatrixInterpretorAttributes.h
    \brief Definition of NetcdfGeoMatrixInterpretor Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Thu Jun 16 12:02:56 2011
*/
   

#ifndef NetcdfGeoMatrixInterpretorAttributes_H
#define NetcdfGeoMatrixInterpretorAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class NetcdfGeoMatrixInterpretorAttributes 
{
public:
//  --  constructor
    NetcdfGeoMatrixInterpretorAttributes();
    
//  --  destructor
    virtual ~NetcdfGeoMatrixInterpretorAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const NetcdfGeoMatrixInterpretorAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief Variable name representing the latitude dimension
    \param latitude Setting netcdf_latitude_variable_name - default=latitude
*/
	void setLatitude(string latitude) 
		{ latitude_ =  latitude; } 
	string getLatitude() const 
		{ return latitude_; } 
        
/*!
    Magics Information:
    \brief Variable name representing the longitude dimension
    \param longitude Setting netcdf_longitude_variable_name - default=longitude
*/
	void setLongitude(string longitude) 
		{ longitude_ =  longitude; } 
	string getLongitude() const 
		{ return longitude_; } 
        
/*!
    Magics Information:
    \brief sample the input data by taking aa longitude every nth longitude
    \param longitude_sample Setting netcdf_longitude_sample - default=1
*/
	void setLongitude_sample(int longitude_sample) 
		{ longitude_sample_ =  longitude_sample; } 
	int getLongitude_sample() const 
		{ return longitude_sample_; } 
        
/*!
    Magics Information:
    \brief sample the input data by taking a latitude every nth latitude
    \param latitude_sample Setting netcdf_latitude_sample - default=1
*/
	void setLatitude_sample(int latitude_sample) 
		{ latitude_sample_ =  latitude_sample; } 
	int getLatitude_sample() const 
		{ return latitude_sample_; } 
        
/*!
    Magics Information:
    \brief value used to represent missing data
    \param missing Setting netcdf_missing_value - default=INT_MAX
*/
	void setMissing(double missing) 
		{ missing_ =  missing; } 
	double getMissing() const 
		{ return missing_; } 
        
/*!
    Magics Information:
    \brief  Primary index latitude/longitude
    \param primary_index Setting netcdf_matrix_primary_index - default=longitude
*/
	void setPrimary_index(string primary_index) 
		{ primary_index_ =  primary_index; } 
	string getPrimary_index() const 
		{ return primary_index_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	string latitude_;
	string longitude_;
	int longitude_sample_;
	int latitude_sample_;
	double missing_;
	string primary_index_;

private:
  
	friend ostream& operator<<(ostream& s,const NetcdfGeoMatrixInterpretorAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
