/***************************************************************************
 *
 * This file is covered by a dual licence. You can choose whether you
 * want to use it according to the terms of the GNU GPL version 2, or
 * under the terms of Zorp Professional Firewall System EULA located
 * on the Zorp installation CD.
 *
 * $Id: streamgzip.h,v 1.2 2003/11/14 15:49:09 sasa Exp $
 *
 ***************************************************************************/

#ifndef ZORP_STREAMGZIP_H_INCLUDED
#define ZORP_STREAMGZIP_H_INCLUDED

#include <zorp/zorplib.h>
#include <zorp/stream.h>

#ifdef __cplusplus
extern "C" {
#endif

GIOStatus z_stream_gzip_flush(ZStream *stream);

GIOStatus z_stream_gzip_get(ZStream *s, char **line, guint *length, GError **error);
GIOStatus z_stream_gzip_get_copy(ZStream *s, char *line, guint *length, GError **error);

ZStream *z_stream_gzip_new(ZStream *child, gboolean flush, guint level, guint buffer_length);

#ifdef __cplusplus
}
#endif

#endif /* ZORP_STREAMGZIP_H_INCLUDED */
