/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.conv;

import com.jclark.xsl.conv.UnambiguousFormatTokenHandler;

class RomanNumberFormat
extends UnambiguousFormatTokenHandler {
    private String letters;

    RomanNumberFormat(String letters) {
        this.letters = letters;
    }

    public String format(int n) {
        if (n == 0) {
            return "0";
        }
        if (n > 5000) {
            return Integer.toString(n);
        }
        StringBuffer result = new StringBuffer();
        while (n >= 1000) {
            result.append(this.letters.charAt(0));
            n -= 1000;
        }
        int letterBase = 0;
        int i = 100;
        while (i > 0) {
            int q = n / i;
            n -= q * i;
            switch (q) {
                case 1: {
                    result.append(this.letters.charAt(letterBase + 2));
                    break;
                }
                case 2: {
                    result.append(this.letters.charAt(letterBase + 2));
                    result.append(this.letters.charAt(letterBase + 2));
                    break;
                }
                case 3: {
                    result.append(this.letters.charAt(letterBase + 2));
                    result.append(this.letters.charAt(letterBase + 2));
                    result.append(this.letters.charAt(letterBase + 2));
                    break;
                }
                case 4: {
                    result.append(this.letters.charAt(letterBase + 2));
                    result.append(this.letters.charAt(letterBase + 1));
                    break;
                }
                case 5: {
                    result.append(this.letters.charAt(letterBase + 1));
                    break;
                }
                case 6: {
                    result.append(this.letters.charAt(letterBase + 1));
                    result.append(this.letters.charAt(letterBase + 2));
                    break;
                }
                case 7: {
                    result.append(this.letters.charAt(letterBase + 1));
                    result.append(this.letters.charAt(letterBase + 2));
                    result.append(this.letters.charAt(letterBase + 2));
                    break;
                }
                case 8: {
                    result.append(this.letters.charAt(letterBase + 1));
                    result.append(this.letters.charAt(letterBase + 2));
                    result.append(this.letters.charAt(letterBase + 2));
                    result.append(this.letters.charAt(letterBase + 2));
                    break;
                }
                case 9: {
                    result.append(this.letters.charAt(letterBase + 2));
                    result.append(this.letters.charAt(letterBase + 0));
                }
            }
            i /= 10;
            letterBase += 2;
        }
        return result.toString();
    }
}

