/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;

public class WLRun
extends Task {
    protected static final String DEFAULT_WL51_POLICY_FILE = "weblogic.policy";
    protected static final String DEFAULT_WL60_POLICY_FILE = "lib/weblogic.policy";
    protected static final String DEFAULT_PROPERTIES_FILE = "weblogic.properties";
    private Path classpath;
    private Path weblogicClasspath;
    private String weblogicMainClass = "weblogic.Server";
    private String additionalArgs = "";
    private String securityPolicy;
    private File weblogicSystemHome;
    private String weblogicDomainName;
    private String weblogicSystemName = "myserver";
    private String weblogicPropertiesFile = null;
    private String additionalJvmArgs = "";
    private File beaHome = null;
    private String managementUsername = "system";
    private String managementPassword = null;
    private String pkPassword = null;

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(((ProjectComponent)this).project);
        }
        return this.classpath.createPath();
    }

    public Path createWLClasspath() {
        if (this.weblogicClasspath == null) {
            this.weblogicClasspath = new Path(((ProjectComponent)this).project);
        }
        return this.weblogicClasspath.createPath();
    }

    public void execute() throws BuildException {
        if (this.weblogicSystemHome == null) {
            throw new BuildException("weblogic home must be set");
        }
        if (!this.weblogicSystemHome.isDirectory()) {
            throw new BuildException("weblogic home directory " + this.weblogicSystemHome.getPath() + " is not valid");
        }
        if (this.beaHome != null) {
            this.executeWLS6();
        } else {
            this.executeWLS();
        }
    }

    private File findSecurityPolicyFile(String defaultSecurityPolicy) {
        String securityPolicy = this.securityPolicy;
        if (securityPolicy == null) {
            securityPolicy = defaultSecurityPolicy;
        }
        File securityPolicyFile = new File(this.weblogicSystemHome, securityPolicy);
        if (this.securityPolicy != null && !securityPolicyFile.exists()) {
            securityPolicyFile = ((ProjectComponent)this).project.resolveFile(securityPolicy);
        }
        if (!securityPolicyFile.exists()) {
            throw new BuildException("Security policy " + securityPolicy + " was not found.");
        }
        return securityPolicyFile;
    }

    private void executeWLS6() {
        File securityPolicyFile = this.findSecurityPolicyFile(DEFAULT_WL60_POLICY_FILE);
        if (!this.beaHome.isDirectory()) {
            throw new BuildException("BEA home " + this.beaHome.getPath() + " is not valid");
        }
        File configFile = new File(this.weblogicSystemHome, "config/" + this.weblogicDomainName + "/config.xml");
        if (!configFile.exists()) {
            throw new BuildException("Server config file " + configFile + " not found.");
        }
        if (this.managementPassword == null) {
            throw new BuildException("You must supply a management password to start the server");
        }
        Java weblogicServer = (Java)((ProjectComponent)this).project.createTask("java");
        weblogicServer.setTaskName(this.getTaskName());
        weblogicServer.setFork(true);
        weblogicServer.setDir(this.weblogicSystemHome);
        weblogicServer.setClassname(this.weblogicMainClass);
        String jvmArgs = this.additionalJvmArgs;
        jvmArgs = jvmArgs + " -Dweblogic.Domain=" + this.weblogicDomainName;
        jvmArgs = jvmArgs + " -Dweblogic.Name=" + this.weblogicSystemName;
        jvmArgs = jvmArgs + " -Dweblogic.system.home=" + this.weblogicSystemHome;
        jvmArgs = jvmArgs + " -Dbea.home=" + this.beaHome;
        jvmArgs = jvmArgs + " -Djava.security.policy==" + securityPolicyFile;
        jvmArgs = jvmArgs + " -Dweblogic.management.username=" + this.managementUsername;
        jvmArgs = jvmArgs + " -Dweblogic.management.password=" + this.managementPassword;
        if (this.pkPassword != null) {
            jvmArgs = jvmArgs + " -Dweblogic.pkpassword=" + this.pkPassword;
        }
        weblogicServer.createJvmarg().setLine(jvmArgs);
        weblogicServer.createArg().setLine(this.additionalArgs);
        if (this.classpath != null) {
            weblogicServer.setClasspath(this.classpath);
        }
        if (weblogicServer.executeJava() != 0) {
            throw new BuildException("Execution of weblogic server failed");
        }
    }

    private void executeWLS() {
        File securityPolicyFile = this.findSecurityPolicyFile(DEFAULT_WL51_POLICY_FILE);
        File propertiesFile = null;
        if (this.weblogicPropertiesFile == null) {
            this.weblogicPropertiesFile = DEFAULT_PROPERTIES_FILE;
        }
        if (!(propertiesFile = new File(this.weblogicSystemHome, this.weblogicPropertiesFile)).exists() && !(propertiesFile = ((ProjectComponent)this).project.resolveFile(this.weblogicPropertiesFile)).exists()) {
            throw new BuildException("Properties file " + this.weblogicPropertiesFile + " not found in weblogic home " + this.weblogicSystemHome + " or as absolute file");
        }
        Java weblogicServer = (Java)((ProjectComponent)this).project.createTask("java");
        weblogicServer.setTaskName(this.getTaskName());
        weblogicServer.setFork(true);
        weblogicServer.setClassname(this.weblogicMainClass);
        String jvmArgs = this.additionalJvmArgs;
        if (this.weblogicClasspath != null) {
            jvmArgs = jvmArgs + " -Dweblogic.class.path=" + this.weblogicClasspath;
        }
        jvmArgs = jvmArgs + " -Djava.security.manager -Djava.security.policy==" + securityPolicyFile;
        jvmArgs = jvmArgs + " -Dweblogic.system.home=" + this.weblogicSystemHome;
        jvmArgs = jvmArgs + " -Dweblogic.system.name=" + this.weblogicSystemName;
        jvmArgs = jvmArgs + " -Dweblogic.system.propertiesFile=" + this.weblogicPropertiesFile;
        weblogicServer.createJvmarg().setLine(jvmArgs);
        weblogicServer.createArg().setLine(this.additionalArgs);
        if (this.classpath != null) {
            weblogicServer.setClasspath(this.classpath);
        }
        if (weblogicServer.executeJava() != 0) {
            throw new BuildException("Execution of weblogic server failed");
        }
    }

    public void setClasspath(Path classpath) {
        this.classpath = classpath;
    }

    public void setWlclasspath(Path weblogicClasspath) {
        this.weblogicClasspath = weblogicClasspath;
    }

    public void setPolicy(String securityPolicy) {
        this.securityPolicy = securityPolicy;
    }

    public void setHome(File weblogicHome) {
        this.weblogicSystemHome = weblogicHome;
    }

    public void setBEAHome(File beaHome) {
        this.beaHome = beaHome;
    }

    public void setName(String serverName) {
        this.weblogicSystemName = serverName;
    }

    public void setDomain(String domain) {
        this.weblogicDomainName = domain;
    }

    public void setProperties(String propertiesFilename) {
        this.weblogicPropertiesFile = propertiesFilename;
    }

    public void setJvmargs(String args) {
        this.additionalJvmArgs = args;
    }

    public void setUsername(String username) {
        this.managementUsername = username;
    }

    public void setPassword(String password) {
        this.managementPassword = password;
    }

    public void setPKPassword(String pkpassword) {
        this.pkPassword = pkpassword;
    }

    public void setArgs(String args) {
        this.additionalArgs = args;
    }

    public void setWeblogicMainClass(String c) {
        this.weblogicMainClass = c;
    }
}

