------------------------------------------------------------------------------
--                             Templates Parser                             --
--                                                                          --
--                            Copyright (C) 2005                            --
--                                  AdaCore                                 --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
------------------------------------------------------------------------------

with Templates_Parser.Debug;
with Ada.Text_IO;
with Ada.Command_Line;

procedure Print_Tree is

   use Ada;
   use Templates_Parser;

begin
   if Command_Line.Argument_Count /= 1 then
      Text_IO.New_Line;
      Text_IO.Put_Line ("Usage: print_tree <filename>");
      Text_IO.New_Line;

   else
      Debug.Print_Tree (Command_Line.Argument (1));
   end if;
end Print_Tree;
