<!-- Stylesheet to extract C enumerations from the Telepathy spec,
based on c-constants-generator.xsl.

The output of c-constants-generator.xsl has to be altered to be API
compatible with libtelepathy:

and if LIBTELEPATHY_DISABLE_DEPRECATED is not defined,

* Prefixes have an alias mangled according to libtelepathy's different
  conventions (Connection -> Conn)
* Type names have an alias TelepathyFooType for the official name TpFooType
* LAST_foo in an enum is actually 1 more than the last entry, i.e. the number
  of entries
* LAST_foo is generated for flag sets, even though it doesn't really make
  sense: it's the numerically highest flag + 1

Copyright (C) 2006, 2007 Collabora Limited

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:tp="http://telepathy.freedesktop.org/wiki/DbusSpec#extensions-v0"
  exclude-result-prefixes="tp">

  <xsl:output method="text" indent="no" encoding="ascii"/>

  <xsl:param name="mixed-case-prefix" select="'Tp'"/>
  <xsl:param name="upper-case-prefix" select="'TP_'"/>
  <xsl:param name="long-mixed-case-prefix" select="'Telepathy'"/>
  <xsl:param name="long-upper-case-prefix" select="'TELEPATHY_'"/>

  <xsl:variable name="upper" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>
  <xsl:variable name="lower" select="'abcdefghijklmnopqrstuvwxyz'"/>

  <xsl:template name="mangle-name">
    <xsl:param name="in" select="''"/>
    <xsl:choose>
      <!-- world's least efficient replace() -->
      <xsl:when test="contains($in, 'Connection')">
        <xsl:call-template name="mangle-name">
          <xsl:with-param name="in"
            select="concat(substring-before($in, 'Connection'), 'Conn',
                           substring-after($in, 'Connection'))"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$in"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="tp:flags">
    <xsl:variable name="spec-value-prefix">
      <xsl:choose>
        <xsl:when test="@value-prefix">
          <xsl:value-of select="@value-prefix"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="@name"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="legacy-value-prefix">
      <xsl:call-template name="mangle-name">
        <xsl:with-param name="in" select="$spec-value-prefix"/>
      </xsl:call-template>
    </xsl:variable>
<xsl:apply-templates>
  <xsl:with-param name="spec-value-prefix" select="$spec-value-prefix"/>
  <xsl:with-param name="legacy-value-prefix" select="$legacy-value-prefix"/>
</xsl:apply-templates>
#define LAST_<xsl:value-of select="translate(concat($upper-case-prefix, $legacy-value-prefix), $lower, $upper)"/> (<xsl:value-of select="tp:flag[position() = last()]/@value"/> + 1)
typedef <xsl:value-of select="translate(concat($mixed-case-prefix, @name), '_', '')"/><xsl:text> </xsl:text><xsl:value-of select="translate(concat($long-mixed-case-prefix, @name), '_', '')"/>;
</xsl:template>

  <xsl:template match="tp:enum">
    <xsl:variable name="spec-value-prefix">
      <xsl:choose>
        <xsl:when test="@value-prefix">
          <xsl:value-of select="@value-prefix"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="@name"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="legacy-value-prefix">
      <xsl:call-template name="mangle-name">
        <xsl:with-param name="in" select="$spec-value-prefix"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="spec-name-plural">
      <xsl:choose>
        <xsl:when test="@plural">
          <xsl:value-of select="@plural"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="@name"/><xsl:text>s</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="name-plural">
      <xsl:call-template name="mangle-name">
        <xsl:with-param name="in" select="$spec-name-plural"/>
      </xsl:call-template>
    </xsl:variable>
<xsl:apply-templates>
  <xsl:with-param name="legacy-value-prefix" select="$legacy-value-prefix"/>
  <xsl:with-param name="spec-value-prefix" select="$spec-value-prefix"/>
</xsl:apply-templates>
typedef <xsl:value-of select="translate(concat($mixed-case-prefix, @name), '_', '')"/><xsl:text> </xsl:text><xsl:value-of select="translate(concat($long-mixed-case-prefix, @name), '_', '')"/>;
#define LAST_<xsl:value-of select="translate(concat($upper-case-prefix, $legacy-value-prefix), $lower, $upper)"/> NUM_<xsl:value-of select="translate(concat($upper-case-prefix, $name-plural), $lower, $upper)"/><xsl:text>&#10;</xsl:text>

</xsl:template>

  <xsl:template match="tp:flags/tp:flag">
    <xsl:param name="legacy-value-prefix"/>
    <xsl:param name="spec-value-prefix"/>

    <xsl:variable name="legacy-name" select="translate(concat($upper-case-prefix, $legacy-value-prefix, '_', @suffix), $lower, $upper)"/>
    <xsl:variable name="name" select="translate(concat($upper-case-prefix, $spec-value-prefix, '_', @suffix), $lower, $upper)"/>
    <xsl:if test="$name != $legacy-name">
      <xsl:text>#define </xsl:text>
      <xsl:value-of select="$legacy-name"/>
      <xsl:text> </xsl:text>
      <xsl:value-of select="$name"/>
      <xsl:text>&#10;</xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="tp:enum/tp:enumvalue">
    <xsl:param name="spec-value-prefix"/>
    <xsl:param name="legacy-value-prefix"/>

    <xsl:variable name="legacy-name" select="translate(concat($upper-case-prefix, $legacy-value-prefix, '_', @suffix), $lower, $upper)"/>
    <xsl:variable name="name" select="translate(concat($upper-case-prefix, $spec-value-prefix, '_', @suffix), $lower, $upper)"/>

    <xsl:if test="$name != $legacy-name">
      <xsl:text>#define </xsl:text>
      <xsl:value-of select="$legacy-name"/>
      <xsl:text> </xsl:text>
      <xsl:value-of select="$name"/>
      <xsl:text>&#10;</xsl:text>
    </xsl:if>
</xsl:template>

  <xsl:template match="tp:flag">
    <xsl:message terminate="yes">tp:flag found outside tp:flags
</xsl:message>
  </xsl:template>

  <xsl:template match="tp:enumvalue">
    <xsl:message terminate="yes">tp:enumvalue found outside tp:enum
</xsl:message>
  </xsl:template>

  <xsl:template match="text()"/>

  <xsl:template match="/tp:spec">/* Generated from the Telepathy spec, version <xsl:value-of select="tp:version"/>
*/

#ifdef __cplusplus
extern "C" {
#endif

<xsl:apply-templates select="node"/>

#ifdef __cplusplus
}
#endif

</xsl:template>

</xsl:stylesheet>

<!-- vim:set sw=2 sts=2 et noai noci: -->
