/* StandardButtons.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

package be.ugent.caagt.swirl;

import javax.swing.JButton;
import javax.swing.UIManager;

/**
 * Helper class which allows creation of 'standard' buttons (OK, Cancel, ...)
 * with captions and mnemonics retrieved
 * from the user interface manager.
 */
public final class StandardButtons {
    
    // should not be instantiated by clients
    private StandardButtons () {
    }
    
    /**
     * Create an OK button with same look-and-feel as the OK button of an
     * option pane.
     */
    public static JButton createOKButton () {
        return createButton ("OptionPane.okButton");
    }
    
    /**
     * Create a Cancel button with same look-and-feel as the Cancel button of an
     * option pane.
     */
    public static JButton createCancelButton () {
        return createButton ("OptionPane.cancelButton");
    }

    /**
     * Create a Yes button with same look-and-feel as the Yes button of an
     * option pane.
     */
    public static JButton createYesButton () {
        return createButton ("OptionPane.yesButton");
    }

    /**
     * Create a No button with same look-and-feel as the No button of an
     * option pane.
     */
    public static JButton createNoButton () {
        return createButton ("OptionPane.noButton");
    }

    
    //
    private static JButton createButton (String prefix) {
        String caption = UIManager.getString(prefix + "Text");
        JButton button = new JButton (caption);
        String mstr = UIManager.getString(prefix + "Mnemonic");
        if (mstr != null && mstr.length() != 0)
            try {
                button.setMnemonic (Integer.parseInt(mstr));
            } catch (NumberFormatException ex) {
                throw new RuntimeException 
                        ("Received unexpected nonnumeric mnemonic from UIManager", ex);
            }
        return button;
        
    }
    
}
