/* case.hh - Convert case in strings
 * Copyright 2008 Bas Wijnen <wijnen@debian.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SHEVEK_CASE_HH
#define SHEVEK_CASE_HH

#include <string>

namespace shevek
{
	/// Convert the characters in a string to uppercase.
	std::string toupper (std::string const &orig);
	/// Convert the characters in a string to lowercase.
	std::string tolower (std::string const &orig);
	/// Convert the characters in a string so that two case-folded
	/// strings compare equal if the original strings were equal, except
	/// for possible case differences.
	inline std::string casefold (std::string const &orig)
	{
		return tolower (orig);
	}
}

#endif
