/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace libsbmlcs {

 using System;
 using System.Runtime.InteropServices;

/** 
 * Abstract Syntax Tree (AST) representation of a
 * mathematical expression.
 *
 * @htmlinclude not-sbml-warning.html
 *
 * Abstract Syntax Trees (ASTs) are a simple kind of data structure used in
 * libSBML for storing mathematical expressions.  The ASTNode is the
 * cornerstone of libSBML's AST representation.  An AST 'node' represents the
 * most basic, indivisible part of a mathematical formula and come in many
 * types.  For instance, there are node types to represent numbers (with
 * subtypes to distinguish integer, real, and rational numbers), names
 * (e.g., constants or variables), simple mathematical operators, logical
 * or relational operators and functions. LibSBML ASTs provide a canonical,
 * in-memory representation for all mathematical formulas regardless of
 * their original format (which might be MathML or might be text strings).
 *
 * An AST @em node in libSBML is a recursive structure containing a pointer
 * to the node's value (which might be, for example, a number or a symbol)
 * and a list of children nodes.  Each ASTNode node may have none, one,
 * two, or more children depending on its type.  The following diagram
 * illustrates an example of how the mathematical expression <c>'1 +
 * 2'</c> is represented as an AST with one @em plus node having two @em
 * integer children nodes for the numbers <c>1</c> and
 * <c>2</c>.  The figure also shows the corresponding MathML
 * representation:
 *
 * @htmlinclude astnode-illustration.html
 *
 * The following are other noteworthy points about the AST representation
 * in libSBML:
 * <ul>
 * <li> A numerical value represented in MathML as a real number with an
 * exponent is preserved as such in the AST node representation, even if
 * the number could be stored in a @c double data type.  This is done
 * so that when an SBML model is read in and then written out again, the
 * amount of change introduced by libSBML to the SBML during the round-trip
 * activity is minimized.
 *  
 * <li> Rational numbers are represented in an AST node using separate
 * numerator and denominator values.  These can be retrieved using the
 * methods ASTNode::getNumerator() and ASTNode::getDenominator().
 * 
 * <li> The children of an ASTNode are other ASTNode objects.  The list of
 * children is empty for nodes that are leaf elements, such as numbers.
 * For nodes that are actually roots of expression subtrees, the list of
 * children points to the parsed objects that make up the rest of the
 * expression.
 * </ul>
 *
 *
 * @if clike <h3><a class='anchor' name='ASTNodeType_t'>
 * ASTNodeType_t</a></h3> @else <h3><a class='anchor'
 * name='ASTNodeType_t'>The set of possible %ASTNode types</a></h3> @endif
 *
 * @if clike Every ASTNode has an associated type code to indicate,
 * for example, whether it holds a number or stands for an arithmetic
 * operator.  The type is recorded as a value drawn from the enumeration 
 * @link ASTNode.h::ASTNodeType_t ASTNodeType_t@endlink.  The list of
 * possible types is quite long, because it covers all the mathematical
 * functions that are permitted in SBML.  The values are shown in the
 * following table: @else Every ASTNode has an associated
 * type code to indicate, for example, whether it holds a number or stands for
 * an arithmetic operator.  The type is recorded as a value drawn from a
 * set of static integer constants defined in the class {@link
 * libsbmlcs.libsbml}.  Their names begin with the characters @c AST_.  The
 * list of possible types is quite long, because it covers all the
 * mathematical functions that are permitted in SBML.  The values are shown
 * in the following table: @endif
 *
 * @htmlinclude astnode-types.html
 *
 * The types have the following meanings:
 * <ul>
 * <li> If the node is basic mathematical operator (e.g., @c '+'), then the
 * node's type will be @c AST_PLUS, @c AST_MINUS, @c AST_TIMES, @c AST_DIVIDE,
 * or @c AST_POWER, as appropriate.
 *
 * <li> If the node is a predefined function or operator from %SBML Level&nbsp;1
 * (in the string-based formula syntax used in Level&nbsp;1) or %SBML Levels&nbsp;2 and&nbsp;3
 * (in the subset of MathML used in SBML Levels&nbsp;2 and&nbsp;3), then the node's type
 * will be either <c>AST_FUNCTION_</c><em><span
 * class='placeholder'>X</span></em>, <c>AST_LOGICAL_</c><em><span
 * class='placeholder'>X</span></em>, or
 * <c>AST_RELATIONAL_</c><em><span class='placeholder'>X</span></em>,
 * as appropriate.  (Examples: @c AST_FUNCTION_LOG, @c AST_RELATIONAL_LEQ.)
 *
 * <li> If the node refers to a user-defined function, the node's type will
 * be @c AST_NAME (because it holds the name of the function).
 *
 * <li> If the node is a lambda expression, its type will be @c AST_LAMBDA.
 * 
 * <li> If the node is a predefined constant (@c 'ExponentialE', @c 'Pi', 
 * @c 'True' or @c 'False'), then the node's type will be @c AST_CONSTANT_E,
 * @c AST_CONSTANT_PI, @c AST_CONSTANT_TRUE, or @c AST_CONSTANT_FALSE.
 * 
 * <li> (Levels&nbsp;2 and&nbsp;3 only) If the node is the special MathML csymbol @c time,
 * the value of the node will be @c AST_NAME_TIME.  (Note, however, that the
 * MathML csymbol @c delay is translated into a node of type
 * @c AST_FUNCTION_DELAY.  The difference is due to the fact that @c time is a
 * single variable, whereas @c delay is actually a function taking
 * arguments.)
 *
 * <li> (Level&nbsp;3 only) If the node is the special MathML csymbol @c avogadro,
 * the value of the node will be @c AST_NAME_AVOGADRO.
 * 
 * <li> If the node contains a numerical value, its type will be
 * @c AST_INTEGER, @c AST_REAL, @c AST_REAL_E, or @c AST_RATIONAL,
 * as appropriate.
 * </ul>
 *
 * 
 * <h3><a class='anchor' name='math-convert'>Converting between ASTs and text strings</a></h3>
 * 
 * The text-string form of mathematical formulas produced by @if clike libsbmlcs.libsbml.formulaToString()@endif@if csharp libsbmlcs.libsbml.formulaToString()@else <c><a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode)'>libsbml.formulaToString()</a></c>@endif and
 * read by @if clike libsbmlcs.libsbml.parseFormula()@endif@if csharp libsbmlcs.libsbml.parseFormula()@else <c><a href='libsbml.html#parseFormula(java.lang.String)'>libsbml.parseFormula()</a></c>@endif
 * are simple C-inspired infix notation taken from SBML Level&nbsp;1.  A
 * formula in this text-string form can be handed to a program that
 * understands SBML Level&nbsp;1 mathematical expressions, or used as part
 * of a translation system.  The libSBML distribution comes with an example
 * program in the @c 'examples' subdirectory called @c translateMath that
 * implements an interactive command-line demonstration of translating
 * infix formulas into MathML and vice-versa.
 *
 * The formula strings may contain operators, function calls, symbols, and
 * white space characters.  The allowable white space characters are tab
 * and space.  The following are illustrative examples of formulas
 * expressed in the syntax:
 * 
 * <code>
0.10 * k4^2
</code>
 * <code>
(vm * s1)/(km + s1)
</code>
 *
 * The following table shows the precedence rules in this syntax.  In the
 * Class column, @em operand implies the construct is an operand, @em
 * prefix implies the operation is applied to the following arguments, @em
 * unary implies there is one argument, and @em binary implies there are
 * two arguments.  The values in the Precedence column show how the order
 * of different types of operation are determined.  For example, the
 * expression <em>a * b + c</em> is evaluated as <em>(a * b) + c</em>
 * because the <c>*</c> operator has higher precedence.  The
 * Associates column shows how the order of similar precedence operations
 * is determined; for example, <em>a - b + c</em> is evaluated as <em>(a -
 * b) + c</em> because the <c>+</c> and <c>-</c> operators are
 * left-associative.  The precedence and associativity rules are taken from
 * the C programming language, except for the symbol <c>^</c>, which
 * is used in C for a different purpose.  (Exponentiation can be invoked
 * using either <c>^</c> or the function @c power.)
 * 
 * @htmlinclude math-precedence-table.html 
 *
 * A program parsing a formula in an SBML model should assume that names
 * appearing in the formula are the identifiers of Species, Parameter,
 * Compartment, FunctionDefinition, Reaction (in SBML Levels&nbsp;2
 * and&nbsp;3), or SpeciesReference (in SBML Level&nbsp;3 only) objects
 * defined in a model.  When a function call is involved, the syntax
 * consists of a function identifier, followed by optional white space,
 * followed by an opening parenthesis, followed by a sequence of zero or
 * more arguments separated by commas (with each comma optionally preceded
 * and/or followed by zero or more white space characters), followed by a
 * closing parenthesis.  There is an almost one-to-one mapping between the
 * list of predefined functions available, and those defined in MathML.
 * All of the MathML functions are recognized; this set is larger than the
 * functions defined in SBML Level&nbsp;1.  In the subset of functions that
 * overlap between MathML and SBML Level&nbsp;1, there exist a few
 * differences.  The following table summarizes the differences between the
 * predefined functions in SBML Level&nbsp;1 and the MathML equivalents in
 * SBML Levels&nbsp;2 and &nbsp;3:
 * 
 * @htmlinclude math-functions.html
 * 
 * @warning @htmlinclude L1-math-syntax-warning.html
 */

public class ASTNode : IDisposable {
	private HandleRef swigCPtr;
	protected bool swigCMemOwn;
	
	internal ASTNode(IntPtr cPtr, bool cMemoryOwn)
	{
		swigCMemOwn = cMemoryOwn;
		swigCPtr    = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(ASTNode obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (ASTNode obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~ASTNode() {
    Dispose();
  }

  public virtual void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_ASTNode(swigCPtr);
        }
        swigCPtr = new HandleRef(null, IntPtr.Zero);
      }
      GC.SuppressFinalize(this);
    }
  }

  public static bool operator==(ASTNode lhs, ASTNode rhs)
  {
    if((Object)lhs == (Object)rhs)
    {
      return true;
    }

    if( ((Object)lhs == null) || ((Object)rhs == null) )
    {
      return false;
    }

    return (getCPtr(lhs).Handle.ToString() == getCPtr(rhs).Handle.ToString());
  }

  public static bool operator!=(ASTNode lhs, ASTNode rhs)
  {
    return !(lhs == rhs);
  }

  public override bool Equals(Object sb)
  {
    if ( ! (sb is ASTNode) )
    {
      return false;
    }

    return this == (ASTNode)sb;
  }

  public override int GetHashCode()
  {
    return swigCPtr.Handle.ToInt32();
  }

  
/**
   * Creates and returns a new ASTNode.
   *
   * Unless the argument @p type is given, the returned node will by
   * default have a type of @link libsbmlcs.libsbml.AST_UNKNOWN
   * AST_UNKNOWN@endlink.  If the type isn't supplied when caling this
   * constructor, the caller should set the node type to something else as
   * soon as possible using
   * @if clike setType()@else ASTNode::setType(int)@endif.
   *
   * @param type an optional
   * @if clike @link #ASTNodeType_t ASTNodeType_t@endlink@else type@endif
   * code indicating the type of node to create.
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 ASTNode(int type) : this(libsbmlPINVOKE.new_ASTNode__SWIG_0(type), true) {
  }

  
/**
   * Creates and returns a new ASTNode.
   *
   * Unless the argument @p type is given, the returned node will by
   * default have a type of @link libsbmlcs.libsbml.AST_UNKNOWN
   * AST_UNKNOWN@endlink.  If the type isn't supplied when caling this
   * constructor, the caller should set the node type to something else as
   * soon as possible using
   * @if clike setType()@else ASTNode::setType(int)@endif.
   *
   * @param type an optional
   * @if clike @link #ASTNodeType_t ASTNodeType_t@endlink@else type@endif
   * code indicating the type of node to create.
   *
   * @if notcpp @docnote @htmlinclude warn-default-args-in-docs.html @endif
   */ public
 ASTNode() : this(libsbmlPINVOKE.new_ASTNode__SWIG_1(), true) {
  }

  
/**
   * Copy constructor; creates a deep copy of the given ASTNode.
   *
   * @param orig the ASTNode to be copied.
   */ public
 ASTNode(ASTNode orig) : this(libsbmlPINVOKE.new_ASTNode__SWIG_2(ASTNode.getCPtr(orig)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Frees the name of this ASTNode and sets it to @c null.
   * 
   * This operation is only applicable to ASTNode objects corresponding to
   * operators, numbers, or @link libsbmlcs.libsbml.AST_UNKNOWN
   * AST_UNKNOWN@endlink.  This method has no effect on other types of
   * nodes.
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
   */ public
 int freeName() {
    int ret = libsbmlPINVOKE.ASTNode_freeName(swigCPtr);
    return ret;
  }

  
/**
   * Converts this ASTNode to a canonical form and returns @c true if
   * successful, @c false otherwise.
   *
   * The rules determining the canonical form conversion are as follows:
   * <ul>
   *
   * <li> If the node type is @link libsbmlcs.libsbml.AST_NAME AST_NAME@endlink
   * and the node name matches @c 'ExponentialE', @c 'Pi', @c 'True' or @c
   * 'False' the node type is converted to the corresponding 
   * <c>AST_CONSTANT_</c><em><span class='placeholder'>X</span></em> type.
   *
   * <li> If the node type is an @link libsbmlcs.libsbml.AST_FUNCTION
   * AST_FUNCTION@endlink and the node name matches an SBML (MathML) function name, logical operator name, or
   * relational operator name, the node is converted to the corresponding
   * <c>AST_FUNCTION_</c><em><span class='placeholder'>X</span></em> or
   * <c>AST_LOGICAL_</c><em><span class='placeholder'>X</span></em> type.
   *
   * </ul>
   *
   * SBML Level&nbsp;1 function names are searched first; thus, for
   * example, canonicalizing @c log will result in a node type of @link
   * libsbmlcs.libsbml.AST_FUNCTION_LN AST_FUNCTION_LN@endlink.  (See the SBML
   * Level&nbsp;1 Version&nbsp;2 Specification, Appendix C.)
   *
   * Sometimes, canonicalization of a node results in a structural
   * conversion of the node as a result of adding a child.  For example, a
   * node with the SBML Level&nbsp;1 function name @c sqr and a single
   * child node (the argument) will be transformed to a node of type
   * @link libsbmlcs.libsbml.AST_FUNCTION_POWER AST_FUNCTION_POWER@endlink with
   * two children.  The first child will remain unchanged, but the second
   * child will be an ASTNode of type @link libsbmlcs.libsbml.AST_INTEGER
   * AST_INTEGER@endlink and a value of 2.  The function names that result
   * in structural changes are: @c log10, @c sqr, and @c sqrt.
   */ public
 bool canonicalize() {
    bool ret = libsbmlPINVOKE.ASTNode_canonicalize(swigCPtr);
    return ret;
  }

  
/**
   * Adds the given node as a child of this ASTNode.  Child nodes are added
   * in-order, from left to right.
   *
   * @param child the ASTNode instance to add
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
   *
   * @note Adding a child to an ASTNode may change the structure of the
   * mathematical formula being represented by the tree structure, and may
   * render the representation invalid.  Callers need to be careful to use
   * this method in the context of other operations to create complete and
   * correct formulas.  The method
   * @if clike isWellFormedASTNode()@else ASTNode::isWellFormedASTNode()@endif
   * may also be useful for checking the results of node modifications.
   *
   * @see prependChild(ASTNode child)
   * @see replaceChild(long n, ASTNode child)
   * @see insertChild(long n, ASTNode child)
   * @see removeChild(long n)
   * @see isWellFormedASTNode()
   */ public
 int addChild(ASTNode child) {
    int ret = libsbmlPINVOKE.ASTNode_addChild(swigCPtr, ASTNode.getCPtrAndDisown(child));
    return ret;
  }

  
/**
   * Adds the given node as a child of this ASTNode.  This method adds
   * child nodes from right to left.
   *
   * @param child the ASTNode instance to add
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
   *
   * @note Prepending a child to an ASTNode may change the structure of the
   * mathematical formula being represented by the tree structure, and may
   * render the representation invalid.
   *
   * @see addChild(ASTNode child)
   * @see replaceChild(long n, ASTNode child)
   * @see insertChild(long n, ASTNode child)
   * @see removeChild(long n)
   */ public
 int prependChild(ASTNode child) {
    int ret = libsbmlPINVOKE.ASTNode_prependChild(swigCPtr, ASTNode.getCPtrAndDisown(child));
    return ret;
  }

  
/**
   * Removes the nth child of this ASTNode object.
   *
   * @param n long the index of the child to remove
   *
   * @return integer value indicating success/failure of the
   * function. The possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE @endlink
   *
   * @note Removing a child from an ASTNode may change the structure of the
   * mathematical formula being represented by the tree structure, and may
   * render the representation invalid.
   *
   * @see addChild(ASTNode child)
   * @see prependChild(ASTNode child)
   * @see replaceChild(long n, ASTNode child)
   * @see insertChild(long n, ASTNode child)
   */ public
 int removeChild(long n) {
    int ret = libsbmlPINVOKE.ASTNode_removeChild(swigCPtr, n);
    return ret;
  }

  
/**
   * Replaces the nth child of this ASTNode with the given ASTNode.
   *
   * @param n long the index of the child to replace
   * @param newChild ASTNode to replace the nth child
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
   *
   * @note Replacing a child from an ASTNode may change the structure of the
   * mathematical formula being represented by the tree structure, and may
   * render the representation invalid.
   * 
   * @see addChild(ASTNode child)
   * @see prependChild(ASTNode child)
   * @see insertChild(long n, ASTNode child)
   * @see removeChild(long n)
   */ public
 int replaceChild(long n, ASTNode newChild) {
    int ret = libsbmlPINVOKE.ASTNode_replaceChild(swigCPtr, n, ASTNode.getCPtrAndDisown(newChild));
    return ret;
  }

  
/**
   * Insert the given ASTNode at point n in the list of children
   * of this ASTNode.
   *
   * @param n long the index of the ASTNode being added
   * @param newChild ASTNode to insert as the nth child
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INDEX_EXCEEDS_SIZE LIBSBML_INDEX_EXCEEDS_SIZE @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
   *
   * @note Inserting a child into an ASTNode may change the structure of the
   * mathematical formula being represented by the tree structure, and may
   * render the representation invalid.
   * 
   * @see addChild(ASTNode child)
   * @see prependChild(ASTNode child)
   * @see replaceChild(long n, ASTNode child)
   * @see removeChild(long n)
   */ public
 int insertChild(long n, ASTNode newChild) {
    int ret = libsbmlPINVOKE.ASTNode_insertChild(swigCPtr, n, ASTNode.getCPtrAndDisown(newChild));
    return ret;
  }

  
/**
   * Creates a recursive copy of this node and all its children.
   * 
   * @return a copy of this ASTNode and all its children.  The caller owns
   * the returned ASTNode and is reponsible for deleting it.
   */ public
 ASTNode deepCopy() {
    IntPtr cPtr = libsbmlPINVOKE.ASTNode_deepCopy(swigCPtr);
    ASTNode ret = (cPtr == IntPtr.Zero) ? null : new ASTNode(cPtr, true);
    return ret;
  }

  
/**
   * Get a child of this node according to its index number.
   *
   * @param n the index of the child to get
   * 
   * @return the nth child of this ASTNode or @c null if this node has no nth
   * child (<c>n &gt; </c>
   * @if clike getNumChildren()@else ASTNode::getNumChildren()@endif
   * <c>- 1</c>).
   */ public
 ASTNode getChild(long n) {
    IntPtr cPtr = libsbmlPINVOKE.ASTNode_getChild(swigCPtr, n);
    ASTNode ret = (cPtr == IntPtr.Zero) ? null : new ASTNode(cPtr, false);
    return ret;
  }

  
/**
   * Get the left child of this node.
   * 
   * @return the left child of this ASTNode.  This is equivalent to calling
   * @if clike getChild()@else ASTNode::getChild(long)@endif
   * with an argument of @c 0.
   */ public
 ASTNode getLeftChild() {
    IntPtr cPtr = libsbmlPINVOKE.ASTNode_getLeftChild(swigCPtr);
    ASTNode ret = (cPtr == IntPtr.Zero) ? null : new ASTNode(cPtr, false);
    return ret;
  }

  
/**
   * Get the right child of this node.
   *
   * @return the right child of this ASTNode, or @c null if this node has no
   * right child.  If
   * @if clike getNumChildren()@else ASTNode::getNumChildren()@endif
   * <c>&gt; 1</c>, then this is equivalent to:
   * @code
   * getChild( getNumChildren() - 1 );
   * @endcode
   */ public
 ASTNode getRightChild() {
    IntPtr cPtr = libsbmlPINVOKE.ASTNode_getRightChild(swigCPtr);
    ASTNode ret = (cPtr == IntPtr.Zero) ? null : new ASTNode(cPtr, false);
    return ret;
  }

  
/**
   * Get the number of children that this node has.
   * 
   * @return the number of children of this ASTNode, or 0 is this node has
   * no children.
   */ public
 long getNumChildren() { return (long)libsbmlPINVOKE.ASTNode_getNumChildren(swigCPtr); }

  
/**
   * Adds the given XMLNode as a <em>semantic annotation</em> of this ASTNode.
   *
   * @htmlinclude about-semantic-annotations.html
   *
   * @param sAnnotation the annotation to add.
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
   *
   * @note Although SBML permits the semantic annotation construct in
   * MathML expressions, the truth is that this construct has so far (at
   * this time of this writing, which is early 2011) seen very little use
   * in SBML software.  The full implications of using semantic annotations
   * are still poorly understood.  If you wish to use this construct, we
   * urge you to discuss possible uses and applications on the SBML
   * discussion lists, particularly <a target='_blank'
   * href='http://sbml.org/Forums'>sbml-discuss&#64;caltech.edu</a> and/or <a
   * target='_blank'
   * href='http://sbml.org/Forums'>sbml-interoperability&#64;caltech.edu</a>.
   */ public
 int addSemanticsAnnotation(XMLNode sAnnotation) {
    int ret = libsbmlPINVOKE.ASTNode_addSemanticsAnnotation(swigCPtr, XMLNode.getCPtrAndDisown(sAnnotation));
    return ret;
  }

  
/**
   * Get the number of <em>semantic annotation</em> elements inside this node.
   *
   * @htmlinclude about-semantic-annotations.html
   * 
   * @return the number of annotations of this ASTNode.
   *
   * @see ASTNode::addSemanticsAnnotation(XMLNode sAnnotation)
   */ public
 long getNumSemanticsAnnotations() { return (long)libsbmlPINVOKE.ASTNode_getNumSemanticsAnnotations(swigCPtr); }

  
/**
   * Get the nth semantic annotation of this node.
   *
   * @htmlinclude about-semantic-annotations.html
   * 
   * @return the nth annotation of this ASTNode, or @c null if this node has
   * no nth annotation (<c>n &gt;</c>
   * @if clike getNumChildren()@else ASTNode::getNumChildren()@endif
   * <c>- 1</c>).
   *
   * @see ASTNode::addSemanticsAnnotation(XMLNode sAnnotation)
   */ public
 XMLNode getSemanticsAnnotation(long n) {
    IntPtr cPtr = libsbmlPINVOKE.ASTNode_getSemanticsAnnotation(swigCPtr, n);
    XMLNode ret = (cPtr == IntPtr.Zero) ? null : new XMLNode(cPtr, false);
    return ret;
  }

  
/**
   * Get the value of this node as a single character.  This function
   * should be called only when
   * @if clike getType()@else ASTNode::getType()@endif returns
   * @link libsbmlcs.libsbml.AST_PLUS AST_PLUS@endlink,
   * @link libsbmlcs.libsbml.AST_MINUS AST_MINUS@endlink,
   * @link libsbmlcs.libsbml.AST_TIMES AST_TIMES@endlink,
   * @link libsbmlcs.libsbml.AST_DIVIDE AST_DIVIDE@endlink or
   * @link libsbmlcs.libsbml.AST_POWER AST_POWER@endlink.
   * 
   * @return the value of this ASTNode as a single character
   */ public
 char getCharacter() {
    char ret = libsbmlPINVOKE.ASTNode_getCharacter(swigCPtr);
    return ret;
  }

  
/**
   * Get the id of this ASTNode.  
   * 
   * @return the mathml id of this ASTNode.
   */ public
 string getId() {
    string ret = libsbmlPINVOKE.ASTNode_getId(swigCPtr);
    return ret;
  }

  
/**
   * Get the class of this ASTNode.  
   * 
   * @return the mathml class of this ASTNode.
   */ public
 string getClass() {
    string ret = libsbmlPINVOKE.ASTNode_getClass(swigCPtr);
    return ret;
  }

  
/**
   * Get the style of this ASTNode.  
   * 
   * @return the mathml style of this ASTNode.
   */ public
 string getStyle() {
    string ret = libsbmlPINVOKE.ASTNode_getStyle(swigCPtr);
    return ret;
  }

  
/**
   * Get the value of this node as an integer. This function should be
   * called only when
   * @if clike getType()@else ASTNode::getType()@endif
   * <c>== @link libsbmlcs.libsbml.AST_INTEGER AST_INTEGER@endlink</c>.
   * 
   * @return the value of this ASTNode as a (<c>long</c>) integer. 
   */ public
 int getInteger() {
    int ret = libsbmlPINVOKE.ASTNode_getInteger(swigCPtr);
    return ret;
  }

  
/**
   * Get the value of this node as a string.  This function may be called
   * on nodes that (1) are not operators, i.e., nodes for which
   * @if clike isOperator()@else ASTNode::isOperator()@endif
   * returns @c false, and (2) are not numbers, i.e.,
   * @if clike isNumber()@else ASTNode::isNumber()@endif returns @c false.
   * 
   * @return the value of this ASTNode as a string.
   */ public
 string getName() {
    string ret = libsbmlPINVOKE.ASTNode_getName(swigCPtr);
    return ret;
  }

  
/**
   * Get the value of the numerator of this node.  This function should be
   * called only when
   * @if clike getType()@else ASTNode::getType()@endif
   * <c>== @link libsbmlcs.libsbml.AST_RATIONAL AST_RATIONAL@endlink</c>.
   * 
   * @return the value of the numerator of this ASTNode.  
   */ public
 int getNumerator() {
    int ret = libsbmlPINVOKE.ASTNode_getNumerator(swigCPtr);
    return ret;
  }

  
/**
   * Get the value of the denominator of this node.  This function should
   * be called only when
   * @if clike getType()@else ASTNode::getType()@endif
   * <c>== @link libsbmlcs.libsbml.AST_RATIONAL AST_RATIONAL@endlink</c>.
   * 
   * @return the value of the denominator of this ASTNode.
   */ public
 int getDenominator() {
    int ret = libsbmlPINVOKE.ASTNode_getDenominator(swigCPtr);
    return ret;
  }

  
/**
   * Get the real-numbered value of this node.  This function
   * should be called only when
   * @if clike isReal()@else ASTNode::isReal()@endif
   * <c>== true</c>.
   *
   * This function performs the necessary arithmetic if the node type is
   * @link libsbmlcs.libsbml.AST_REAL_E AST_REAL_E@endlink (<em>mantissa *
   * 10<sup> exponent</sup></em>) or @link libsbmlcs.libsbml.AST_RATIONAL
   * AST_RATIONAL@endlink (<em>numerator / denominator</em>).
   * 
   * @return the value of this ASTNode as a real (double).
   */ public
 double getReal() {
    double ret = libsbmlPINVOKE.ASTNode_getReal(swigCPtr);
    return ret;
  }

  
/**
   * Get the mantissa value of this node.  This function should be called
   * only when @if clike getType()@else ASTNode::getType()@endif
   * returns @link libsbmlcs.libsbml.AST_REAL_E AST_REAL_E@endlink
   * or @link libsbmlcs.libsbml.AST_REAL AST_REAL@endlink.
   * If @if clike getType()@else ASTNode::getType()@endif
   * returns @link libsbmlcs.libsbml.AST_REAL AST_REAL@endlink,
   * this method is identical to
   * @if clike getReal()@else ASTNode::getReal()@endif.
   * 
   * @return the value of the mantissa of this ASTNode. 
   */ public
 double getMantissa() {
    double ret = libsbmlPINVOKE.ASTNode_getMantissa(swigCPtr);
    return ret;
  }

  
/**
   * Get the exponent value of this ASTNode.  This function should be
   * called only when
   * @if clike getType()@else ASTNode::getType()@endif
   * returns @link libsbmlcs.libsbml.AST_REAL_E AST_REAL_E@endlink
   * or @link libsbmlcs.libsbml.AST_REAL AST_REAL@endlink.
   * 
   * @return the value of the exponent of this ASTNode.
   */ public
 int getExponent() {
    int ret = libsbmlPINVOKE.ASTNode_getExponent(swigCPtr);
    return ret;
  }

  
/**
   * Get the precedence of this node in the infix math syntax of SBML
   * Level&nbsp;1.  For more information about the infix syntax, see the
   * discussion about <a href='#math-convert'>text string formulas</a> at
   * the top of the documentation for ASTNode.
   * 
   * @return an integer indicating the precedence of this ASTNode
   */ public
 int getPrecedence() {
    int ret = libsbmlPINVOKE.ASTNode_getPrecedence(swigCPtr);
    return ret;
  }

  
/**
   * Get the type of this ASTNode.  The value returned is one of the
   * enumeration values such as @link libsbmlcs.libsbml.AST_LAMBDA
   * AST_LAMBDA@endlink, @link libsbmlcs.libsbml.AST_PLUS AST_PLUS@endlink,
   * etc.
   * 
   * @return the type of this ASTNode.
   */ public
 int getType() {
    int ret = libsbmlPINVOKE.ASTNode_getType(swigCPtr);
    return ret;
  }

  
/**
   * Get the units of this ASTNode.  
   *
   * @htmlinclude about-sbml-units-attrib.html
   * 
   * @return the units of this ASTNode.
   *
   * @note The <c>sbml:units</c> attribute is only available in SBML
   * Level&nbsp;3.  It may not be used in Levels 1&ndash;2 of SBML.
   * 
   */ public
 string getUnits() {
    string ret = libsbmlPINVOKE.ASTNode_getUnits(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node is the special 
   * symbol @c avogadro.  The predicate returns @c false (zero) otherwise.
   * 
   * @return @c true if this ASTNode is the special symbol avogadro.
   */ public
 bool isAvogadro() {
    bool ret = libsbmlPINVOKE.ASTNode_isAvogadro(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node has a bool type
   * (a logical operator, a relational operator, or the constants @c true
   * or @c false).
   *
   * @return true if this ASTNode is a bool, false otherwise.
   */ public
 bool isBoolean() {
    bool ret = libsbmlPINVOKE.ASTNode_isBoolean(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node returns a bool type
   * or @c false (zero) otherwise.
   *
   * This function looks at the whole ASTNode rather than just the top 
   * level of the ASTNode. Thus it will consider return values from
   * piecewise statements.  In addition, if this ASTNode uses a function
   * call, the return value of the functionDefinition will be determined.
   * Note that this is only possible where the ASTNode can trace its parent
   * Model, that is, the ASTNode must represent the math element of some
   * SBML object that has already been added to an instance of an SBMLDocument.
   *
   * @see isBoolean()
   *
   * @return true if this ASTNode returns a bool, false otherwise.
   */ public
 bool returnsBoolean(Model model) {
    bool ret = libsbmlPINVOKE.ASTNode_returnsBoolean__SWIG_0(swigCPtr, Model.getCPtr(model));
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node returns a bool type
   * or @c false (zero) otherwise.
   *
   * This function looks at the whole ASTNode rather than just the top 
   * level of the ASTNode. Thus it will consider return values from
   * piecewise statements.  In addition, if this ASTNode uses a function
   * call, the return value of the functionDefinition will be determined.
   * Note that this is only possible where the ASTNode can trace its parent
   * Model, that is, the ASTNode must represent the math element of some
   * SBML object that has already been added to an instance of an SBMLDocument.
   *
   * @see isBoolean()
   *
   * @return true if this ASTNode returns a bool, false otherwise.
   */ public
 bool returnsBoolean() {
    bool ret = libsbmlPINVOKE.ASTNode_returnsBoolean__SWIG_1(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node represents a MathML
   * constant (e.g., @c true, @c Pi).
   * 
   * @return @c true if this ASTNode is a MathML constant, @c false otherwise.
   * 
   * @note this function will also return @c true for @link
   * libsbmlcs.libsbml.AST_NAME_AVOGADRO AST_NAME_AVOGADRO@endlink in SBML Level&nbsp;3.
   */ public
 bool isConstant() {
    bool ret = libsbmlPINVOKE.ASTNode_isConstant(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node represents a
   * MathML function (e.g., <c>abs()</c>), or an SBML Level&nbsp;1
   * function, or a user-defined function.
   * 
   * @return @c true if this ASTNode is a function, @c false otherwise.
   */ public
 bool isFunction() {
    bool ret = libsbmlPINVOKE.ASTNode_isFunction(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node represents
   * the special IEEE 754 value infinity, @c false (zero) otherwise.
   *
   * @return @c true if this ASTNode is the special IEEE 754 value infinity,
   * @c false otherwise.
   */ public
 bool isInfinity() {
    bool ret = libsbmlPINVOKE.ASTNode_isInfinity(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node contains an
   * integer value, @c false (zero) otherwise.
   *
   * @return @c true if this ASTNode is of type @link
   * libsbmlcs.libsbml.AST_INTEGER AST_INTEGER@endlink, @c false otherwise.
   */ public
 bool isInteger() {
    bool ret = libsbmlPINVOKE.ASTNode_isInteger(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node is a MathML
   * <c>&lt;lambda&gt;</c>, @c false (zero) otherwise.
   * 
   * @return @c true if this ASTNode is of type @link libsbmlcs.libsbml.AST_LAMBDA
   * AST_LAMBDA@endlink, @c false otherwise.
   */ public
 bool isLambda() {
    bool ret = libsbmlPINVOKE.ASTNode_isLambda(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node represents a 
   * @c log10 function, @c false (zero) otherwise.  More precisely, this
   * predicate returns @c true if the node type is @link
   * libsbmlcs.libsbml.AST_FUNCTION_LOG AST_FUNCTION_LOG@endlink with two
   * children, the first of which is an @link libsbmlcs.libsbml.AST_INTEGER
   * AST_INTEGER@endlink equal to 10.
   * 
   * @return @c true if the given ASTNode represents a log10() function, @c
   * false otherwise.
   */ public
 bool isLog10() {
    bool ret = libsbmlPINVOKE.ASTNode_isLog10(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node is a MathML
   * logical operator (i.e., @c and, @c or, @c not, @c xor).
   * 
   * @return @c true if this ASTNode is a MathML logical operator
   */ public
 bool isLogical() {
    bool ret = libsbmlPINVOKE.ASTNode_isLogical(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node is a user-defined
   * variable name in SBML L1, L2 (MathML), or the special symbols @c delay
   * or @c time.  The predicate returns @c false (zero) otherwise.
   * 
   * @return @c true if this ASTNode is a user-defined variable name in SBML
   * L1, L2 (MathML) or the special symbols delay or time.
   */ public
 bool isName() {
    bool ret = libsbmlPINVOKE.ASTNode_isName(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node represents the
   * special IEEE 754 value 'not a number' (NaN), @c false (zero)
   * otherwise.
   * 
   * @return @c true if this ASTNode is the special IEEE 754 NaN.
   */ public
 bool isNaN() {
    bool ret = libsbmlPINVOKE.ASTNode_isNaN(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node represents the
   * special IEEE 754 value 'negative infinity', @c false (zero) otherwise.
   * 
   * @return @c true if this ASTNode is the special IEEE 754 value negative
   * infinity, @c false otherwise.
   */ public
 bool isNegInfinity() {
    bool ret = libsbmlPINVOKE.ASTNode_isNegInfinity(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node contains a number,
   * @c false (zero) otherwise.  This is functionally equivalent to the
   * following code:
   * @code
   *   isInteger() || isReal()
   * @endcode
   * 
   * @return @c true if this ASTNode is a number, @c false otherwise.
   */ public
 bool isNumber() {
    bool ret = libsbmlPINVOKE.ASTNode_isNumber(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node is a mathematical
   * operator, meaning, <c>+</c>, <c>-</c>, <c>*</c>, 
   * <c>/</c> or <c>^</c> (power).
   * 
   * @return @c true if this ASTNode is an operator.
   */ public
 bool isOperator() {
    bool ret = libsbmlPINVOKE.ASTNode_isOperator(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node is the MathML
   * <c>&lt;piecewise&gt;</c> construct, @c false (zero) otherwise.
   * 
   * @return @c true if this ASTNode is a MathML @c piecewise function
   */ public
 bool isPiecewise() {
    bool ret = libsbmlPINVOKE.ASTNode_isPiecewise(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node represents a rational
   * number, @c false (zero) otherwise.
   * 
   * @return @c true if this ASTNode is of type @link
   * libsbmlcs.libsbml.AST_RATIONAL AST_RATIONAL@endlink.
   */ public
 bool isRational() {
    bool ret = libsbmlPINVOKE.ASTNode_isRational(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node can represent a
   * real number, @c false (zero) otherwise.  More precisely, this node
   * must be of one of the following types: @link libsbmlcs.libsbml.AST_REAL
   * AST_REAL@endlink, @link libsbmlcs.libsbml.AST_REAL_E AST_REAL_E@endlink or
   * @link libsbmlcs.libsbml.AST_RATIONAL AST_RATIONAL@endlink.
   * 
   * @return @c true if the value of this ASTNode can represented as a real
   * number, @c false otherwise.
   */ public
 bool isReal() {
    bool ret = libsbmlPINVOKE.ASTNode_isReal(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node is a MathML
   * relational operator, meaning <c>==</c>, <c>&gt;=</c>, 
   * <c>&gt;</c>, <c>&lt;</c>, and <c>!=</c>.
   * 
   * @return @c true if this ASTNode is a MathML relational operator, @c
   * false otherwise
   */ public
 bool isRelational() {
    bool ret = libsbmlPINVOKE.ASTNode_isRelational(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node represents a
   * square root function, @c false (zero) otherwise.  More precisely, the
   * node type must be @link libsbmlcs.libsbml.AST_FUNCTION_ROOT
   * AST_FUNCTION_ROOT@endlink with two children, the first of which is an
   * @link libsbmlcs.libsbml.AST_INTEGER AST_INTEGER@endlink node having value
   * equal to 2.
   * 
   * @return @c true if the given ASTNode represents a sqrt() function,
   * @c false otherwise.
   */ public
 bool isSqrt() {
    bool ret = libsbmlPINVOKE.ASTNode_isSqrt(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node is a unary minus
   * operator, @c false (zero) otherwise.  A node is defined as a unary
   * minus node if it is of type @link libsbmlcs.libsbml.AST_MINUS
   * AST_MINUS@endlink and has exactly one child.
   * 
   * For numbers, unary minus nodes can be 'collapsed' by negating the
   * number.  In fact, 
   * @if clike libsbmlcs.libsbml.parseFormula() @endif@if csharp libsbmlcs.libsbml.parseFormula() @else <c><a href='libsbml.html#parseFormula(java.lang.String)'>libsbml.parseFormula()</a></c>@endif does this during its parsing process.
   * However, unary minus nodes for symbols
   * (@link libsbmlcs.libsbml.AST_NAME AST_NAME@endlink) cannot
   * be 'collapsed', so this predicate function is necessary.
   * 
   * @return @c true if this ASTNode is a unary minus, @c false otherwise.
   */ public
 bool isUMinus() {
    bool ret = libsbmlPINVOKE.ASTNode_isUMinus(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node is a unary plus
   * operator, @c false (zero) otherwise.  A node is defined as a unary
   * minus node if it is of type @link libsbmlcs.libsbml.AST_MINUS
   * AST_MINUS@endlink and has exactly one child.
   *
   * @return @c true if this ASTNode is a unary plus, @c false otherwise.
   */ public
 bool isUPlus() {
    bool ret = libsbmlPINVOKE.ASTNode_isUPlus(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node has an unknown type.
   * 
   * 'Unknown' nodes have the type @link libsbmlcs.libsbml.AST_UNKNOWN
   * AST_UNKNOWN@endlink.  Nodes with unknown types will not appear in an
   * ASTNode tree returned by libSBML based upon valid SBML input; the only
   * situation in which a node with type @link libsbmlcs.libsbml.AST_UNKNOWN
   * AST_UNKNOWN@endlink may appear is immediately after having create a
   * new, untyped node using the ASTNode constructor.  Callers creating
   * nodes should endeavor to set the type to a valid node type as soon as
   * possible after creating new nodes.
   * 
   * @return @c true if this ASTNode is of type @link
   * libsbmlcs.libsbml.AST_UNKNOWN AST_UNKNOWN@endlink, @c false otherwise.
   */ public
 bool isUnknown() {
    bool ret = libsbmlPINVOKE.ASTNode_isUnknown(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node has the mathml attribute
   * <c>id</c>.
   * 
   * @return true if this ASTNode has an attribute id, false otherwise.
   */ public
 bool isSetId() {
    bool ret = libsbmlPINVOKE.ASTNode_isSetId(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node has the mathml attribute
   * <c>class</c>.
   * 
   * @return true if this ASTNode has an attribute class, false otherwise.
   */ public
 bool isSetClass() {
    bool ret = libsbmlPINVOKE.ASTNode_isSetClass(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node has the mathml attribute
   * <c>style</c>.
   * 
   * @return true if this ASTNode has an attribute style, false otherwise.
   */ public
 bool isSetStyle() {
    bool ret = libsbmlPINVOKE.ASTNode_isSetStyle(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node has the attribute
   * <c>sbml:units</c>.
   *
   * @htmlinclude about-sbml-units-attrib.html
   * 
   * @return @c true if this ASTNode has units associated with it, @c false otherwise.
   *
   * @note The <c>sbml:units</c> attribute is only available in SBML
   * Level&nbsp;3.  It may not be used in Levels 1&ndash;2 of SBML.
   */ public
 bool isSetUnits() {
    bool ret = libsbmlPINVOKE.ASTNode_isSetUnits(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true (non-zero) if this node or any of its
   * children nodes have the attribute <c>sbml:units</c>.
   *
   * @htmlinclude about-sbml-units-attrib.html
   * 
   * @return @c true if this ASTNode or its children has units associated
   * with it, @c false otherwise.
   *
   * @note The <c>sbml:units</c> attribute is only available in SBML
   * Level&nbsp;3.  It may not be used in Levels 1&ndash;2 of SBML.
   */ public
 bool hasUnits() {
    bool ret = libsbmlPINVOKE.ASTNode_hasUnits(swigCPtr);
    return ret;
  }

  
/**
   * Sets the value of this ASTNode to the given character.  If character
   * is one of @c +, @c -, <c>*</c>, <c>/</c> or @c ^, the node
   * type will be set accordingly.  For all other characters, the node type
   * will be set to @link libsbmlcs.libsbml.AST_UNKNOWN AST_UNKNOWN@endlink.
   *
   * @param value the character value to which the node's value should be
   * set.
   *
   * @return integer value indicating success/failure of the function.  The
   * possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   */ public
 int setCharacter(char value) {
    int ret = libsbmlPINVOKE.ASTNode_setCharacter(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the mathml id of this ASTNode to id.
   *
   * @param id @c string representing the identifier.
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   */ public
 int setId(string id) {
    int ret = libsbmlPINVOKE.ASTNode_setId(swigCPtr, id);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the mathml class of this ASTNode to className.
   *
   * @param className @c string representing the mathml class for this node.
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   */ public
 int setClass(string className) {
    int ret = libsbmlPINVOKE.ASTNode_setClass(swigCPtr, className);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the mathml style of this ASTNode to style.
   *
   * @param style @c string representing the identifier.
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   */ public
 int setStyle(string style) {
    int ret = libsbmlPINVOKE.ASTNode_setStyle(swigCPtr, style);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the value of this ASTNode to the given name.
   *
   * As a side-effect, this ASTNode object's type will be reset to
   * @link libsbmlcs.libsbml.AST_NAME AST_NAME@endlink if (and <em>only
   * if</em>) the ASTNode was previously an operator (
   * @if clike isOperator()@else ASTNode::isOperator()@endif
   * <c>== true</c>), number (
   * @if clike isNumber()@else ASTNode::isNumber()@endif
   * <c>== true</c>), or unknown.
   * This allows names to be set for @link libsbmlcs.libsbml.AST_FUNCTION
   * AST_FUNCTION@endlink nodes and the like.
   *
   * @param name the string containing the name to which this node's value
   * should be set
   *
   * @return integer value indicating success/failure of the function.  The
   * possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   */ public
 int setName(string name) {
    int ret = libsbmlPINVOKE.ASTNode_setName(swigCPtr, name);
    return ret;
  }

  
/**
   * Sets the value of this ASTNode to the given (@c long) integer and sets
   * the node type to @link libsbmlcs.libsbml.AST_INTEGER AST_INTEGER@endlink.
   *
   * @param value the integer to which this node's value should be set
   *
   * @return integer value indicating success/failure of the function.  The
   * possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   */ public
 int setValue(int value) {
    int ret = libsbmlPINVOKE.ASTNode_setValue__SWIG_0(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the value of this ASTNode to the given rational in two parts: the
   * numerator and denominator.  The node type is set to @link
   * libsbmlcs.libsbml.AST_RATIONAL AST_RATIONAL@endlink.
   *
   * @param numerator the numerator value of the rational
   * @param denominator the denominator value of the rational
   *
   * @return integer value indicating success/failure of the function.  The
   * possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   */ public
 int setValue(int numerator, int denominator) {
    int ret = libsbmlPINVOKE.ASTNode_setValue__SWIG_1(swigCPtr, numerator, denominator);
    return ret;
  }

  
/**
   * Sets the value of this ASTNode to the given real (@c double) and sets
   * the node type to @link libsbmlcs.libsbml.AST_REAL AST_REAL@endlink.
   *
   * This is functionally equivalent to:
   * @code
   * setValue(value, 0);
   * @endcode
   *
   * @param value the @c double format number to which this node's value
   * should be set
   *
   * @return integer value indicating success/failure of the function.  The
   * possible values returned by this function are: @li @link
   * libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS
   * LIBSBML_OPERATION_SUCCESS @endlink
   */ public
 int setValue(double value) {
    int ret = libsbmlPINVOKE.ASTNode_setValue__SWIG_2(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the value of this ASTNode to the given real (@c double) in two
   * parts: the mantissa and the exponent.  The node type is set to
   * @link libsbmlcs.libsbml.AST_REAL_E AST_REAL_E@endlink.
   *
   * @param mantissa the mantissa of this node's real-numbered value
   * @param exponent the exponent of this node's real-numbered value
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   */ public
 int setValue(double mantissa, int exponent) {
    int ret = libsbmlPINVOKE.ASTNode_setValue__SWIG_3(swigCPtr, mantissa, exponent);
    return ret;
  }

  
/**
   * Sets the type of this ASTNode to the given type code.  A side-effect
   * of doing this is that any numerical values previously stored in this
   * node are reset to zero.
   *
   * @param type the type to which this node should be set
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
   */ public
 int setType(int type) {
    int ret = libsbmlPINVOKE.ASTNode_setType(swigCPtr, type);
    return ret;
  }

  
/**
   * Sets the units of this ASTNode to units.
   *
   * The units will be set @em only if this ASTNode object represents a
   * MathML <c>&lt;cn&gt;</c> element, i.e., represents a number.
   * Callers may use
   * @if clike isNumber()@else ASTNode::isNumber()@endif
   * to inquire whether the node is of that type.
   *
   * @htmlinclude about-sbml-units-attrib.html
   *
   * @param units @c string representing the unit identifier.
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
   *
   * @note The <c>sbml:units</c> attribute is only available in SBML
   * Level&nbsp;3.  It may not be used in Levels 1&ndash;2 of SBML.
   */ public
 int setUnits(string units) {
    int ret = libsbmlPINVOKE.ASTNode_setUnits(swigCPtr, units);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Swap the children of this ASTNode object with the children of the
   * given ASTNode object.
   *
   * @param that the other node whose children should be used to replace
   * <em>this</em> node's children
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
   */ public
 int swapChildren(ASTNode that) {
    int ret = libsbmlPINVOKE.ASTNode_swapChildren(swigCPtr, ASTNode.getCPtr(that));
    return ret;
  }

  
/**
   * Renames all the SIdRef attributes on this node and any child node
   */ public
 void renameSIdRefs(string oldid, string newid) {
    libsbmlPINVOKE.ASTNode_renameSIdRefs(swigCPtr, oldid, newid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Renames all the UnitSIdRef attributes on this node and any child node.
   * (The only place UnitSIDRefs appear in MathML <c>&lt;cn&gt;</c> elements.)
   */ public
 void renameUnitSIdRefs(string oldid, string newid) {
    libsbmlPINVOKE.ASTNode_renameUnitSIdRefs(swigCPtr, oldid, newid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Replace any nodes of type AST_NAME with the name 'id' from the child 'math' object with the provided ASTNode. 
   *
   */ /* libsbml-internal */ public
 void replaceIDWithFunction(string id, ASTNode function) {
    libsbmlPINVOKE.ASTNode_replaceIDWithFunction(swigCPtr, id, ASTNode.getCPtr(function));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Replaces any 'AST_NAME_TIME' nodes with a node that multiplies time by the given function.
   *
   */ /* libsbml-internal */ public
 void multiplyTimeBy(ASTNode function) {
    libsbmlPINVOKE.ASTNode_multiplyTimeBy(swigCPtr, ASTNode.getCPtr(function));
  }

  
/**
   * Unsets the units of this ASTNode.
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
   */ public
 int unsetUnits() {
    int ret = libsbmlPINVOKE.ASTNode_unsetUnits(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the mathml id of this ASTNode.
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
   */ public
 int unsetId() {
    int ret = libsbmlPINVOKE.ASTNode_unsetId(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the mathml class of this ASTNode.
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
   */ public
 int unsetClass() {
    int ret = libsbmlPINVOKE.ASTNode_unsetClass(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the mathml style of this ASTNode.
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
   */ public
 int unsetStyle() {
    int ret = libsbmlPINVOKE.ASTNode_unsetStyle(swigCPtr);
    return ret;
  }

  
/**
   * Gets the MathML @c definitionURL attribute value.
   *
   * @return the value of the @c definitionURL attribute, in the form of
   * a libSBML XMLAttributes object.
   */ public
 XMLAttributes getDefinitionURL() {
    IntPtr cPtr = libsbmlPINVOKE.ASTNode_getDefinitionURL(swigCPtr);
    XMLAttributes ret = (cPtr == IntPtr.Zero) ? null : new XMLAttributes(cPtr, false);
    return ret;
  }

  
/**
   * Replaces occurences of a given name within this ASTNode with the
   * name/value/formula represented by @p arg.
   * 
   * For example, if the formula in this ASTNode is <c>x + y</c>,
   * then the <c>&lt;bvar&gt;</c> is @c x and @c arg is an ASTNode
   * representing the real value @c 3.  This method substitutes @c 3 for @c
   * x within this ASTNode object.
   *
   * @param bvar a string representing the variable name to be substituted
   * @param arg an ASTNode representing the name/value/formula to substitute
   */ public
 void replaceArgument(string bvar, ASTNode arg) {
    libsbmlPINVOKE.ASTNode_replaceArgument(swigCPtr, bvar, ASTNode.getCPtr(arg));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Returns the parent SBML object.
   * 
   * @return the parent SBML object of this ASTNode.
   */ public
 SBase getParentSBMLObject() {
	SBase ret = (SBase) libsbml.DowncastSBase(libsbmlPINVOKE.ASTNode_getParentSBMLObject(swigCPtr), false);
	return ret;
}

  
/**
   * Reduces this ASTNode to a binary tree.
   * 
   * Example: if this ASTNode is <c>and(x, y, z)</c>, then the 
   * formula of the reduced node is <c>and(and(x, y), z)</c>.  The
   * operation replaces the formula stored in the current ASTNode object.
   */ public
 void reduceToBinary() {
    libsbmlPINVOKE.ASTNode_reduceToBinary(swigCPtr);
  }

  
/**
  * Predicate returning @c true or @c false depending on whether this
  * ASTNode is well-formed.
  *
  * @note An ASTNode may be well-formed, with each node and its children
  * having the appropriate number of children for the given type, but may
  * still be invalid in the context of its use within an SBML model.
  *
  * @return @c true if this ASTNode is well-formed, @c false otherwise.
  *
  * @see hasCorrectNumberArguments()
  */ public
 bool isWellFormedASTNode() {
    bool ret = libsbmlPINVOKE.ASTNode_isWellFormedASTNode(swigCPtr);
    return ret;
  }

  
/**
  * Predicate returning @c true or @c false depending on whether this
  * ASTNode has the correct number of children for it's type.
  *
  * For example, an ASTNode with type @link libsbmlcs.libsbml.AST_PLUS
  * AST_PLUS@endlink expects 2 child nodes.
  *
  * @note This function performs a check on the toplevel node only.
  * Child nodes are not checked.
  *
  * @return @c true if this ASTNode is has appropriate number of children
  * for it's type, @c false otherwise.
  *
  * @see isWellFormedASTNode()
  */ public
 bool hasCorrectNumberArguments() {
    bool ret = libsbmlPINVOKE.ASTNode_hasCorrectNumberArguments(swigCPtr);
    return ret;
  }

  
/**
  * Predicate returning @c true or @c false depending on whether this
  * ASTNode has the correct number of children for it's type.
  *
  * For example, an ASTNode with type @link libsbmlcs.libsbml.AST_PLUS
  * AST_PLUS@endlink expects 2 child nodes.
  *
  * @note This function performs a check on the toplevel node only.
  * Child nodes are not checked.
  *
  * @return @c true if this ASTNode is has appropriate number of children
  * for it's type, @c false otherwise.
  *
  * @see isWellFormedASTNode()
  */ /* libsbml-internal */ public
 bool isBvar() {
    bool ret = libsbmlPINVOKE.ASTNode_isBvar(swigCPtr);
    return ret;
  }

  
/**
  * Predicate returning @c true or @c false depending on whether this
  * ASTNode has the correct number of children for it's type.
  *
  * For example, an ASTNode with type @link libsbmlcs.libsbml.AST_PLUS
  * AST_PLUS@endlink expects 2 child nodes.
  *
  * @note This function performs a check on the toplevel node only.
  * Child nodes are not checked.
  *
  * @return @c true if this ASTNode is has appropriate number of children
  * for it's type, @c false otherwise.
  *
  * @see isWellFormedASTNode()
  */ /* libsbml-internal */ public
 void setBvar() {
    libsbmlPINVOKE.ASTNode_setBvar(swigCPtr);
  }

  public ASTNodeList getListOfNodes() {
    IntPtr cPtr = libsbmlPINVOKE.ASTNode_getListOfNodes(swigCPtr);
    ASTNodeList ret = (cPtr == IntPtr.Zero) ? null : new ASTNodeList(cPtr, true);
    return ret;
  }

}

}
