/*
	sample xml-rpc handler module for caudium

   (c) 1999 Martin Baehr
   (c) 2001 Karl Pitrich

   This program is free software; you can redistribute it and/or modify it *
   under the terms of the GNU General Public License as published by the   *
   Free Software Foundation; either version 2 of the License, or (at your  *
   option) any later version.     
   
   CHANGELOG:
      -fixed array type handling (pit, 2001-03-30)
      -class framework (pit, 2001-03-30)
*/

inherit "module";
inherit "xmlrpc.pmod";
inherit "caudiumlib";
#include <module.h>

constant cvs_version = "$Id: xml-rpc.pike,v 1.2 2001/04/10 18:31:32 pit Exp $";
constant module_type = MODULE_LOCATION;
constant module_name = "XML-RPC Module";
constant module_doc =
"This module accepts XMLRPC requests "
"(see <a href='http://www.xmlrpc.org/'>http://www.xmlrpc.org/</a>) "
" and invokes the appropriate method.";

object xml_rpc;

void create()
{
  defvar("mountpoint", "/xmlrpc/", "Mount point",
			TYPE_LOCATION,
			"This is where the module will be inserted "
			"in the namespace of your server.");
}

void start()
{
	xml_rpc=xmlRPC();
}

void stop()
{
	destruct(xml_rpc);
}

mapping|Stdio.File|void find_file( string path, object id )
{
  function    call;
  string xmlResult;
  mixed callResult;
  string     fcall;
  mixed       args;
  mapping      rpc;

  rpc = xml_rpc->parse(id->data);
  fcall = rpc["methodName"];
  args  = rpc["params"];

  array rpc_providers = id->conf->get_providers("XML-RPC");
  foreach(rpc_providers, mixed provider) {
	mapping functions;

	functions = provider->query_rpc_functions();
	call = functions[fcall];
	if ( functionp(call) ) {
	   callResult = call(@args);
           if ( callResult != 0 ) {
	       xmlResult = xml_rpc->compose_response(callResult);
	       return http_string_answer(xmlResult, "text/xml");
           }
        }
  }
  xmlResult = xml_rpc->compose_fault();
  return http_string_answer(xmlResult, "text/xml");
}


string query_location()
{
  return query( "mountpoint" );
}

array(int) stat_file( string path, object id )
{
  return ({ 0775, // mode
	    ({ 17, -2 })[random(2)], // size/special
	    963331858, // atime
	    963331858, // mtime
	    963331858, // ctime
	    0, // uid
	    0 /* gid */ });
} 

string|void real_file( string path, object id );

array(string)|void find_dir( string path, object id )
{
  return ({ });
}
