#include "rapi2_api.h"
#include "rapi_context.h"
#include <assert.h>
#include <stdlib.h>
#include <string.h>
#if HAVE_CONFIG_H
#include "rapi_config.h"
#endif

#define RAPI_DATABASE_DEBUG 0

#if RAPI_DATABASE_DEBUG
#define rapi_database_trace(args...)    synce_trace(args)
#define rapi_database_trace_wstr(args...)    synce_trace_wstr(args)
#define rapi_database_warning(args...)  synce_warning(args)
#define rapi_database_error(args...)    synce_error(args)
#else
#define rapi_database_trace(args...)
#define rapi_database_trace_wstr(args...)
#define rapi_database_warning(args...)
#define rapi_database_error(args...)
#endif


CEOID _NotImplementedCeCreateDatabase2(
		LPWSTR lpszName,
		DWORD dwDbaseType,
		WORD wNumSortOrder,
		SORTORDERSPEC *rgSortSpecs)
{
  RapiContext* context = rapi_context_current();
  context->rapi_error = E_NOTIMPL;
  context->last_error = ERROR_SUCCESS;
  return 0;
}

BOOL _NotImplementedCeDeleteDatabase2(/*{{{*/
		CEOID oid)
{
  RapiContext* context = rapi_context_current();
  context->rapi_error = E_NOTIMPL;
  context->last_error = ERROR_SUCCESS;
  return 0;
}/*}}}*/

BOOL _NotImplementedCeFindAllDatabases2(/*{{{*/
		DWORD dwDbaseType,
		WORD wFlags,
		LPWORD cFindData,
		LPLPCEDB_FIND_DATA ppFindData)
{
  RapiContext* context = rapi_context_current();
  context->rapi_error = E_NOTIMPL;
  context->last_error = ERROR_SUCCESS;
  return 0;
}/*}}}*/

HANDLE _NotImplementedCeFindFirstDatabase2(/*{{{*/
		DWORD dwDbaseType)
{
  RapiContext* context = rapi_context_current();
  context->rapi_error = E_NOTIMPL;
  context->last_error = ERROR_SUCCESS;
  return INVALID_HANDLE_VALUE;
}/*}}}*/

CEOID _NotImplementedCeFindNextDatabase2(/*{{{*/
		HANDLE hEnum)
{
  RapiContext* context = rapi_context_current();
  context->rapi_error = E_NOTIMPL;
  context->last_error = ERROR_SUCCESS;
  return 0;
}/*}}}*/

HANDLE _NotImplementedCeOpenDatabase2(/*{{{*/
		PCEOID poid,
		LPWSTR lpszName,
		CEPROPID propid,
		DWORD dwFlags,
		HWND hwndNotify)
{
  RapiContext* context = rapi_context_current();
  context->rapi_error = E_NOTIMPL;
  context->last_error = ERROR_SUCCESS;
  return INVALID_HANDLE_VALUE;
}/*}}}*/


CEOID _NotImplementedCeReadRecordProps2(/*{{{*/
		HANDLE hDbase,
		DWORD dwFlags,
		LPWORD lpcPropID,
		CEPROPID *rgPropID,
		LPBYTE *lplpBuffer,
		LPDWORD lpcbBuffer)
{
  RapiContext* context = rapi_context_current();
  context->rapi_error = E_NOTIMPL;
  context->last_error = ERROR_SUCCESS;
  return 0;
}

CEOID _NotImplementedCeWriteRecordProps2( HANDLE hDbase, CEOID oidRecord, WORD cPropID, CEPROPVAL* rgPropVal)/*{{{*/
{
  RapiContext* context = rapi_context_current();
  context->rapi_error = E_NOTIMPL;
  context->last_error = ERROR_SUCCESS;
  return 0;
}


CEOID _NotImplementedCeSeekDatabase2(/*{{{*/
		HANDLE hDatabase,
		DWORD dwSeekType,
		DWORD dwValue,
		LPDWORD lpdwIndex)
{
  RapiContext* context = rapi_context_current();
  context->rapi_error = E_NOTIMPL;
  context->last_error = ERROR_SUCCESS;
  return 0;
}/*}}}*/

BOOL _NotImplementedCeDeleteRecord2(/*{{{*/
    HANDLE hDatabase,
    CEOID oidRecord)
{
  RapiContext* context = rapi_context_current();
  context->rapi_error = E_NOTIMPL;
  context->last_error = ERROR_SUCCESS;
  return 0;
}/*}}}*/

BOOL _NotImplementedCeSetDatabaseInfo2(
    CEOID oidDbase,
    CEDBASEINFO* pNewInfo)
{
  RapiContext* context = rapi_context_current();
  context->rapi_error = E_NOTIMPL;
  context->last_error = ERROR_SUCCESS;
  return 0;
}

