     

INCLUDE(UsePkgConfig)
PKGCONFIG(GTLCore _GTLCoreIncDir _GTLCoreLinkDir _GTLCoreLinkFlags _GTLCoreCflags)

set(GTLCORE_DEFINITIONS ${_GTLCoreCflags})
set(GTLCORE_LIBRARIES ${_GTLCoreLinkFlags})
set(GTLCORE_INCLUDE_DIR ${_GTLCoreIncDir})

if(GTLCORE_DEFINITIONS AND GTLCORE_LIBRARIES)

  FIND_PROGRAM(PKGCONFIG_EXECUTABLE NAMES pkg-config PATHS /usr/bin/ /usr/local/bin )

  # query pkg-config asking for GTLCore == 0.9.2
  EXEC_PROGRAM(${PKGCONFIG_EXECUTABLE} ARGS --atleast-version=0.9.3 GTLCore RETURN_VALUE _return_VALUE OUTPUT_VARIABLE _pkgconfigDevNull )

  if(_return_VALUE STREQUAL "0")
    set(GTLCORE_FOUND TRUE)
    set(HAVE_GTLCORE TRUE)
  else(_return_VALUE STREQUAL "0")
    message(STATUS "GTLCore >= 0.9.3 was found")
  endif(_return_VALUE STREQUAL "0")
endif(GTLCORE_DEFINITIONS AND GTLCORE_LIBRARIES)

if (GTLCORE_FOUND)
    if (NOT GTLCore_FIND_QUIETLY)
        message(STATUS "Found GTLCORE: ${GTLCORE_LIBRARIES}")
    endif (NOT GTLCore_FIND_QUIETLY)
else (GTLCORE_FOUND)
    if (NOT GTLCore_FIND_QUIETLY)
        message(STATUS "GTLCore was NOT found.")
    endif (NOT GTLCore_FIND_QUIETLY)
    if (GTLCore_FIND_REQUIRED)
        message(FATAL_ERROR "Could NOT find GTLCORE")
    endif (GTLCore_FIND_REQUIRED)
endif (GTLCORE_FOUND)
