/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "RgbaDialog_p.h"

#include "SpinBoxSliderConnector_p.h"

#include "ui_UiRgbaDialog.h"

using namespace QtShiva;

RgbaDialog::RgbaDialog( QWidget* _widget, bool showAlpha ) : QDialog(_widget), m_rgbaDialog( new Ui_RgbaDialog )
{
  m_rgbaDialog->setupUi( this );
  
  connect( m_rgbaDialog->triangleSelector, SIGNAL(colorChanged(const QColor& )), SLOT(triangleColorChanged(const QColor&) ) );
  
  m_connectors[0] = new SpinBoxSliderConnector( this, m_rgbaDialog->doubleSpinBoxRed, m_rgbaDialog->sliderRed );
  connect( m_connectors[0], SIGNAL(valueChanged(double)), SLOT(spinBoxesValuesChanged()));
  m_connectors[1] = new SpinBoxSliderConnector( this, m_rgbaDialog->doubleSpinBoxGreen, m_rgbaDialog->sliderGreen );
  connect( m_connectors[1], SIGNAL(valueChanged(double)), SLOT(spinBoxesValuesChanged()));
  m_connectors[2] = new SpinBoxSliderConnector( this, m_rgbaDialog->doubleSpinBoxBlue, m_rgbaDialog->sliderBlue );
  connect( m_connectors[2], SIGNAL(valueChanged(double)), SLOT(spinBoxesValuesChanged()));
  m_connectors[3] = new SpinBoxSliderConnector( this, m_rgbaDialog->doubleSpinBoxAlpha, m_rgbaDialog->sliderAlpha );
  connect( m_connectors[3], SIGNAL(valueChanged(double)), SLOT(spinBoxesValuesChanged()));
  m_rgbaDialog->doubleSpinBoxAlpha->setVisible( showAlpha );
  m_rgbaDialog->sliderAlpha->setVisible( showAlpha );
  m_rgbaDialog->labelAlpha->setVisible( showAlpha );
}

RgbaDialog::~RgbaDialog()
{
}

QColor RgbaDialog::color()
{
  QColor c = m_rgbaDialog->triangleSelector->color();
  c.setAlpha( m_rgbaDialog->doubleSpinBoxAlpha->value() * 255 );
  return c;
}

void RgbaDialog::setColor( const QColor& c)
{
  bool v = m_rgbaDialog->triangleSelector->blockSignals( true );
  m_rgbaDialog->triangleSelector->setQColor( c );
  triangleColorChanged(  c );
  m_connectors[3]->setValue( c.alpha() / 255.0 );
  m_rgbaDialog->triangleSelector->blockSignals( v );
}

void RgbaDialog::triangleColorChanged( const QColor& c)
{
  m_connectors[0]->setValue( c.red() / 255.0 );
  m_connectors[1]->setValue( c.green() / 255.0 );
  m_connectors[2]->setValue( c.blue() / 255.0 );
}
void RgbaDialog::spinBoxesValuesChanged()
{
  QColor c( m_connectors[0]->value() * 255, m_connectors[1]->value() * 255, m_connectors[2]->value() * 255 );
  m_rgbaDialog->triangleSelector->setQColor( c );
}

#include "RgbaDialog_p.moc"
