/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _QTGTL_QIMAGEBUFFER_H_
#define _QTGTL_QIMAGEBUFFER_H_

#include <QImage>
#include <GTLCore/Buffer.h>

namespace QtGTL {
  /**
   * @ingroup QtGTL
   * 
   * This class allow to wrap a QImage inside a \ref GTLCore::Buffer
   */
  class QImageBuffer : public GTLCore::Buffer {
    public:
      QImageBuffer(const QImage& img);
      ~QImageBuffer();
      const QImage& image() const;
    private:
      struct Private;
      Private* const d;
  };
}

#endif
