/*################################################################################
# Linux Management Providers (LMP), Provider Common Library
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
################################################################################*/

// CIM servers have cmpi headers that don't conform to the CMPI standard
#ifndef USE_STANDARD_CMPI
#define enumerateInstanceNames enumInstanceNames
#define enumerateInstances enumInstances
#endif

#include "CMPIBroking.h"

int CB_enumerateInstanceNames(const CMPIBroker* broker, const CMPIContext* ctx, const string& nameSpace, const string& classname, vector<Objectpath>& objectpaths, string& errorMessage) {
	CMPIStatus rc={CMPI_RC_OK, NULL};	
	CMPIObjectPath* cop = CMNewObjectPath(broker, nameSpace.c_str(), classname.c_str(), &rc);
	if (rc.rc!=CMPI_RC_OK) {
		errorMessage = CMGetCharPtr(rc.msg);
		return rc.rc;
	}
	
	CMPIEnumeration* en = broker->bft->enumerateInstanceNames(broker, ctx, cop, &rc);
	if (rc.rc!=CMPI_RC_OK) {
		errorMessage = CMGetCharPtr(rc.msg);
		return rc.rc;
	}
	
	while ((bool) en->ft->hasNext(en, &rc)) {
		Objectpath ref(broker, en->ft->getNext(en, &rc).value.ref);
		objectpaths.push_back(ref);
		if (rc.rc!=CMPI_RC_OK) {
			errorMessage = CMGetCharPtr(rc.msg);
			return rc.rc;
		}
	}
	
	if (rc.rc!=CMPI_RC_OK) {
		errorMessage = CMGetCharPtr(rc.msg);
		return rc.rc;
	}
	return OK;
}

int CB_enumerateInstances(const CMPIBroker* broker, const CMPIContext* ctx, const string& nameSpace, const string& classname, const char** properties, vector<Instance>& instances, string& errorMessage) {
	CMPIStatus rc={CMPI_RC_OK, NULL};
	CMPIObjectPath* cop = CMNewObjectPath(broker, nameSpace.c_str(), classname.c_str(), &rc);
	if (rc.rc!=CMPI_RC_OK) {
		errorMessage = CMGetCharPtr(rc.msg);
		return rc.rc;
	}

	CMPIEnumeration* en = broker->bft->enumerateInstances(broker, ctx, cop, properties, &rc);
	if (rc.rc!=CMPI_RC_OK) {
		errorMessage = CMGetCharPtr(rc.msg);
		return rc.rc;
	}
	
	while ((bool) en->ft->hasNext(en, &rc)) {
		CMPIInstance* inst = en->ft->getNext(en, &rc).value.inst;
		instances.push_back(Instance(broker, inst));
		if (rc.rc!=CMPI_RC_OK) {
			errorMessage = CMGetCharPtr(rc.msg);
			return rc.rc;
		}
	}

	if (rc.rc!=CMPI_RC_OK) {
		errorMessage = CMGetCharPtr(rc.msg);
		return rc.rc;
	}
	return OK;
}

int CB_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, const Objectpath& op, const char** properties, Instance& instance, string& errorMessage) {
	CMPIStatus rc={CMPI_RC_OK, NULL};	
	CMPIInstance* ci = broker->bft->getInstance(broker, ctx, ((Objectpath) op).getHdl(), properties, &rc);
	if (rc.rc!=CMPI_RC_OK) {
		errorMessage = CMGetCharPtr(rc.msg);
		return rc.rc;
	}
	
	instance = Instance(broker, ci);
	return OK;
}
