/**
  test/components/parser/omxparsertest.h

  Test application uses following OpenMAX components,
    mux  -- 3gp file muxer ,
    audio encoder pipeline  - alsa src and audio encoder
    video encoder pipeline  - video src and video encoder

  Test application that uses five OpenMAX components, a mux, an audio encoder,
  a video deocder, an alsa src and a video src. The application capture audio and video stream
  using a mic and camera then encode it using audio and video encoders.
  And sends the encoded data to mux component to write into a file. Only components
  based on ffmpeg library are supported.
  The video formats supported are:
    MPEG4 (ffmpeg)
    H264  (ffmpeg)
  The audio formats supported are:
    amr (ffmpeg)


  Copyright (C) 2007-2009 STMicroelectronics
  Copyright (C) 2007-2009 Nokia Corporation and/or its subsidiary(-ies).

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
  details.

  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA
  02110-1301  USA

*/

#ifndef __OMXMUXTEST_H__
#define __OMXMUXTEST_H__

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <pthread.h>
#include <ctype.h>

#include <OMX_Core.h>
#include <OMX_Component.h>
#include <OMX_Types.h>
#include <OMX_Video.h>
#include <OMX_Audio.h>

#include <bellagio/tsemaphore.h>
#include <user_debug_levels.h>

typedef struct appPrivateType{
  tsem_t* muxEventSem;
  tsem_t* clockEventSem;
  tsem_t* videoencEventSem;
  tsem_t* videosrcEventSem;
  tsem_t* audioencEventSem;
  tsem_t* audiosrcEventSem;
  tsem_t* eofSem;
  OMX_HANDLETYPE videoenchandle;
  OMX_HANDLETYPE videosrchandle;
  OMX_HANDLETYPE audioenchandle;
  OMX_HANDLETYPE audiosrchandle;
  OMX_HANDLETYPE muxhandle;
  OMX_HANDLETYPE clocksrchandle;
}appPrivateType;

#define BUFFER_IN_SIZE 32768
#define BUFFER_OUT_SIZE_AUDIO 32768
#define BUFFER_OUT_SIZE_VIDEO 32768
#define BUFFER_OUT_SIZE   640*480*3 // 1382400    //921600 -- the output buffer size is chosen to support upto VGA picture: 640*480*3

/** Specification version*/
#define VERSIONMAJOR    1
#define VERSIONMINOR    1
#define VERSIONREVISION 0
#define VERSIONSTEP     0

/* Callback prototypes for video decoder*/
OMX_ERRORTYPE videoencEventHandler(
  OMX_HANDLETYPE hComponent,
  OMX_PTR pAppData,
  OMX_EVENTTYPE eEvent,
  OMX_U32 Data1,
  OMX_U32 Data2,
  OMX_PTR pEventData);

OMX_ERRORTYPE videoencEmptyBufferDone(
  OMX_HANDLETYPE hComponent,
  OMX_PTR pAppData,
  OMX_BUFFERHEADERTYPE* pBuffer);

OMX_ERRORTYPE videoencFillBufferDone(
  OMX_HANDLETYPE hComponent,
  OMX_PTR pAppData,
  OMX_BUFFERHEADERTYPE* pBuffer);

/** callback prototypes for video src */
OMX_ERRORTYPE videosrcEventHandler(
  OMX_HANDLETYPE hComponent,
  OMX_PTR pAppData,
  OMX_EVENTTYPE eEvent,
  OMX_U32 Data1,
  OMX_U32 Data2,
  OMX_PTR pEventData);

OMX_ERRORTYPE videosrcFillBufferDone(
  OMX_HANDLETYPE hComponent,
  OMX_PTR pAppData,
  OMX_BUFFERHEADERTYPE* pBuffer);

/** callback prototypes for mux */
OMX_ERRORTYPE muxEventHandler(
  OMX_HANDLETYPE hComponent,
  OMX_PTR pAppData,
  OMX_EVENTTYPE eEvent,
  OMX_U32 Data1,
  OMX_U32 Data2,
  OMX_PTR pEventData);

OMX_ERRORTYPE muxEmptyBufferDone(
  OMX_HANDLETYPE hComponent,
  OMX_PTR pAppData,
  OMX_BUFFERHEADERTYPE* pBuffer);

OMX_ERRORTYPE clocksrcEventHandler(
  OMX_HANDLETYPE hComponent,
  OMX_PTR pAppData,
  OMX_EVENTTYPE eEvent,
  OMX_U32 Data1,
  OMX_U32 Data2,
  OMX_PTR pEventData);

OMX_ERRORTYPE clocksrcFillBufferDone(
  OMX_HANDLETYPE hComponent,
  OMX_PTR pAppData,
  OMX_BUFFERHEADERTYPE* pBuffer);


/** callback prototypes for audio Decoder */
OMX_ERRORTYPE audioencEventHandler(
  OMX_HANDLETYPE hComponent,
  OMX_PTR pAppData,
  OMX_EVENTTYPE eEvent,
  OMX_U32 Data1,
  OMX_U32 Data2,
  OMX_PTR pEventData);

OMX_ERRORTYPE audioencEmptyBufferDone(
  OMX_HANDLETYPE hComponent,
  OMX_PTR pAppData,
  OMX_BUFFERHEADERTYPE* pBuffer);

OMX_ERRORTYPE audioencFillBufferDone(
  OMX_HANDLETYPE hComponent,
  OMX_PTR pAppData,
  OMX_BUFFERHEADERTYPE* pBuffer);

/** callback prototypes for audio src */
OMX_ERRORTYPE audiosrcEventHandler(
  OMX_HANDLETYPE hComponent,
  OMX_PTR pAppData,
  OMX_EVENTTYPE eEvent,
  OMX_U32 Data1,
  OMX_U32 Data2,
  OMX_PTR pEventData);

OMX_ERRORTYPE audiosrcFillBufferDone(
  OMX_HANDLETYPE hComponent,
  OMX_PTR pAppData,
  OMX_BUFFERHEADERTYPE* pBuffer);

/** display general help  */
void display_help();

/** this function sets the video src port characteristics
  * based on the video decoder output port settings
  */
int setPortParametersVideo();
int setPortParametersAudio();
#endif

