/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.apisupport.project.metainf;

import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.java.project.JavaProjectConstants;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOperation;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;

/**
 * Customizer for adding META-INF/services item
 * @author  pzajac
 */
public class AddServiceDialog extends javax.swing.JPanel {
    
    /** selected class name 
     */
    private Project project;
    /** Creates new form AddNodeDialog */
    public AddServiceDialog(Project project) {
        initComponents();
        this.project = project;
        okButton = new JButton();
        cancelButton = new JButton();
        org.openide.awt.Mnemonics.setLocalizedText(okButton, NbBundle.getMessage(AddServiceDialog.class, "CTL_OK")); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(cancelButton, NbBundle.getMessage(AddServiceDialog.class, "CTL_CANCEL")); // NOI18N
        okButton.setEnabled(false);
        classField.getDocument().addDocumentListener(new DocumentListener() {

            public void insertUpdate(DocumentEvent e) {
                checkJavaFile();
            }

            public void removeUpdate(DocumentEvent e) {
                checkJavaFile();
            }

            public void changedUpdate(DocumentEvent e) {
                checkJavaFile();
            }
        });
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        classField = new javax.swing.JTextField();
        browseButton = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();

        org.openide.awt.Mnemonics.setLocalizedText(browseButton, org.openide.util.NbBundle.getMessage(AddServiceDialog.class, "CTL_BROWSE")); // NOI18N
        browseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseButtonActionPerformed(evt);
            }
        });

        jLabel1.setLabelFor(classField);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(AddServiceDialog.class, "LBL_CLASS_NAME")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 299, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(layout.createSequentialGroup()
                        .add(classField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 299, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(browseButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(classField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 25, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(browseButton))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        classField.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(AddServiceDialog.class, "AddServiceDialog.classField.AccessibleContext.accessibleDescription")); // NOI18N

        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(AddServiceDialog.class, "AddServiceDialog.AccessibleContext.accessibleDescription")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    private void browseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseButtonActionPerformed
        Sources sources = project.getLookup().lookup(Sources.class);    
        SourceGroup groups[] = sources.getSourceGroups(JavaProjectConstants.SOURCES_TYPE_JAVA); 
        
        ProjectInformation inf = project.getLookup().lookup(ProjectInformation.class);
        if (groups.length > 0) {
            Node srcNode = PackageView.createPackageView(groups[0]);
            try {
                Node node = NodeOperation.getDefault().select(NbBundle.getMessage(AddServiceDialog.class, "MSG_SelectAClass"),
                        inf.getDisplayName(),
                        srcNode );
                // try find a java file
                DataObject dobj = null;
                do {
                    dobj =  node.getLookup().lookup(DataObject.class);
                    node = node.getParentNode();
                } while (dobj == null && node != null);
                if (dobj != null) {
                    FileObject fo = dobj.getPrimaryFile();
                    if (fo.getExt().equals("java")) { // NOI18N
                        String fileName = fo.getPath();
                        NbModuleProvider info = project.getLookup().lookup(NbModuleProvider.class);
                        String className = fileName.substring(info.getSourceDirectory().getPath().length(),
                                fileName.length() - ".java".length()); // NOI18N
                        if (className.startsWith("/")) { // NOI18N
                            className = className.substring(1);
                        }
                        className = className.replace('/','.');
                        classField.setText(className);
                    }
                    
                }
                checkJavaFile();
            } catch (UserCancelException uc) {
                // cancel button  clicked
            }
            
        }
        
    }//GEN-LAST:event_browseButtonActionPerformed
    
    
    private void checkJavaFile() {
        String path = classField.getText();
        FileObject root = ((NbModuleProject)project).getSourceDirectory();
        boolean status = false;
        // check if class already exists
        // checking validity of inner classes is missing
        StringTokenizer tokenizer = new StringTokenizer(path,"."); // NOI18N
        while (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken();
            FileObject childFo = root.getFileObject(name);
            if (childFo != null) {
                if (childFo.isFolder()) {
                    root = childFo;
                } else {
                    status = "java".equals(childFo.getExt()); // NOI18N
                    break;
                }
            } else {
                status =  root.getFileObject(name + ".java") != null; // NOI18N
                break;
            }
        }
        okButton.setEnabled(status);
    }
    public String getClassName() {
        return classField.getText();
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JButton getOkButton() {
        return okButton;
    }
    
    private JButton okButton;
    private JButton cancelButton;
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton browseButton;
    private javax.swing.JTextField classField;
    private javax.swing.JLabel jLabel1;
    // End of variables declaration//GEN-END:variables
    
}
