/*
 * Copyright 2003 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

/*
 * @test
 * @bug 4920023
 * @summary add "hexadecimal floating-point literal" support to javac as per 4896828
 * @author gafter
 */

public class HexFloatLiterals {
    public static void check(float a, float b) {
        if (a != b) throw new Error(a + " != " + b);
    }
    public static void check(double a, double b) {
        if (a != b) throw new Error(a + " != " + b);
    }
    public static void main(String[] args) {
        check(-0X.003p12d, Double.parseDouble("-0X.003p12d"));
        check(-0x.003P12F, Float.parseFloat("-0x.003P12F"));
        check(0x.006p11D, Double.parseDouble("0x.006p11D"));
        check(0X.00cP10D, Double.parseDouble("0X.00cP10D"));
        check(-0x.018P9, Double.parseDouble("-0x.018P9"));
        check(0x.018P9D, Double.parseDouble("0x.018P9D"));
        check(0X.018P9D, Double.parseDouble("0X.018P9D"));
        check(-0x.3p4F, Float.parseFloat("-0x.3p4F"));
        check(0x.3p4d, Double.parseDouble("0x.3p4d"));
        check(+0x.Cp2F, Float.parseFloat("+0x.Cp2F"));
        check(0X.cP2F, Float.parseFloat("0X.cP2F"));
        check(0x1.8p1d, Double.parseDouble("0x1.8p1d"));
        check(0X1.8p1D, Double.parseDouble("0X1.8p1D"));
        check(0X1.8p1f, Float.parseFloat("0X1.8p1f"));
        check(0X1.8P1, Double.parseDouble("0X1.8P1"));
        check(0x3p0d, Double.parseDouble("0x3p0d"));
        check(-0x3P0d, Double.parseDouble("-0x3P0d"));
        check(0X3P0, Double.parseDouble("0X3P0"));
        check(0x6.0p-1d, Double.parseDouble("0x6.0p-1d"));
        check(-0X6.0P-1, Double.parseDouble("-0X6.0P-1"));
        check(+0xC.0p-2f, Float.parseFloat("+0xC.0p-2f"));
        check(-0xC.0p-2F, Float.parseFloat("-0xC.0p-2F"));
        check(-0X3000000p-24, Double.parseDouble("-0X3000000p-24"));
        check(+0x3.0P0, Double.parseDouble("+0x3.0P0"));
        check(0x3.000000p0d, Double.parseDouble("0x3.000000p0d"));
        check(0x3.000000P0, Double.parseDouble("0x3.000000P0"));
        check(-0X3.000000p0, Double.parseDouble("-0X3.000000p0"));
        check(0X3.000000P0D, Double.parseDouble("0X3.000000P0D"));
        check(-0x0.0P-2044, Double.parseDouble("-0x0.0P-2044"));
        check(+0x0.0P2147483646, Double.parseDouble("+0x0.0P2147483646"));
        check(0X0.0p2147483647d, Double.parseDouble("0X0.0p2147483647d"));
        check(0X0.0p2147483647D, Double.parseDouble("0X0.0p2147483647D"));
        check(+0x0.0p2147483648, Double.parseDouble("+0x0.0p2147483648"));
        check(+0x0.0P2147483648D, Double.parseDouble("+0x0.0P2147483648D"));
        check(-0X0.0P-2147483649d, Double.parseDouble("-0X0.0P-2147483649d"));
        check(-0X0.0P-2147483648, Double.parseDouble("-0X0.0P-2147483648"));
        check(0X0.0P-2147483647F, Float.parseFloat("0X0.0P-2147483647F"));
        check(-0x0.0p9223372036854775806, Double.parseDouble("-0x0.0p9223372036854775806"));
        check(-0x0.0P9223372036854775806f, Float.parseFloat("-0x0.0P9223372036854775806f"));
        check(-0x0.0p9223372036854775807F, Float.parseFloat("-0x0.0p9223372036854775807F"));
        check(-0X0.0p9223372036854775807D, Double.parseDouble("-0X0.0p9223372036854775807D"));
        check(0X0.0P9223372036854775807D, Double.parseDouble("0X0.0P9223372036854775807D"));
        check(0x0.0p-9223372036854775807, Double.parseDouble("0x0.0p-9223372036854775807"));
        check(-0x0.0p-9223372036854775807F, Float.parseFloat("-0x0.0p-9223372036854775807F"));
        check(+0X0.0P-9223372036854775807D, Double.parseDouble("+0X0.0P-9223372036854775807D"));
        check(+0X0.0p-9223372036854775808d, Double.parseDouble("+0X0.0p-9223372036854775808d"));
        check(+0x1p0, Double.parseDouble("+0x1p0"));
        check(-0x1p0F, Float.parseFloat("-0x1p0F"));
        check(-0X1p0, Double.parseDouble("-0X1p0"));
        check(0X12P0F, Float.parseFloat("0X12P0F"));
        check(-0x123p0F, Float.parseFloat("-0x123p0F"));
        check(+0x123P0d, Double.parseDouble("+0x123P0d"));
        check(0X1234P0, Double.parseDouble("0X1234P0"));
        check(-0X12345p0f, Float.parseFloat("-0X12345p0f"));
        check(-0x123456p0F, Float.parseFloat("-0x123456p0F"));
        check(0X123456p0f, Float.parseFloat("0X123456p0f"));
        check(-0X123456p0f, Float.parseFloat("-0X123456p0f"));
        check(-0x1234567P0d, Double.parseDouble("-0x1234567P0d"));
        check(-0X1234567P0f, Float.parseFloat("-0X1234567P0f"));
        check(+0X123456789P0F, Float.parseFloat("+0X123456789P0F"));
        check(0x123456789ap0d, Double.parseDouble("0x123456789ap0d"));
        check(0x123456789ABp0, Double.parseDouble("0x123456789ABp0"));
        check(+0x123456789ABp0f, Float.parseFloat("+0x123456789ABp0f"));
        check(0X123456789abcP0F, Float.parseFloat("0X123456789abcP0F"));
        check(+0X123456789ABCDp0, Double.parseDouble("+0X123456789ABCDp0"));
        check(0x123456789ABCDEp0D, Double.parseDouble("0x123456789ABCDEp0D"));
        check(-0X0.3P0F, Float.parseFloat("-0X0.3P0F"));
        check(0X0.4P0F, Float.parseFloat("0X0.4P0F"));
        check(+0X0.4P0, Double.parseDouble("+0X0.4P0"));
        check(+0X0.5p0f, Float.parseFloat("+0X0.5p0f"));
        check(0X0.5p0d, Double.parseDouble("0X0.5p0d"));
        check(-0X0.5p0d, Double.parseDouble("-0X0.5p0d"));
        check(-0X0.6p0F, Float.parseFloat("-0X0.6p0F"));
        check(+0X0.6P0F, Float.parseFloat("+0X0.6P0F"));
        check(+0x0.8p0f, Float.parseFloat("+0x0.8p0f"));
        check(+0x0.8p0F, Float.parseFloat("+0x0.8p0F"));
        check(0x0.9P0D, Double.parseDouble("0x0.9P0D"));
        check(-0X0.Bp0, Double.parseDouble("-0X0.Bp0"));
        check(-0x0.CP0F, Float.parseFloat("-0x0.CP0F"));
        check(+0X0.Cp0d, Double.parseDouble("+0X0.Cp0d"));
        check(-0x0.dp0F, Float.parseFloat("-0x0.dp0F"));
        check(0x0.DP0F, Float.parseFloat("0x0.DP0F"));
        check(-0X0.eP0f, Float.parseFloat("-0X0.eP0f"));
        check(-0X1.000000000001p-1075, Double.parseDouble("-0X1.000000000001p-1075"));
        check(+0x0.FFFFFFFFFFFFF8p-1022, Double.parseDouble("+0x0.FFFFFFFFFFFFF8p-1022"));
        check(-0X1.FFFFFFFFFFFFF0000000P1023, Double.parseDouble("-0X1.FFFFFFFFFFFFF0000000P1023"));
        check(-0x1.FFFFFFFFFFFFF4p1023, Double.parseDouble("-0x1.FFFFFFFFFFFFF4p1023"));
        check(+0X1.ffffffffffffe7p1023d, Double.parseDouble("+0X1.ffffffffffffe7p1023d"));
        check(+0x1.FFFFFFFFFFFFE8000001p1023d, Double.parseDouble("+0x1.FFFFFFFFFFFFE8000001p1023d"));
        check(0x7FFFFFFFFFFFF80P-58, Double.parseDouble("0x7FFFFFFFFFFFF80P-58"));
        check(0xFFFFFFFFFFFFF00p-59, Double.parseDouble("0xFFFFFFFFFFFFF00p-59"));
        check(0xFFFFFFFFFFFFF00P-59d, Double.parseDouble("0xFFFFFFFFFFFFF00P-59d"));
        check(0XFFFFFFFFFFFFF00P-59d, Double.parseDouble("0XFFFFFFFFFFFFF00P-59d"));
        check(+0x1ffffffffffffe00p-60f, Float.parseFloat("+0x1ffffffffffffe00p-60f"));
        check(0x3ffffffffffffc00P-61d, Double.parseDouble("0x3ffffffffffffc00P-61d"));
        check(0X3ffffffffffffc00p-61d, Double.parseDouble("0X3ffffffffffffc00p-61d"));
        check(0X7FFFFFFFFFFFF800p-62F, Float.parseFloat("0X7FFFFFFFFFFFF800p-62F"));
        check(+0Xfffffffffffff000p-63D, Double.parseDouble("+0Xfffffffffffff000p-63D"));
        check(+0X7FFFFFFFFFFFF81p-58f, Float.parseFloat("+0X7FFFFFFFFFFFF81p-58f"));
        check(0xfffffffffffff02P-59D, Double.parseDouble("0xfffffffffffff02P-59D"));
        check(+0X7ffffffffffff810P-62, Double.parseDouble("+0X7ffffffffffff810P-62"));
        check(-0Xfffffffffffff020p-63, Double.parseDouble("-0Xfffffffffffff020p-63"));
        check(0Xfffffffffffff020p-63D, Double.parseDouble("0Xfffffffffffff020p-63D"));
        check(+0XFFFFFFFFFFFFF020P-63D, Double.parseDouble("+0XFFFFFFFFFFFFF020P-63D"));
        check(+0x7ffffffffffff82p-58, Double.parseDouble("+0x7ffffffffffff82p-58"));
        check(-0x7ffffffffffff82p-58f, Float.parseFloat("-0x7ffffffffffff82p-58f"));
        check(-0x7ffffffffffff82P-58D, Double.parseDouble("-0x7ffffffffffff82P-58D"));
        check(+0xFFFFFFFFFFFFF04p-59F, Float.parseFloat("+0xFFFFFFFFFFFFF04p-59F"));
        check(0Xfffffffffffff04P-59d, Double.parseDouble("0Xfffffffffffff04P-59d"));
        check(+0x7ffffffffffff820p-62D, Double.parseDouble("+0x7ffffffffffff820p-62D"));
        check(-0x7FFFFFFFFFFFF820P-62f, Float.parseFloat("-0x7FFFFFFFFFFFF820P-62f"));
        check(0xfffffffffffff040P-63d, Double.parseDouble("0xfffffffffffff040P-63d"));
        check(0x7FFFFFFFFFFFF84p-58, Double.parseDouble("0x7FFFFFFFFFFFF84p-58"));
        check(+0X7ffffffffffff84P-58d, Double.parseDouble("+0X7ffffffffffff84P-58d"));
        check(0X7FFFFFFFFFFFF84P-58f, Float.parseFloat("0X7FFFFFFFFFFFF84P-58f"));
        check(-0xfffffffffffff08P-59f, Float.parseFloat("-0xfffffffffffff08P-59f"));
        check(-0xFFFFFFFFFFFFF08P-59f, Float.parseFloat("-0xFFFFFFFFFFFFF08P-59f"));
        check(-0X1FFFFFFFFFFFFE10p-60F, Float.parseFloat("-0X1FFFFFFFFFFFFE10p-60F"));
        check(-0X3ffffffffffffc20P-61F, Float.parseFloat("-0X3ffffffffffffc20P-61F"));
        check(0X3FFFFFFFFFFFFC20P-61f, Float.parseFloat("0X3FFFFFFFFFFFFC20P-61f"));
        check(-0x7FFFFFFFFFFFF840P-62f, Float.parseFloat("-0x7FFFFFFFFFFFF840P-62f"));
        check(-0X7FFFFFFFFFFFF840p-62, Double.parseDouble("-0X7FFFFFFFFFFFF840p-62"));
        check(+0X7FFFFFFFFFFFF85p-58F, Float.parseFloat("+0X7FFFFFFFFFFFF85p-58F"));
        check(-0xFFFFFFFFFFFFF0Ap-59d, Double.parseDouble("-0xFFFFFFFFFFFFF0Ap-59d"));
        check(-0xfffffffffffff0aP-59d, Double.parseDouble("-0xfffffffffffff0aP-59d"));
        check(-0xfffffffffffff0aP-59D, Double.parseDouble("-0xfffffffffffff0aP-59D"));
        check(+0Xfffffffffffff0aP-59, Double.parseDouble("+0Xfffffffffffff0aP-59"));
        check(+0X1FFFFFFFFFFFFE14p-60f, Float.parseFloat("+0X1FFFFFFFFFFFFE14p-60f"));
        check(+0x3FFFFFFFFFFFFC28p-61, Double.parseDouble("+0x3FFFFFFFFFFFFC28p-61"));
        check(0x7ffffffffffff850P-62F, Float.parseFloat("0x7ffffffffffff850P-62F"));
        check(+0X7ffffffffffff850P-62, Double.parseDouble("+0X7ffffffffffff850P-62"));
        check(-0xFFFFFFFFFFFFF0Cp-59F, Float.parseFloat("-0xFFFFFFFFFFFFF0Cp-59F"));
        check(-0x1ffffffffffffe18p-60D, Double.parseDouble("-0x1ffffffffffffe18p-60D"));
        check(+0x1FFFFFFFFFFFFE18p-60, Double.parseDouble("+0x1FFFFFFFFFFFFE18p-60"));
        check(0x1ffffffffffffe18P-60D, Double.parseDouble("0x1ffffffffffffe18P-60D"));
        check(+0X7FFFFFFFFFFFF860P-62d, Double.parseDouble("+0X7FFFFFFFFFFFF860P-62d"));
        check(0x7ffffffffffff88P-58F, Float.parseFloat("0x7ffffffffffff88P-58F"));
        check(-0x7FFFFFFFFFFFF88P-58d, Double.parseDouble("-0x7FFFFFFFFFFFF88P-58d"));
        check(0X7ffffffffffff88p-58D, Double.parseDouble("0X7ffffffffffff88p-58D"));
        check(-0X1FFFFFFFFFFFFE20p-60D, Double.parseDouble("-0X1FFFFFFFFFFFFE20p-60D"));
        check(-0x3FFFFFFFFFFFFC40P-61f, Float.parseFloat("-0x3FFFFFFFFFFFFC40P-61f"));
        check(0x3FFFFFFFFFFFFC40P-61F, Float.parseFloat("0x3FFFFFFFFFFFFC40P-61F"));
        check(-0x3FFFFFFFFFFFFC40P-61F, Float.parseFloat("-0x3FFFFFFFFFFFFC40P-61F"));
        check(-0X3FFFFFFFFFFFFC40p-61d, Double.parseDouble("-0X3FFFFFFFFFFFFC40p-61d"));
        check(+0X3ffffffffffffc40P-61d, Double.parseDouble("+0X3ffffffffffffc40P-61d"));
        check(-0x7FFFFFFFFFFFF880p-62, Double.parseDouble("-0x7FFFFFFFFFFFF880p-62"));
        check(-0X7FFFFFFFFFFFF880P-62f, Float.parseFloat("-0X7FFFFFFFFFFFF880P-62f"));
        check(+0xFFFFFFFFFFFFF100p-63f, Float.parseFloat("+0xFFFFFFFFFFFFF100p-63f"));
        check(0Xfffffffffffff100p-63f, Float.parseFloat("0Xfffffffffffff100p-63f"));
        check(0Xfffffffffffff100P-63D, Double.parseDouble("0Xfffffffffffff100P-63D"));
        check(0X7FFFFFFFFFFFF89p-58d, Double.parseDouble("0X7FFFFFFFFFFFF89p-58d"));
        check(0Xfffffffffffff12P-59f, Float.parseFloat("0Xfffffffffffff12P-59f"));
        check(-0x3ffffffffffffc48P-61f, Float.parseFloat("-0x3ffffffffffffc48P-61f"));
        check(0xFFFFFFFFFFFFF120P-63D, Double.parseDouble("0xFFFFFFFFFFFFF120P-63D"));
        check(0Xfffffffffffff120p-63, Double.parseDouble("0Xfffffffffffff120p-63"));
        check(+0x7ffffffffffff8ap-58d, Double.parseDouble("+0x7ffffffffffff8ap-58d"));
        check(+0x7FFFFFFFFFFFF8AP-58D, Double.parseDouble("+0x7FFFFFFFFFFFF8AP-58D"));
        check(0X7ffffffffffff8aP-58d, Double.parseDouble("0X7ffffffffffff8aP-58d"));
        check(-0xfffffffffffff14p-59D, Double.parseDouble("-0xfffffffffffff14p-59D"));
        check(0xfffffffffffff14P-59, Double.parseDouble("0xfffffffffffff14P-59"));
        check(+0Xfffffffffffff14P-59F, Float.parseFloat("+0Xfffffffffffff14P-59F"));
        check(-0x3ffffffffffffc50P-61d, Double.parseDouble("-0x3ffffffffffffc50P-61d"));
        check(-0X3ffffffffffffc50P-61F, Float.parseFloat("-0X3ffffffffffffc50P-61F"));
        check(0X7ffffffffffff8a0p-62f, Float.parseFloat("0X7ffffffffffff8a0p-62f"));
        check(+0X7ffffffffffff8a0P-62, Double.parseDouble("+0X7ffffffffffff8a0P-62"));
        check(+0xfffffffffffff140P-63, Double.parseDouble("+0xfffffffffffff140P-63"));
        check(+0xfffffffffffff140P-63d, Double.parseDouble("+0xfffffffffffff140P-63d"));
        check(-0X7ffffffffffff8cp-58D, Double.parseDouble("-0X7ffffffffffff8cp-58D"));
        check(+0X7FFFFFFFFFFFF8Cp-58D, Double.parseDouble("+0X7FFFFFFFFFFFF8Cp-58D"));
        check(-0x1FFFFFFFFFFFFE30P-60f, Float.parseFloat("-0x1FFFFFFFFFFFFE30P-60f"));
        check(+0X3FFFFFFFFFFFFC60P-61D, Double.parseDouble("+0X3FFFFFFFFFFFFC60P-61D"));
        check(+0x7FFFFFFFFFFFF8C0p-62d, Double.parseDouble("+0x7FFFFFFFFFFFF8C0p-62d"));
        check(0X7FFFFFFFFFFFF8C0p-62f, Float.parseFloat("0X7FFFFFFFFFFFF8C0p-62f"));
        check(0Xfffffffffffff180P-63f, Float.parseFloat("0Xfffffffffffff180P-63f"));
        check(-0x7ffffffffffff8dp-58d, Double.parseDouble("-0x7ffffffffffff8dp-58d"));
        check(0xfffffffffffff1aP-59D, Double.parseDouble("0xfffffffffffff1aP-59D"));
        check(+0X3FFFFFFFFFFFFC68P-61, Double.parseDouble("+0X3FFFFFFFFFFFFC68P-61"));
        check(0X7ffffffffffff8d0p-62F, Float.parseFloat("0X7ffffffffffff8d0p-62F"));
        check(-0x7FFFFFFFFFFFF8Ep-58f, Float.parseFloat("-0x7FFFFFFFFFFFF8Ep-58f"));
        check(0xfffffffffffff1cp-59d, Double.parseDouble("0xfffffffffffff1cp-59d"));
        check(-0x1FFFFFFFFFFFFE38p-60F, Float.parseFloat("-0x1FFFFFFFFFFFFE38p-60F"));
        check(0X1ffffffffffffe38p-60, Double.parseDouble("0X1ffffffffffffe38p-60"));
        check(+0x3FFFFFFFFFFFFC70P-61d, Double.parseDouble("+0x3FFFFFFFFFFFFC70P-61d"));
        check(0X3ffffffffffffc70P-61d, Double.parseDouble("0X3ffffffffffffc70P-61d"));
        check(-0X3FFFFFFFFFFFFC70P-61f, Float.parseFloat("-0X3FFFFFFFFFFFFC70P-61f"));
        check(-0X7ffffffffffff8e0p-62f, Float.parseFloat("-0X7ffffffffffff8e0p-62f"));
        check(0X7FFFFFFFFFFFF8E0p-62F, Float.parseFloat("0X7FFFFFFFFFFFF8E0p-62F"));
        check(+0XFFFFFFFFFFFFF1C0p-63, Double.parseDouble("+0XFFFFFFFFFFFFF1C0p-63"));
        check(+0x7FFFFFFFFFFFF90P-58, Double.parseDouble("+0x7FFFFFFFFFFFF90P-58"));
        check(0X7ffffffffffff90P-58d, Double.parseDouble("0X7ffffffffffff90P-58d"));
        check(0Xfffffffffffff20p-59, Double.parseDouble("0Xfffffffffffff20p-59"));
        check(-0Xfffffffffffff20p-59f, Float.parseFloat("-0Xfffffffffffff20p-59f"));
        check(0x3FFFFFFFFFFFFC80p-61f, Float.parseFloat("0x3FFFFFFFFFFFFC80p-61f"));
        check(-0X3FFFFFFFFFFFFC80p-61f, Float.parseFloat("-0X3FFFFFFFFFFFFC80p-61f"));
        check(0xFFFFFFFFFFFFF200P-63, Double.parseDouble("0xFFFFFFFFFFFFF200P-63"));
        check(-0X7ffffffffffff91P-58f, Float.parseFloat("-0X7ffffffffffff91P-58f"));
        check(0xfffffffffffff22P-59d, Double.parseDouble("0xfffffffffffff22P-59d"));
        check(-0X3ffffffffffffc88P-61D, Double.parseDouble("-0X3ffffffffffffc88P-61D"));
        check(-0X7ffffffffffff92P-58D, Double.parseDouble("-0X7ffffffffffff92P-58D"));
        check(0XFFFFFFFFFFFFF24p-59f, Float.parseFloat("0XFFFFFFFFFFFFF24p-59f"));
        check(+0XFFFFFFFFFFFFF24p-59D, Double.parseDouble("+0XFFFFFFFFFFFFF24p-59D"));
        check(+0x7ffffffffffff920P-62d, Double.parseDouble("+0x7ffffffffffff920P-62d"));
        check(+0x7ffffffffffff94P-58F, Float.parseFloat("+0x7ffffffffffff94P-58F"));
        check(+0X7FFFFFFFFFFFF94p-58, Double.parseDouble("+0X7FFFFFFFFFFFF94p-58"));
        check(0X7FFFFFFFFFFFF94p-58F, Float.parseFloat("0X7FFFFFFFFFFFF94p-58F"));
        check(+0xFFFFFFFFFFFFF28p-59, Double.parseDouble("+0xFFFFFFFFFFFFF28p-59"));
        check(+0xFFFFFFFFFFFFF28p-59d, Double.parseDouble("+0xFFFFFFFFFFFFF28p-59d"));
        check(0x1FFFFFFFFFFFFE50P-60F, Float.parseFloat("0x1FFFFFFFFFFFFE50P-60F"));
        check(+0x3FFFFFFFFFFFFCA0p-61f, Float.parseFloat("+0x3FFFFFFFFFFFFCA0p-61f"));
        check(+0X7ffffffffffff940P-62D, Double.parseDouble("+0X7ffffffffffff940P-62D"));
        check(+0xFFFFFFFFFFFFF2Ap-59d, Double.parseDouble("+0xFFFFFFFFFFFFF2Ap-59d"));
        check(-0X1FFFFFFFFFFFFE54p-60F, Float.parseFloat("-0X1FFFFFFFFFFFFE54p-60F"));
        check(0X1FFFFFFFFFFFFE54P-60F, Float.parseFloat("0X1FFFFFFFFFFFFE54P-60F"));
        check(-0X1FFFFFFFFFFFFE54P-60d, Double.parseDouble("-0X1FFFFFFFFFFFFE54P-60d"));
        check(+0X3FFFFFFFFFFFFCA8P-61d, Double.parseDouble("+0X3FFFFFFFFFFFFCA8P-61d"));
        check(0x7FFFFFFFFFFFF950P-62D, Double.parseDouble("0x7FFFFFFFFFFFF950P-62D"));
        check(-0X7ffffffffffff950p-62d, Double.parseDouble("-0X7ffffffffffff950p-62d"));
        check(0xFFFFFFFFFFFFF2A0P-63d, Double.parseDouble("0xFFFFFFFFFFFFF2A0P-63d"));
        check(+0XFFFFFFFFFFFFF2A0P-63d, Double.parseDouble("+0XFFFFFFFFFFFFF2A0P-63d"));
        check(0x7FFFFFFFFFFFF96P-58D, Double.parseDouble("0x7FFFFFFFFFFFF96P-58D"));
        check(-0XFFFFFFFFFFFFF2Cp-59f, Float.parseFloat("-0XFFFFFFFFFFFFF2Cp-59f"));
        check(+0X1ffffffffffffe58P-60F, Float.parseFloat("+0X1ffffffffffffe58P-60F"));
        check(+0x7ffffffffffff960P-62D, Double.parseDouble("+0x7ffffffffffff960P-62D"));
        check(+0X7ffffffffffff960p-62F, Float.parseFloat("+0X7ffffffffffff960p-62F"));
        check(0X7FFFFFFFFFFFF960p-62, Double.parseDouble("0X7FFFFFFFFFFFF960p-62"));
        check(0xfffffffffffff2c0P-63, Double.parseDouble("0xfffffffffffff2c0P-63"));
        check(-0Xfffffffffffff2c0p-63d, Double.parseDouble("-0Xfffffffffffff2c0p-63d"));
        check(-0x7FFFFFFFFFFFF98P-58F, Float.parseFloat("-0x7FFFFFFFFFFFF98P-58F"));
        check(-0xFFFFFFFFFFFFF30P-59f, Float.parseFloat("-0xFFFFFFFFFFFFF30P-59f"));
        check(0x3ffffffffffffcc0p-61, Double.parseDouble("0x3ffffffffffffcc0p-61"));
        check(0X7ffffffffffff980p-62F, Float.parseFloat("0X7ffffffffffff980p-62F"));
        check(-0Xfffffffffffff300P-63F, Float.parseFloat("-0Xfffffffffffff300P-63F"));
        check(0X7ffffffffffff99P-58D, Double.parseDouble("0X7ffffffffffff99P-58D"));
        check(+0xFFFFFFFFFFFFF32p-59f, Float.parseFloat("+0xFFFFFFFFFFFFF32p-59f"));
        check(0Xfffffffffffff32p-59f, Float.parseFloat("0Xfffffffffffff32p-59f"));
        check(-0XFFFFFFFFFFFFF32p-59f, Float.parseFloat("-0XFFFFFFFFFFFFF32p-59f"));
        check(0x3FFFFFFFFFFFFCC8p-61D, Double.parseDouble("0x3FFFFFFFFFFFFCC8p-61D"));
        check(0X7ffffffffffff990P-62D, Double.parseDouble("0X7ffffffffffff990P-62D"));
        check(-0X7FFFFFFFFFFFF9Ap-58, Double.parseDouble("-0X7FFFFFFFFFFFF9Ap-58"));
        check(+0X7FFFFFFFFFFFF9Ap-58F, Float.parseFloat("+0X7FFFFFFFFFFFF9Ap-58F"));
        check(0X7ffffffffffff9aP-58f, Float.parseFloat("0X7ffffffffffff9aP-58f"));
        check(+0x1ffffffffffffe68p-60d, Double.parseDouble("+0x1ffffffffffffe68p-60d"));
        check(+0X1ffffffffffffe68P-60d, Double.parseDouble("+0X1ffffffffffffe68P-60d"));
        check(0x3ffffffffffffcd0P-61F, Float.parseFloat("0x3ffffffffffffcd0P-61F"));
        check(+0X7ffffffffffff9a0p-62, Double.parseDouble("+0X7ffffffffffff9a0p-62"));
        check(+0xfffffffffffff340p-63f, Float.parseFloat("+0xfffffffffffff340p-63f"));
        check(0X7ffffffffffff9cp-58d, Double.parseDouble("0X7ffffffffffff9cp-58d"));
        check(0xfffffffffffff38p-59f, Float.parseFloat("0xfffffffffffff38p-59f"));
        check(+0X1ffffffffffffe70p-60F, Float.parseFloat("+0X1ffffffffffffe70p-60F"));
        check(+0X3ffffffffffffce0p-61F, Float.parseFloat("+0X3ffffffffffffce0p-61F"));
        check(+0X7ffffffffffff9c0p-62, Double.parseDouble("+0X7ffffffffffff9c0p-62"));
        check(-0X7FFFFFFFFFFFF9C0p-62, Double.parseDouble("-0X7FFFFFFFFFFFF9C0p-62"));
        check(0X7ffffffffffff9c0P-62, Double.parseDouble("0X7ffffffffffff9c0P-62"));
        check(0XFFFFFFFFFFFFF380P-63f, Float.parseFloat("0XFFFFFFFFFFFFF380P-63f"));
        check(0x7ffffffffffff9dP-58f, Float.parseFloat("0x7ffffffffffff9dP-58f"));
        check(+0x7ffffffffffff9dP-58D, Double.parseDouble("+0x7ffffffffffff9dP-58D"));
        check(-0X7ffffffffffff9dP-58, Double.parseDouble("-0X7ffffffffffff9dP-58"));
        check(0Xfffffffffffff3ap-59f, Float.parseFloat("0Xfffffffffffff3ap-59f"));
        check(0X1ffffffffffffe74p-60d, Double.parseDouble("0X1ffffffffffffe74p-60d"));
        check(0X1FFFFFFFFFFFFE74p-60F, Float.parseFloat("0X1FFFFFFFFFFFFE74p-60F"));
        check(0X3FFFFFFFFFFFFCE8P-61d, Double.parseDouble("0X3FFFFFFFFFFFFCE8P-61d"));
        check(-0x7ffffffffffff9d0p-62d, Double.parseDouble("-0x7ffffffffffff9d0p-62d"));
        check(0Xfffffffffffff3a0p-63F, Float.parseFloat("0Xfffffffffffff3a0p-63F"));
        check(+0X1FFFFFFFFFFFFE78P-60D, Double.parseDouble("+0X1FFFFFFFFFFFFE78P-60D"));
        check(+0x7ffffffffffff9e0P-62D, Double.parseDouble("+0x7ffffffffffff9e0P-62D"));
        check(+0X7ffffffffffff9e0p-62d, Double.parseDouble("+0X7ffffffffffff9e0p-62d"));
        check(0XFFFFFFFFFFFFF3C0P-63F, Float.parseFloat("0XFFFFFFFFFFFFF3C0P-63F"));
        check(-0XFFFFFFFFFFFFF40p-59d, Double.parseDouble("-0XFFFFFFFFFFFFF40p-59d"));
        check(-0Xfffffffffffff40P-59D, Double.parseDouble("-0Xfffffffffffff40P-59D"));
        check(0x1ffffffffffffe80P-60D, Double.parseDouble("0x1ffffffffffffe80P-60D"));
        check(0X7FFFFFFFFFFFFA00p-62f, Float.parseFloat("0X7FFFFFFFFFFFFA00p-62f"));
        check(0x7ffffffffffffa1p-58d, Double.parseDouble("0x7ffffffffffffa1p-58d"));
        check(+0x7ffffffffffffa1p-58d, Double.parseDouble("+0x7ffffffffffffa1p-58d"));
        check(0x7FFFFFFFFFFFFA1P-58d, Double.parseDouble("0x7FFFFFFFFFFFFA1P-58d"));
        check(0xfffffffffffff42p-59, Double.parseDouble("0xfffffffffffff42p-59"));
        check(-0xfffffffffffff42p-59f, Float.parseFloat("-0xfffffffffffff42p-59f"));
        check(-0xfffffffffffff42P-59d, Double.parseDouble("-0xfffffffffffff42P-59d"));
        check(0Xfffffffffffff42p-59d, Double.parseDouble("0Xfffffffffffff42p-59d"));
        check(+0XFFFFFFFFFFFFF42p-59D, Double.parseDouble("+0XFFFFFFFFFFFFF42p-59D"));
        check(-0X3ffffffffffffd08P-61f, Float.parseFloat("-0X3ffffffffffffd08P-61f"));
        check(+0x7ffffffffffffa10P-62F, Float.parseFloat("+0x7ffffffffffffa10P-62F"));
        check(+0x7FFFFFFFFFFFFA2P-58d, Double.parseDouble("+0x7FFFFFFFFFFFFA2P-58d"));
        check(+0xfffffffffffff44p-59D, Double.parseDouble("+0xfffffffffffff44p-59D"));
        check(-0XFFFFFFFFFFFFF44P-59F, Float.parseFloat("-0XFFFFFFFFFFFFF44P-59F"));
        check(-0x3ffffffffffffd10p-61F, Float.parseFloat("-0x3ffffffffffffd10p-61F"));
        check(+0x3ffffffffffffd10p-61F, Float.parseFloat("+0x3ffffffffffffd10p-61F"));
        check(+0x3FFFFFFFFFFFFD10P-61D, Double.parseDouble("+0x3FFFFFFFFFFFFD10P-61D"));
        check(+0X7FFFFFFFFFFFFA20p-62D, Double.parseDouble("+0X7FFFFFFFFFFFFA20p-62D"));
        check(-0X7ffffffffffffa20P-62F, Float.parseFloat("-0X7ffffffffffffa20P-62F"));
        check(+0xFFFFFFFFFFFFF440p-63F, Float.parseFloat("+0xFFFFFFFFFFFFF440p-63F"));
        check(-0x1ffffffffffffe90P-60D, Double.parseDouble("-0x1ffffffffffffe90P-60D"));
        check(0X1ffffffffffffe90p-60F, Float.parseFloat("0X1ffffffffffffe90p-60F"));
        check(+0X7FFFFFFFFFFFFA40P-62d, Double.parseDouble("+0X7FFFFFFFFFFFFA40P-62d"));
        check(-0x7FFFFFFFFFFFFA5p-58D, Double.parseDouble("-0x7FFFFFFFFFFFFA5p-58D"));
        check(+0xFFFFFFFFFFFFF4Ap-59d, Double.parseDouble("+0xFFFFFFFFFFFFF4Ap-59d"));
        check(+0x3FFFFFFFFFFFFD28p-61f, Float.parseFloat("+0x3FFFFFFFFFFFFD28p-61f"));
        check(-0xFFFFFFFFFFFFF4A0p-63d, Double.parseDouble("-0xFFFFFFFFFFFFF4A0p-63d"));
        check(+0xfffffffffffff4a0P-63, Double.parseDouble("+0xfffffffffffff4a0P-63"));
        check(-0xFFFFFFFFFFFFF4A0P-63D, Double.parseDouble("-0xFFFFFFFFFFFFF4A0P-63D"));
        check(-0XFFFFFFFFFFFFF4A0p-63D, Double.parseDouble("-0XFFFFFFFFFFFFF4A0p-63D"));
        check(-0Xfffffffffffff4a0P-63F, Float.parseFloat("-0Xfffffffffffff4a0P-63F"));
        check(-0X7ffffffffffffa6P-58D, Double.parseDouble("-0X7ffffffffffffa6P-58D"));
        check(0X7FFFFFFFFFFFFA6P-58, Double.parseDouble("0X7FFFFFFFFFFFFA6P-58"));
        check(-0Xfffffffffffff4cp-59D, Double.parseDouble("-0Xfffffffffffff4cp-59D"));
        check(+0x7FFFFFFFFFFFFA8P-58, Double.parseDouble("+0x7FFFFFFFFFFFFA8P-58"));
        check(0X7ffffffffffffa8P-58D, Double.parseDouble("0X7ffffffffffffa8P-58D"));
        check(0x1ffffffffffffea0P-60D, Double.parseDouble("0x1ffffffffffffea0P-60D"));
        check(+0X3ffffffffffffd40P-61f, Float.parseFloat("+0X3ffffffffffffd40P-61f"));
        check(-0X7ffffffffffffa80P-62D, Double.parseDouble("-0X7ffffffffffffa80P-62D"));
        check(0xfffffffffffff500P-63F, Float.parseFloat("0xfffffffffffff500P-63F"));
        check(0xfffffffffffff500P-63d, Double.parseDouble("0xfffffffffffff500P-63d"));
        check(+0x7ffffffffffffa9P-58d, Double.parseDouble("+0x7ffffffffffffa9P-58d"));
        check(0X7ffffffffffffa9P-58D, Double.parseDouble("0X7ffffffffffffa9P-58D"));
        check(+0X7ffffffffffffa9P-58D, Double.parseDouble("+0X7ffffffffffffa9P-58D"));
        check(0x1FFFFFFFFFFFFEA4p-60, Double.parseDouble("0x1FFFFFFFFFFFFEA4p-60"));
        check(-0x3FFFFFFFFFFFFD48P-61f, Float.parseFloat("-0x3FFFFFFFFFFFFD48P-61f"));
        check(+0x7ffffffffffffa90P-62f, Float.parseFloat("+0x7ffffffffffffa90P-62f"));
        check(0xFFFFFFFFFFFFF520P-63F, Float.parseFloat("0xFFFFFFFFFFFFF520P-63F"));
        check(+0XFFFFFFFFFFFFF520p-63, Double.parseDouble("+0XFFFFFFFFFFFFF520p-63"));
        check(+0X7FFFFFFFFFFFFAAp-58F, Float.parseFloat("+0X7FFFFFFFFFFFFAAp-58F"));
        check(-0xfffffffffffff54P-59, Double.parseDouble("-0xfffffffffffff54P-59"));
        check(-0X7FFFFFFFFFFFFAA0p-62, Double.parseDouble("-0X7FFFFFFFFFFFFAA0p-62"));
        check(0xFFFFFFFFFFFFF58p-59d, Double.parseDouble("0xFFFFFFFFFFFFF58p-59d"));
        check(-0xFFFFFFFFFFFFF58p-59D, Double.parseDouble("-0xFFFFFFFFFFFFF58p-59D"));
        check(+0Xfffffffffffff58p-59, Double.parseDouble("+0Xfffffffffffff58p-59"));
        check(+0x1FFFFFFFFFFFFEB0P-60D, Double.parseDouble("+0x1FFFFFFFFFFFFEB0P-60D"));
        check(0Xfffffffffffff580P-63, Double.parseDouble("0Xfffffffffffff580P-63"));
        check(0XFFFFFFFFFFFFF580P-63D, Double.parseDouble("0XFFFFFFFFFFFFF580P-63D"));
        check(-0XFFFFFFFFFFFFF5Ap-59, Double.parseDouble("-0XFFFFFFFFFFFFF5Ap-59"));
        check(0x1FFFFFFFFFFFFEB4P-60f, Float.parseFloat("0x1FFFFFFFFFFFFEB4P-60f"));
        check(+0X3ffffffffffffd68P-61F, Float.parseFloat("+0X3ffffffffffffd68P-61F"));
        check(-0x7FFFFFFFFFFFFAD0P-62f, Float.parseFloat("-0x7FFFFFFFFFFFFAD0P-62f"));
        check(0X7FFFFFFFFFFFFAD0P-62d, Double.parseDouble("0X7FFFFFFFFFFFFAD0P-62d"));
        check(+0X7FFFFFFFFFFFFAD0P-62d, Double.parseDouble("+0X7FFFFFFFFFFFFAD0P-62d"));
        check(-0x7FFFFFFFFFFFFAEp-58F, Float.parseFloat("-0x7FFFFFFFFFFFFAEp-58F"));
        check(0X7ffffffffffffaep-58D, Double.parseDouble("0X7ffffffffffffaep-58D"));
        check(-0X7ffffffffffffaeP-58, Double.parseDouble("-0X7ffffffffffffaeP-58"));
        check(-0x1FFFFFFFFFFFFEB8p-60F, Float.parseFloat("-0x1FFFFFFFFFFFFEB8p-60F"));
        check(-0x3FFFFFFFFFFFFD70P-61d, Double.parseDouble("-0x3FFFFFFFFFFFFD70P-61d"));
        check(+0X3ffffffffffffd70p-61f, Float.parseFloat("+0X3ffffffffffffd70p-61f"));
        check(-0x7ffffffffffffae0p-62d, Double.parseDouble("-0x7ffffffffffffae0p-62d"));
        check(0x7FFFFFFFFFFFFAE0p-62d, Double.parseDouble("0x7FFFFFFFFFFFFAE0p-62d"));
        check(0x7ffffffffffffae0P-62, Double.parseDouble("0x7ffffffffffffae0P-62"));
        check(+0X7ffffffffffffae0p-62f, Float.parseFloat("+0X7ffffffffffffae0p-62f"));
        check(0X7FFFFFFFFFFFFAE0p-62d, Double.parseDouble("0X7FFFFFFFFFFFFAE0p-62d"));
        check(0Xfffffffffffff5c0P-63F, Float.parseFloat("0Xfffffffffffff5c0P-63F"));
        check(+0XFFFFFFFFFFFFF5C0P-63, Double.parseDouble("+0XFFFFFFFFFFFFF5C0P-63"));
        check(-0xFFFFFFFFFFFFF60p-59D, Double.parseDouble("-0xFFFFFFFFFFFFF60p-59D"));
        check(+0Xfffffffffffff60P-59D, Double.parseDouble("+0Xfffffffffffff60P-59D"));
        check(-0X1FFFFFFFFFFFFEC0p-60D, Double.parseDouble("-0X1FFFFFFFFFFFFEC0p-60D"));
        check(-0x3ffffffffffffd80P-61d, Double.parseDouble("-0x3ffffffffffffd80P-61d"));
        check(0x7ffffffffffffb00P-62F, Float.parseFloat("0x7ffffffffffffb00P-62F"));
        check(+0x7FFFFFFFFFFFFB00P-62D, Double.parseDouble("+0x7FFFFFFFFFFFFB00P-62D"));
        check(0xfffffffffffff600P-63D, Double.parseDouble("0xfffffffffffff600P-63D"));
        check(0x7FFFFFFFFFFFFB1p-58, Double.parseDouble("0x7FFFFFFFFFFFFB1p-58"));
        check(+0xfffffffffffff62p-59d, Double.parseDouble("+0xfffffffffffff62p-59d"));
        check(+0xFFFFFFFFFFFFF62P-59F, Float.parseFloat("+0xFFFFFFFFFFFFF62P-59F"));
        check(+0Xfffffffffffff62p-59, Double.parseDouble("+0Xfffffffffffff62p-59"));
        check(-0Xfffffffffffff62P-59F, Float.parseFloat("-0Xfffffffffffff62P-59F"));
        check(0x1ffffffffffffec4P-60D, Double.parseDouble("0x1ffffffffffffec4P-60D"));
        check(+0X1FFFFFFFFFFFFEC4p-60D, Double.parseDouble("+0X1FFFFFFFFFFFFEC4p-60D"));
        check(+0X3ffffffffffffd88p-61, Double.parseDouble("+0X3ffffffffffffd88p-61"));
        check(-0X7ffffffffffffb10P-62, Double.parseDouble("-0X7ffffffffffffb10P-62"));
        check(0xFFFFFFFFFFFFF620p-63, Double.parseDouble("0xFFFFFFFFFFFFF620p-63"));
        check(+0xfffffffffffff620P-63F, Float.parseFloat("+0xfffffffffffff620P-63F"));
        check(+0Xfffffffffffff620p-63D, Double.parseDouble("+0Xfffffffffffff620p-63D"));
        check(+0x7ffffffffffffb2P-58f, Float.parseFloat("+0x7ffffffffffffb2P-58f"));
        check(+0X7ffffffffffffb2P-58f, Float.parseFloat("+0X7ffffffffffffb2P-58f"));
        check(0xFFFFFFFFFFFFF64p-59d, Double.parseDouble("0xFFFFFFFFFFFFF64p-59d"));
        check(+0xFFFFFFFFFFFFF64P-59f, Float.parseFloat("+0xFFFFFFFFFFFFF64P-59f"));
        check(+0Xfffffffffffff64p-59D, Double.parseDouble("+0Xfffffffffffff64p-59D"));
        check(+0x1ffffffffffffec8P-60f, Float.parseFloat("+0x1ffffffffffffec8P-60f"));
        check(0x7ffffffffffffb20P-62, Double.parseDouble("0x7ffffffffffffb20P-62"));
        check(0x7ffffffffffffb20P-62F, Float.parseFloat("0x7ffffffffffffb20P-62F"));
        check(0x7FFFFFFFFFFFFB20P-62d, Double.parseDouble("0x7FFFFFFFFFFFFB20P-62d"));
        check(-0XFFFFFFFFFFFFF640p-63f, Float.parseFloat("-0XFFFFFFFFFFFFF640p-63f"));
        check(-0Xfffffffffffff640P-63F, Float.parseFloat("-0Xfffffffffffff640P-63F"));
        check(+0x7ffffffffffffb4p-58d, Double.parseDouble("+0x7ffffffffffffb4p-58d"));
        check(0x7FFFFFFFFFFFFB4p-58d, Double.parseDouble("0x7FFFFFFFFFFFFB4p-58d"));
        check(0x7FFFFFFFFFFFFB4P-58, Double.parseDouble("0x7FFFFFFFFFFFFB4P-58"));
        check(+0X1FFFFFFFFFFFFED0p-60F, Float.parseFloat("+0X1FFFFFFFFFFFFED0p-60F"));
        check(0X1FFFFFFFFFFFFED0P-60f, Float.parseFloat("0X1FFFFFFFFFFFFED0P-60f"));
        check(-0X3ffffffffffffda0P-61D, Double.parseDouble("-0X3ffffffffffffda0P-61D"));
        check(-0x7FFFFFFFFFFFFB40p-62D, Double.parseDouble("-0x7FFFFFFFFFFFFB40p-62D"));
        check(+0XFFFFFFFFFFFFF680p-63f, Float.parseFloat("+0XFFFFFFFFFFFFF680p-63f"));
        check(+0X7ffffffffffffb5p-58f, Float.parseFloat("+0X7ffffffffffffb5p-58f"));
        check(0X7FFFFFFFFFFFFB5P-58, Double.parseDouble("0X7FFFFFFFFFFFFB5P-58"));
        check(0xFFFFFFFFFFFFF6Ap-59f, Float.parseFloat("0xFFFFFFFFFFFFF6Ap-59f"));
        check(+0xFFFFFFFFFFFFF6AP-59f, Float.parseFloat("+0xFFFFFFFFFFFFF6AP-59f"));
        check(-0Xfffffffffffff6aP-59d, Double.parseDouble("-0Xfffffffffffff6aP-59d"));
        check(+0x7ffffffffffffb50p-62F, Float.parseFloat("+0x7ffffffffffffb50p-62F"));
        check(-0x7FFFFFFFFFFFFB6p-58D, Double.parseDouble("-0x7FFFFFFFFFFFFB6p-58D"));
        check(0X7FFFFFFFFFFFFB6P-58, Double.parseDouble("0X7FFFFFFFFFFFFB6P-58"));
        check(0xfffffffffffff6cp-59, Double.parseDouble("0xfffffffffffff6cp-59"));
        check(-0x1ffffffffffffed8p-60, Double.parseDouble("-0x1ffffffffffffed8p-60"));
        check(0X1FFFFFFFFFFFFED8P-60f, Float.parseFloat("0X1FFFFFFFFFFFFED8P-60f"));
        check(0xfffffffffffff6c0p-63F, Float.parseFloat("0xfffffffffffff6c0p-63F"));
        check(0xFFFFFFFFFFFFF70p-59f, Float.parseFloat("0xFFFFFFFFFFFFF70p-59f"));
        check(-0xFFFFFFFFFFFFF70P-59F, Float.parseFloat("-0xFFFFFFFFFFFFF70P-59F"));
        check(+0XFFFFFFFFFFFFF70P-59, Double.parseDouble("+0XFFFFFFFFFFFFF70P-59"));
        check(-0x1ffffffffffffee0p-60d, Double.parseDouble("-0x1ffffffffffffee0p-60d"));
        check(0X1FFFFFFFFFFFFEE0P-60, Double.parseDouble("0X1FFFFFFFFFFFFEE0P-60"));
        check(+0x3ffffffffffffdc0P-61f, Float.parseFloat("+0x3ffffffffffffdc0P-61f"));
        check(+0XFFFFFFFFFFFFF700P-63D, Double.parseDouble("+0XFFFFFFFFFFFFF700P-63D"));
        check(0x7FFFFFFFFFFFFB9p-58F, Float.parseFloat("0x7FFFFFFFFFFFFB9p-58F"));
        check(-0x7ffffffffffffb9P-58D, Double.parseDouble("-0x7ffffffffffffb9P-58D"));
        check(0X7FFFFFFFFFFFFB9P-58, Double.parseDouble("0X7FFFFFFFFFFFFB9P-58"));
        check(0xfffffffffffff72P-59f, Float.parseFloat("0xfffffffffffff72P-59f"));
        check(-0x1ffffffffffffee4P-60f, Float.parseFloat("-0x1ffffffffffffee4P-60f"));
        check(-0X3ffffffffffffdc8P-61f, Float.parseFloat("-0X3ffffffffffffdc8P-61f"));
        check(-0xFFFFFFFFFFFFF720p-63F, Float.parseFloat("-0xFFFFFFFFFFFFF720p-63F"));
        check(-0XFFFFFFFFFFFFF720P-63d, Double.parseDouble("-0XFFFFFFFFFFFFF720P-63d"));
        check(+0X7FFFFFFFFFFFFBAp-58d, Double.parseDouble("+0X7FFFFFFFFFFFFBAp-58d"));
        check(-0X7ffffffffffffbaP-58f, Float.parseFloat("-0X7ffffffffffffbaP-58f"));
        check(+0xfffffffffffff74p-59D, Double.parseDouble("+0xfffffffffffff74p-59D"));
        check(-0xFFFFFFFFFFFFF74p-59F, Float.parseFloat("-0xFFFFFFFFFFFFF74p-59F"));
        check(+0x1ffffffffffffee8p-60D, Double.parseDouble("+0x1ffffffffffffee8p-60D"));
        check(+0X1FFFFFFFFFFFFEE8p-60d, Double.parseDouble("+0X1FFFFFFFFFFFFEE8p-60d"));
        check(0x3FFFFFFFFFFFFDD0P-61d, Double.parseDouble("0x3FFFFFFFFFFFFDD0P-61d"));
        check(-0X3ffffffffffffdd0p-61d, Double.parseDouble("-0X3ffffffffffffdd0p-61d"));
        check(0x7ffffffffffffba0P-62F, Float.parseFloat("0x7ffffffffffffba0P-62F"));
        check(+0XFFFFFFFFFFFFF740p-63d, Double.parseDouble("+0XFFFFFFFFFFFFF740p-63d"));
        check(0X7FFFFFFFFFFFFBCp-58, Double.parseDouble("0X7FFFFFFFFFFFFBCp-58"));
        check(-0xfffffffffffff78p-59D, Double.parseDouble("-0xfffffffffffff78p-59D"));
        check(-0xfffffffffffff78P-59, Double.parseDouble("-0xfffffffffffff78P-59"));
        check(+0x1FFFFFFFFFFFFEF0p-60D, Double.parseDouble("+0x1FFFFFFFFFFFFEF0p-60D"));
        check(0x3ffffffffffffde0p-61D, Double.parseDouble("0x3ffffffffffffde0p-61D"));
        check(-0x7ffffffffffffbc0P-62f, Float.parseFloat("-0x7ffffffffffffbc0P-62f"));
        check(0x7ffffffffffffbdP-58F, Float.parseFloat("0x7ffffffffffffbdP-58F"));
        check(-0xFFFFFFFFFFFFF7AP-59d, Double.parseDouble("-0xFFFFFFFFFFFFF7AP-59d"));
        check(-0XFFFFFFFFFFFFF7AP-59, Double.parseDouble("-0XFFFFFFFFFFFFF7AP-59"));
        check(-0x7ffffffffffffbd0p-62d, Double.parseDouble("-0x7ffffffffffffbd0p-62d"));
        check(-0XFFFFFFFFFFFFF7A0P-63F, Float.parseFloat("-0XFFFFFFFFFFFFF7A0P-63F"));
        check(0xfffffffffffff7cP-59d, Double.parseDouble("0xfffffffffffff7cP-59d"));
        check(-0xFFFFFFFFFFFFF7CP-59F, Float.parseFloat("-0xFFFFFFFFFFFFF7CP-59F"));
        check(+0Xfffffffffffff7cp-59D, Double.parseDouble("+0Xfffffffffffff7cp-59D"));
        check(-0x7ffffffffffffbe0p-62f, Float.parseFloat("-0x7ffffffffffffbe0p-62f"));
        check(+0x7FFFFFFFFFFFFBE0p-62f, Float.parseFloat("+0x7FFFFFFFFFFFFBE0p-62f"));
        check(0Xfffffffffffff7c0p-63f, Float.parseFloat("0Xfffffffffffff7c0p-63f"));
        check(+0x7FFFFFFFFFFFFC0p-58, Double.parseDouble("+0x7FFFFFFFFFFFFC0p-58"));
        check(+0XFFFFFFFFFFFFF80p-59D, Double.parseDouble("+0XFFFFFFFFFFFFF80p-59D"));
        check(+0x1fffffffffffff00p-60, Double.parseDouble("+0x1fffffffffffff00p-60"));
        check(+0x1FFFFFFFFFFFFF00P-60D, Double.parseDouble("+0x1FFFFFFFFFFFFF00P-60D"));
        check(-0X1FFFFFFFFFFFFF00P-60f, Float.parseFloat("-0X1FFFFFFFFFFFFF00P-60f"));
        check(-0X7ffffffffffffc1p-58, Double.parseDouble("-0X7ffffffffffffc1p-58"));
        check(0Xfffffffffffff82p-59, Double.parseDouble("0Xfffffffffffff82p-59"));
        check(+0X1FFFFFFFFFFFFF04P-60d, Double.parseDouble("+0X1FFFFFFFFFFFFF04P-60d"));
        check(+0xFFFFFFFFFFFFF820p-63, Double.parseDouble("+0xFFFFFFFFFFFFF820p-63"));
        check(-0xFFFFFFFFFFFFF84p-59F, Float.parseFloat("-0xFFFFFFFFFFFFF84p-59F"));
        check(0XFFFFFFFFFFFFF84P-59f, Float.parseFloat("0XFFFFFFFFFFFFF84P-59f"));
        check(0XFFFFFFFFFFFFF84P-59F, Float.parseFloat("0XFFFFFFFFFFFFF84P-59F"));
        check(+0XFFFFFFFFFFFFF88p-59f, Float.parseFloat("+0XFFFFFFFFFFFFF88p-59f"));
        check(+0X1fffffffffffff10p-60f, Float.parseFloat("+0X1fffffffffffff10p-60f"));
        check(-0X1fffffffffffff10P-60D, Double.parseDouble("-0X1fffffffffffff10P-60D"));
        check(-0X1FFFFFFFFFFFFF10P-60f, Float.parseFloat("-0X1FFFFFFFFFFFFF10P-60f"));
        check(0x3FFFFFFFFFFFFE20p-61f, Float.parseFloat("0x3FFFFFFFFFFFFE20p-61f"));
        check(0X7FFFFFFFFFFFFC5p-58D, Double.parseDouble("0X7FFFFFFFFFFFFC5p-58D"));
        check(+0X7FFFFFFFFFFFFC5P-58D, Double.parseDouble("+0X7FFFFFFFFFFFFC5P-58D"));
        check(0xFFFFFFFFFFFFF8Ap-59d, Double.parseDouble("0xFFFFFFFFFFFFF8Ap-59d"));
        check(0XFFFFFFFFFFFFF8Ap-59d, Double.parseDouble("0XFFFFFFFFFFFFF8Ap-59d"));
        check(0Xfffffffffffff8aP-59d, Double.parseDouble("0Xfffffffffffff8aP-59d"));
        check(0x1FFFFFFFFFFFFF14p-60D, Double.parseDouble("0x1FFFFFFFFFFFFF14p-60D"));
        check(+0X1FFFFFFFFFFFFF14p-60F, Float.parseFloat("+0X1FFFFFFFFFFFFF14p-60F"));
        check(+0X7FFFFFFFFFFFFC50p-62F, Float.parseFloat("+0X7FFFFFFFFFFFFC50p-62F"));
        check(+0xfffffffffffff8a0p-63D, Double.parseDouble("+0xfffffffffffff8a0p-63D"));
        check(0xFFFFFFFFFFFFF8A0P-63, Double.parseDouble("0xFFFFFFFFFFFFF8A0P-63"));
        check(-0Xfffffffffffff8a0p-63F, Float.parseFloat("-0Xfffffffffffff8a0p-63F"));
        check(0x7FFFFFFFFFFFFC6p-58F, Float.parseFloat("0x7FFFFFFFFFFFFC6p-58F"));
        check(0X1FFFFFFFFFFFFF18p-60d, Double.parseDouble("0X1FFFFFFFFFFFFF18p-60d"));
        check(0X1FFFFFFFFFFFFF18P-60f, Float.parseFloat("0X1FFFFFFFFFFFFF18P-60f"));
        check(0X3ffffffffffffe30p-61F, Float.parseFloat("0X3ffffffffffffe30p-61F"));
        check(0XFFFFFFFFFFFFF8C0p-63F, Float.parseFloat("0XFFFFFFFFFFFFF8C0p-63F"));
        check(+0Xfffffffffffff8c0P-63d, Double.parseDouble("+0Xfffffffffffff8c0P-63d"));
        check(0x7ffffffffffffc8P-58, Double.parseDouble("0x7ffffffffffffc8P-58"));
        check(-0x7ffffffffffffc8P-58d, Double.parseDouble("-0x7ffffffffffffc8P-58d"));
        check(+0X3ffffffffffffe40P-61d, Double.parseDouble("+0X3ffffffffffffe40P-61d"));
        check(+0X7ffffffffffffc80P-62D, Double.parseDouble("+0X7ffffffffffffc80P-62D"));
        check(0Xfffffffffffff900p-63F, Float.parseFloat("0Xfffffffffffff900p-63F"));
        check(-0Xfffffffffffff900P-63F, Float.parseFloat("-0Xfffffffffffff900P-63F"));
        check(0x7FFFFFFFFFFFFC9P-58D, Double.parseDouble("0x7FFFFFFFFFFFFC9P-58D"));
        check(+0xfffffffffffff92P-59D, Double.parseDouble("+0xfffffffffffff92P-59D"));
        check(0x3FFFFFFFFFFFFE48p-61f, Float.parseFloat("0x3FFFFFFFFFFFFE48p-61f"));
        check(+0x7ffffffffffffc90p-62f, Float.parseFloat("+0x7ffffffffffffc90p-62f"));
        check(+0xfffffffffffff920p-63F, Float.parseFloat("+0xfffffffffffff920p-63F"));
        check(0XFFFFFFFFFFFFF920p-63F, Float.parseFloat("0XFFFFFFFFFFFFF920p-63F"));
        check(+0Xfffffffffffff920P-63d, Double.parseDouble("+0Xfffffffffffff920P-63d"));
        check(0x7ffffffffffffcap-58f, Float.parseFloat("0x7ffffffffffffcap-58f"));
        check(+0xfffffffffffff94p-59f, Float.parseFloat("+0xfffffffffffff94p-59f"));
        check(-0Xfffffffffffff94p-59f, Float.parseFloat("-0Xfffffffffffff94p-59f"));
        check(0X1FFFFFFFFFFFFF28P-60, Double.parseDouble("0X1FFFFFFFFFFFFF28P-60"));
        check(0xfffffffffffff940p-63F, Float.parseFloat("0xfffffffffffff940p-63F"));
        check(-0Xfffffffffffff940p-63, Double.parseDouble("-0Xfffffffffffff940p-63"));
        check(0xfffffffffffff98p-59f, Float.parseFloat("0xfffffffffffff98p-59f"));
        check(+0xfffffffffffff98P-59f, Float.parseFloat("+0xfffffffffffff98P-59f"));
        check(+0X1fffffffffffff30P-60d, Double.parseDouble("+0X1fffffffffffff30P-60d"));
        check(0X3FFFFFFFFFFFFE60p-61D, Double.parseDouble("0X3FFFFFFFFFFFFE60p-61D"));
        check(0X7ffffffffffffcc0P-62, Double.parseDouble("0X7ffffffffffffcc0P-62"));
        check(0XFFFFFFFFFFFFF980p-63F, Float.parseFloat("0XFFFFFFFFFFFFF980p-63F"));
        check(-0Xfffffffffffff980P-63F, Float.parseFloat("-0Xfffffffffffff980P-63F"));
        check(+0x7ffffffffffffcdp-58F, Float.parseFloat("+0x7ffffffffffffcdp-58F"));
        check(-0xfffffffffffff9ap-59, Double.parseDouble("-0xfffffffffffff9ap-59"));
        check(-0Xfffffffffffff9ap-59D, Double.parseDouble("-0Xfffffffffffff9ap-59D"));
        check(0X1fffffffffffff34P-60f, Float.parseFloat("0X1fffffffffffff34P-60f"));
        check(0X3ffffffffffffe68p-61d, Double.parseDouble("0X3ffffffffffffe68p-61d"));
        check(+0X3ffffffffffffe68P-61d, Double.parseDouble("+0X3ffffffffffffe68P-61d"));
        check(0X3FFFFFFFFFFFFE68P-61f, Float.parseFloat("0X3FFFFFFFFFFFFE68P-61f"));
        check(+0xfffffffffffff9a0p-63f, Float.parseFloat("+0xfffffffffffff9a0p-63f"));
        check(+0xfffffffffffff9a0P-63f, Float.parseFloat("+0xfffffffffffff9a0P-63f"));
        check(+0xfffffffffffff9cP-59d, Double.parseDouble("+0xfffffffffffff9cP-59d"));
        check(-0XFFFFFFFFFFFFF9CP-59f, Float.parseFloat("-0XFFFFFFFFFFFFF9CP-59f"));
        check(-0X1FFFFFFFFFFFFF38p-60, Double.parseDouble("-0X1FFFFFFFFFFFFF38p-60"));
        check(0X3ffffffffffffe70p-61f, Float.parseFloat("0X3ffffffffffffe70p-61f"));
        check(-0X3FFFFFFFFFFFFE70P-61D, Double.parseDouble("-0X3FFFFFFFFFFFFE70P-61D"));
        check(-0xfffffffffffff9c0P-63, Double.parseDouble("-0xfffffffffffff9c0P-63"));
        check(0XFFFFFFFFFFFFF9C0P-63F, Float.parseFloat("0XFFFFFFFFFFFFF9C0P-63F"));
        check(+0xFFFFFFFFFFFFFA0p-59F, Float.parseFloat("+0xFFFFFFFFFFFFFA0p-59F"));
        check(0x1FFFFFFFFFFFFF40p-60d, Double.parseDouble("0x1FFFFFFFFFFFFF40p-60d"));
        check(-0X7ffffffffffffd00p-62D, Double.parseDouble("-0X7ffffffffffffd00p-62D"));
        check(-0X7FFFFFFFFFFFFD00P-62, Double.parseDouble("-0X7FFFFFFFFFFFFD00P-62"));
        check(-0XFFFFFFFFFFFFFA00p-63d, Double.parseDouble("-0XFFFFFFFFFFFFFA00p-63d"));
        check(+0xFFFFFFFFFFFFFA2P-59D, Double.parseDouble("+0xFFFFFFFFFFFFFA2P-59D"));
        check(-0X3ffffffffffffe88p-61F, Float.parseFloat("-0X3ffffffffffffe88p-61F"));
        check(+0X3ffffffffffffe88P-61f, Float.parseFloat("+0X3ffffffffffffe88P-61f"));
        check(-0X3FFFFFFFFFFFFE88P-61f, Float.parseFloat("-0X3FFFFFFFFFFFFE88P-61f"));
        check(+0x7FFFFFFFFFFFFD10P-62f, Float.parseFloat("+0x7FFFFFFFFFFFFD10P-62f"));
        check(+0Xfffffffffffffa20p-63, Double.parseDouble("+0Xfffffffffffffa20p-63"));
        check(-0x7FFFFFFFFFFFFD2P-58d, Double.parseDouble("-0x7FFFFFFFFFFFFD2P-58d"));
        check(-0xFFFFFFFFFFFFFA4p-59F, Float.parseFloat("-0xFFFFFFFFFFFFFA4p-59F"));
        check(+0XFFFFFFFFFFFFFA4P-59f, Float.parseFloat("+0XFFFFFFFFFFFFFA4P-59f"));
        check(0X1FFFFFFFFFFFFF48P-60d, Double.parseDouble("0X1FFFFFFFFFFFFF48P-60d"));
        check(-0x3ffffffffffffe90P-61f, Float.parseFloat("-0x3ffffffffffffe90P-61f"));
        check(+0X3ffffffffffffe90P-61D, Double.parseDouble("+0X3ffffffffffffe90P-61D"));
        check(+0x7ffffffffffffd20p-62, Double.parseDouble("+0x7ffffffffffffd20p-62"));
        check(0xFFFFFFFFFFFFFA40P-63F, Float.parseFloat("0xFFFFFFFFFFFFFA40P-63F"));
        check(+0X1FFFFFFFFFFFFF50P-60, Double.parseDouble("+0X1FFFFFFFFFFFFF50P-60"));
        check(-0X3ffffffffffffea0p-61d, Double.parseDouble("-0X3ffffffffffffea0p-61d"));
        check(+0x7FFFFFFFFFFFFD40p-62f, Float.parseFloat("+0x7FFFFFFFFFFFFD40p-62f"));
        check(-0xfffffffffffffa80p-63f, Float.parseFloat("-0xfffffffffffffa80p-63f"));
        check(-0xfffffffffffffa80P-63f, Float.parseFloat("-0xfffffffffffffa80P-63f"));
        check(0xfffffffffffffa80P-63d, Double.parseDouble("0xfffffffffffffa80P-63d"));
        check(0xFFFFFFFFFFFFFA80P-63F, Float.parseFloat("0xFFFFFFFFFFFFFA80P-63F"));
        check(-0x7ffffffffffffd5P-58D, Double.parseDouble("-0x7ffffffffffffd5P-58D"));
        check(0X7FFFFFFFFFFFFD5P-58D, Double.parseDouble("0X7FFFFFFFFFFFFD5P-58D"));
        check(-0Xfffffffffffffaap-59f, Float.parseFloat("-0Xfffffffffffffaap-59f"));
        check(-0x3ffffffffffffea8p-61, Double.parseDouble("-0x3ffffffffffffea8p-61"));
        check(+0x3FFFFFFFFFFFFEA8P-61F, Float.parseFloat("+0x3FFFFFFFFFFFFEA8P-61F"));
        check(+0X3FFFFFFFFFFFFEA8p-61, Double.parseDouble("+0X3FFFFFFFFFFFFEA8p-61"));
        check(-0xfffffffffffffaa0p-63d, Double.parseDouble("-0xfffffffffffffaa0p-63d"));
        check(-0x7ffffffffffffd6p-58f, Float.parseFloat("-0x7ffffffffffffd6p-58f"));
        check(-0x7ffffffffffffd6p-58D, Double.parseDouble("-0x7ffffffffffffd6p-58D"));
        check(-0x7FFFFFFFFFFFFD6P-58f, Float.parseFloat("-0x7FFFFFFFFFFFFD6P-58f"));
        check(-0X3ffffffffffffeb0p-61D, Double.parseDouble("-0X3ffffffffffffeb0p-61D"));
        check(-0XFFFFFFFFFFFFFAC0p-63, Double.parseDouble("-0XFFFFFFFFFFFFFAC0p-63"));
        check(-0x3FFFFFFFFFFFFEC0p-61F, Float.parseFloat("-0x3FFFFFFFFFFFFEC0p-61F"));
        check(0X3FFFFFFFFFFFFEC0p-61F, Float.parseFloat("0X3FFFFFFFFFFFFEC0p-61F"));
        check(+0x7FFFFFFFFFFFFD80P-62d, Double.parseDouble("+0x7FFFFFFFFFFFFD80P-62d"));
        check(-0X7ffffffffffffd80p-62d, Double.parseDouble("-0X7ffffffffffffd80p-62d"));
        check(0X7FFFFFFFFFFFFD80P-62, Double.parseDouble("0X7FFFFFFFFFFFFD80P-62"));
        check(-0x7FFFFFFFFFFFFD9P-58f, Float.parseFloat("-0x7FFFFFFFFFFFFD9P-58f"));
        check(-0xfffffffffffffb2p-59F, Float.parseFloat("-0xfffffffffffffb2p-59F"));
        check(0xFFFFFFFFFFFFFB2p-59d, Double.parseDouble("0xFFFFFFFFFFFFFB2p-59d"));
        check(0Xfffffffffffffb2p-59f, Float.parseFloat("0Xfffffffffffffb2p-59f"));
        check(-0x1fffffffffffff64p-60F, Float.parseFloat("-0x1fffffffffffff64p-60F"));
        check(0X1FFFFFFFFFFFFF64p-60f, Float.parseFloat("0X1FFFFFFFFFFFFF64p-60f"));
        check(0x3FFFFFFFFFFFFEC8P-61D, Double.parseDouble("0x3FFFFFFFFFFFFEC8P-61D"));
        check(0X3FFFFFFFFFFFFEC8P-61d, Double.parseDouble("0X3FFFFFFFFFFFFEC8P-61d"));
        check(-0x7ffffffffffffd90P-62, Double.parseDouble("-0x7ffffffffffffd90P-62"));
        check(0x7ffffffffffffd90P-62D, Double.parseDouble("0x7ffffffffffffd90P-62D"));
        check(+0x7FFFFFFFFFFFFDAP-58f, Float.parseFloat("+0x7FFFFFFFFFFFFDAP-58f"));
        check(-0x7FFFFFFFFFFFFDAP-58F, Float.parseFloat("-0x7FFFFFFFFFFFFDAP-58F"));
        check(0xfffffffffffffb4p-59F, Float.parseFloat("0xfffffffffffffb4p-59F"));
        check(-0xfffffffffffffb4P-59d, Double.parseDouble("-0xfffffffffffffb4P-59d"));
        check(-0XFFFFFFFFFFFFFB4P-59D, Double.parseDouble("-0XFFFFFFFFFFFFFB4P-59D"));
        check(0X1fffffffffffff68P-60f, Float.parseFloat("0X1fffffffffffff68P-60f"));
        check(0X3ffffffffffffed0P-61D, Double.parseDouble("0X3ffffffffffffed0P-61D"));
        check(0x7FFFFFFFFFFFFDCP-58d, Double.parseDouble("0x7FFFFFFFFFFFFDCP-58d"));
        check(+0xFFFFFFFFFFFFFB8P-59F, Float.parseFloat("+0xFFFFFFFFFFFFFB8P-59F"));
        check(+0x1FFFFFFFFFFFFF70P-60d, Double.parseDouble("+0x1FFFFFFFFFFFFF70P-60d"));
        check(0X7ffffffffffffddP-58d, Double.parseDouble("0X7ffffffffffffddP-58d"));
        check(-0xfffffffffffffbap-59F, Float.parseFloat("-0xfffffffffffffbap-59F"));
        check(+0XFFFFFFFFFFFFFBAp-59f, Float.parseFloat("+0XFFFFFFFFFFFFFBAp-59f"));
        check(+0XfffffffffffffbaP-59F, Float.parseFloat("+0XfffffffffffffbaP-59F"));
        check(+0XfffffffffffffbaP-59d, Double.parseDouble("+0XfffffffffffffbaP-59d"));
        check(+0XFFFFFFFFFFFFFBAP-59F, Float.parseFloat("+0XFFFFFFFFFFFFFBAP-59F"));
        check(-0x1fffffffffffff74p-60f, Float.parseFloat("-0x1fffffffffffff74p-60f"));
        check(-0x1FFFFFFFFFFFFF74p-60, Double.parseDouble("-0x1FFFFFFFFFFFFF74p-60"));
        check(0xFFFFFFFFFFFFFBCP-59d, Double.parseDouble("0xFFFFFFFFFFFFFBCP-59d"));
        check(+0Xfffffffffffffbcp-59D, Double.parseDouble("+0Xfffffffffffffbcp-59D"));
        check(-0XfffffffffffffbcP-59f, Float.parseFloat("-0XfffffffffffffbcP-59f"));
        check(+0x1fffffffffffff78p-60d, Double.parseDouble("+0x1fffffffffffff78p-60d"));
        check(0x1fffffffffffff78P-60d, Double.parseDouble("0x1fffffffffffff78P-60d"));
        check(-0Xfffffffffffffbc0p-63F, Float.parseFloat("-0Xfffffffffffffbc0p-63F"));
        check(0Xfffffffffffffbc0P-63D, Double.parseDouble("0Xfffffffffffffbc0P-63D"));
        check(-0Xfffffffffffffc0p-59d, Double.parseDouble("-0Xfffffffffffffc0p-59d"));
        check(0XFFFFFFFFFFFFFC0P-59f, Float.parseFloat("0XFFFFFFFFFFFFFC0P-59f"));
        check(+0x1fffffffffffff80p-60D, Double.parseDouble("+0x1fffffffffffff80p-60D"));
        check(+0x1FFFFFFFFFFFFF80p-60F, Float.parseFloat("+0x1FFFFFFFFFFFFF80p-60F"));
        check(-0x1fffffffffffff80P-60D, Double.parseDouble("-0x1fffffffffffff80P-60D"));
        check(+0X1FFFFFFFFFFFFF80P-60f, Float.parseFloat("+0X1FFFFFFFFFFFFF80P-60f"));
        check(0x3fffffffffffff00P-61d, Double.parseDouble("0x3fffffffffffff00P-61d"));
        check(+0X3fffffffffffff00p-61F, Float.parseFloat("+0X3fffffffffffff00p-61F"));
        check(-0x7ffffffffffffe1p-58, Double.parseDouble("-0x7ffffffffffffe1p-58"));
        check(-0x7ffffffffffffe1p-58d, Double.parseDouble("-0x7ffffffffffffe1p-58d"));
        check(-0Xfffffffffffffc2P-59F, Float.parseFloat("-0Xfffffffffffffc2P-59F"));
        check(0x1FFFFFFFFFFFFF84p-60F, Float.parseFloat("0x1FFFFFFFFFFFFF84p-60F"));
        check(-0x1FFFFFFFFFFFFF84P-60, Double.parseDouble("-0x1FFFFFFFFFFFFF84P-60"));
        check(0X1fffffffffffff84p-60F, Float.parseFloat("0X1fffffffffffff84p-60F"));
        check(+0X1fffffffffffff84p-60D, Double.parseDouble("+0X1fffffffffffff84p-60D"));
        check(-0X1fffffffffffff84P-60d, Double.parseDouble("-0X1fffffffffffff84P-60d"));
        check(-0x3fffffffffffff08p-61D, Double.parseDouble("-0x3fffffffffffff08p-61D"));
        check(+0x7ffffffffffffe10P-62F, Float.parseFloat("+0x7ffffffffffffe10P-62F"));
        check(0xfffffffffffffc20p-63D, Double.parseDouble("0xfffffffffffffc20p-63D"));
        check(+0x7FFFFFFFFFFFFE2p-58F, Float.parseFloat("+0x7FFFFFFFFFFFFE2p-58F"));
        check(-0x7FFFFFFFFFFFFE2p-58D, Double.parseDouble("-0x7FFFFFFFFFFFFE2p-58D"));
        check(-0X7FFFFFFFFFFFFE2P-58f, Float.parseFloat("-0X7FFFFFFFFFFFFE2P-58f"));
        check(0xFFFFFFFFFFFFFC4P-59d, Double.parseDouble("0xFFFFFFFFFFFFFC4P-59d"));
        check(-0Xfffffffffffffc4P-59D, Double.parseDouble("-0Xfffffffffffffc4P-59D"));
        check(0X1FFFFFFFFFFFFF88p-60F, Float.parseFloat("0X1FFFFFFFFFFFFF88p-60F"));
        check(+0x3FFFFFFFFFFFFF10p-61D, Double.parseDouble("+0x3FFFFFFFFFFFFF10p-61D"));
        check(+0x7FFFFFFFFFFFFE4p-58, Double.parseDouble("+0x7FFFFFFFFFFFFE4p-58"));
        check(0X7ffffffffffffe4p-58, Double.parseDouble("0X7ffffffffffffe4p-58"));
        check(0X7FFFFFFFFFFFFE4p-58f, Float.parseFloat("0X7FFFFFFFFFFFFE4p-58f"));
        check(-0xFFFFFFFFFFFFFC8P-59F, Float.parseFloat("-0xFFFFFFFFFFFFFC8P-59F"));
        check(-0Xfffffffffffffc8p-59, Double.parseDouble("-0Xfffffffffffffc8p-59"));
        check(-0x1fffffffffffff90p-60D, Double.parseDouble("-0x1fffffffffffff90p-60D"));
        check(0xFFFFFFFFFFFFFCAP-59F, Float.parseFloat("0xFFFFFFFFFFFFFCAP-59F"));
        check(-0x1fffffffffffff94P-60D, Double.parseDouble("-0x1fffffffffffff94P-60D"));
        check(-0x1FFFFFFFFFFFFF94P-60F, Float.parseFloat("-0x1FFFFFFFFFFFFF94P-60F"));
        check(+0X1fffffffffffff94p-60, Double.parseDouble("+0X1fffffffffffff94p-60"));
        check(-0X1fffffffffffff94p-60D, Double.parseDouble("-0X1fffffffffffff94p-60D"));
        check(-0x3FFFFFFFFFFFFF28p-61d, Double.parseDouble("-0x3FFFFFFFFFFFFF28p-61d"));
        check(+0x7ffffffffffffe50P-62D, Double.parseDouble("+0x7ffffffffffffe50P-62D"));
        check(0X7FFFFFFFFFFFFE50p-62f, Float.parseFloat("0X7FFFFFFFFFFFFE50p-62f"));
        check(0X7FFFFFFFFFFFFE50p-62D, Double.parseDouble("0X7FFFFFFFFFFFFE50p-62D"));
        check(0xFFFFFFFFFFFFFCA0p-63f, Float.parseFloat("0xFFFFFFFFFFFFFCA0p-63f"));
        check(-0xfffffffffffffca0P-63F, Float.parseFloat("-0xfffffffffffffca0P-63F"));
        check(-0Xfffffffffffffca0p-63, Double.parseDouble("-0Xfffffffffffffca0p-63"));
        check(0x7ffffffffffffe6p-58F, Float.parseFloat("0x7ffffffffffffe6p-58F"));
        check(+0xfffffffffffffccP-59D, Double.parseDouble("+0xfffffffffffffccP-59D"));
        check(+0xFFFFFFFFFFFFFCCP-59d, Double.parseDouble("+0xFFFFFFFFFFFFFCCP-59d"));
        check(-0x1FFFFFFFFFFFFFA0p-60f, Float.parseFloat("-0x1FFFFFFFFFFFFFA0p-60f"));
        check(0x1FFFFFFFFFFFFFA0P-60D, Double.parseDouble("0x1FFFFFFFFFFFFFA0P-60D"));
        check(-0x7ffffffffffffe9p-58D, Double.parseDouble("-0x7ffffffffffffe9p-58D"));
        check(+0x7FFFFFFFFFFFFE9P-58f, Float.parseFloat("+0x7FFFFFFFFFFFFE9P-58f"));
        check(0X7FFFFFFFFFFFFE9P-58, Double.parseDouble("0X7FFFFFFFFFFFFE9P-58"));
        check(-0xFFFFFFFFFFFFFD2p-59, Double.parseDouble("-0xFFFFFFFFFFFFFD2p-59"));
        check(0xfffffffffffffd2P-59d, Double.parseDouble("0xfffffffffffffd2P-59d"));
        check(+0X3fffffffffffff48P-61, Double.parseDouble("+0X3fffffffffffff48P-61"));
        check(-0x7ffffffffffffe90P-62D, Double.parseDouble("-0x7ffffffffffffe90P-62D"));
        check(-0X7ffffffffffffeaP-58F, Float.parseFloat("-0X7ffffffffffffeaP-58F"));
        check(0xfffffffffffffd4p-59F, Float.parseFloat("0xfffffffffffffd4p-59F"));
        check(+0Xfffffffffffffd4p-59f, Float.parseFloat("+0Xfffffffffffffd4p-59f"));
        check(-0XFFFFFFFFFFFFFD4P-59D, Double.parseDouble("-0XFFFFFFFFFFFFFD4P-59D"));
        check(+0x3fffffffffffff50P-61, Double.parseDouble("+0x3fffffffffffff50P-61"));
        check(-0X3fffffffffffff50P-61f, Float.parseFloat("-0X3fffffffffffff50P-61f"));
        check(0X3FFFFFFFFFFFFF50P-61D, Double.parseDouble("0X3FFFFFFFFFFFFF50P-61D"));
        check(-0xfffffffffffffd8p-59d, Double.parseDouble("-0xfffffffffffffd8p-59d"));
        check(0Xfffffffffffffd8p-59D, Double.parseDouble("0Xfffffffffffffd8p-59D"));
        check(-0x1FFFFFFFFFFFFFB0p-60, Double.parseDouble("-0x1FFFFFFFFFFFFFB0p-60"));
        check(+0x1FFFFFFFFFFFFFB0p-60, Double.parseDouble("+0x1FFFFFFFFFFFFFB0p-60"));
        check(0X3fffffffffffff60P-61D, Double.parseDouble("0X3fffffffffffff60P-61D"));
        check(+0X7ffffffffffffec0p-62D, Double.parseDouble("+0X7ffffffffffffec0p-62D"));
        check(+0xfffffffffffffd80p-63D, Double.parseDouble("+0xfffffffffffffd80p-63D"));
        check(+0X7FFFFFFFFFFFFEDp-58, Double.parseDouble("+0X7FFFFFFFFFFFFEDp-58"));
        check(-0Xfffffffffffffdap-59f, Float.parseFloat("-0Xfffffffffffffdap-59f"));
        check(+0x1fffffffffffffb4p-60F, Float.parseFloat("+0x1fffffffffffffb4p-60F"));
        check(-0X1fffffffffffffb4p-60d, Double.parseDouble("-0X1fffffffffffffb4p-60d"));
        check(+0X3FFFFFFFFFFFFF70P-61D, Double.parseDouble("+0X3FFFFFFFFFFFFF70P-61D"));
        check(0X7FFFFFFFFFFFFEE0P-62f, Float.parseFloat("0X7FFFFFFFFFFFFEE0P-62f"));
        check(+0xfffffffffffffdc0P-63F, Float.parseFloat("+0xfffffffffffffdc0P-63F"));
        check(+0X7fffffffffffff0p-58, Double.parseDouble("+0X7fffffffffffff0p-58"));
        check(+0X7FFFFFFFFFFFFF0p-58d, Double.parseDouble("+0X7FFFFFFFFFFFFF0p-58d"));
        check(0x3fffffffffffff80P-61f, Float.parseFloat("0x3fffffffffffff80P-61f"));
        check(-0x3fffffffffffff80P-61D, Double.parseDouble("-0x3fffffffffffff80P-61D"));
        check(0X7FFFFFFFFFFFFF00p-62f, Float.parseFloat("0X7FFFFFFFFFFFFF00p-62f"));
        check(0X7FFFFFFFFFFFFF00p-62d, Double.parseDouble("0X7FFFFFFFFFFFFF00p-62d"));
        check(+0x7fffffffffffff1P-58D, Double.parseDouble("+0x7fffffffffffff1P-58D"));
        check(0X7FFFFFFFFFFFFF1p-58, Double.parseDouble("0X7FFFFFFFFFFFFF1p-58"));
        check(+0xFFFFFFFFFFFFFE2P-59d, Double.parseDouble("+0xFFFFFFFFFFFFFE2P-59d"));
        check(0XFFFFFFFFFFFFFE2p-59, Double.parseDouble("0XFFFFFFFFFFFFFE2p-59"));
        check(+0XFFFFFFFFFFFFFE2p-59f, Float.parseFloat("+0XFFFFFFFFFFFFFE2p-59f"));
        check(+0x3fffffffffffff88p-61F, Float.parseFloat("+0x3fffffffffffff88p-61F"));
        check(0X3fffffffffffff88p-61F, Float.parseFloat("0X3fffffffffffff88p-61F"));
        check(0xfffffffffffffe20P-63, Double.parseDouble("0xfffffffffffffe20P-63"));
        check(-0xfffffffffffffe20P-63d, Double.parseDouble("-0xfffffffffffffe20P-63d"));
        check(+0x7FFFFFFFFFFFFF2P-58f, Float.parseFloat("+0x7FFFFFFFFFFFFF2P-58f"));
        check(0xfffffffffffffe4P-59d, Double.parseDouble("0xfffffffffffffe4P-59d"));
        check(+0x1FFFFFFFFFFFFFC8p-60, Double.parseDouble("+0x1FFFFFFFFFFFFFC8p-60"));
        check(-0x7fffffffffffff20P-62, Double.parseDouble("-0x7fffffffffffff20P-62"));
        check(-0X7FFFFFFFFFFFFF20P-62d, Double.parseDouble("-0X7FFFFFFFFFFFFF20P-62d"));
        check(+0X7fffffffffffff4P-58f, Float.parseFloat("+0X7fffffffffffff4P-58f"));
        check(+0x1fffffffffffffd0P-60, Double.parseDouble("+0x1fffffffffffffd0P-60"));
        check(-0X1fffffffffffffd0P-60D, Double.parseDouble("-0X1fffffffffffffd0P-60D"));
        check(0X3FFFFFFFFFFFFFA0P-61D, Double.parseDouble("0X3FFFFFFFFFFFFFA0P-61D"));
        check(-0xfffffffffffffe80p-63D, Double.parseDouble("-0xfffffffffffffe80p-63D"));
        check(+0xfffffffffffffe80P-63d, Double.parseDouble("+0xfffffffffffffe80P-63d"));
        check(-0Xfffffffffffffe80p-63d, Double.parseDouble("-0Xfffffffffffffe80p-63d"));
        check(0x7FFFFFFFFFFFFF5P-58d, Double.parseDouble("0x7FFFFFFFFFFFFF5P-58d"));
        check(0X7fffffffffffff5p-58D, Double.parseDouble("0X7fffffffffffff5p-58D"));
        check(0X7FFFFFFFFFFFFF5p-58F, Float.parseFloat("0X7FFFFFFFFFFFFF5p-58F"));
        check(-0xfffffffffffffeap-59D, Double.parseDouble("-0xfffffffffffffeap-59D"));
        check(0x1fffffffffffffd4p-60, Double.parseDouble("0x1fffffffffffffd4p-60"));
        check(+0x1fffffffffffffd4P-60F, Float.parseFloat("+0x1fffffffffffffd4P-60F"));
        check(0X1FFFFFFFFFFFFFD4P-60d, Double.parseDouble("0X1FFFFFFFFFFFFFD4P-60d"));
        check(0x3FFFFFFFFFFFFFA8P-61F, Float.parseFloat("0x3FFFFFFFFFFFFFA8P-61F"));
        check(-0xfffffffffffffea0p-63D, Double.parseDouble("-0xfffffffffffffea0p-63D"));
        check(0x7FFFFFFFFFFFFF6P-58F, Float.parseFloat("0x7FFFFFFFFFFFFF6P-58F"));
        check(-0X7fffffffffffff6p-58F, Float.parseFloat("-0X7fffffffffffff6p-58F"));
        check(+0xfffffffffffffecP-59d, Double.parseDouble("+0xfffffffffffffecP-59d"));
        check(0x3fffffffffffffb0p-61D, Double.parseDouble("0x3fffffffffffffb0p-61D"));
        check(+0x3fffffffffffffb0p-61D, Double.parseDouble("+0x3fffffffffffffb0p-61D"));
        check(+0x3FFFFFFFFFFFFFB0P-61d, Double.parseDouble("+0x3FFFFFFFFFFFFFB0P-61d"));
        check(-0X3FFFFFFFFFFFFFB0p-61f, Float.parseFloat("-0X3FFFFFFFFFFFFFB0p-61f"));
        check(+0X3fffffffffffffb0P-61D, Double.parseDouble("+0X3fffffffffffffb0P-61D"));
        check(0X3FFFFFFFFFFFFFB0P-61, Double.parseDouble("0X3FFFFFFFFFFFFFB0P-61"));
        check(+0xfffffffffffffec0P-63, Double.parseDouble("+0xfffffffffffffec0P-63"));
        check(0Xfffffffffffffec0p-63F, Float.parseFloat("0Xfffffffffffffec0p-63F"));
        check(0Xfffffffffffffec0p-63D, Double.parseDouble("0Xfffffffffffffec0p-63D"));
        check(+0x7fffffffffffff8p-58D, Double.parseDouble("+0x7fffffffffffff8p-58D"));
        check(0x7FFFFFFFFFFFFF8p-58F, Float.parseFloat("0x7FFFFFFFFFFFFF8p-58F"));
        check(+0X7FFFFFFFFFFFFF8p-58, Double.parseDouble("+0X7FFFFFFFFFFFFF8p-58"));
        check(+0XFFFFFFFFFFFFFF0p-59, Double.parseDouble("+0XFFFFFFFFFFFFFF0p-59"));
        check(-0xffffffffffffff00p-63d, Double.parseDouble("-0xffffffffffffff00p-63d"));
        check(0xFFFFFFFFFFFFFF00p-63D, Double.parseDouble("0xFFFFFFFFFFFFFF00p-63D"));
        check(0X7FFFFFFFFFFFFF9p-58f, Float.parseFloat("0X7FFFFFFFFFFFFF9p-58f"));
        check(-0XFFFFFFFFFFFFFF2p-59F, Float.parseFloat("-0XFFFFFFFFFFFFFF2p-59F"));
        check(-0x1FFFFFFFFFFFFFE4P-60F, Float.parseFloat("-0x1FFFFFFFFFFFFFE4P-60F"));
        check(-0X1FFFFFFFFFFFFFE4p-60f, Float.parseFloat("-0X1FFFFFFFFFFFFFE4p-60f"));
        check(+0x7fffffffffffff90P-62f, Float.parseFloat("+0x7fffffffffffff90P-62f"));
        check(0X7FFFFFFFFFFFFF90P-62, Double.parseDouble("0X7FFFFFFFFFFFFF90P-62"));
        check(-0Xffffffffffffff20P-63, Double.parseDouble("-0Xffffffffffffff20P-63"));
        check(0X7fffffffffffffap-58D, Double.parseDouble("0X7fffffffffffffap-58D"));
        check(-0xFFFFFFFFFFFFFF4p-59D, Double.parseDouble("-0xFFFFFFFFFFFFFF4p-59D"));
        check(+0x1fffffffffffffe8P-60F, Float.parseFloat("+0x1fffffffffffffe8P-60F"));
        check(-0x1fffffffffffffe8P-60d, Double.parseDouble("-0x1fffffffffffffe8P-60d"));
        check(+0X1fffffffffffffe8p-60, Double.parseDouble("+0X1fffffffffffffe8p-60"));
        check(0X1fffffffffffffe8p-60f, Float.parseFloat("0X1fffffffffffffe8p-60f"));
        check(+0xffffffffffffff8p-59f, Float.parseFloat("+0xffffffffffffff8p-59f"));
        check(0xffffffffffffff8p-59D, Double.parseDouble("0xffffffffffffff8p-59D"));
        check(0x1FFFFFFFFFFFFFF0p-60F, Float.parseFloat("0x1FFFFFFFFFFFFFF0p-60F"));
        check(0x1FFFFFFFFFFFFFF0P-60D, Double.parseDouble("0x1FFFFFFFFFFFFFF0P-60D"));
        check(0X3FFFFFFFFFFFFFE0p-61F, Float.parseFloat("0X3FFFFFFFFFFFFFE0p-61F"));
        check(0x7fffffffffffffc0P-62, Double.parseDouble("0x7fffffffffffffc0P-62"));
        check(+0X7FFFFFFFFFFFFFC0p-62, Double.parseDouble("+0X7FFFFFFFFFFFFFC0p-62"));
        check(-0xffffffffffffffap-59f, Float.parseFloat("-0xffffffffffffffap-59f"));
        check(-0x1ffffffffffffff4P-60, Double.parseDouble("-0x1ffffffffffffff4P-60"));
        check(-0X1FFFFFFFFFFFFFF4p-60d, Double.parseDouble("-0X1FFFFFFFFFFFFFF4p-60d"));
        check(+0xFFFFFFFFFFFFFFCp-59F, Float.parseFloat("+0xFFFFFFFFFFFFFFCp-59F"));
        check(+0x1ffffffffffffff8P-60f, Float.parseFloat("+0x1ffffffffffffff8P-60f"));
        check(-0x3FFFFFFFFFFFFFF0P-61f, Float.parseFloat("-0x3FFFFFFFFFFFFFF0P-61f"));
        check(-0x3FFFFFFFFFFFFFF0P-61F, Float.parseFloat("-0x3FFFFFFFFFFFFFF0P-61F"));
        check(-0X3ffffffffffffff0P-61F, Float.parseFloat("-0X3ffffffffffffff0P-61F"));
        check(-0X7fffffffffffffe0P-62F, Float.parseFloat("-0X7fffffffffffffe0P-62F"));
        check(-0X1.5904f0756062P-3, Double.parseDouble("-0X1.5904f0756062P-3"));
        check(-0X1.5904F0756062P-3D, Double.parseDouble("-0X1.5904F0756062P-3D"));
        check(+0x1.EA02BAF90CD5EP-2f, Float.parseFloat("+0x1.EA02BAF90CD5EP-2f"));
        check(0x1.EA02BAF90CD5EP-2D, Double.parseDouble("0x1.EA02BAF90CD5EP-2D"));
        check(-0x1.3E8F62BDEE08CP-3F, Float.parseFloat("-0x1.3E8F62BDEE08CP-3F"));
        check(0X1.3e8f62bdee08cp-3, Double.parseDouble("0X1.3e8f62bdee08cp-3"));
        check(-0X1.2db622e9a5aebp-1, Double.parseDouble("-0X1.2db622e9a5aebp-1"));
        check(+0x1.69649E7F27397p-1d, Double.parseDouble("+0x1.69649E7F27397p-1d"));
        check(+0X1.2fc7ca23769f5p-1f, Float.parseFloat("+0X1.2fc7ca23769f5p-1f"));
        check(0X1.ceda0d46c00beP-2D, Double.parseDouble("0X1.ceda0d46c00beP-2D"));
        check(0X1.CEDA0D46C00BEP-2F, Float.parseFloat("0X1.CEDA0D46C00BEP-2F"));
        check(-0X1.38fd2f4a8ed8ap-1f, Float.parseFloat("-0X1.38fd2f4a8ed8ap-1f"));
        check(-0X1.38FD2F4A8ED8Ap-1, Double.parseDouble("-0X1.38FD2F4A8ED8Ap-1"));
        check(+0X1.38FD2F4A8ED8AP-1D, Double.parseDouble("+0X1.38FD2F4A8ED8AP-1D"));
        check(-0x1.5273b203432dfP-1D, Double.parseDouble("-0x1.5273b203432dfP-1D"));
        check(+0X1.5273B203432DFp-1, Double.parseDouble("+0X1.5273B203432DFp-1"));
        check(0x1.e7e2d01cb7b54P-2D, Double.parseDouble("0x1.e7e2d01cb7b54P-2D"));
        check(0X1.E7E2D01CB7B54p-2D, Double.parseDouble("0X1.E7E2D01CB7B54p-2D"));
        check(0X1.e7e2d01cb7b54P-2f, Float.parseFloat("0X1.e7e2d01cb7b54P-2f"));
        check(0X1.E7E2D01CB7B54P-2d, Double.parseDouble("0X1.E7E2D01CB7B54P-2d"));
        check(-0x1.1ED3A7DA0FEE3p-1, Double.parseDouble("-0x1.1ED3A7DA0FEE3p-1"));
        check(-0X1.1ED3A7DA0FEE3p-1d, Double.parseDouble("-0X1.1ED3A7DA0FEE3p-1d"));
        check(0x1.6D3EEE5613554P-3d, Double.parseDouble("0x1.6D3EEE5613554P-3d"));
        check(0X1.6d3eee5613554p-3F, Float.parseFloat("0X1.6d3eee5613554p-3F"));
        check(+0x1.6D11DD06F0C08p-4d, Double.parseDouble("+0x1.6D11DD06F0C08p-4d"));
        check(+0X1.139C2D984BB27P-1F, Float.parseFloat("+0X1.139C2D984BB27P-1F"));
        check(0x1.7C79B969BD688P-3d, Double.parseDouble("0x1.7C79B969BD688P-3d"));
        check(+0X1.1B4C60BD93FA6P-1, Double.parseDouble("+0X1.1B4C60BD93FA6P-1"));
        check(0x1.04B2D188FBD7AP-2f, Float.parseFloat("0x1.04B2D188FBD7AP-2f"));
        check(0X1.5dab308a1cff8p-2D, Double.parseDouble("0X1.5dab308a1cff8p-2D"));
        check(+0X1.5DAB308A1CFF8p-2, Double.parseDouble("+0X1.5DAB308A1CFF8p-2"));
        check(+0x1.0D1EC6D7D5D5AP-1, Double.parseDouble("+0x1.0D1EC6D7D5D5AP-1"));
        check(+0X1.22bfce93f0f42P-2d, Double.parseDouble("+0X1.22bfce93f0f42P-2d"));
        check(0X1.1a515fe283515p-1d, Double.parseDouble("0X1.1a515fe283515p-1d"));
        check(0X1.1a515fe283515P-1F, Float.parseFloat("0X1.1a515fe283515P-1F"));
        check(-0X1.1A515FE283515P-1, Double.parseDouble("-0X1.1A515FE283515P-1"));
        check(0X1.1ED7B6E39B6D1P-1F, Float.parseFloat("0X1.1ED7B6E39B6D1P-1F"));
        check(+0x1.F813F1588CE5Ep-2, Double.parseDouble("+0x1.F813F1588CE5Ep-2"));
        check(0X1.F813F1588CE5Ep-2, Double.parseDouble("0X1.F813F1588CE5Ep-2"));
        check(+0X1.C6B82C26D1C96P-2, Double.parseDouble("+0X1.C6B82C26D1C96P-2"));
        check(0X1.C6B82C26D1C96P-2d, Double.parseDouble("0X1.C6B82C26D1C96P-2d"));
        check(0x1.a9f80a0a50b5dp-1F, Float.parseFloat("0x1.a9f80a0a50b5dp-1F"));
        check(0x1.a9f80a0a50b5dP-1D, Double.parseDouble("0x1.a9f80a0a50b5dP-1D"));
        check(0X1.a9f80a0a50b5dP-1F, Float.parseFloat("0X1.a9f80a0a50b5dP-1F"));
        check(0X1.a9f80a0a50b5dP-1d, Double.parseDouble("0X1.a9f80a0a50b5dP-1d"));
        check(-0X1.7C402E8A62B12p-2f, Float.parseFloat("-0X1.7C402E8A62B12p-2f"));
        check(+0x1.5e79e530d5174p-2d, Double.parseDouble("+0x1.5e79e530d5174p-2d"));
        check(+0x1.5e79e530d5174P-2f, Float.parseFloat("+0x1.5e79e530d5174P-2f"));
        check(-0x1.5e79e530d5174P-2D, Double.parseDouble("-0x1.5e79e530d5174P-2D"));
        check(0x1.DF37C102AC48Bp-1d, Double.parseDouble("0x1.DF37C102AC48Bp-1d"));
        check(+0x1.fa63912b31d33p-1F, Float.parseFloat("+0x1.fa63912b31d33p-1F"));
        check(+0X1.fa63912b31d33P-1F, Float.parseFloat("+0X1.fa63912b31d33P-1F"));
        check(-0x1.780c455790458P-3f, Float.parseFloat("-0x1.780c455790458P-3f"));
        check(0x1.780C455790458P-3D, Double.parseDouble("0x1.780C455790458P-3D"));
        check(+0x1.5a57f5ce9b1ap-3f, Float.parseFloat("+0x1.5a57f5ce9b1ap-3f"));
        check(0X1.5A57F5CE9B1Ap-3D, Double.parseDouble("0X1.5A57F5CE9B1Ap-3D"));
        check(-0x1.df85c5515a532P-1F, Float.parseFloat("-0x1.df85c5515a532P-1F"));
        check(0x1.df85c5515a532P-1D, Double.parseDouble("0x1.df85c5515a532P-1D"));
        check(-0x1.0f72bba4d5bd8P-1, Double.parseDouble("-0x1.0f72bba4d5bd8P-1"));
        check(+0X1.771f4248b54d3P-1F, Float.parseFloat("+0X1.771f4248b54d3P-1F"));
        check(-0x1.2e2a583ac357dp-1F, Float.parseFloat("-0x1.2e2a583ac357dp-1F"));
        check(+0x1.cfd684d98bf89P-1D, Double.parseDouble("+0x1.cfd684d98bf89P-1D"));
        check(-0X1.B2C0A663A3B1AP-1f, Float.parseFloat("-0X1.B2C0A663A3B1AP-1f"));
        check(-0x1.88d83e84450f5p-1F, Float.parseFloat("-0x1.88d83e84450f5p-1F"));
        check(0X1.027311D07010DP-1f, Float.parseFloat("0X1.027311D07010DP-1f"));
        check(0X1.B38705C5F6372P-1d, Double.parseDouble("0X1.B38705C5F6372P-1d"));
        check(-0x1.4CB013D32728Ap-2d, Double.parseDouble("-0x1.4CB013D32728Ap-2d"));
        check(+0X1.4CB013D32728AP-2F, Float.parseFloat("+0X1.4CB013D32728AP-2F"));
        check(+0X1.3DF0D61305AP-5d, Double.parseDouble("+0X1.3DF0D61305AP-5d"));
        check(+0X1.02D92D177E93Cp-1F, Float.parseFloat("+0X1.02D92D177E93Cp-1F"));
        check(0x1.59cf48627c40cP-2, Double.parseDouble("0x1.59cf48627c40cP-2"));
        check(0x1.fddd3413a3481p-1, Double.parseDouble("0x1.fddd3413a3481p-1"));
        check(+0X1.fddd3413a3481p-1F, Float.parseFloat("+0X1.fddd3413a3481p-1F"));
        check(0x1.004163b6de405P-1F, Float.parseFloat("0x1.004163b6de405P-1F"));
        check(-0X1.84B0BDC9FE8F4p-2d, Double.parseDouble("-0X1.84B0BDC9FE8F4p-2d"));
        check(-0X1.84B0BDC9FE8F4p-2D, Double.parseDouble("-0X1.84B0BDC9FE8F4p-2D"));
        check(-0X1.c1daaf553b624p-1d, Double.parseDouble("-0X1.c1daaf553b624p-1d"));
        check(-0X1.C1DAAF553B624P-1D, Double.parseDouble("-0X1.C1DAAF553B624P-1D"));
        check(0X1.0BB85CB0A094P-7F, Float.parseFloat("0X1.0BB85CB0A094P-7F"));
        check(+0X1.B17FC7B327B75p-1, Double.parseDouble("+0X1.B17FC7B327B75p-1"));
        check(0X1.b17fc7b327b75P-1, Double.parseDouble("0X1.b17fc7b327b75P-1"));
        check(0x1.180e61e0399c5p-1F, Float.parseFloat("0x1.180e61e0399c5p-1F"));
        check(-0x1.005D8F414B3D8p-1D, Double.parseDouble("-0x1.005D8F414B3D8p-1D"));
        check(+0X1.005d8f414b3d8p-1D, Double.parseDouble("+0X1.005d8f414b3d8p-1D"));
        check(-0x1.33fca005aba74p-1D, Double.parseDouble("-0x1.33fca005aba74p-1D"));
        check(-0X1.741EA674347C7p-1d, Double.parseDouble("-0X1.741EA674347C7p-1d"));
        check(-0X1.F5DAD86BBED29p-1F, Float.parseFloat("-0X1.F5DAD86BBED29p-1F"));
        check(+0X1.F5DAD86BBED29p-1D, Double.parseDouble("+0X1.F5DAD86BBED29p-1D"));
        check(+0x1.3d80c64dc5506P-1d, Double.parseDouble("+0x1.3d80c64dc5506P-1d"));
        check(0X1.3D80C64DC5506P-1f, Float.parseFloat("0X1.3D80C64DC5506P-1f"));
        check(0x1.039619AF2DA68P-2, Double.parseDouble("0x1.039619AF2DA68P-2"));
        check(+0X1.039619af2da68P-2F, Float.parseFloat("+0X1.039619af2da68P-2F"));
        check(+0X1.039619AF2DA68P-2, Double.parseDouble("+0X1.039619AF2DA68P-2"));
        check(0x1.a76c04bc2ce8p-4f, Float.parseFloat("0x1.a76c04bc2ce8p-4f"));
        check(+0x1.A76C04BC2CE8p-4, Double.parseDouble("+0x1.A76C04BC2CE8p-4"));
        check(+0x1.A76C04BC2CE8p-4f, Float.parseFloat("+0x1.A76C04BC2CE8p-4f"));
        check(0x1.A76C04BC2CE8p-4d, Double.parseDouble("0x1.A76C04BC2CE8p-4d"));
        check(+0x1.a76c04bc2ce8P-4, Double.parseDouble("+0x1.a76c04bc2ce8P-4"));
        check(-0X1.fd24a4049ae6dp-1D, Double.parseDouble("-0X1.fd24a4049ae6dp-1D"));
        check(+0x1.201c55907808cp-2d, Double.parseDouble("+0x1.201c55907808cp-2d"));
        check(+0x1.82ea1117e1c45P-1f, Float.parseFloat("+0x1.82ea1117e1c45P-1f"));
        check(-0X1.4EA1D207DA71Bp-1d, Double.parseDouble("-0X1.4EA1D207DA71Bp-1d"));
        check(0x1.F1A2B602B5527p-1, Double.parseDouble("0x1.F1A2B602B5527p-1"));
        check(-0x1.229e68be614c2p-2F, Float.parseFloat("-0x1.229e68be614c2p-2F"));
        check(-0x1.229e68be614c2p-2d, Double.parseDouble("-0x1.229e68be614c2p-2d"));
        check(0x1.229E68BE614C2p-2D, Double.parseDouble("0x1.229E68BE614C2p-2D"));
        check(+0X1.229E68BE614C2p-2, Double.parseDouble("+0X1.229E68BE614C2p-2"));
        check(+0X1.229E68BE614C2p-2f, Float.parseFloat("+0X1.229E68BE614C2p-2f"));
        check(+0x1.4997037C060D6P-2f, Float.parseFloat("+0x1.4997037C060D6P-2f"));
        check(+0x1.169349ac6531P-5F, Float.parseFloat("+0x1.169349ac6531P-5F"));
        check(+0x1.86571846da363p-1f, Float.parseFloat("+0x1.86571846da363p-1f"));
        check(+0x1.86571846DA363p-1f, Float.parseFloat("+0x1.86571846DA363p-1f"));
        check(-0X1.86571846da363P-1, Double.parseDouble("-0X1.86571846da363P-1"));
        check(+0X1.3a1f6135e6848P-1F, Float.parseFloat("+0X1.3a1f6135e6848P-1F"));
        check(0x1.594F819CB9F08P-1f, Float.parseFloat("0x1.594F819CB9F08P-1f"));
        check(-0x1.594F819CB9F08P-1F, Float.parseFloat("-0x1.594F819CB9F08P-1F"));
        check(0X1.594f819cb9f08p-1D, Double.parseDouble("0X1.594f819cb9f08p-1D"));
        check(+0X1.594f819cb9f08P-1D, Double.parseDouble("+0X1.594f819cb9f08P-1D"));
        check(+0X1.594F819CB9F08P-1D, Double.parseDouble("+0X1.594F819CB9F08P-1D"));
        check(+0X1.6049651efc30cP-3f, Float.parseFloat("+0X1.6049651efc30cP-3f"));
        check(+0X1.6049651EFC30CP-3F, Float.parseFloat("+0X1.6049651EFC30CP-3F"));
        check(-0x1.71d29dca9a554P-3F, Float.parseFloat("-0x1.71d29dca9a554P-3F"));
        check(+0X1.71d29dca9a554p-3d, Double.parseDouble("+0X1.71d29dca9a554p-3d"));
        check(-0X1.71D29DCA9A554P-3F, Float.parseFloat("-0X1.71D29DCA9A554P-3F"));
        check(+0x1.98886dfb629a1P-1F, Float.parseFloat("+0x1.98886dfb629a1P-1F"));
        check(0X1.55a7430e68e12p-1f, Float.parseFloat("0X1.55a7430e68e12p-1f"));
        check(+0X1.55A7430E68E12p-1, Double.parseDouble("+0X1.55A7430E68E12p-1"));
        check(-0x1.F5DFCB4248FD2p-1F, Float.parseFloat("-0x1.F5DFCB4248FD2p-1F"));
        check(-0x1.f5dfcb4248fd2P-1, Double.parseDouble("-0x1.f5dfcb4248fd2P-1"));
        check(0X1.f5dfcb4248fd2P-1F, Float.parseFloat("0X1.f5dfcb4248fd2P-1F"));
        check(+0x1.4d5dd652fa9e4P-1f, Float.parseFloat("+0x1.4d5dd652fa9e4P-1f"));
        check(-0X1.C09EDC0098A5p-2d, Double.parseDouble("-0X1.C09EDC0098A5p-2d"));
        check(0X1.C09EDC0098A5P-2F, Float.parseFloat("0X1.C09EDC0098A5P-2F"));
        check(0x1.6F2D25028B031p-1, Double.parseDouble("0x1.6F2D25028B031p-1"));
        check(0X1.6f2d25028b031p-1D, Double.parseDouble("0X1.6f2d25028b031p-1D"));
        check(+0x1.4b9db07f3ad54p-1f, Float.parseFloat("+0x1.4b9db07f3ad54p-1f"));
        check(+0x1.4b9db07f3ad54P-1F, Float.parseFloat("+0x1.4b9db07f3ad54P-1F"));
        check(+0X1.31AE38C33D9EP-4d, Double.parseDouble("+0X1.31AE38C33D9EP-4d"));
        check(+0X1.029ac6c1733d6p-1D, Double.parseDouble("+0X1.029ac6c1733d6p-1D"));
        check(-0x1.A24F18BBE4A62P-1, Double.parseDouble("-0x1.A24F18BBE4A62P-1"));
        check(-0X1.A24F18BBE4A62p-1f, Float.parseFloat("-0X1.A24F18BBE4A62p-1f"));
        check(+0X1.A24F18BBE4A62P-1f, Float.parseFloat("+0X1.A24F18BBE4A62P-1f"));
        check(+0x1.6a103ecc5ec7fP-1f, Float.parseFloat("+0x1.6a103ecc5ec7fP-1f"));
        check(0x1.610abf9427c0cp-3f, Float.parseFloat("0x1.610abf9427c0cp-3f"));
        check(0X1.3cfd679a29064p-3f, Float.parseFloat("0X1.3cfd679a29064p-3f"));
        check(-0X1.3CFD679A29064p-3f, Float.parseFloat("-0X1.3CFD679A29064p-3f"));
        check(-0X1.3cfd679a29064P-3f, Float.parseFloat("-0X1.3cfd679a29064P-3f"));
        check(0X1.9add00f43cf78P-3D, Double.parseDouble("0X1.9add00f43cf78P-3D"));
        check(-0X1.270593A88CAD4p-2D, Double.parseDouble("-0X1.270593A88CAD4p-2D"));
        check(-0x1.9c26495b09b24P-3, Double.parseDouble("-0x1.9c26495b09b24P-3"));
        check(-0X1.B2D40066C0D58p-4F, Float.parseFloat("-0X1.B2D40066C0D58p-4F"));
        check(-0x1.53479F994331CP-2F, Float.parseFloat("-0x1.53479F994331CP-2F"));
        check(-0x1.8406e373e811ap-1F, Float.parseFloat("-0x1.8406e373e811ap-1F"));
        check(-0x1.ad52cbff9d688p-3F, Float.parseFloat("-0x1.ad52cbff9d688p-3F"));
        check(0X1.ad52cbff9d688P-3D, Double.parseDouble("0X1.ad52cbff9d688P-3D"));
        check(0X1.AD52CBFF9D688P-3D, Double.parseDouble("0X1.AD52CBFF9D688P-3D"));
        check(+0x1.53F8A525FDA4Cp-3D, Double.parseDouble("+0x1.53F8A525FDA4Cp-3D"));
        check(+0x1.53F8A525FDA4CP-3f, Float.parseFloat("+0x1.53F8A525FDA4CP-3f"));
        check(-0X1.6c7f63ee671a4p-2F, Float.parseFloat("-0X1.6c7f63ee671a4p-2F"));
        check(-0x1.56b5050d65102p-1f, Float.parseFloat("-0x1.56b5050d65102p-1f"));
        check(-0X1.56B5050D65102P-1f, Float.parseFloat("-0X1.56B5050D65102P-1f"));
        check(+0X1.61e811e92769aP-1D, Double.parseDouble("+0X1.61e811e92769aP-1D"));
        check(-0x1.bc7fc9c8f5228P-4d, Double.parseDouble("-0x1.bc7fc9c8f5228P-4d"));
        check(-0X1.bc7fc9c8f5228P-4F, Float.parseFloat("-0X1.bc7fc9c8f5228P-4F"));
        check(+0X1.bc7fc9c8f5228P-4d, Double.parseDouble("+0X1.bc7fc9c8f5228P-4d"));
        check(0x1.1993F9F37D0A8P-4d, Double.parseDouble("0x1.1993F9F37D0A8P-4d"));
        check(0X1.1993F9F37D0A8p-4d, Double.parseDouble("0X1.1993F9F37D0A8p-4d"));
        check(+0x1.e6742fa1b480aP-2, Double.parseDouble("+0x1.e6742fa1b480aP-2"));
        check(0X1.e6742fa1b480ap-2d, Double.parseDouble("0X1.e6742fa1b480ap-2d"));
        check(-0X1.E6742FA1B480Ap-2, Double.parseDouble("-0X1.E6742FA1B480Ap-2"));
        check(-0X1.e6742fa1b480aP-2F, Float.parseFloat("-0X1.e6742fa1b480aP-2F"));
        check(+0x1.2BD8ABBA8C0CP-3f, Float.parseFloat("+0x1.2BD8ABBA8C0CP-3f"));
        check(+0X1.206ddf2398b71p-1f, Float.parseFloat("+0X1.206ddf2398b71p-1f"));
        check(-0X1.955b37238d3e4P-1f, Float.parseFloat("-0X1.955b37238d3e4P-1f"));
        check(0x1.21575de95f72ap-2F, Float.parseFloat("0x1.21575de95f72ap-2F"));
        check(+0x1.21575de95f72aP-2f, Float.parseFloat("+0x1.21575de95f72aP-2f"));
        check(-0x1.57516D9B8A1CFP-1d, Double.parseDouble("-0x1.57516D9B8A1CFP-1d"));
        check(0X1.57516d9b8a1cfP-1f, Float.parseFloat("0X1.57516d9b8a1cfP-1f"));
        check(-0x1.867C6ED548D5Cp-2F, Float.parseFloat("-0x1.867C6ED548D5Cp-2F"));
        check(-0x1.6d5339b64db9p-4d, Double.parseDouble("-0x1.6d5339b64db9p-4d"));
        check(-0X1.6D5339B64DB9p-4d, Double.parseDouble("-0X1.6D5339B64DB9p-4d"));
        check(+0X1.89A899D9CBC48p-1D, Double.parseDouble("+0X1.89A899D9CBC48p-1D"));
        check(-0X1.89A899D9CBC48P-1d, Double.parseDouble("-0X1.89A899D9CBC48P-1d"));
        check(-0x1.212ad4bff477P-2F, Float.parseFloat("-0x1.212ad4bff477P-2F"));
        check(+0x1.212AD4BFF477P-2D, Double.parseDouble("+0x1.212AD4BFF477P-2D"));
        check(-0X1.212AD4BFF477p-2, Double.parseDouble("-0X1.212AD4BFF477p-2"));
        check(+0X1.212AD4BFF477P-2d, Double.parseDouble("+0X1.212AD4BFF477P-2d"));
        check(+0X1.7e9a5aae587dcp-1, Double.parseDouble("+0X1.7e9a5aae587dcp-1"));
        check(0X1.7E9A5AAE587DCp-1d, Double.parseDouble("0X1.7E9A5AAE587DCp-1d"));
        check(-0X1.BFAEB0DBE605Cp-2, Double.parseDouble("-0X1.BFAEB0DBE605Cp-2"));
        check(+0X1.F9726C9C3FF0Ap-1d, Double.parseDouble("+0X1.F9726C9C3FF0Ap-1d"));
        check(0X1.F9726C9C3FF0AP-1D, Double.parseDouble("0X1.F9726C9C3FF0AP-1D"));
        check(+0X1.218696969FC0Cp-1d, Double.parseDouble("+0X1.218696969FC0Cp-1d"));
        check(0x1.77F4D5DC28D7Ap-1D, Double.parseDouble("0x1.77F4D5DC28D7Ap-1D"));
        check(-0x1.77F4D5DC28D7AP-1D, Double.parseDouble("-0x1.77F4D5DC28D7AP-1D"));
        check(-0X1.77F4D5DC28D7AP-1d, Double.parseDouble("-0X1.77F4D5DC28D7AP-1d"));
        check(0x1.9dab775a35939p-1d, Double.parseDouble("0x1.9dab775a35939p-1d"));
        check(-0X1.9DAB775A35939P-1F, Float.parseFloat("-0X1.9DAB775A35939P-1F"));
        check(+0X1.8e2f7b9f31dc4P-1, Double.parseDouble("+0X1.8e2f7b9f31dc4P-1"));
        check(+0x1.E5E4BEC8133DP-4d, Double.parseDouble("+0x1.E5E4BEC8133DP-4d"));
        check(-0X1.927759aa99ad5p-1d, Double.parseDouble("-0X1.927759aa99ad5p-1d"));
        check(-0x1.a05e17ce86b3p-3, Double.parseDouble("-0x1.a05e17ce86b3p-3"));
        check(-0x1.a05e17ce86b3P-3d, Double.parseDouble("-0x1.a05e17ce86b3P-3d"));
        check(+0x1.4dd143bc4d411P-1d, Double.parseDouble("+0x1.4dd143bc4d411P-1d"));
        check(-0x1.B5444B0196BF8p-1f, Float.parseFloat("-0x1.B5444B0196BF8p-1f"));
        check(0X1.B5444B0196BF8P-1f, Float.parseFloat("0X1.B5444B0196BF8P-1f"));
        check(-0x1.AE6836A0443D2P-1f, Float.parseFloat("-0x1.AE6836A0443D2P-1f"));
        check(-0x1.AE6836A0443D2P-1F, Float.parseFloat("-0x1.AE6836A0443D2P-1F"));
        check(-0X1.ae6836a0443d2P-1D, Double.parseDouble("-0X1.ae6836a0443d2P-1D"));
        check(0x1.d215befd7ab8p-7f, Float.parseFloat("0x1.d215befd7ab8p-7f"));
        check(+0x1.D215BEFD7AB8p-7f, Float.parseFloat("+0x1.D215BEFD7AB8p-7f"));
        check(0X1.d215befd7ab8P-7, Double.parseDouble("0X1.d215befd7ab8P-7"));
        check(+0X1.5eade0671c276P-1D, Double.parseDouble("+0X1.5eade0671c276P-1D"));
        check(+0x1.f314de473ce98p-1D, Double.parseDouble("+0x1.f314de473ce98p-1D"));
        check(-0x1.F314DE473CE98p-1d, Double.parseDouble("-0x1.F314DE473CE98p-1d"));
        check(0X1.f314de473ce98p-1f, Float.parseFloat("0X1.f314de473ce98p-1f"));
        check(0X1.F314DE473CE98P-1f, Float.parseFloat("0X1.F314DE473CE98P-1f"));
        check(0x1.89A8B8EC68AC2P-2, Double.parseDouble("0x1.89A8B8EC68AC2P-2"));
        check(0x1.9aa8e355b5ef1p-1F, Float.parseFloat("0x1.9aa8e355b5ef1p-1F"));
        check(+0x1.9AA8E355B5EF1P-1f, Float.parseFloat("+0x1.9AA8E355B5EF1P-1f"));
        check(+0x1.F92014A5DED88P-1D, Double.parseDouble("+0x1.F92014A5DED88P-1D"));
        check(+0X1.F92014A5DED88P-1d, Double.parseDouble("+0X1.F92014A5DED88P-1d"));
        check(0X1.f7665edb691a4P-3f, Float.parseFloat("0X1.f7665edb691a4P-3f"));
        check(+0x1.5c96664b2b5d7p-1, Double.parseDouble("+0x1.5c96664b2b5d7p-1"));
        check(0X1.5C96664B2B5D7p-1D, Double.parseDouble("0X1.5C96664B2B5D7p-1D"));
        check(0X1.5C96664B2B5D7P-1F, Float.parseFloat("0X1.5C96664B2B5D7P-1F"));
        check(0X1.8691C7EA24B7Ap-1f, Float.parseFloat("0X1.8691C7EA24B7Ap-1f"));
        check(0X1.8691c7ea24b7aP-1d, Double.parseDouble("0X1.8691c7ea24b7aP-1d"));
        check(+0x1.AEE4F9E82615p-1f, Float.parseFloat("+0x1.AEE4F9E82615p-1f"));
        check(-0x1.93a055917f0f4p-1f, Float.parseFloat("-0x1.93a055917f0f4p-1f"));
        check(0x1.93A055917F0F4p-1D, Double.parseDouble("0x1.93A055917F0F4p-1D"));
        check(+0X1.9d7adc8c855c4P-3, Double.parseDouble("+0X1.9d7adc8c855c4P-3"));
        check(+0X1.9D7ADC8C855C4P-3d, Double.parseDouble("+0X1.9D7ADC8C855C4P-3d"));
        check(+0X1.d96514031b5e8P-1d, Double.parseDouble("+0X1.d96514031b5e8P-1d"));
        check(0x1.2750d0c9bfec2p-1F, Float.parseFloat("0x1.2750d0c9bfec2p-1F"));
        check(+0x1.2750D0C9BFEC2p-1, Double.parseDouble("+0x1.2750D0C9BFEC2p-1"));
        check(+0X1.db1308217e8cdp-1F, Float.parseFloat("+0X1.db1308217e8cdp-1F"));
        check(-0X1.7a0fd074299a4p-1f, Float.parseFloat("-0X1.7a0fd074299a4p-1f"));
        check(-0x1.9aa53fb75d336P-2D, Double.parseDouble("-0x1.9aa53fb75d336P-2D"));
        check(-0X1.0D54C97AACB0Ap-2, Double.parseDouble("-0X1.0D54C97AACB0Ap-2"));
        check(0x1.F0D89FDA3930Cp-1d, Double.parseDouble("0x1.F0D89FDA3930Cp-1d"));
        check(0X1.65CAB94E579A1p-1F, Float.parseFloat("0X1.65CAB94E579A1p-1F"));
        check(0X1.65CAB94E579A1p-1D, Double.parseDouble("0X1.65CAB94E579A1p-1D"));
        check(0x1.ab4d489fe955cP-2, Double.parseDouble("0x1.ab4d489fe955cP-2"));
        check(0x1.878350f2b699bp-1, Double.parseDouble("0x1.878350f2b699bp-1"));
        check(0X1.878350F2B699Bp-1D, Double.parseDouble("0X1.878350F2B699Bp-1D"));
        check(+0X1.878350F2B699Bp-1D, Double.parseDouble("+0X1.878350F2B699Bp-1D"));
        check(0X1.34b0067dcedap-6, Double.parseDouble("0X1.34b0067dcedap-6"));
        check(0x1.8B5BF1450D90Fp-1F, Float.parseFloat("0x1.8B5BF1450D90Fp-1F"));
        check(+0x1.8B5BF1450D90Fp-1D, Double.parseDouble("+0x1.8B5BF1450D90Fp-1D"));
        check(-0x1.8b5bf1450d90fP-1D, Double.parseDouble("-0x1.8b5bf1450d90fP-1D"));
        check(+0x1.DE913ABA6D12p-4F, Float.parseFloat("+0x1.DE913ABA6D12p-4F"));
        check(-0x1.3f4fa670421b6p-2f, Float.parseFloat("-0x1.3f4fa670421b6p-2f"));
        check(-0X1.54C657337E713P-1f, Float.parseFloat("-0X1.54C657337E713P-1f"));
        check(+0x1.08ff67283fb5cp-3d, Double.parseDouble("+0x1.08ff67283fb5cp-3d"));
        check(+0x1.08ff67283fb5cp-3D, Double.parseDouble("+0x1.08ff67283fb5cp-3D"));
        check(0x1.1f57fd9dd342p-3, Double.parseDouble("0x1.1f57fd9dd342p-3"));
        check(-0X1.1f57fd9dd342P-3D, Double.parseDouble("-0X1.1f57fd9dd342P-3D"));
        check(-0X1.E09A11925D193p-1f, Float.parseFloat("-0X1.E09A11925D193p-1f"));
        check(0x1.697524A46F524p-1F, Float.parseFloat("0x1.697524A46F524p-1F"));
        check(+0X1.697524A46F524P-1F, Float.parseFloat("+0X1.697524A46F524P-1F"));
        check(+0x1.9c8174ffba373p-1, Double.parseDouble("+0x1.9c8174ffba373p-1"));
        check(-0x1.09B459903F5F8p-3, Double.parseDouble("-0x1.09B459903F5F8p-3"));
        check(+0X1.cee20cea07fep-5, Double.parseDouble("+0X1.cee20cea07fep-5"));
        check(+0X1.CEE20CEA07FEp-5, Double.parseDouble("+0X1.CEE20CEA07FEp-5"));
        check(0x1.333449aab0358p-2D, Double.parseDouble("0x1.333449aab0358p-2D"));
        check(+0x1.333449AAB0358p-2, Double.parseDouble("+0x1.333449AAB0358p-2"));
        check(+0x1.333449AAB0358p-2d, Double.parseDouble("+0x1.333449AAB0358p-2d"));
        check(0X1.333449aab0358P-2f, Float.parseFloat("0X1.333449aab0358P-2f"));
        check(0X1.333449aab0358P-2d, Double.parseDouble("0X1.333449aab0358P-2d"));
        check(+0X1.333449aab0358P-2D, Double.parseDouble("+0X1.333449aab0358P-2D"));
        check(+0X1.CB5D4D192EA1Cp-3f, Float.parseFloat("+0X1.CB5D4D192EA1Cp-3f"));
        check(0X1.CB5D4D192EA1Cp-3D, Double.parseDouble("0X1.CB5D4D192EA1Cp-3D"));
        check(-0x1.8000D5ED870Ap-5, Double.parseDouble("-0x1.8000D5ED870Ap-5"));
        check(-0x1.8000D5ED870Ap-5f, Float.parseFloat("-0x1.8000D5ED870Ap-5f"));
        check(-0X1.8000D5ED870AP-5d, Double.parseDouble("-0X1.8000D5ED870AP-5d"));
        check(+0X1.374F24CE7E103p-1, Double.parseDouble("+0X1.374F24CE7E103p-1"));
        check(0X1.028A1150374P-9f, Float.parseFloat("0X1.028A1150374P-9f"));
        check(+0X1.D096F69DE26A8p-4F, Float.parseFloat("+0X1.D096F69DE26A8p-4F"));
        check(0x1.217D402B5BD0BP-1F, Float.parseFloat("0x1.217D402B5BD0BP-1F"));
        check(+0x1.217D402B5BD0BP-1D, Double.parseDouble("+0x1.217D402B5BD0BP-1D"));
        check(+0X1.fdedbe696e6fcp-2D, Double.parseDouble("+0X1.fdedbe696e6fcp-2D"));
        check(-0X1.FDEDBE696E6FCp-2F, Float.parseFloat("-0X1.FDEDBE696E6FCp-2F"));
        check(-0x1.36e4fd2fdc32aP-1f, Float.parseFloat("-0x1.36e4fd2fdc32aP-1f"));
        check(+0X1.36e4fd2fdc32ap-1F, Float.parseFloat("+0X1.36e4fd2fdc32ap-1F"));
        check(-0X1.36e4fd2fdc32aP-1f, Float.parseFloat("-0X1.36e4fd2fdc32aP-1f"));
        check(-0x1.A7ABF05616EFP-1D, Double.parseDouble("-0x1.A7ABF05616EFP-1D"));
        check(-0x1.C63385AAED7CCp-2F, Float.parseFloat("-0x1.C63385AAED7CCp-2F"));
        check(0x1.C63385AAED7CCP-2f, Float.parseFloat("0x1.C63385AAED7CCP-2f"));
        check(-0X1.C63385AAED7CCp-2F, Float.parseFloat("-0X1.C63385AAED7CCp-2F"));
        check(0X1.0AC1E4F5D0DE6P-1F, Float.parseFloat("0X1.0AC1E4F5D0DE6P-1F"));
        check(+0x1.8888a06893bbap-2, Double.parseDouble("+0x1.8888a06893bbap-2"));
        check(-0x1.8888a06893bbaP-2d, Double.parseDouble("-0x1.8888a06893bbaP-2d"));
        check(-0X1.8888a06893bbaP-2, Double.parseDouble("-0X1.8888a06893bbaP-2"));
        check(0X1.78a21c35d2be8p-1, Double.parseDouble("0X1.78a21c35d2be8p-1"));
        check(-0x1.7C590C103021CP-3F, Float.parseFloat("-0x1.7C590C103021CP-3F"));
        check(-0X1.7C590C103021CP-3f, Float.parseFloat("-0X1.7C590C103021CP-3f"));
        check(0x1.FC69EB25D34AFp-1d, Double.parseDouble("0x1.FC69EB25D34AFp-1d"));
        check(0X1.3572af1f9d253p-1f, Float.parseFloat("0X1.3572af1f9d253p-1f"));
        check(+0x1.7106b7fd7636ep-1D, Double.parseDouble("+0x1.7106b7fd7636ep-1D"));
        check(+0x1.bf7b4f72df7bfP-1F, Float.parseFloat("+0x1.bf7b4f72df7bfP-1F"));
        check(+0x1.BF7B4F72DF7BFP-1f, Float.parseFloat("+0x1.BF7B4F72DF7BFP-1f"));
        check(-0x1.AAEA386FAF463P-1, Double.parseDouble("-0x1.AAEA386FAF463P-1"));
        check(-0X1.AAEA386FAF463p-1, Double.parseDouble("-0X1.AAEA386FAF463p-1"));
        check(+0x1.9eabaf1307dafp-1F, Float.parseFloat("+0x1.9eabaf1307dafp-1F"));
        check(0x1.B1AC7615499P-8, Double.parseDouble("0x1.B1AC7615499P-8"));
        check(+0x1.53d46ac20cce8p-2, Double.parseDouble("+0x1.53d46ac20cce8p-2"));
        check(-0x1.53d46ac20cce8p-2F, Float.parseFloat("-0x1.53d46ac20cce8p-2F"));
        check(0x1.3aa5e9d8b583ap-2f, Float.parseFloat("0x1.3aa5e9d8b583ap-2f"));
        check(+0X1.3aa5e9d8b583ap-2F, Float.parseFloat("+0X1.3aa5e9d8b583ap-2F"));
        check(-0X1.3aa5e9d8b583aP-2f, Float.parseFloat("-0X1.3aa5e9d8b583aP-2f"));
        check(-0X1.840B933F3EF04p-2F, Float.parseFloat("-0X1.840B933F3EF04p-2F"));
        check(-0X1.840B933F3EF04P-2F, Float.parseFloat("-0X1.840B933F3EF04P-2F"));
        check(0x1.7f2c900d058f2P-1D, Double.parseDouble("0x1.7f2c900d058f2P-1D"));
        check(+0x1.09fe131d9f276p-1F, Float.parseFloat("+0x1.09fe131d9f276p-1F"));
        check(+0X1.09FE131D9F276p-1F, Float.parseFloat("+0X1.09FE131D9F276p-1F"));
        check(-0X1.09fe131d9f276P-1F, Float.parseFloat("-0X1.09fe131d9f276P-1F"));
        check(+0x1.016BAD0AA7F92p-2d, Double.parseDouble("+0x1.016BAD0AA7F92p-2d"));
        check(0x1.C5D3F028539C2P-2D, Double.parseDouble("0x1.C5D3F028539C2P-2D"));
        check(+0X1.c5d3f028539c2P-2F, Float.parseFloat("+0X1.c5d3f028539c2P-2F"));
        check(0x1.6EAB67BC3B0AAp-2d, Double.parseDouble("0x1.6EAB67BC3B0AAp-2d"));
        check(-0x1.35c1e994b5758P-1F, Float.parseFloat("-0x1.35c1e994b5758P-1F"));
        check(0x1.c15d865bd4fcP-6d, Double.parseDouble("0x1.c15d865bd4fcP-6d"));
        check(-0x1.C15D865BD4FCP-6F, Float.parseFloat("-0x1.C15D865BD4FCP-6F"));
        check(0x1.72C75FF81623Dp-1D, Double.parseDouble("0x1.72C75FF81623Dp-1D"));
        check(-0X1.AC9D871EB0F9Ap-1D, Double.parseDouble("-0X1.AC9D871EB0F9Ap-1D"));
        check(0X1.ac9d871eb0f9aP-1f, Float.parseFloat("0X1.ac9d871eb0f9aP-1f"));
        check(0X1.AF22AD1F01CA1p-1d, Double.parseDouble("0X1.AF22AD1F01CA1p-1d"));
        check(-0x1.D836672332D4p-4F, Float.parseFloat("-0x1.D836672332D4p-4F"));
        check(+0x1.d836672332d4P-4, Double.parseDouble("+0x1.d836672332d4P-4"));
        check(+0x1.D836672332D4P-4d, Double.parseDouble("+0x1.D836672332D4P-4d"));
        check(+0x1.cb67b5296ae5cp-1f, Float.parseFloat("+0x1.cb67b5296ae5cp-1f"));
        check(-0x1.cb67b5296ae5cP-1, Double.parseDouble("-0x1.cb67b5296ae5cP-1"));
        check(0x1.CB67B5296AE5CP-1f, Float.parseFloat("0x1.CB67B5296AE5CP-1f"));
        check(0X1.CB67B5296AE5Cp-1F, Float.parseFloat("0X1.CB67B5296AE5Cp-1F"));
        check(0x1.130b0177cd19fp-1d, Double.parseDouble("0x1.130b0177cd19fp-1d"));
        check(0x1.130B0177CD19Fp-1, Double.parseDouble("0x1.130B0177CD19Fp-1"));
        check(+0X1.130B0177CD19Fp-1f, Float.parseFloat("+0X1.130B0177CD19Fp-1f"));
        check(-0X1.83ba7cd73b809P-1d, Double.parseDouble("-0X1.83ba7cd73b809P-1d"));
        check(-0x1.6340840E51627p-1f, Float.parseFloat("-0x1.6340840E51627p-1f"));
        check(0x1.bdfde1f7f9cacp-2f, Float.parseFloat("0x1.bdfde1f7f9cacp-2f"));
        check(+0x1.1aba6ae19ae6bP-1, Double.parseDouble("+0x1.1aba6ae19ae6bP-1"));
        check(-0x1.1CF9F982E798EP-1D, Double.parseDouble("-0x1.1CF9F982E798EP-1D"));
        check(-0X1.1CF9F982E798EP-1f, Float.parseFloat("-0X1.1CF9F982E798EP-1f"));
        check(-0x1.D38FB8FD5189P-5d, Double.parseDouble("-0x1.D38FB8FD5189P-5d"));
        check(0X1.d38fb8fd5189p-5d, Double.parseDouble("0X1.d38fb8fd5189p-5d"));
        check(+0x1.47a5ce92ce1caP-1, Double.parseDouble("+0x1.47a5ce92ce1caP-1"));
        check(+0x1.47A5CE92CE1CAP-1f, Float.parseFloat("+0x1.47A5CE92CE1CAP-1f"));
        check(0X1.9a467cf87a678P-2F, Float.parseFloat("0X1.9a467cf87a678P-2F"));
        check(-0x1.5b76cdf5e27c5p-1, Double.parseDouble("-0x1.5b76cdf5e27c5p-1"));
        check(+0X1.5b76cdf5e27c5P-1, Double.parseDouble("+0X1.5b76cdf5e27c5P-1"));
        check(0x1.3989d34b7f5b3p-1D, Double.parseDouble("0x1.3989d34b7f5b3p-1D"));
        check(+0x1.3989d34b7f5b3P-1F, Float.parseFloat("+0x1.3989d34b7f5b3P-1F"));
        check(0X1.3989D34B7F5B3P-1f, Float.parseFloat("0X1.3989D34B7F5B3P-1f"));
        check(0x1.ABAB42944556P-1d, Double.parseDouble("0x1.ABAB42944556P-1d"));
        check(-0X1.ABAB42944556P-1D, Double.parseDouble("-0X1.ABAB42944556P-1D"));
        check(+0x1.58166789e1e7cP-3f, Float.parseFloat("+0x1.58166789e1e7cP-3f"));
        check(0x1.27765d09e6f1P-4f, Float.parseFloat("0x1.27765d09e6f1P-4f"));
        check(+0X1.0F78657063DF6p-1, Double.parseDouble("+0X1.0F78657063DF6p-1"));
        check(0x1.D8142F24065F6p-2D, Double.parseDouble("0x1.D8142F24065F6p-2D"));
        check(0x1.D8142F24065F6P-2D, Double.parseDouble("0x1.D8142F24065F6P-2D"));
        check(-0X1.D8142F24065F6p-2f, Float.parseFloat("-0X1.D8142F24065F6p-2f"));
        check(0x1.7D149767BD108p-1F, Float.parseFloat("0x1.7D149767BD108p-1F"));
        check(-0x1.7D149767BD108p-1d, Double.parseDouble("-0x1.7D149767BD108p-1d"));
        check(0X1.4A9B2CF26A958P-3f, Float.parseFloat("0X1.4A9B2CF26A958P-3f"));
        check(0x1.19DF33786B77Cp-1, Double.parseDouble("0x1.19DF33786B77Cp-1"));
        check(+0X1.19DF33786B77Cp-1, Double.parseDouble("+0X1.19DF33786B77Cp-1"));
        check(0X1.19df33786b77cP-1d, Double.parseDouble("0X1.19df33786b77cP-1d"));
        check(+0X1.19DF33786B77CP-1D, Double.parseDouble("+0X1.19DF33786B77CP-1D"));
        check(0x1.630D5345D3B8P-2D, Double.parseDouble("0x1.630D5345D3B8P-2D"));
        check(+0X1.dcf41765c656cP-1F, Float.parseFloat("+0X1.dcf41765c656cP-1F"));
        check(-0X1.d3313e1d5ea08p-4D, Double.parseDouble("-0X1.d3313e1d5ea08p-4D"));
        check(0X1.6cb8f5540e3ep-4, Double.parseDouble("0X1.6cb8f5540e3ep-4"));
        check(-0x1.9E649F2B8C1EBP-1F, Float.parseFloat("-0x1.9E649F2B8C1EBP-1F"));
        check(+0X1.9E649F2B8C1EBp-1, Double.parseDouble("+0X1.9E649F2B8C1EBp-1"));
        check(0x1.7010fac3d5e05p-1F, Float.parseFloat("0x1.7010fac3d5e05p-1F"));
        check(-0x1.1146b0a479fb8P-3F, Float.parseFloat("-0x1.1146b0a479fb8P-3F"));
        check(+0X1.d1845c809d9f4p-1f, Float.parseFloat("+0X1.d1845c809d9f4p-1f"));
        check(+0X1.d1845c809d9f4P-1d, Double.parseDouble("+0X1.d1845c809d9f4P-1d"));
        check(-0x1.9399C175325F2p-1f, Float.parseFloat("-0x1.9399C175325F2p-1f"));
        check(0x1.40E734CD3D11p-5F, Float.parseFloat("0x1.40E734CD3D11p-5F"));
        check(-0x1.40E734CD3D11p-5F, Float.parseFloat("-0x1.40E734CD3D11p-5F"));
        check(-0x1.9DF2ACAC069BAp-1f, Float.parseFloat("-0x1.9DF2ACAC069BAp-1f"));
        check(0x1.14F6D75EB7BFP-1f, Float.parseFloat("0x1.14F6D75EB7BFP-1f"));
        check(+0X1.e8006b1f37931P-1F, Float.parseFloat("+0X1.e8006b1f37931P-1F"));
        check(-0x1.16c2a6d2b42d4p-2D, Double.parseDouble("-0x1.16c2a6d2b42d4p-2D"));
        check(-0x1.16C2A6D2B42D4P-2d, Double.parseDouble("-0x1.16C2A6D2B42D4P-2d"));
        check(0X1.124281715e5fcP-1D, Double.parseDouble("0X1.124281715e5fcP-1D"));
        check(0x1.35d10dd5a4394P-3F, Float.parseFloat("0x1.35d10dd5a4394P-3F"));
        check(0x1.35D10DD5A4394P-3f, Float.parseFloat("0x1.35D10DD5A4394P-3f"));
        check(-0x1.BA7184144325Ap-1, Double.parseDouble("-0x1.BA7184144325Ap-1"));
        check(-0x1.BA7184144325AP-1D, Double.parseDouble("-0x1.BA7184144325AP-1D"));
        check(-0X1.450B4C9892F44p-3D, Double.parseDouble("-0X1.450B4C9892F44p-3D"));
        check(-0x1.c2c7519bc9b48P-2F, Float.parseFloat("-0x1.c2c7519bc9b48P-2F"));
        check(-0X1.C2C7519BC9B48P-2, Double.parseDouble("-0X1.C2C7519BC9B48P-2"));
        check(+0x1.3adb7bf603d7P-1, Double.parseDouble("+0x1.3adb7bf603d7P-1"));
        check(0x1.427A2A81F581Ep-1F, Float.parseFloat("0x1.427A2A81F581Ep-1F"));
        check(-0x1.0288AEFC8DC79p-1D, Double.parseDouble("-0x1.0288AEFC8DC79p-1D"));
        check(0X1.0288aefc8dc79p-1d, Double.parseDouble("0X1.0288aefc8dc79p-1d"));
        check(-0x1.992fa377c4d06p-2d, Double.parseDouble("-0x1.992fa377c4d06p-2d"));
        check(-0x1.992FA377C4D06p-2f, Float.parseFloat("-0x1.992FA377C4D06p-2f"));
        check(-0x1.43A7FAC37E744p-1f, Float.parseFloat("-0x1.43A7FAC37E744p-1f"));
        check(+0x1.43A7FAC37E744p-1f, Float.parseFloat("+0x1.43A7FAC37E744p-1f"));
        check(+0x1.C8604AE26C14P-1, Double.parseDouble("+0x1.C8604AE26C14P-1"));
        check(-0X1.C8604AE26C14p-1, Double.parseDouble("-0X1.C8604AE26C14p-1"));
        check(+0x1.4C020EC4CE138P-3F, Float.parseFloat("+0x1.4C020EC4CE138P-3F"));
        check(0x1.609A10D293D8p-7f, Float.parseFloat("0x1.609A10D293D8p-7f"));
        check(-0X1.609A10D293D8p-7D, Double.parseDouble("-0X1.609A10D293D8p-7D"));
        check(-0x1.B641BFE8AD2BDP-1D, Double.parseDouble("-0x1.B641BFE8AD2BDP-1D"));
        check(+0X1.9245bb4d759f8P-4d, Double.parseDouble("+0X1.9245bb4d759f8P-4d"));
        check(-0x1.6f9f940f0edeP-3d, Double.parseDouble("-0x1.6f9f940f0edeP-3d"));
        check(0x1.5a9233787494P-6, Double.parseDouble("0x1.5a9233787494P-6"));
        check(+0x1.0ec52214d4abp-3f, Float.parseFloat("+0x1.0ec52214d4abp-3f"));
        check(0X1.0ec52214d4abp-3, Double.parseDouble("0X1.0ec52214d4abp-3"));
        check(0X1.A957DA839701Cp-3f, Float.parseFloat("0X1.A957DA839701Cp-3f"));
        check(-0X1.A957DA839701CP-3d, Double.parseDouble("-0X1.A957DA839701CP-3d"));
        check(0X1.ada9077dee87p-1, Double.parseDouble("0X1.ada9077dee87p-1"));
        check(-0X1.c065309e2679p-2D, Double.parseDouble("-0X1.c065309e2679p-2D"));
        check(0X1.C065309E2679p-2d, Double.parseDouble("0X1.C065309E2679p-2d"));
        check(0x1.D3CF0A7B5FCBP-1f, Float.parseFloat("0x1.D3CF0A7B5FCBP-1f"));
        check(+0x1.D3CF0A7B5FCBP-1F, Float.parseFloat("+0x1.D3CF0A7B5FCBP-1F"));
        check(-0x1.C60B7C9C703A4p-2, Double.parseDouble("-0x1.C60B7C9C703A4p-2"));
        check(+0X1.C60B7C9C703A4p-2d, Double.parseDouble("+0X1.C60B7C9C703A4p-2d"));
        check(+0X1.C60B7C9C703A4P-2f, Float.parseFloat("+0X1.C60B7C9C703A4P-2f"));
        check(-0x1.ca7ba5963f8a4p-3f, Float.parseFloat("-0x1.ca7ba5963f8a4p-3f"));
        check(+0X1.ca7ba5963f8a4p-3f, Float.parseFloat("+0X1.ca7ba5963f8a4p-3f"));
        check(0X1.CA7BA5963F8A4P-3F, Float.parseFloat("0X1.CA7BA5963F8A4P-3F"));
        check(+0x1.8948C4D21F5AP-1D, Double.parseDouble("+0x1.8948C4D21F5AP-1D"));
        check(0x1.F19FAA44BB874p-2, Double.parseDouble("0x1.F19FAA44BB874p-2"));
        check(+0X1.F19FAA44BB874p-2, Double.parseDouble("+0X1.F19FAA44BB874p-2"));
        check(-0X1.F19FAA44BB874P-2F, Float.parseFloat("-0X1.F19FAA44BB874P-2F"));
        check(+0x1.3a14227946b5ap-1, Double.parseDouble("+0x1.3a14227946b5ap-1"));
        check(-0x1.3A14227946B5AP-1D, Double.parseDouble("-0x1.3A14227946B5AP-1D"));
        check(-0x1.383482939fd34p-1d, Double.parseDouble("-0x1.383482939fd34p-1d"));
        check(-0x1.383482939fd34P-1f, Float.parseFloat("-0x1.383482939fd34P-1f"));
        check(0x1.56603FC05E74CP-2d, Double.parseDouble("0x1.56603FC05E74CP-2d"));
        check(+0x1.23c2460feb32p-1, Double.parseDouble("+0x1.23c2460feb32p-1"));
        check(-0x1.23C2460FEB32p-1f, Float.parseFloat("-0x1.23C2460FEB32p-1f"));
        check(+0X1.23C2460FEB32P-1D, Double.parseDouble("+0X1.23C2460FEB32P-1D"));
        check(0x1.30EAF0F2DF3E7p-1, Double.parseDouble("0x1.30EAF0F2DF3E7p-1"));
        check(0X1.30EAF0F2DF3E7P-1F, Float.parseFloat("0X1.30EAF0F2DF3E7P-1F"));
        check(-0x1.2BA59B557EE6p-2f, Float.parseFloat("-0x1.2BA59B557EE6p-2f"));
        check(-0x1.2ba59b557ee6P-2F, Float.parseFloat("-0x1.2ba59b557ee6P-2F"));
        check(-0X1.5BB8E23383E5p-5f, Float.parseFloat("-0X1.5BB8E23383E5p-5f"));
        check(0x1.243fe3f07f7e4P-3D, Double.parseDouble("0x1.243fe3f07f7e4P-3D"));
        check(-0X1.243fe3f07f7e4P-3F, Float.parseFloat("-0X1.243fe3f07f7e4P-3F"));
        check(+0x1.2c25b81e7c49P-5D, Double.parseDouble("+0x1.2c25b81e7c49P-5D"));
        check(+0X1.2C25B81E7C49p-5D, Double.parseDouble("+0X1.2C25B81E7C49p-5D"));
        check(+0x1.60c6cd979b31P-3, Double.parseDouble("+0x1.60c6cd979b31P-3"));
        check(0X1.60C6CD979B31p-3F, Float.parseFloat("0X1.60C6CD979B31p-3F"));
        check(+0X1.47DD62FDA305Bp-1d, Double.parseDouble("+0X1.47DD62FDA305Bp-1d"));
        check(0X1.47dd62fda305bP-1f, Float.parseFloat("0X1.47dd62fda305bP-1f"));
        check(0x1.904D2862DDB3Cp-3D, Double.parseDouble("0x1.904D2862DDB3Cp-3D"));
        check(+0X1.904d2862ddb3cp-3, Double.parseDouble("+0X1.904d2862ddb3cp-3"));
        check(+0x1.4CB35EAB06566p-2f, Float.parseFloat("+0x1.4CB35EAB06566p-2f"));
        check(0X1.f09eeca71fc8P-6f, Float.parseFloat("0X1.f09eeca71fc8P-6f"));
        check(+0X1.1e3cdd6a9ba33p-1d, Double.parseDouble("+0X1.1e3cdd6a9ba33p-1d"));
        check(-0X1.1e3cdd6a9ba33P-1f, Float.parseFloat("-0X1.1e3cdd6a9ba33P-1f"));
        check(0x1.57e6296dfbe6aP-1F, Float.parseFloat("0x1.57e6296dfbe6aP-1F"));
        check(+0X1.57E6296DFBE6AP-1d, Double.parseDouble("+0X1.57E6296DFBE6AP-1d"));
        check(+0x1.6d5ed2efa87P-7D, Double.parseDouble("+0x1.6d5ed2efa87P-7D"));
        check(-0x1.6D5ED2EFA87P-7F, Float.parseFloat("-0x1.6D5ED2EFA87P-7F"));
        check(0x1.56DF944D8991Fp-1F, Float.parseFloat("0x1.56DF944D8991Fp-1F"));
        check(0X1.56df944d8991fP-1D, Double.parseDouble("0X1.56df944d8991fP-1D"));
        check(0x1.be393142b004ep-1D, Double.parseDouble("0x1.be393142b004ep-1D"));
        check(+0X1.be393142b004eP-1d, Double.parseDouble("+0X1.be393142b004eP-1d"));
        check(-0x1.EA945F4466EDP-3, Double.parseDouble("-0x1.EA945F4466EDP-3"));
        check(0X1.670a04b6c52e4p-2F, Float.parseFloat("0X1.670a04b6c52e4p-2F"));
        check(+0x1.079488f20b808P-2f, Float.parseFloat("+0x1.079488f20b808P-2f"));
        check(0X1.079488F20B808P-2, Double.parseDouble("0X1.079488F20B808P-2"));
        check(-0x1.D337FD2B7331p-5, Double.parseDouble("-0x1.D337FD2B7331p-5"));
        check(-0x1.D337FD2B7331P-5F, Float.parseFloat("-0x1.D337FD2B7331P-5F"));
        check(-0x1.88e752b767b34P-2, Double.parseDouble("-0x1.88e752b767b34P-2"));
        check(+0X1.88E752B767B34P-2d, Double.parseDouble("+0X1.88E752B767B34P-2d"));
        check(+0x1.8286ECA99556p-1F, Float.parseFloat("+0x1.8286ECA99556p-1F"));
        check(+0X1.8286eca99556p-1f, Float.parseFloat("+0X1.8286eca99556p-1f"));
        check(+0x1.8410489A152DFP-1, Double.parseDouble("+0x1.8410489A152DFP-1"));
        check(0X1.8410489A152DFP-1f, Float.parseFloat("0X1.8410489A152DFP-1f"));
        check(-0x1.2f32864189a6p-3F, Float.parseFloat("-0x1.2f32864189a6p-3F"));
        check(-0X1.B5DA83D3267BCP-3D, Double.parseDouble("-0X1.B5DA83D3267BCP-3D"));
        check(-0X1.A0B3647ED8A7Bp-1D, Double.parseDouble("-0X1.A0B3647ED8A7Bp-1D"));
        check(+0x1.1FF0F1C398CFEp-2D, Double.parseDouble("+0x1.1FF0F1C398CFEp-2D"));
        check(-0x1.1ff0f1c398cfeP-2f, Float.parseFloat("-0x1.1ff0f1c398cfeP-2f"));
        check(+0x1.138f5708a211P-1F, Float.parseFloat("+0x1.138f5708a211P-1F"));
        check(+0x1.91199d7ce6a94P-1F, Float.parseFloat("+0x1.91199d7ce6a94P-1F"));
        check(+0x1.5408545f29cd6P-2, Double.parseDouble("+0x1.5408545f29cd6P-2"));
        check(0X1.5408545f29cd6p-2, Double.parseDouble("0X1.5408545f29cd6p-2"));
        check(-0x1.f1abcb8351a4ap-2, Double.parseDouble("-0x1.f1abcb8351a4ap-2"));
        check(0x1.F1ABCB8351A4AP-2D, Double.parseDouble("0x1.F1ABCB8351A4AP-2D"));
        check(0x1.a77f6e53c204cP-2f, Float.parseFloat("0x1.a77f6e53c204cP-2f"));
        check(+0X1.a77f6e53c204cp-2D, Double.parseDouble("+0X1.a77f6e53c204cp-2D"));
        check(-0X1.A77F6E53C204Cp-2d, Double.parseDouble("-0X1.A77F6E53C204Cp-2d"));
        check(0X1.a77f6e53c204cP-2, Double.parseDouble("0X1.a77f6e53c204cP-2"));
        check(+0X1.A77F6E53C204CP-2f, Float.parseFloat("+0X1.A77F6E53C204CP-2f"));
        check(+0X1.3f0769c4677p-5F, Float.parseFloat("+0X1.3f0769c4677p-5F"));
        check(+0X1.3F0769C4677p-5f, Float.parseFloat("+0X1.3F0769C4677p-5f"));
        check(0x1.AF55520C77916p-2D, Double.parseDouble("0x1.AF55520C77916p-2D"));
        check(0X1.af55520c77916p-2d, Double.parseDouble("0X1.af55520c77916p-2d"));
        check(-0X1.af55520c77916P-2F, Float.parseFloat("-0X1.af55520c77916P-2F"));
        check(+0x1.30A69788B1CD2p-2f, Float.parseFloat("+0x1.30A69788B1CD2p-2f"));
        check(0X1.6CB974A1D1BE8p-3, Double.parseDouble("0X1.6CB974A1D1BE8p-3"));
        check(-0X1.6CB974A1D1BE8p-3d, Double.parseDouble("-0X1.6CB974A1D1BE8p-3d"));
        check(0X1.84F1EB1F07C46P-2f, Float.parseFloat("0X1.84F1EB1F07C46P-2f"));
        check(-0x1.3D84DC41F261FP-1, Double.parseDouble("-0x1.3D84DC41F261FP-1"));
        check(+0x1.D0F80BD1F6C84P-3, Double.parseDouble("+0x1.D0F80BD1F6C84P-3"));
        check(+0X1.74E352ED359E1p-1F, Float.parseFloat("+0X1.74E352ED359E1p-1F"));
        check(-0x1.5C85F0811C74P-2F, Float.parseFloat("-0x1.5C85F0811C74P-2F"));
        check(+0x1.DD4E85EB076P-7f, Float.parseFloat("+0x1.DD4E85EB076P-7f"));
        check(+0X1.dd4e85eb076p-7F, Float.parseFloat("+0X1.dd4e85eb076p-7F"));
        check(+0X1.dd4e85eb076P-7D, Double.parseDouble("+0X1.dd4e85eb076P-7D"));
        check(-0x1.dfc780ec3ab4P-3f, Float.parseFloat("-0x1.dfc780ec3ab4P-3f"));
        check(0x1.dfc780ec3ab4P-3F, Float.parseFloat("0x1.dfc780ec3ab4P-3F"));
        check(+0X1.0F15398160E77p-1, Double.parseDouble("+0X1.0F15398160E77p-1"));
        check(+0X1.0F15398160E77p-1f, Float.parseFloat("+0X1.0F15398160E77p-1f"));
        check(0x1.B0A4E367B826P-4F, Float.parseFloat("0x1.B0A4E367B826P-4F"));
        check(+0X1.B0A4E367B826P-4, Double.parseDouble("+0X1.B0A4E367B826P-4"));
        check(-0x1.E90D455CB12AAP-2d, Double.parseDouble("-0x1.E90D455CB12AAP-2d"));
        check(+0X1.adf0ed1f045e4P-2f, Float.parseFloat("+0X1.adf0ed1f045e4P-2f"));
        check(+0x1.3bc820a6483d8P-1f, Float.parseFloat("+0x1.3bc820a6483d8P-1f"));
        check(-0x1.3BC820A6483D8P-1d, Double.parseDouble("-0x1.3BC820A6483D8P-1d"));
        check(-0X1.6cc1048bf7f4eP-1f, Float.parseFloat("-0X1.6cc1048bf7f4eP-1f"));
        check(0X1.6CC1048BF7F4EP-1F, Float.parseFloat("0X1.6CC1048BF7F4EP-1F"));
        check(-0X1.68679C459CF6Dp-1f, Float.parseFloat("-0X1.68679C459CF6Dp-1f"));
        check(0x1.591a1a9b88754P-3F, Float.parseFloat("0x1.591a1a9b88754P-3F"));
        check(0X1.591A1A9B88754p-3F, Float.parseFloat("0X1.591A1A9B88754p-3F"));
        check(+0x1.ea0dd0caed086p-2, Double.parseDouble("+0x1.ea0dd0caed086p-2"));
        check(-0x1.57A241DFCEAFCp-1, Double.parseDouble("-0x1.57A241DFCEAFCp-1"));
        check(-0X1.8E8E4D3BE6F2EP-2d, Double.parseDouble("-0X1.8E8E4D3BE6F2EP-2d"));
        check(0x1.2f124eac695fep-1F, Float.parseFloat("0x1.2f124eac695fep-1F"));
        check(+0x1.09171B11394C2P-1d, Double.parseDouble("+0x1.09171B11394C2P-1d"));
        check(-0X1.579bbbd8d46acP-2d, Double.parseDouble("-0X1.579bbbd8d46acP-2d"));
        check(0x1.a60f4d07eb41dP-1, Double.parseDouble("0x1.a60f4d07eb41dP-1"));
        check(-0x1.A60F4D07EB41DP-1f, Float.parseFloat("-0x1.A60F4D07EB41DP-1f"));
        check(-0X1.A60F4D07EB41DP-1d, Double.parseDouble("-0X1.A60F4D07EB41DP-1d"));
        check(-0x1.805804bb9bc22P-1d, Double.parseDouble("-0x1.805804bb9bc22P-1d"));
        check(0X1.A273D5AEDA65DP-1, Double.parseDouble("0X1.A273D5AEDA65DP-1"));
        check(+0x1.9888ddaaa4436p-1D, Double.parseDouble("+0x1.9888ddaaa4436p-1D"));
        check(0x1.9888DDAAA4436p-1F, Float.parseFloat("0x1.9888DDAAA4436p-1F"));
        check(+0X1.9888DDAAA4436p-1, Double.parseDouble("+0X1.9888DDAAA4436p-1"));
        check(0x1.94B2470E56281P-1d, Double.parseDouble("0x1.94B2470E56281P-1d"));
        check(+0X1.94B2470E56281P-1f, Float.parseFloat("+0X1.94B2470E56281P-1f"));
        check(-0x1.6bd4ce85aef6p-4, Double.parseDouble("-0x1.6bd4ce85aef6p-4"));
        check(+0x1.6BD4CE85AEF6p-4, Double.parseDouble("+0x1.6BD4CE85AEF6p-4"));
        check(0x1.6BD4CE85AEF6p-4f, Float.parseFloat("0x1.6BD4CE85AEF6p-4f"));
        check(+0X1.e01fae9a03151P-1d, Double.parseDouble("+0X1.e01fae9a03151P-1d"));
        check(0x1.d6126b9a0ce1cp-2f, Float.parseFloat("0x1.d6126b9a0ce1cp-2f"));
        check(+0x1.d6126b9a0ce1cP-2F, Float.parseFloat("+0x1.d6126b9a0ce1cP-2F"));
        check(-0X1.d6126b9a0ce1cp-2d, Double.parseDouble("-0X1.d6126b9a0ce1cp-2d"));
        check(-0X1.5ec3c671b5757P-1D, Double.parseDouble("-0X1.5ec3c671b5757P-1D"));
        check(-0x1.CDF1C3A391094p-3d, Double.parseDouble("-0x1.CDF1C3A391094p-3d"));
        check(0X1.294AA63E21238P-1, Double.parseDouble("0X1.294AA63E21238P-1"));
        check(0X1.980D5115E5B8p-6d, Double.parseDouble("0X1.980D5115E5B8p-6d"));
        check(-0x1.61BB93F78CD0Ep-2d, Double.parseDouble("-0x1.61BB93F78CD0Ep-2d"));
        check(-0X1.2CB4F794899C4P-2F, Float.parseFloat("-0X1.2CB4F794899C4P-2F"));
        check(0x1.5192297A790F6p-2D, Double.parseDouble("0x1.5192297A790F6p-2D"));
        check(0X1.5192297A790F6p-2D, Double.parseDouble("0X1.5192297A790F6p-2D"));
        check(-0X1.dd582ee0dad1cp-3d, Double.parseDouble("-0X1.dd582ee0dad1cp-3d"));
        check(-0X1.dd582ee0dad1cP-3d, Double.parseDouble("-0X1.dd582ee0dad1cP-3d"));
        check(+0X1.125f113e35657P-1, Double.parseDouble("+0X1.125f113e35657P-1"));
        check(0x1.D86AE06017571p-1F, Float.parseFloat("0x1.D86AE06017571p-1F"));
        check(-0x1.D86AE06017571P-1, Double.parseDouble("-0x1.D86AE06017571P-1"));
        check(-0x1.41e293bd0683cp-2F, Float.parseFloat("-0x1.41e293bd0683cp-2F"));
        check(+0x1.41E293BD0683Cp-2D, Double.parseDouble("+0x1.41E293BD0683Cp-2D"));
        check(0X1.41e293bd0683cP-2F, Float.parseFloat("0X1.41e293bd0683cP-2F"));
        check(-0X1.f11abef821848p-2, Double.parseDouble("-0X1.f11abef821848p-2"));
        check(0X1.01db9a807df38P-3f, Float.parseFloat("0X1.01db9a807df38P-3f"));
        check(0X1.01db9a807df38P-3d, Double.parseDouble("0X1.01db9a807df38P-3d"));
        check(-0X1.01DB9A807DF38P-3F, Float.parseFloat("-0X1.01DB9A807DF38P-3F"));
        check(+0X1.7a3f1bdb18c5fP-1, Double.parseDouble("+0X1.7a3f1bdb18c5fP-1"));
        check(-0X1.7A3F1BDB18C5FP-1f, Float.parseFloat("-0X1.7A3F1BDB18C5FP-1f"));
        check(+0X1.40FB92767CBFEp-2, Double.parseDouble("+0X1.40FB92767CBFEp-2"));
        check(-0X1.40fb92767cbfeP-2D, Double.parseDouble("-0X1.40fb92767cbfeP-2D"));
        check(-0x1.8751618800C48p-4f, Float.parseFloat("-0x1.8751618800C48p-4f"));
        check(-0X1.8751618800c48p-4, Double.parseDouble("-0X1.8751618800c48p-4"));
        check(0x1.6945A3942A46EP-1d, Double.parseDouble("0x1.6945A3942A46EP-1d"));
        check(+0X1.6945a3942a46eP-1, Double.parseDouble("+0X1.6945a3942a46eP-1"));
        check(+0x1.91a212ed19e64p-3f, Float.parseFloat("+0x1.91a212ed19e64p-3f"));
        check(-0x1.91A212ED19E64p-3D, Double.parseDouble("-0x1.91A212ED19E64p-3D"));
        check(0x1.bc0311b60f63ap-1D, Double.parseDouble("0x1.bc0311b60f63ap-1D"));
        check(0X1.BC0311B60F63AP-1f, Float.parseFloat("0X1.BC0311B60F63AP-1f"));
        check(+0X1.556F9BADC4604P-2, Double.parseDouble("+0X1.556F9BADC4604P-2"));
        check(+0X1.0b7ccf3181a96P-2D, Double.parseDouble("+0X1.0b7ccf3181a96P-2D"));
        check(+0X1.0B7CCF3181A96P-2d, Double.parseDouble("+0X1.0B7CCF3181A96P-2d"));
        check(0X1.ac8c4b4d00785p-1f, Float.parseFloat("0X1.ac8c4b4d00785p-1f"));
        check(0x1.12af38cbc7ab3p-1, Double.parseDouble("0x1.12af38cbc7ab3p-1"));
        check(+0x1.12af38cbc7ab3P-1d, Double.parseDouble("+0x1.12af38cbc7ab3P-1d"));
        check(-0X1.12af38cbc7ab3p-1f, Float.parseFloat("-0X1.12af38cbc7ab3p-1f"));
        check(-0x1.d6322ef570a19P-1F, Float.parseFloat("-0x1.d6322ef570a19P-1F"));
        check(0x1.D6322EF570A19P-1d, Double.parseDouble("0x1.D6322EF570A19P-1d"));
        check(-0X1.f744605a3bea9p-1F, Float.parseFloat("-0X1.f744605a3bea9p-1F"));
        check(-0X1.f744605a3bea9P-1D, Double.parseDouble("-0X1.f744605a3bea9P-1D"));
        check(0X1.348d34f611492p-1F, Float.parseFloat("0X1.348d34f611492p-1F"));
        check(0x1.e66a619f10ae2P-1f, Float.parseFloat("0x1.e66a619f10ae2P-1f"));
        check(0X1.e66a619f10ae2p-1F, Float.parseFloat("0X1.e66a619f10ae2p-1F"));
        check(0X1.d4200ddfe47fP-3f, Float.parseFloat("0X1.d4200ddfe47fP-3f"));
        check(+0x1.8E02751D209Cp-3d, Double.parseDouble("+0x1.8E02751D209Cp-3d"));
        check(-0x1.b8dfbd85cbae4p-3f, Float.parseFloat("-0x1.b8dfbd85cbae4p-3f"));
        check(+0x1.B8DFBD85CBAE4p-3f, Float.parseFloat("+0x1.B8DFBD85CBAE4p-3f"));
        check(-0X1.B8DFBD85CBAE4P-3d, Double.parseDouble("-0X1.B8DFBD85CBAE4P-3d"));
        check(+0x1.0447D53649052p-2F, Float.parseFloat("+0x1.0447D53649052p-2F"));
        check(+0X1.b08c8fad0687p-5F, Float.parseFloat("+0X1.b08c8fad0687p-5F"));
        check(+0x1.E02E844A272C9P-1F, Float.parseFloat("+0x1.E02E844A272C9P-1F"));
        check(0X1.E02E844A272C9P-1F, Float.parseFloat("0X1.E02E844A272C9P-1F"));
        check(-0x1.FAD6DBF56FC84P-1, Double.parseDouble("-0x1.FAD6DBF56FC84P-1"));
        check(-0x1.0d8e981053f98P-3d, Double.parseDouble("-0x1.0d8e981053f98P-3d"));
        check(+0X1.0D8E981053F98p-3d, Double.parseDouble("+0X1.0D8E981053F98p-3d"));
        check(+0X1.0D8E981053F98P-3, Double.parseDouble("+0X1.0D8E981053F98P-3"));
        check(-0x1.b817cb2709b4fp-1d, Double.parseDouble("-0x1.b817cb2709b4fp-1d"));
        check(+0X1.b817cb2709b4fP-1, Double.parseDouble("+0X1.b817cb2709b4fP-1"));
        check(-0X1.AC3BCDA4CD0CFP-1f, Float.parseFloat("-0X1.AC3BCDA4CD0CFP-1f"));
        check(-0x1.1f2adac733aecP-2F, Float.parseFloat("-0x1.1f2adac733aecP-2F"));
        check(-0x1.1F2ADAC733AECP-2D, Double.parseDouble("-0x1.1F2ADAC733AECP-2D"));
        check(0x1.159FE0551D02P-6d, Double.parseDouble("0x1.159FE0551D02P-6d"));
        check(0x1.AB18F95A783D3P-1D, Double.parseDouble("0x1.AB18F95A783D3P-1D"));
        check(+0x1.5941BFC616EE8P-1f, Float.parseFloat("+0x1.5941BFC616EE8P-1f"));
        check(+0X1.4c72709b126cP-1D, Double.parseDouble("+0X1.4c72709b126cP-1D"));
        check(+0X1.4C72709B126CP-1F, Float.parseFloat("+0X1.4C72709B126CP-1F"));
        check(0X1.ec532b9084d8dp-1D, Double.parseDouble("0X1.ec532b9084d8dp-1D"));
        check(0X1.EC532B9084D8DP-1D, Double.parseDouble("0X1.EC532B9084D8DP-1D"));
        check(-0x1.f698761e8f698p-1F, Float.parseFloat("-0x1.f698761e8f698p-1F"));
        check(-0X1.f698761e8f698p-1D, Double.parseDouble("-0X1.f698761e8f698p-1D"));
        check(0X1.f698761e8f698P-1d, Double.parseDouble("0X1.f698761e8f698P-1d"));
        check(0X1.F698761E8F698P-1, Double.parseDouble("0X1.F698761E8F698P-1"));
        check(-0X1.F698761E8F698P-1, Double.parseDouble("-0X1.F698761E8F698P-1"));
        check(0X1.2F68D505E4EC6p-2F, Float.parseFloat("0X1.2F68D505E4EC6p-2F"));
        check(+0X1.dd1cfe0b7d049p-1F, Float.parseFloat("+0X1.dd1cfe0b7d049p-1F"));
        check(+0X1.DD1CFE0B7D049p-1f, Float.parseFloat("+0X1.DD1CFE0B7D049p-1f"));
        check(+0X1.dd1cfe0b7d049P-1f, Float.parseFloat("+0X1.dd1cfe0b7d049P-1f"));
        check(+0x1.73A3321DE2A2Ap-2F, Float.parseFloat("+0x1.73A3321DE2A2Ap-2F"));
        check(+0X1.73a3321de2a2ap-2D, Double.parseDouble("+0X1.73a3321de2a2ap-2D"));
        check(0X1.BE5A7700A5E1Cp-1, Double.parseDouble("0X1.BE5A7700A5E1Cp-1"));
        check(-0X1.be5a7700a5e1cP-1, Double.parseDouble("-0X1.be5a7700a5e1cP-1"));
        check(0X1.BE5A7700A5E1CP-1D, Double.parseDouble("0X1.BE5A7700A5E1CP-1D"));
        check(+0X1.BE5A7700A5E1CP-1D, Double.parseDouble("+0X1.BE5A7700A5E1CP-1D"));
        check(-0x1.28d4c9cdf37f8P-1, Double.parseDouble("-0x1.28d4c9cdf37f8P-1"));
        check(-0x1.28d4c9cdf37f8P-1f, Float.parseFloat("-0x1.28d4c9cdf37f8P-1f"));
        check(-0x1.DF4B393909FACp-2F, Float.parseFloat("-0x1.DF4B393909FACp-2F"));
        check(0x1.11cf45694f0d3p-1d, Double.parseDouble("0x1.11cf45694f0d3p-1d"));
        check(0x1.4a3d86f2cb619p-1f, Float.parseFloat("0x1.4a3d86f2cb619p-1f"));
        check(-0x1.4a3d86f2cb619P-1f, Float.parseFloat("-0x1.4a3d86f2cb619P-1f"));
        check(0X1.4a3d86f2cb619P-1, Double.parseDouble("0X1.4a3d86f2cb619P-1"));
        check(+0x1.6CF906E7FE23DP-1f, Float.parseFloat("+0x1.6CF906E7FE23DP-1f"));
        check(-0x1.6CF906E7FE23DP-1D, Double.parseDouble("-0x1.6CF906E7FE23DP-1D"));
        check(+0X1.6cf906e7fe23dp-1f, Float.parseFloat("+0X1.6cf906e7fe23dp-1f"));
        check(+0X1.6CF906E7FE23DP-1f, Float.parseFloat("+0X1.6CF906E7FE23DP-1f"));
        check(0x1.A653E2ECCFD42p-2f, Float.parseFloat("0x1.A653E2ECCFD42p-2f"));
        check(0x1.a653e2eccfd42P-2D, Double.parseDouble("0x1.a653e2eccfd42P-2D"));
        check(0x1.A653E2ECCFD42P-2, Double.parseDouble("0x1.A653E2ECCFD42P-2"));
        check(0X1.A653E2ECCFD42p-2F, Float.parseFloat("0X1.A653E2ECCFD42p-2F"));
        check(-0X1.9DAB4AEC30A7Dp-1d, Double.parseDouble("-0X1.9DAB4AEC30A7Dp-1d"));
        check(+0X1.231A34F655192P-2, Double.parseDouble("+0X1.231A34F655192P-2"));
        check(+0x1.13A4D69EDAAFFp-1f, Float.parseFloat("+0x1.13A4D69EDAAFFp-1f"));
        check(+0x1.13A4D69EDAAFFp-1d, Double.parseDouble("+0x1.13A4D69EDAAFFp-1d"));
        check(0X1.bd7c1ec0a258aP-1d, Double.parseDouble("0X1.bd7c1ec0a258aP-1d"));
        check(0x1.F6B73EBD56804p-1D, Double.parseDouble("0x1.F6B73EBD56804p-1D"));
        check(-0x1.f6b73ebd56804P-1F, Float.parseFloat("-0x1.f6b73ebd56804P-1F"));
        check(-0X1.F6B73EBD56804p-1d, Double.parseDouble("-0X1.F6B73EBD56804p-1d"));
        check(0x1.ae4f6f4f6ee1p-4F, Float.parseFloat("0x1.ae4f6f4f6ee1p-4F"));
        check(0X1.AE4F6F4F6EE1p-4D, Double.parseDouble("0X1.AE4F6F4F6EE1p-4D"));
        check(+0x1.D71E69981CD6CP-1D, Double.parseDouble("+0x1.D71E69981CD6CP-1D"));
        check(-0X1.d71e69981cd6cp-1, Double.parseDouble("-0X1.d71e69981cd6cp-1"));
        check(-0x1.a1b11d945d7c5p-1d, Double.parseDouble("-0x1.a1b11d945d7c5p-1d"));
        check(+0X1.21916207310cp-1f, Float.parseFloat("+0X1.21916207310cp-1f"));
        check(0x1.3EA4A27AEDF8DP-1d, Double.parseDouble("0x1.3EA4A27AEDF8DP-1d"));
        check(+0X1.D8F652C415682P-2f, Float.parseFloat("+0X1.D8F652C415682P-2f"));
        check(0X1.9D0E432DE0A56p-2D, Double.parseDouble("0X1.9D0E432DE0A56p-2D"));
        check(0X1.674e6f0a76586p-1F, Float.parseFloat("0X1.674e6f0a76586p-1F"));
        check(+0X1.7020e95f4056bP-1F, Float.parseFloat("+0X1.7020e95f4056bP-1F"));
        check(0X1.9b59a2068ab8ap-1f, Float.parseFloat("0X1.9b59a2068ab8ap-1f"));
        check(-0X1.9b59a2068ab8aP-1F, Float.parseFloat("-0X1.9b59a2068ab8aP-1F"));
        check(-0X1.6C31A44968C6p-6d, Double.parseDouble("-0X1.6C31A44968C6p-6d"));
        check(+0X1.6C31A44968C6p-6d, Double.parseDouble("+0X1.6C31A44968C6p-6d"));
        check(-0x1.DCFC430B7869Cp-1, Double.parseDouble("-0x1.DCFC430B7869Cp-1"));
        check(0X1.dc1fcb62cfcafp-1, Double.parseDouble("0X1.dc1fcb62cfcafp-1"));
        check(0X1.dc1fcb62cfcafP-1D, Double.parseDouble("0X1.dc1fcb62cfcafP-1D"));
        check(-0x1.0C5520155EDC6p-1f, Float.parseFloat("-0x1.0C5520155EDC6p-1f"));
        check(0x1.92f3562862e28p-3D, Double.parseDouble("0x1.92f3562862e28p-3D"));
        check(0X1.2e4cb78d43438P-4f, Float.parseFloat("0X1.2e4cb78d43438P-4f"));
        check(0x1.c95e2cb71b218p-3f, Float.parseFloat("0x1.c95e2cb71b218p-3f"));
        check(+0X1.C95E2CB71B218P-3d, Double.parseDouble("+0X1.C95E2CB71B218P-3d"));
        check(+0X1.c99f5032b3315P-1F, Float.parseFloat("+0X1.c99f5032b3315P-1F"));
        check(0X1.3E27069D8FC3P-2d, Double.parseDouble("0X1.3E27069D8FC3P-2d"));
        check(+0x1.3b9d9c52f2824P-3F, Float.parseFloat("+0x1.3b9d9c52f2824P-3F"));
        check(-0X1.3b9d9c52f2824P-3, Double.parseDouble("-0X1.3b9d9c52f2824P-3"));
        check(+0X1.3B9D9C52F2824P-3d, Double.parseDouble("+0X1.3B9D9C52F2824P-3d"));
        check(0x1.d25ab89240a34p-2, Double.parseDouble("0x1.d25ab89240a34p-2"));
        check(+0x1.d25ab89240a34P-2, Double.parseDouble("+0x1.d25ab89240a34P-2"));
        check(0X1.D25AB89240A34p-2F, Float.parseFloat("0X1.D25AB89240A34p-2F"));
        check(0x1.fa479ed072d4cp-3F, Float.parseFloat("0x1.fa479ed072d4cp-3F"));
        check(+0x1.c1b559522b58bp-1F, Float.parseFloat("+0x1.c1b559522b58bp-1F"));
        check(-0X1.C1B559522B58Bp-1f, Float.parseFloat("-0X1.C1B559522B58Bp-1f"));
        check(-0X1.C1B559522B58BP-1, Double.parseDouble("-0X1.C1B559522B58BP-1"));
        check(-0x1.6730329f770c4P-2, Double.parseDouble("-0x1.6730329f770c4P-2"));
        check(+0x1.6730329f770c4P-2, Double.parseDouble("+0x1.6730329f770c4P-2"));
        check(-0X1.6730329F770C4p-2, Double.parseDouble("-0X1.6730329F770C4p-2"));
        check(0X1.36641C0B7A062P-1d, Double.parseDouble("0X1.36641C0B7A062P-1d"));
        check(-0X1.f313b93dc7a82p-1f, Float.parseFloat("-0X1.f313b93dc7a82p-1f"));
        check(-0x1.7C0E190FBD8Bp-2d, Double.parseDouble("-0x1.7C0E190FBD8Bp-2d"));
        check(+0X1.FC719C14EE46P-4, Double.parseDouble("+0X1.FC719C14EE46P-4"));
        check(0X1.27F7E4AF3CA1Cp-1d, Double.parseDouble("0X1.27F7E4AF3CA1Cp-1d"));
        check(0x1.a24e8c3044f88P-3, Double.parseDouble("0x1.a24e8c3044f88P-3"));
        check(0X1.A24E8C3044F88P-3F, Float.parseFloat("0X1.A24E8C3044F88P-3F"));
        check(-0x1.95A0476135A16p-2F, Float.parseFloat("-0x1.95A0476135A16p-2F"));
        check(0x1.915353d3a30c2P-1, Double.parseDouble("0x1.915353d3a30c2P-1"));
        check(-0x1.5309639EA536DP-1d, Double.parseDouble("-0x1.5309639EA536DP-1d"));
        check(-0X1.5309639ea536dp-1D, Double.parseDouble("-0X1.5309639ea536dp-1D"));
        check(+0X1.308560e0b2ae6p-1F, Float.parseFloat("+0X1.308560e0b2ae6p-1F"));
        check(+0x1.06DD42A786978P-3, Double.parseDouble("+0x1.06DD42A786978P-3"));
        check(0x1.08e75b251b324p-3F, Float.parseFloat("0x1.08e75b251b324p-3F"));
        check(0x1.066e2e27503a6P-2f, Float.parseFloat("0x1.066e2e27503a6P-2f"));
        check(0X1.066E2E27503A6P-2, Double.parseDouble("0X1.066E2E27503A6P-2"));
        check(-0X1.8B3258321441Dp-1f, Float.parseFloat("-0X1.8B3258321441Dp-1f"));
        check(0X1.C5301B9C70762P-1d, Double.parseDouble("0X1.C5301B9C70762P-1d"));
        check(0x1.bea4bd5172a58p-4D, Double.parseDouble("0x1.bea4bd5172a58p-4D"));
        check(+0x1.BEA4BD5172A58p-4F, Float.parseFloat("+0x1.BEA4BD5172A58p-4F"));
        check(-0x1.9fe79bea46eaap-2d, Double.parseDouble("-0x1.9fe79bea46eaap-2d"));
        check(+0X1.9fe79bea46eaaP-2, Double.parseDouble("+0X1.9fe79bea46eaaP-2"));
        check(0X1.4201717c9f1f8P-2d, Double.parseDouble("0X1.4201717c9f1f8P-2d"));
        check(+0X1.060801a0d6472P-1F, Float.parseFloat("+0X1.060801a0d6472P-1F"));
        check(0x1.46B9307028632P-1, Double.parseDouble("0x1.46B9307028632P-1"));
        check(0x1.7cd67f952627p-5d, Double.parseDouble("0x1.7cd67f952627p-5d"));
        check(0x1.7cd67f952627P-5D, Double.parseDouble("0x1.7cd67f952627P-5D"));
        check(+0x1.E8B4D59483232P-2F, Float.parseFloat("+0x1.E8B4D59483232P-2F"));
        check(-0X1.23aa7c292c30bp-1F, Float.parseFloat("-0X1.23aa7c292c30bp-1F"));
        check(+0X1.23AA7C292C30Bp-1, Double.parseDouble("+0X1.23AA7C292C30Bp-1"));
        check(-0x1.FF74DEBE8F75Cp-3F, Float.parseFloat("-0x1.FF74DEBE8F75Cp-3F"));
        check(-0x1.FF74DEBE8F75CP-3f, Float.parseFloat("-0x1.FF74DEBE8F75CP-3f"));
        check(-0X1.FF74DEBE8F75CP-3, Double.parseDouble("-0X1.FF74DEBE8F75CP-3"));
        check(0x1.683178f02760cP-3, Double.parseDouble("0x1.683178f02760cP-3"));
        check(0x1.683178F02760CP-3D, Double.parseDouble("0x1.683178F02760CP-3D"));
        check(-0x1.9AC0D18D2B5AAP-2F, Float.parseFloat("-0x1.9AC0D18D2B5AAP-2F"));
        check(0X1.B71CFE6C8DE9Fp-1f, Float.parseFloat("0X1.B71CFE6C8DE9Fp-1f"));
        check(-0X1.B71CFE6C8DE9FP-1D, Double.parseDouble("-0X1.B71CFE6C8DE9FP-1D"));
        check(+0x1.D5EE91D86EE6EP-2d, Double.parseDouble("+0x1.D5EE91D86EE6EP-2d"));
        check(+0x1.E408AB0F0E9Ap-3F, Float.parseFloat("+0x1.E408AB0F0E9Ap-3F"));
        check(+0X1.e408ab0f0e9ap-3d, Double.parseDouble("+0X1.e408ab0f0e9ap-3d"));
        check(0X1.AB2B052426A7P-5F, Float.parseFloat("0X1.AB2B052426A7P-5F"));
        check(0x1.0860b62dbc212p-2F, Float.parseFloat("0x1.0860b62dbc212p-2F"));
        check(-0X1.0860b62dbc212p-2d, Double.parseDouble("-0X1.0860b62dbc212p-2d"));
        check(+0x1.889ED166431p-5d, Double.parseDouble("+0x1.889ED166431p-5d"));
        check(-0X1.87f570c305c82p-1d, Double.parseDouble("-0X1.87f570c305c82p-1d"));
        check(+0x1.710682DD53AE6P-1f, Float.parseFloat("+0x1.710682DD53AE6P-1f"));
        check(-0x1.A36495CE1B992p-2, Double.parseDouble("-0x1.A36495CE1B992p-2"));
        check(+0X1.a36495ce1b992P-2f, Float.parseFloat("+0X1.a36495ce1b992P-2f"));
        check(0x1.A811E6D02FBE8p-4, Double.parseDouble("0x1.A811E6D02FBE8p-4"));
        check(0x1.CC3E49D3D18A8p-2D, Double.parseDouble("0x1.CC3E49D3D18A8p-2D"));
        check(+0X1.cc3e49d3d18a8P-2d, Double.parseDouble("+0X1.cc3e49d3d18a8P-2d"));
        check(0x1.1060f2a4f3aap-1d, Double.parseDouble("0x1.1060f2a4f3aap-1d"));
        check(0X1.71d9ce0127ae4P-3, Double.parseDouble("0X1.71d9ce0127ae4P-3"));
        check(-0x1.94aff2762c8dP-5, Double.parseDouble("-0x1.94aff2762c8dP-5"));
        check(0x1.94aff2762c8dP-5D, Double.parseDouble("0x1.94aff2762c8dP-5D"));
        check(-0x1.94AFF2762C8DP-5f, Float.parseFloat("-0x1.94AFF2762C8DP-5f"));
        check(+0X1.6318202AE6449P-1F, Float.parseFloat("+0X1.6318202AE6449P-1F"));
        check(+0X1.6d966cb0fdd9ap-2D, Double.parseDouble("+0X1.6d966cb0fdd9ap-2D"));
        check(-0X1.6D966CB0FDD9Ap-2D, Double.parseDouble("-0X1.6D966CB0FDD9Ap-2D"));
        check(-0X1.6d966cb0fdd9aP-2F, Float.parseFloat("-0X1.6d966cb0fdd9aP-2F"));
        check(-0X1.6D966CB0FDD9AP-2d, Double.parseDouble("-0X1.6D966CB0FDD9AP-2d"));
        check(+0X1.8d38f923073eeP-1, Double.parseDouble("+0X1.8d38f923073eeP-1"));
        check(0X1.b13301faf887cp-1, Double.parseDouble("0X1.b13301faf887cp-1"));
        check(-0X1.B13301FAF887CP-1, Double.parseDouble("-0X1.B13301FAF887CP-1"));
        check(-0x1.0ec64eec1484p-3, Double.parseDouble("-0x1.0ec64eec1484p-3"));
        check(-0X1.13B45AB2AC437P-1D, Double.parseDouble("-0X1.13B45AB2AC437P-1D"));
        check(+0x1.37eecf28d442bp-1D, Double.parseDouble("+0x1.37eecf28d442bp-1D"));
        check(0x1.E9D4D06248E3p-4D, Double.parseDouble("0x1.E9D4D06248E3p-4D"));
        check(-0X1.1EC17008F8FEp-5, Double.parseDouble("-0X1.1EC17008F8FEp-5"));
        check(+0X1.e4b60576a42afP-1f, Float.parseFloat("+0X1.e4b60576a42afP-1f"));
        check(-0X1.eeb166191348p-2D, Double.parseDouble("-0X1.eeb166191348p-2D"));
        check(-0x1.2F135A5E417B4p-1D, Double.parseDouble("-0x1.2F135A5E417B4p-1D"));
        check(+0X1.2f135a5e417b4P-1F, Float.parseFloat("+0X1.2f135a5e417b4P-1F"));
        check(-0X1.91d262a641baP-6D, Double.parseDouble("-0X1.91d262a641baP-6D"));
        check(+0x1.5290C0D8CAE3DP-1D, Double.parseDouble("+0x1.5290C0D8CAE3DP-1D"));
        check(-0X1.5290C0D8CAE3Dp-1, Double.parseDouble("-0X1.5290C0D8CAE3Dp-1"));
        check(+0X1.5290C0D8CAE3DP-1, Double.parseDouble("+0X1.5290C0D8CAE3DP-1"));
        check(-0x1.B03430B19680EP-1D, Double.parseDouble("-0x1.B03430B19680EP-1D"));
        check(+0X1.B03430B19680Ep-1D, Double.parseDouble("+0X1.B03430B19680Ep-1D"));
        check(+0X1.b03430b19680eP-1, Double.parseDouble("+0X1.b03430b19680eP-1"));
        check(-0x1.863426C6F338Ep-2, Double.parseDouble("-0x1.863426C6F338Ep-2"));
        check(0x1.863426c6f338eP-2, Double.parseDouble("0x1.863426c6f338eP-2"));
        check(0X1.4830c0d4f960ep-2D, Double.parseDouble("0X1.4830c0d4f960ep-2D"));
        check(+0X1.4830C0D4F960Ep-2F, Float.parseFloat("+0X1.4830C0D4F960Ep-2F"));
        check(0x1.ecef3368172cbp-1D, Double.parseDouble("0x1.ecef3368172cbp-1D"));
        check(-0x1.ECEF3368172CBp-1D, Double.parseDouble("-0x1.ECEF3368172CBp-1D"));
        check(0x1.ecef3368172cbP-1f, Float.parseFloat("0x1.ecef3368172cbP-1f"));
        check(+0x1.DCEB465F33E3P-4D, Double.parseDouble("+0x1.DCEB465F33E3P-4D"));
        check(-0X1.dceb465f33e3p-4f, Float.parseFloat("-0X1.dceb465f33e3p-4f"));
        check(+0X1.f0a7cf7006ff2P-2d, Double.parseDouble("+0X1.f0a7cf7006ff2P-2d"));
        check(-0X1.2AEEB6939108Dp-1f, Float.parseFloat("-0X1.2AEEB6939108Dp-1f"));
        check(-0X1.d00bac4c02df4P-2, Double.parseDouble("-0X1.d00bac4c02df4P-2"));
        check(0x1.F623EF07B7458P-4F, Float.parseFloat("0x1.F623EF07B7458P-4F"));
        check(-0X1.F623EF07B7458p-4, Double.parseDouble("-0X1.F623EF07B7458p-4"));
        check(0x1.e746a91f0fb1p-2F, Float.parseFloat("0x1.e746a91f0fb1p-2F"));
        check(0X1.e746a91f0fb1P-2F, Float.parseFloat("0X1.e746a91f0fb1P-2F"));
        check(0x1.1ED24C97E6308p-4d, Double.parseDouble("0x1.1ED24C97E6308p-4d"));
        check(0x1.1ed24c97e6308P-4d, Double.parseDouble("0x1.1ed24c97e6308P-4d"));
        check(0x1.1ED24C97E6308P-4f, Float.parseFloat("0x1.1ED24C97E6308P-4f"));
        check(+0X1.8034b06bc6742p-2D, Double.parseDouble("+0X1.8034b06bc6742p-2D"));
        check(0X1.8034b06bc6742P-2F, Float.parseFloat("0X1.8034b06bc6742P-2F"));
        check(0X1.8034B06BC6742P-2d, Double.parseDouble("0X1.8034B06BC6742P-2d"));
        check(-0x1.0182e6a7be724P-2F, Float.parseFloat("-0x1.0182e6a7be724P-2F"));
        check(+0X1.0182E6A7BE724p-2, Double.parseDouble("+0X1.0182E6A7BE724p-2"));
        check(+0X1.99da9f1fabc0cp-3f, Float.parseFloat("+0X1.99da9f1fabc0cp-3f"));
        check(+0x1.5D5ED8E171A09p-1, Double.parseDouble("+0x1.5D5ED8E171A09p-1"));
        check(+0x1.dff1c777a8ed3P-1D, Double.parseDouble("+0x1.dff1c777a8ed3P-1D"));
        check(-0X1.DFF1C777A8ED3P-1D, Double.parseDouble("-0X1.DFF1C777A8ED3P-1D"));
        check(-0X1.B72622E1293CEP-2D, Double.parseDouble("-0X1.B72622E1293CEP-2D"));
        check(0x1.30DFCABB962EBp-1D, Double.parseDouble("0x1.30DFCABB962EBp-1D"));
        check(+0X1.8c9429f717b54P-3, Double.parseDouble("+0X1.8c9429f717b54P-3"));
        check(+0X1.602FC150969FEP-1f, Float.parseFloat("+0X1.602FC150969FEP-1f"));
        check(+0x1.a9e7114bde2ecp-1F, Float.parseFloat("+0x1.a9e7114bde2ecp-1F"));
        check(+0x1.A9E7114BDE2ECp-1, Double.parseDouble("+0x1.A9E7114BDE2ECp-1"));
        check(-0x1.A9E7114BDE2ECP-1d, Double.parseDouble("-0x1.A9E7114BDE2ECP-1d"));
        check(-0X1.a9e7114bde2ecP-1d, Double.parseDouble("-0X1.a9e7114bde2ecP-1d"));
        check(0x1.5877A2B86F749P-1f, Float.parseFloat("0x1.5877A2B86F749P-1f"));
        check(-0X1.5877a2b86f749p-1, Double.parseDouble("-0X1.5877a2b86f749p-1"));
        check(0X1.5877a2b86f749p-1f, Float.parseFloat("0X1.5877a2b86f749p-1f"));
        check(-0x1.9EF7633F63B58P-3f, Float.parseFloat("-0x1.9EF7633F63B58P-3f"));
        check(0x1.9EF7633F63B58P-3F, Float.parseFloat("0x1.9EF7633F63B58P-3F"));
        check(0X1.9ef7633f63b58p-3F, Float.parseFloat("0X1.9ef7633f63b58p-3F"));
        check(-0x1.FC9736D0A49A8p-3, Double.parseDouble("-0x1.FC9736D0A49A8p-3"));
        check(0X1.FC9736D0A49A8p-3F, Float.parseFloat("0X1.FC9736D0A49A8p-3F"));
        check(+0x1.3CA80AEBF32B8p-1F, Float.parseFloat("+0x1.3CA80AEBF32B8p-1F"));
        check(+0X1.3CA80AEBF32B8P-1, Double.parseDouble("+0X1.3CA80AEBF32B8P-1"));
        check(0x1.8cf5aed9d2725p-1F, Float.parseFloat("0x1.8cf5aed9d2725p-1F"));
        check(+0x1.8CF5AED9D2725P-1d, Double.parseDouble("+0x1.8CF5AED9D2725P-1d"));
        check(0X1.8cf5aed9d2725P-1D, Double.parseDouble("0X1.8cf5aed9d2725P-1D"));
        check(0X1.7012BCC4CF011p-1F, Float.parseFloat("0X1.7012BCC4CF011p-1F"));
        check(+0x1.3e706bdd2eed8P-2d, Double.parseDouble("+0x1.3e706bdd2eed8P-2d"));
        check(-0X1.0d0130264a3edp-1F, Float.parseFloat("-0X1.0d0130264a3edp-1F"));
        check(+0X1.88977402474D6p-2D, Double.parseDouble("+0X1.88977402474D6p-2D"));
        check(+0X1.0A8623E4E215Bp-1f, Float.parseFloat("+0X1.0A8623E4E215Bp-1f"));
        check(0X1.0a8623e4e215bP-1, Double.parseDouble("0X1.0a8623e4e215bP-1"));
        check(-0X1.C5C35E46C844Ep-1F, Float.parseFloat("-0X1.C5C35E46C844Ep-1F"));
        check(0X1.9BF39DAB5752P-3d, Double.parseDouble("0X1.9BF39DAB5752P-3d"));
        check(0x1.D9EB30C8A7EA5p-1F, Float.parseFloat("0x1.D9EB30C8A7EA5p-1F"));
        check(0x1.eb3ba65d647dap-1F, Float.parseFloat("0x1.eb3ba65d647dap-1F"));
        check(0x1.EB3BA65D647DAP-1D, Double.parseDouble("0x1.EB3BA65D647DAP-1D"));
        check(-0x1.f09acc149b73cp-2, Double.parseDouble("-0x1.f09acc149b73cp-2"));
        check(-0X1.d75bda35805acp-3d, Double.parseDouble("-0X1.d75bda35805acp-3d"));
        check(+0X1.D75BDA35805ACp-3d, Double.parseDouble("+0X1.D75BDA35805ACp-3d"));
        check(+0x1.67e8799f16db5p-1f, Float.parseFloat("+0x1.67e8799f16db5p-1f"));
        check(-0X1.67E8799F16DB5P-1, Double.parseDouble("-0X1.67E8799F16DB5P-1"));
        check(+0X1.598f52beb084bp-1d, Double.parseDouble("+0X1.598f52beb084bp-1d"));
        check(0X1.598F52BEB084BP-1f, Float.parseFloat("0X1.598F52BEB084BP-1f"));
        check(-0x1.F39504CEE508Cp-2d, Double.parseDouble("-0x1.F39504CEE508Cp-2d"));
        check(+0x1.f39504cee508cP-2d, Double.parseDouble("+0x1.f39504cee508cP-2d"));
        check(-0x1.7773d3e9eb4cP-7F, Float.parseFloat("-0x1.7773d3e9eb4cP-7F"));
        check(+0x1.e32069980c21ap-1D, Double.parseDouble("+0x1.e32069980c21ap-1D"));
        check(0X1.e32069980c21aP-1, Double.parseDouble("0X1.e32069980c21aP-1"));
        check(+0x1.b8119dc867db3P-1D, Double.parseDouble("+0x1.b8119dc867db3P-1D"));
        check(0X1.b301ea5b12b89P-1, Double.parseDouble("0X1.b301ea5b12b89P-1"));
        check(-0x1.4b2dce922b9f4P-1f, Float.parseFloat("-0x1.4b2dce922b9f4P-1f"));
        check(-0x1.4B2DCE922B9F4P-1d, Double.parseDouble("-0x1.4B2DCE922B9F4P-1d"));
        check(+0X1.06b3e7ba6032eP-2f, Float.parseFloat("+0X1.06b3e7ba6032eP-2f"));
        check(+0x1.AB9C05BB70DCCp-2d, Double.parseDouble("+0x1.AB9C05BB70DCCp-2d"));
        check(0x1.ab9c05bb70dccP-2D, Double.parseDouble("0x1.ab9c05bb70dccP-2D"));
        check(-0X1.ab9c05bb70dccp-2F, Float.parseFloat("-0X1.ab9c05bb70dccp-2F"));
        check(0x1.deb910b91dc9fp-1f, Float.parseFloat("0x1.deb910b91dc9fp-1f"));
        check(+0x1.DEB910B91DC9Fp-1F, Float.parseFloat("+0x1.DEB910B91DC9Fp-1F"));
        check(-0X1.65D27CE1A2B54p-3d, Double.parseDouble("-0X1.65D27CE1A2B54p-3d"));
        check(-0X1.b8febdc7e9bc2p-2D, Double.parseDouble("-0X1.b8febdc7e9bc2p-2D"));
        check(-0x1.3B6D5609B778Cp-1d, Double.parseDouble("-0x1.3B6D5609B778Cp-1d"));
        check(+0X1.5418B6138207Ap-1D, Double.parseDouble("+0X1.5418B6138207Ap-1D"));
        check(0x1.5102b493ee78bp-1D, Double.parseDouble("0x1.5102b493ee78bp-1D"));
        check(+0X1.f23035df98e56p-1, Double.parseDouble("+0X1.f23035df98e56p-1"));
        check(-0X1.6a79e452fa9a8P-4f, Float.parseFloat("-0X1.6a79e452fa9a8P-4f"));
        check(0X1.4568e9c124428P-4f, Float.parseFloat("0X1.4568e9c124428P-4f"));
        check(0x1.aad0830fa7ce5p-1D, Double.parseDouble("0x1.aad0830fa7ce5p-1D"));
        check(0X1.AAD0830FA7CE5p-1F, Float.parseFloat("0X1.AAD0830FA7CE5p-1F"));
        check(+0x1.B39D3F34D078BP-1d, Double.parseDouble("+0x1.B39D3F34D078BP-1d"));
        check(+0x1.BE3500CC8C2AAp-2D, Double.parseDouble("+0x1.BE3500CC8C2AAp-2D"));
        check(0X1.be3500cc8c2aaP-2, Double.parseDouble("0X1.be3500cc8c2aaP-2"));
        check(0X1.BE3500CC8C2AAP-2f, Float.parseFloat("0X1.BE3500CC8C2AAP-2f"));
        check(-0x1.930E468A5F56Dp-1F, Float.parseFloat("-0x1.930E468A5F56Dp-1F"));
        check(-0x1.930e468a5f56dP-1f, Float.parseFloat("-0x1.930e468a5f56dP-1f"));
        check(+0X1.930e468a5f56dp-1d, Double.parseDouble("+0X1.930e468a5f56dp-1d"));
        check(-0X1.930E468A5F56Dp-1f, Float.parseFloat("-0X1.930E468A5F56Dp-1f"));
        check(0x1.DF6AF665CB2A2P-2D, Double.parseDouble("0x1.DF6AF665CB2A2P-2D"));
        check(-0X1.DF6AF665CB2A2p-2d, Double.parseDouble("-0X1.DF6AF665CB2A2p-2d"));
        check(0X1.CE34ED72CD528p-3f, Float.parseFloat("0X1.CE34ED72CD528p-3f"));
        check(+0x1.0ee352cbf84fcp-1F, Float.parseFloat("+0x1.0ee352cbf84fcp-1F"));
        check(+0X1.0ee352cbf84fcP-1, Double.parseDouble("+0X1.0ee352cbf84fcP-1"));
        check(-0X1.4B87ACCFD9988P-4f, Float.parseFloat("-0X1.4B87ACCFD9988P-4f"));
        check(-0x1.0fb9eb0a3726bp-1D, Double.parseDouble("-0x1.0fb9eb0a3726bp-1D"));
        check(-0x1.0fb9eb0a3726bP-1d, Double.parseDouble("-0x1.0fb9eb0a3726bP-1d"));
        check(+0X1.77DF7C681EDCEp-2D, Double.parseDouble("+0X1.77DF7C681EDCEp-2D"));
        check(+0X1.0CA7FAB117FBCp-1, Double.parseDouble("+0X1.0CA7FAB117FBCp-1"));
        check(-0X1.0ca7fab117fbcP-1f, Float.parseFloat("-0X1.0ca7fab117fbcP-1f"));
        check(-0X1.55b009c44c4P-11D, Double.parseDouble("-0X1.55b009c44c4P-11D"));
        check(-0x1.be8902b1ec276p-1D, Double.parseDouble("-0x1.be8902b1ec276p-1D"));
        check(0X1.be8902b1ec276p-1f, Float.parseFloat("0X1.be8902b1ec276p-1f"));
        check(0X1.9c84842530e46P-1F, Float.parseFloat("0X1.9c84842530e46P-1F"));
        check(0X1.ed422c2a3c3f6p-2F, Float.parseFloat("0X1.ed422c2a3c3f6p-2F"));
        check(0x1.216d2dfdb6a84P-1d, Double.parseDouble("0x1.216d2dfdb6a84P-1d"));
        check(0x1.4F18A66E58A8p-6f, Float.parseFloat("0x1.4F18A66E58A8p-6f"));
        check(+0x1.4f18a66e58a8P-6f, Float.parseFloat("+0x1.4f18a66e58a8P-6f"));
        check(-0x1.42A57BE6C8A33p-1F, Float.parseFloat("-0x1.42A57BE6C8A33p-1F"));
        check(+0x1.42a57be6c8a33P-1f, Float.parseFloat("+0x1.42a57be6c8a33P-1f"));
        check(+0x1.0C5F920C9B2A1P-1F, Float.parseFloat("+0x1.0C5F920C9B2A1P-1F"));
        check(-0x1.a1bfeb88f75bcp-1D, Double.parseDouble("-0x1.a1bfeb88f75bcp-1D"));
        check(-0x1.1D3E8A6E3707Bp-1, Double.parseDouble("-0x1.1D3E8A6E3707Bp-1"));
        check(0X1.3a58ed9e8e64p-7f, Float.parseFloat("0X1.3a58ed9e8e64p-7f"));
        check(+0X1.3A58ED9E8E64p-7D, Double.parseDouble("+0X1.3A58ED9E8E64p-7D"));
        check(+0X1.60D17A8A3ED5Fp-1D, Double.parseDouble("+0X1.60D17A8A3ED5Fp-1D"));
        check(0X1.60d17a8a3ed5fP-1d, Double.parseDouble("0X1.60d17a8a3ed5fP-1d"));
        check(0X1.38E345B3C5F1p-3f, Float.parseFloat("0X1.38E345B3C5F1p-3f"));
        check(0x1.f358a477d9387p-1f, Float.parseFloat("0x1.f358a477d9387p-1f"));
        check(+0x1.f358a477d9387P-1f, Float.parseFloat("+0x1.f358a477d9387P-1f"));
        check(-0x1.f358a477d9387P-1d, Double.parseDouble("-0x1.f358a477d9387P-1d"));
        check(+0x1.89be42b3900c2p-1, Double.parseDouble("+0x1.89be42b3900c2p-1"));
        check(+0x1.89be42b3900c2p-1D, Double.parseDouble("+0x1.89be42b3900c2p-1D"));
        check(-0x1.89be42b3900c2P-1d, Double.parseDouble("-0x1.89be42b3900c2P-1d"));
        check(+0X1.fdfdce66edbd4p-1F, Float.parseFloat("+0X1.fdfdce66edbd4p-1F"));
        check(0X1.fdfdce66edbd4P-1D, Double.parseDouble("0X1.fdfdce66edbd4P-1D"));
        check(+0X1.FDFDCE66EDBD4P-1f, Float.parseFloat("+0X1.FDFDCE66EDBD4P-1f"));
        check(+0x1.971c790ba04eep-2d, Double.parseDouble("+0x1.971c790ba04eep-2d"));
        check(-0X1.971c790ba04eep-2f, Float.parseFloat("-0X1.971c790ba04eep-2f"));
        check(0x1.fb873803dae0fp-1, Double.parseDouble("0x1.fb873803dae0fp-1"));
        check(0X1.fb873803dae0fP-1d, Double.parseDouble("0X1.fb873803dae0fP-1d"));
        check(0x1.FF13A9F7A51AP-1D, Double.parseDouble("0x1.FF13A9F7A51AP-1D"));
        check(+0X1.FF13A9F7A51AP-1d, Double.parseDouble("+0X1.FF13A9F7A51AP-1d"));
        check(+0x1.8A2E9E50312p-1, Double.parseDouble("+0x1.8A2E9E50312p-1"));
        check(-0X1.8A2E9E50312P-1F, Float.parseFloat("-0X1.8A2E9E50312P-1F"));
        check(-0x1.80fd989b13e2ep-2D, Double.parseDouble("-0x1.80fd989b13e2ep-2D"));
        check(+0x1.80FD989B13E2Ep-2D, Double.parseDouble("+0x1.80FD989B13E2Ep-2D"));
        check(0x1.99166183578a9p-1, Double.parseDouble("0x1.99166183578a9p-1"));
        check(+0x1.c07c9811796ccP-3D, Double.parseDouble("+0x1.c07c9811796ccP-3D"));
        check(-0X1.C07C9811796CCp-3d, Double.parseDouble("-0X1.C07C9811796CCp-3d"));
        check(0X1.5A88C403E028FP-1, Double.parseDouble("0X1.5A88C403E028FP-1"));
        check(-0X1.e800075767bb4P-3D, Double.parseDouble("-0X1.e800075767bb4P-3D"));
        check(+0X1.25159C8192013p-1f, Float.parseFloat("+0X1.25159C8192013p-1f"));
        check(-0X1.25159C8192013P-1f, Float.parseFloat("-0X1.25159C8192013P-1f"));
        check(+0X1.d88e62dace2baP-2d, Double.parseDouble("+0X1.d88e62dace2baP-2d"));
        check(-0X1.D88E62DACE2BAP-2d, Double.parseDouble("-0X1.D88E62DACE2BAP-2d"));
        check(+0x1.6A8E43CEE57B7p-1D, Double.parseDouble("+0x1.6A8E43CEE57B7p-1D"));
        check(+0x1.6A8E43CEE57B7P-1D, Double.parseDouble("+0x1.6A8E43CEE57B7P-1D"));
        check(0X1.6a8e43cee57b7P-1f, Float.parseFloat("0X1.6a8e43cee57b7P-1f"));
        check(+0x1.2A7C10AF2A1A1P-1F, Float.parseFloat("+0x1.2A7C10AF2A1A1P-1F"));
        check(0x1.2A7C10AF2A1A1P-1d, Double.parseDouble("0x1.2A7C10AF2A1A1P-1d"));
        check(0x1.BE9A0B7E4B8p-10F, Float.parseFloat("0x1.BE9A0B7E4B8p-10F"));
        check(+0X1.be9a0b7e4b8P-10, Double.parseDouble("+0X1.be9a0b7e4b8P-10"));
        check(-0X1.be9a0b7e4b8P-10D, Double.parseDouble("-0X1.be9a0b7e4b8P-10D"));
        check(+0x1.83677dea2cf16P-2d, Double.parseDouble("+0x1.83677dea2cf16P-2d"));
        check(-0x1.e15176fa60466P-1F, Float.parseFloat("-0x1.e15176fa60466P-1F"));
        check(0X1.86d8bef2a87f4P-2D, Double.parseDouble("0X1.86d8bef2a87f4P-2D"));
        check(0X1.86D8BEF2A87F4P-2d, Double.parseDouble("0X1.86D8BEF2A87F4P-2d"));
        check(0x1.1C710502C9B86P-2, Double.parseDouble("0x1.1C710502C9B86P-2"));
        check(-0X1.1C710502C9B86P-2D, Double.parseDouble("-0X1.1C710502C9B86P-2D"));
        check(0X1.fd4241c540734P-3D, Double.parseDouble("0X1.fd4241c540734P-3D"));
        check(0x1.C3F202DE5965CP-3D, Double.parseDouble("0x1.C3F202DE5965CP-3D"));
        check(0x1.A2991EDE3C822P-1, Double.parseDouble("0x1.A2991EDE3C822P-1"));
        check(+0X1.a2991ede3c822p-1D, Double.parseDouble("+0X1.a2991ede3c822p-1D"));
        check(-0x1.F94677E62DC8P-6f, Float.parseFloat("-0x1.F94677E62DC8P-6f"));
        check(-0X1.F94677E62DC8P-6D, Double.parseDouble("-0X1.F94677E62DC8P-6D"));
        check(+0x1.88fce68e34bb8P-4F, Float.parseFloat("+0x1.88fce68e34bb8P-4F"));
        check(+0x1.59d24c9a28782p-1d, Double.parseDouble("+0x1.59d24c9a28782p-1d"));
        check(0x1.59D24C9A28782p-1D, Double.parseDouble("0x1.59D24C9A28782p-1D"));
        check(-0X1.59D24C9A28782p-1F, Float.parseFloat("-0X1.59D24C9A28782p-1F"));
        check(-0x1.6CE9B33F58FC4P-2D, Double.parseDouble("-0x1.6CE9B33F58FC4P-2D"));
        check(0X1.6CE9B33F58FC4P-2d, Double.parseDouble("0X1.6CE9B33F58FC4P-2d"));
        check(-0X1.21FE2434A095Ep-2d, Double.parseDouble("-0X1.21FE2434A095Ep-2d"));
        check(-0X1.21fe2434a095eP-2, Double.parseDouble("-0X1.21fe2434a095eP-2"));
        check(0X1.21fe2434a095eP-2d, Double.parseDouble("0X1.21fe2434a095eP-2d"));
        check(+0x1.E23232519FC6Cp-1, Double.parseDouble("+0x1.E23232519FC6Cp-1"));
        check(+0x1.f7ff6396e499ap-2d, Double.parseDouble("+0x1.f7ff6396e499ap-2d"));
        check(+0x1.F7FF6396E499AP-2, Double.parseDouble("+0x1.F7FF6396E499AP-2"));
        check(0x1.1CE8ADAB61BF4p-3d, Double.parseDouble("0x1.1CE8ADAB61BF4p-3d"));
        check(0X1.1ce8adab61bf4P-3F, Float.parseFloat("0X1.1ce8adab61bf4P-3F"));
        check(-0x1.7dc78e66e6a1cp-1f, Float.parseFloat("-0x1.7dc78e66e6a1cp-1f"));
        check(0X1.6F78F5D2FB402P-1F, Float.parseFloat("0X1.6F78F5D2FB402P-1F"));
        check(+0x1.cbed98f6f9614p-3D, Double.parseDouble("+0x1.cbed98f6f9614p-3D"));
        check(+0x1.CBED98F6F9614p-3D, Double.parseDouble("+0x1.CBED98F6F9614p-3D"));
        check(+0X1.cbed98f6f9614p-3D, Double.parseDouble("+0X1.cbed98f6f9614p-3D"));
        check(0x1.3e1116fa465fep-1, Double.parseDouble("0x1.3e1116fa465fep-1"));
        check(0x1.3E1116FA465FEp-1F, Float.parseFloat("0x1.3E1116FA465FEp-1F"));
        check(+0x1.31F5AC08973FCp-2, Double.parseDouble("+0x1.31F5AC08973FCp-2"));
        check(-0x1.31f5ac08973fcP-2f, Float.parseFloat("-0x1.31f5ac08973fcP-2f"));
        check(+0X1.F3AC438866932p-1, Double.parseDouble("+0X1.F3AC438866932p-1"));
        check(0X1.F3AC438866932p-1F, Float.parseFloat("0X1.F3AC438866932p-1F"));
        check(+0x1.817e4478a4ea8p-3d, Double.parseDouble("+0x1.817e4478a4ea8p-3d"));
        check(-0x1.817E4478A4EA8P-3, Double.parseDouble("-0x1.817E4478A4EA8P-3"));
        check(+0x1.F0DEA1123576Ep-1F, Float.parseFloat("+0x1.F0DEA1123576Ep-1F"));
        check(0X1.F0DEA1123576Ep-1f, Float.parseFloat("0X1.F0DEA1123576Ep-1f"));
        check(0X1.1191101e4371eP-1d, Double.parseDouble("0X1.1191101e4371eP-1d"));
        check(0X1.F5DA3A6F8DFEAp-2F, Float.parseFloat("0X1.F5DA3A6F8DFEAp-2F"));
        check(+0X1.F5DA3A6F8DFEAP-2D, Double.parseDouble("+0X1.F5DA3A6F8DFEAP-2D"));
        check(+0x1.825FCD66F0DF2P-2d, Double.parseDouble("+0x1.825FCD66F0DF2P-2d"));
        check(-0X1.825FCD66F0DF2P-2, Double.parseDouble("-0X1.825FCD66F0DF2P-2"));
        check(+0x1.aea8ece5d766aP-2, Double.parseDouble("+0x1.aea8ece5d766aP-2"));
        check(-0x1.89ACE75A7CD3p-2D, Double.parseDouble("-0x1.89ACE75A7CD3p-2D"));
        check(-0X1.89ace75a7cd3p-2d, Double.parseDouble("-0X1.89ace75a7cd3p-2d"));
        check(0x1.ec999abd994f5P-1F, Float.parseFloat("0x1.ec999abd994f5P-1F"));
        check(0x1.5d4344bafa16P-5f, Float.parseFloat("0x1.5d4344bafa16P-5f"));
        check(+0x1.01400dc38b39ep-2F, Float.parseFloat("+0x1.01400dc38b39ep-2F"));
        check(+0X1.D479C348499FCp-3, Double.parseDouble("+0X1.D479C348499FCp-3"));
        check(-0X1.D479C348499FCp-3F, Float.parseFloat("-0X1.D479C348499FCp-3F"));
        check(0x1.A1A5FAA0E934p-2d, Double.parseDouble("0x1.A1A5FAA0E934p-2d"));
        check(+0X1.e9a45d12f0748P-3d, Double.parseDouble("+0X1.e9a45d12f0748P-3d"));
        check(0X1.C500A285380Bp-3D, Double.parseDouble("0X1.C500A285380Bp-3D"));
        check(0x1.b572c4a22fbfep-2f, Float.parseFloat("0x1.b572c4a22fbfep-2f"));
        check(+0X1.B572C4A22FBFEp-2F, Float.parseFloat("+0X1.B572C4A22FBFEp-2F"));
        check(+0x1.BFE7D03921DC2p-1, Double.parseDouble("+0x1.BFE7D03921DC2p-1"));
        check(+0x1.b292e8a7f1eep-3F, Float.parseFloat("+0x1.b292e8a7f1eep-3F"));
        check(-0X1.B292E8A7F1EEP-3f, Float.parseFloat("-0X1.B292E8A7F1EEP-3f"));
        check(0x1.E26B7EE283616P-2f, Float.parseFloat("0x1.E26B7EE283616P-2f"));
        check(-0x1.E88BF9ACFA29P-1f, Float.parseFloat("-0x1.E88BF9ACFA29P-1f"));
        check(-0x1.77D022D4E1DA4p-2, Double.parseDouble("-0x1.77D022D4E1DA4p-2"));
        check(+0x1.77d022d4e1da4P-2f, Float.parseFloat("+0x1.77d022d4e1da4P-2f"));
        check(-0x1.C3E4BCC759019p-1d, Double.parseDouble("-0x1.C3E4BCC759019p-1d"));
        check(0x1.C3E4BCC759019P-1f, Float.parseFloat("0x1.C3E4BCC759019P-1f"));
        check(-0X1.25147c08c62a4p-3d, Double.parseDouble("-0X1.25147c08c62a4p-3d"));
        check(+0X1.25147c08c62a4P-3, Double.parseDouble("+0X1.25147c08c62a4P-3"));
        check(-0x1.071be218f7cfap-2F, Float.parseFloat("-0x1.071be218f7cfap-2F"));
        check(+0X1.9535d1c634c77P-1d, Double.parseDouble("+0X1.9535d1c634c77P-1d"));
        check(-0x1.44f2858c54349p-1, Double.parseDouble("-0x1.44f2858c54349p-1"));
        check(0X1.44F2858C54349p-1, Double.parseDouble("0X1.44F2858C54349p-1"));
        check(0x1.9f3feb1d43a56p-2d, Double.parseDouble("0x1.9f3feb1d43a56p-2d"));
        check(0x1.9F3FEB1D43A56p-2F, Float.parseFloat("0x1.9F3FEB1D43A56p-2F"));
        check(0x1.9F3FEB1D43A56P-2D, Double.parseDouble("0x1.9F3FEB1D43A56P-2D"));
        check(+0X1.9F3FEB1D43A56P-2F, Float.parseFloat("+0X1.9F3FEB1D43A56P-2F"));
        check(+0x1.4CD5F850F9A2Fp-1d, Double.parseDouble("+0x1.4CD5F850F9A2Fp-1d"));
        check(+0X1.4cd5f850f9a2fP-1D, Double.parseDouble("+0X1.4cd5f850f9a2fP-1D"));
        check(+0x1.9ca142875afa4p-3D, Double.parseDouble("+0x1.9ca142875afa4p-3D"));
        check(0x1.ddae8bd64b76ep-2f, Float.parseFloat("0x1.ddae8bd64b76ep-2f"));
        check(0X1.AE5A146FDCB2P-6, Double.parseDouble("0X1.AE5A146FDCB2P-6"));
        check(-0x1.78110486FDFECp-2d, Double.parseDouble("-0x1.78110486FDFECp-2d"));
        check(-0X1.78110486FDFECp-2, Double.parseDouble("-0X1.78110486FDFECp-2"));
        check(-0x1.9952D195A5A4p-6f, Float.parseFloat("-0x1.9952D195A5A4p-6f"));
        check(+0x1.9952D195A5A4p-6F, Float.parseFloat("+0x1.9952D195A5A4p-6F"));
        check(+0x1.9952d195a5a4P-6, Double.parseDouble("+0x1.9952d195a5a4P-6"));
        check(-0X1.d430b66f9007bp-1f, Float.parseFloat("-0X1.d430b66f9007bp-1f"));
        check(-0X1.d430b66f9007bP-1D, Double.parseDouble("-0X1.d430b66f9007bP-1D"));
        check(-0X1.cc77e330a39b1p-1D, Double.parseDouble("-0X1.cc77e330a39b1p-1D"));
        check(0X1.CC77E330A39B1P-1f, Float.parseFloat("0X1.CC77E330A39B1P-1f"));
        check(+0X1.972ae016c013fp-1, Double.parseDouble("+0X1.972ae016c013fp-1"));
        check(0X1.192F91C9D309Cp-2D, Double.parseDouble("0X1.192F91C9D309Cp-2D"));
        check(0X1.cd3f673a54e58p-2, Double.parseDouble("0X1.cd3f673a54e58p-2"));
        check(+0X1.cd3f673a54e58p-2F, Float.parseFloat("+0X1.cd3f673a54e58p-2F"));
        check(+0x1.e8a1ff59349P-5d, Double.parseDouble("+0x1.e8a1ff59349P-5d"));
        check(0x1.E8A1FF59349P-5F, Float.parseFloat("0x1.E8A1FF59349P-5F"));
        check(-0x1.410D39ED9678Ep-1D, Double.parseDouble("-0x1.410D39ED9678Ep-1D"));
        check(-0x1.410D39ED9678EP-1F, Float.parseFloat("-0x1.410D39ED9678EP-1F"));
        check(-0X1.38600c09cac5fp-1f, Float.parseFloat("-0X1.38600c09cac5fp-1f"));
        check(0X1.38600c09cac5fP-1, Double.parseDouble("0X1.38600c09cac5fP-1"));
        check(-0x1.C30CB41E87131P-1D, Double.parseDouble("-0x1.C30CB41E87131P-1D"));
        check(-0x1.8b95a05d6771ep-1, Double.parseDouble("-0x1.8b95a05d6771ep-1"));
        check(+0X1.90C91AA54C0C6P-1f, Float.parseFloat("+0X1.90C91AA54C0C6P-1f"));
        check(0X1.acb56541057f6P-2, Double.parseDouble("0X1.acb56541057f6P-2"));
        check(0X1.ACB56541057F6P-2F, Float.parseFloat("0X1.ACB56541057F6P-2F"));
        check(0X1.0c53e9e492367P-1D, Double.parseDouble("0X1.0c53e9e492367P-1D"));
        check(-0x1.372FB13DD907p-2, Double.parseDouble("-0x1.372FB13DD907p-2"));
        check(+0X1.372FB13DD907p-2D, Double.parseDouble("+0X1.372FB13DD907p-2D"));
        check(+0X1.372fb13dd907P-2F, Float.parseFloat("+0X1.372fb13dd907P-2F"));
        check(-0x1.9083d117eeb38P-4D, Double.parseDouble("-0x1.9083d117eeb38P-4D"));
        check(+0x1.8ac97ba2ed4a6P-2f, Float.parseFloat("+0x1.8ac97ba2ed4a6P-2f"));
        check(+0X1.5E6B377A9389p-3F, Float.parseFloat("+0X1.5E6B377A9389p-3F"));
        check(0X1.5e6b377a9389P-3f, Float.parseFloat("0X1.5e6b377a9389P-3f"));
        check(+0X1.83694e3e4e51cp-1, Double.parseDouble("+0X1.83694e3e4e51cp-1"));
        check(0X1.83694e3e4e51cp-1D, Double.parseDouble("0X1.83694e3e4e51cp-1D"));
        check(0X1.83694e3e4e51cP-1, Double.parseDouble("0X1.83694e3e4e51cP-1"));
        check(+0x1.71d2b73627f5fp-1f, Float.parseFloat("+0x1.71d2b73627f5fp-1f"));
        check(0x1.d188e62552838P-2D, Double.parseDouble("0x1.d188e62552838P-2D"));
        check(+0x1.e6c2fa251686bp-1, Double.parseDouble("+0x1.e6c2fa251686bp-1"));
        check(-0X1.b3b632cb9a4f4P-1D, Double.parseDouble("-0X1.b3b632cb9a4f4P-1D"));
        check(-0X1.B3B632CB9A4F4P-1, Double.parseDouble("-0X1.B3B632CB9A4F4P-1"));
        check(+0x1.d5fa3e453c266p-1D, Double.parseDouble("+0x1.d5fa3e453c266p-1D"));
        check(+0x1.C3DF592B8FBCp-3F, Float.parseFloat("+0x1.C3DF592B8FBCp-3F"));
        check(+0x1.c3df592b8fbcP-3, Double.parseDouble("+0x1.c3df592b8fbcP-3"));
        check(+0X1.5ed1c77bc80dep-2F, Float.parseFloat("+0X1.5ed1c77bc80dep-2F"));
        check(0x1.c67fb0441e475p-1F, Float.parseFloat("0x1.c67fb0441e475p-1F"));
        check(0x1.59AE6E3A117F4P-2F, Float.parseFloat("0x1.59AE6E3A117F4P-2F"));
        check(-0x1.b1df9db37dd16p-2F, Float.parseFloat("-0x1.b1df9db37dd16p-2F"));
        check(0x1.b1df9db37dd16p-2D, Double.parseDouble("0x1.b1df9db37dd16p-2D"));
        check(+0X1.b1df9db37dd16P-2, Double.parseDouble("+0X1.b1df9db37dd16P-2"));
        check(+0X1.CC4EF14196362P-2, Double.parseDouble("+0X1.CC4EF14196362P-2"));
        check(-0x1.21db20dff1ef4p-1d, Double.parseDouble("-0x1.21db20dff1ef4p-1d"));
        check(0x1.8B77F84D7D228P-1f, Float.parseFloat("0x1.8B77F84D7D228P-1f"));
        check(+0X1.8b77f84d7d228p-1, Double.parseDouble("+0X1.8b77f84d7d228p-1"));
        check(+0X1.eea18b9b23623p-1, Double.parseDouble("+0X1.eea18b9b23623p-1"));
        check(-0X1.EEA18B9B23623p-1F, Float.parseFloat("-0X1.EEA18B9B23623p-1F"));
        check(0x1.D7007A90ACFFP-1, Double.parseDouble("0x1.D7007A90ACFFP-1"));
        check(+0X1.BC5FA9784DF22P-1d, Double.parseDouble("+0X1.BC5FA9784DF22P-1d"));
        check(0x1.e5920c6d10018p-3, Double.parseDouble("0x1.e5920c6d10018p-3"));
        check(0x1.e5920c6d10018P-3f, Float.parseFloat("0x1.e5920c6d10018P-3f"));
        check(0X1.e5920c6d10018p-3, Double.parseDouble("0X1.e5920c6d10018p-3"));
        check(0X1.C12D766EAF83AP-1f, Float.parseFloat("0X1.C12D766EAF83AP-1f"));
        check(-0X1.b33ebab89cca5p-1D, Double.parseDouble("-0X1.b33ebab89cca5p-1D"));
        check(-0x1.114945192de1dp-1F, Float.parseFloat("-0x1.114945192de1dp-1F"));
        check(0X1.114945192de1dP-1f, Float.parseFloat("0X1.114945192de1dP-1f"));
        check(0X1.114945192de1dP-1F, Float.parseFloat("0X1.114945192de1dP-1F"));
        check(0X1.149ba37ee369aP-2D, Double.parseDouble("0X1.149ba37ee369aP-2D"));
        check(0x1.864fbbba2d8feP-1f, Float.parseFloat("0x1.864fbbba2d8feP-1f"));
        check(-0X1.f19f188d9d66ep-1D, Double.parseDouble("-0X1.f19f188d9d66ep-1D"));
        check(0x1.19DE4FDEE28C4P-1D, Double.parseDouble("0x1.19DE4FDEE28C4P-1D"));
        check(-0x1.33255540E32A2p-1F, Float.parseFloat("-0x1.33255540E32A2p-1F"));
        check(-0X1.33255540E32A2P-1d, Double.parseDouble("-0X1.33255540E32A2P-1d"));
        check(0X1.33255540E32A2P-1D, Double.parseDouble("0X1.33255540E32A2P-1D"));
        check(+0X1.826da50c942e2P-1D, Double.parseDouble("+0X1.826da50c942e2P-1D"));
        check(-0x1.974307541493p-3F, Float.parseFloat("-0x1.974307541493p-3F"));
        check(+0X1.974307541493P-3D, Double.parseDouble("+0X1.974307541493P-3D"));
        check(0X1.B615EA4D3EEEp-1f, Float.parseFloat("0X1.B615EA4D3EEEp-1f"));
        check(-0X1.42e53419d7a38p-2, Double.parseDouble("-0X1.42e53419d7a38p-2"));
        check(-0x1.46110e9eb8978P-4f, Float.parseFloat("-0x1.46110e9eb8978P-4f"));
        check(+0X1.46110e9eb8978p-4F, Float.parseFloat("+0X1.46110e9eb8978p-4F"));
        check(0x1.f4b8433e700fp-1D, Double.parseDouble("0x1.f4b8433e700fp-1D"));
        check(-0x1.f4b8433e700fP-1d, Double.parseDouble("-0x1.f4b8433e700fP-1d"));
        check(+0X1.f4b8433e700fp-1D, Double.parseDouble("+0X1.f4b8433e700fp-1D"));
        check(-0X1.F4B8433E700Fp-1F, Float.parseFloat("-0X1.F4B8433E700Fp-1F"));
        check(0X1.D0343C89AADDEp-2d, Double.parseDouble("0X1.D0343C89AADDEp-2d"));
        check(0x1.a1154618a3764p-1f, Float.parseFloat("0x1.a1154618a3764p-1f"));
        check(+0x1.a1154618a3764p-1F, Float.parseFloat("+0x1.a1154618a3764p-1F"));
        check(-0X1.A1154618A3764p-1d, Double.parseDouble("-0X1.A1154618A3764p-1d"));
        check(0x1.5D55A70DEE29Ep-1d, Double.parseDouble("0x1.5D55A70DEE29Ep-1d"));
        check(0x1.5D55A70DEE29Ep-1D, Double.parseDouble("0x1.5D55A70DEE29Ep-1D"));
        check(0x1.044A042E29BD1P-1d, Double.parseDouble("0x1.044A042E29BD1P-1d"));
        check(-0x1.7325d1e88fb24p-2d, Double.parseDouble("-0x1.7325d1e88fb24p-2d"));
        check(0x1.7325D1E88FB24P-2D, Double.parseDouble("0x1.7325D1E88FB24P-2D"));
        check(-0X1.7325D1E88FB24p-2, Double.parseDouble("-0X1.7325D1E88FB24p-2"));
        check(+0x1.9af71e96ebc04P-1d, Double.parseDouble("+0x1.9af71e96ebc04P-1d"));
        check(-0x1.505e19818009aP-1, Double.parseDouble("-0x1.505e19818009aP-1"));
        check(+0X1.505E19818009AP-1D, Double.parseDouble("+0X1.505E19818009AP-1D"));
        check(+0X1.4E886067F6F2Fp-1d, Double.parseDouble("+0X1.4E886067F6F2Fp-1d"));
        check(-0x1.E09709C718C6AP-2d, Double.parseDouble("-0x1.E09709C718C6AP-2d"));
        check(-0X1.E09709C718C6Ap-2D, Double.parseDouble("-0X1.E09709C718C6Ap-2D"));
        check(0X1.E09709C718C6AP-2d, Double.parseDouble("0X1.E09709C718C6AP-2d"));
        check(0x1.628C3B3D23C78p-4d, Double.parseDouble("0x1.628C3B3D23C78p-4d"));
        check(0x1.628C3B3D23C78P-4F, Float.parseFloat("0x1.628C3B3D23C78P-4F"));
        check(+0X1.628c3b3d23c78p-4, Double.parseDouble("+0X1.628c3b3d23c78p-4"));
        check(0x1.83CD36116C64p-4f, Float.parseFloat("0x1.83CD36116C64p-4f"));
        check(0x1.83cd36116c64P-4, Double.parseDouble("0x1.83cd36116c64P-4"));
        check(0X1.83cd36116c64p-4d, Double.parseDouble("0X1.83cd36116c64p-4d"));
        check(-0x1.f315bd7c1ff16p-1d, Double.parseDouble("-0x1.f315bd7c1ff16p-1d"));
        check(-0x1.f315bd7c1ff16P-1F, Float.parseFloat("-0x1.f315bd7c1ff16P-1F"));
        check(0x1.F315BD7C1FF16P-1, Double.parseDouble("0x1.F315BD7C1FF16P-1"));
        check(0x1.dcee2dc282d8bP-1, Double.parseDouble("0x1.dcee2dc282d8bP-1"));
        check(-0x1.DCEE2DC282D8BP-1D, Double.parseDouble("-0x1.DCEE2DC282D8BP-1D"));
        check(+0X1.dcee2dc282d8bP-1d, Double.parseDouble("+0X1.dcee2dc282d8bP-1d"));
        check(+0x1.3fb46969bfabeP-2f, Float.parseFloat("+0x1.3fb46969bfabeP-2f"));
        check(-0x1.3FB46969BFABEP-2D, Double.parseDouble("-0x1.3FB46969BFABEP-2D"));
        check(-0x1.3807BC95C5D9p-1d, Double.parseDouble("-0x1.3807BC95C5D9p-1d"));
        check(0x1.9c09b8d7e8e2ap-2, Double.parseDouble("0x1.9c09b8d7e8e2ap-2"));
        check(+0x1.9c09b8d7e8e2ap-2f, Float.parseFloat("+0x1.9c09b8d7e8e2ap-2f"));
        check(0X1.9C09B8D7E8E2Ap-2D, Double.parseDouble("0X1.9C09B8D7E8E2Ap-2D"));
        check(0x1.8f0d8d1c8618P-4D, Double.parseDouble("0x1.8f0d8d1c8618P-4D"));
        check(0X1.8F0D8D1C8618p-4f, Float.parseFloat("0X1.8F0D8D1C8618p-4f"));
        check(+0x1.e1066ec3a3fc6p-1, Double.parseDouble("+0x1.e1066ec3a3fc6p-1"));
        check(0x1.dde7659b3ffcp-1f, Float.parseFloat("0x1.dde7659b3ffcp-1f"));
        check(-0x1.dde7659b3ffcp-1F, Float.parseFloat("-0x1.dde7659b3ffcp-1F"));
        check(0x1.dde7659b3ffcP-1F, Float.parseFloat("0x1.dde7659b3ffcP-1F"));
        check(-0x1.971fa42992ad4P-3, Double.parseDouble("-0x1.971fa42992ad4P-3"));
        check(0x1.971FA42992AD4P-3D, Double.parseDouble("0x1.971FA42992AD4P-3D"));
        check(+0X1.971FA42992AD4p-3, Double.parseDouble("+0X1.971FA42992AD4p-3"));
        check(+0x1.02831e7624972p-1F, Float.parseFloat("+0x1.02831e7624972p-1F"));
        check(+0x1.02831E7624972p-1F, Float.parseFloat("+0x1.02831E7624972p-1F"));
        check(0x1.9fc55cefbfd08p-2f, Float.parseFloat("0x1.9fc55cefbfd08p-2f"));
        check(0x1.9FC55CEFBFD08p-2d, Double.parseDouble("0x1.9FC55CEFBFD08p-2d"));
        check(0X1.c106d27800f01p-1f, Float.parseFloat("0X1.c106d27800f01p-1f"));
        check(0X1.4f15cee34d718p-3D, Double.parseDouble("0X1.4f15cee34d718p-3D"));
        check(-0x1.49361a83ca564P-3, Double.parseDouble("-0x1.49361a83ca564P-3"));
        check(+0X1.21d8191a795ap-1D, Double.parseDouble("+0X1.21d8191a795ap-1D"));
        check(0X1.c2a6a27540aa4P-2, Double.parseDouble("0X1.c2a6a27540aa4P-2"));
        check(-0x1.c8aaefee62cc4p-2d, Double.parseDouble("-0x1.c8aaefee62cc4p-2d"));
        check(+0X1.c8aaefee62cc4p-2D, Double.parseDouble("+0X1.c8aaefee62cc4p-2D"));
        check(-0x1.77B61D75961Cp-7f, Float.parseFloat("-0x1.77B61D75961Cp-7f"));
        check(-0X1.77B61D75961CP-7d, Double.parseDouble("-0X1.77B61D75961CP-7d"));
        check(+0X1.8fa774cd1a102p-1, Double.parseDouble("+0X1.8fa774cd1a102p-1"));
        check(-0x1.bcec1419de228P-3F, Float.parseFloat("-0x1.bcec1419de228P-3F"));
        check(+0X1.60A6EA5530BBP-4f, Float.parseFloat("+0X1.60A6EA5530BBP-4f"));
        check(-0x1.C448BDFF0A01FP-1F, Float.parseFloat("-0x1.C448BDFF0A01FP-1F"));
        check(-0X1.c448bdff0a01fp-1D, Double.parseDouble("-0X1.c448bdff0a01fp-1D"));
        check(0X1.C448BDFF0A01FP-1F, Float.parseFloat("0X1.C448BDFF0A01FP-1F"));
        check(0x1.3E9AEE85DC481P-1d, Double.parseDouble("0x1.3E9AEE85DC481P-1d"));
        check(-0X1.3E9AEE85DC481p-1f, Float.parseFloat("-0X1.3E9AEE85DC481p-1f"));
        check(+0X1.3e9aee85dc481P-1, Double.parseDouble("+0X1.3e9aee85dc481P-1"));
        check(0X1.4450405989bb1p-1, Double.parseDouble("0X1.4450405989bb1p-1"));
        check(+0X1.03804059023e6P-1F, Float.parseFloat("+0X1.03804059023e6P-1F"));
        check(+0x1.64F02206269CDp-1d, Double.parseDouble("+0x1.64F02206269CDp-1d"));
        check(+0x1.64f02206269cdP-1F, Float.parseFloat("+0x1.64f02206269cdP-1F"));
        check(0x1.1371111b16b75P-1D, Double.parseDouble("0x1.1371111b16b75P-1D"));
        check(-0x1.1371111B16B75P-1F, Float.parseFloat("-0x1.1371111B16B75P-1F"));
        check(0X1.1371111b16b75p-1d, Double.parseDouble("0X1.1371111b16b75p-1d"));
        check(+0x1.099A04187DDF6p-2D, Double.parseDouble("+0x1.099A04187DDF6p-2D"));
        check(-0x1.099a04187ddf6P-2f, Float.parseFloat("-0x1.099a04187ddf6P-2f"));
        check(-0x1.099a04187ddf6P-2F, Float.parseFloat("-0x1.099a04187ddf6P-2F"));
        check(+0X1.099a04187ddf6P-2d, Double.parseDouble("+0X1.099a04187ddf6P-2d"));
        check(0x1.3f8c808d27a26P-2D, Double.parseDouble("0x1.3f8c808d27a26P-2D"));
        check(+0X1.3f8c808d27a26p-2D, Double.parseDouble("+0X1.3f8c808d27a26p-2D"));
        check(0X1.3F8C808D27A26P-2, Double.parseDouble("0X1.3F8C808D27A26P-2"));
        check(+0x1.84546C327CA2Fp-1d, Double.parseDouble("+0x1.84546C327CA2Fp-1d"));
        check(+0x1.F4167D40063AP-2, Double.parseDouble("+0x1.F4167D40063AP-2"));
        check(-0x1.F4167D40063AP-2f, Float.parseFloat("-0x1.F4167D40063AP-2f"));
        check(-0X1.F4167D40063Ap-2d, Double.parseDouble("-0X1.F4167D40063Ap-2d"));
        check(0x1.2DEB0C3D7A34Ep-2, Double.parseDouble("0x1.2DEB0C3D7A34Ep-2"));
        check(-0x1.5e9956fb5cbfap-2D, Double.parseDouble("-0x1.5e9956fb5cbfap-2D"));
        check(0x1.1daefb96405e8P-1f, Float.parseFloat("0x1.1daefb96405e8P-1f"));
        check(-0x1.A937DB5A01A18P-3, Double.parseDouble("-0x1.A937DB5A01A18P-3"));
        check(0x1.A937DB5A01A18P-3F, Float.parseFloat("0x1.A937DB5A01A18P-3F"));
        check(+0x1.A937DB5A01A18P-3F, Float.parseFloat("+0x1.A937DB5A01A18P-3F"));
        check(0X1.a937db5a01a18P-3D, Double.parseDouble("0X1.a937db5a01a18P-3D"));
        check(-0x1.faf0d95a2c71ep-2d, Double.parseDouble("-0x1.faf0d95a2c71ep-2d"));
        check(-0x1.b97386c2a6227P-1F, Float.parseFloat("-0x1.b97386c2a6227P-1F"));
        check(+0X1.8DAC5C236AE68p-3, Double.parseDouble("+0X1.8DAC5C236AE68p-3"));
        check(-0x0.7ffffffffffffffp-149, Double.parseDouble("-0x0.7ffffffffffffffp-149"));
    }
}
