package com.sun.tools.javac.util;

/**
 *
 * @author Tomas Zezula
 */
public class CancelService {
    
    
    /** The context key for the parameter name resolver. */
    protected static final Context.Key<CancelService> cancelServiceKey =
        new Context.Key<CancelService>();

    public static CancelService instance(Context context) {
        CancelService instance = context.get(cancelServiceKey);
        if (instance == null) {
            instance = new CancelService();
            context.put(cancelServiceKey, instance);
        }
        return instance;
    }

    protected CancelService() {
    }
    
    
    public boolean isCanceled () {
        return false;
    }
    
    public final void abortIfCanceled () {
        if (isCanceled()) {
            throw new CancelAbort ();
        }
    }

}
