/*
 * MusicBrainz -- The Internet music metadatabase
 *
 * Copyright (C) 2006 Lukas Lalinsky
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * $Id: releaseevent.cpp 8466 2006-09-05 08:59:44Z luks $
 */
 
#include <string>
#include <musicbrainz3/releaseevent.h>

using namespace std;
using namespace MusicBrainz;

class ReleaseEvent::ReleaseEventPrivate
{
public:
	ReleaseEventPrivate()
		{}
		
	string country;
	string dateStr;
};

ReleaseEvent::ReleaseEvent(const string &country, const string &dateStr)
{
	d = new ReleaseEventPrivate();
	
	d->country = country;
	d->dateStr = dateStr;
}

ReleaseEvent::~ReleaseEvent()
{
	delete d;
}

string
ReleaseEvent::getCountry() const
{
	return d->country;
}

void
ReleaseEvent::setCountry(const string &value)
{
	d->country = value;
}

string
ReleaseEvent::getDate() const
{
	return d->dateStr;
}

void
ReleaseEvent::setDate(const string &value)
{
	d->dateStr = value;
}

