package Locales::DB::Language::bn;

# Auto generated from CLDR

$Locales::DB::Language::bn::VERSION = '0.09';

$Locales::DB::Language::bn::cldr_version = '2.0';

%Locales::DB::Language::bn::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "ভাষা\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ এবং\ \{1\}",
            'end'    => "\{0\}\,\ এবং\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#\,\#\#0\%",
        'territory' => "অঞ্চল\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '’',
        'alternate_quotation_start' => '‘',
        'quotation_end'             => '”',
        'quotation_start'           => '“'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( $_[0] == 1 ) ) ) { return 'one'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr'  => 'না',
        'yesstr' => 'হাঁ'
    },
);

%Locales::DB::Language::bn::code_to_name = (
    'aa'    => 'আফার',
    'ab'    => 'আব্খাজিয়',
    'ace'   => 'আচিনিয়',
    'ach'   => 'আকোলী',
    'ada'   => 'অদাগ্মে',
    'ady'   => 'আদেগে',
    'ae'    => 'আবেস্তীয়',
    'af'    => 'আফ্রিকান্স',
    'afa'   => "অফ্রো\-এশিয়াটিক",
    'afh'   => 'আফ্রিহিলি',
    'agq'   => 'Aghem',
    'ain'   => 'আইনু',
    'ak'    => 'আকান',
    'akk'   => 'আক্কাদিয়ান',
    'ale'   => 'আলেউত',
    'alg'   => 'আলগোঙকুইআন',
    'alt'   => "দক্ষিন\ আলতাই",
    'am'    => 'আমহারিক',
    'an'    => 'আর্গোনিজ',
    'ang'   => "প্রাচীন\ ইংরেজী",
    'anp'   => 'আঙ্গীকা',
    'apa'   => 'অ্যাপাচি',
    'ar'    => 'আরবী',
    'arc'   => 'আরামাইক',
    'arn'   => 'অ্যারোকেনিয়',
    'arp'   => 'আরাপাহো',
    'art'   => 'কৃত্রিম',
    'arw'   => 'আরাওয়াক',
    'as'    => 'আসামি',
    'asa'   => 'Asu',
    'ast'   => 'আস্তুরিয়',
    'ath'   => 'আথাপাস্কান',
    'aus'   => 'অস্ট্রেলিয়',
    'av'    => 'আভেরিক',
    'awa'   => 'আওয়াধি',
    'ay'    => 'আয়মারা',
    'az'    => 'আজেরি',
    'ba'    => 'বাশকির',
    'bad'   => 'বান্দা',
    'bai'   => "বামিলেকে\ ভাষা",
    'bal'   => 'বেলুচী',
    'ban'   => 'বালিনীয়',
    'bas'   => 'বাসা',
    'bat'   => "বাল্টিক\ ভাষা",
    'be'    => 'বেলারুশিয়',
    'bej'   => 'বেজা',
    'bem'   => 'বেম্বা',
    'ber'   => 'বেরবের',
    'bez'   => 'Bena',
    'bg'    => 'বুলগেরিয়',
    'bh'    => 'বিহারি',
    'bho'   => 'ভোজপুরি',
    'bi'    => 'বিসলামা',
    'bik'   => 'বিকোল',
    'bin'   => 'বিনি',
    'bla'   => 'সিকসিকা',
    'bm'    => 'বামবারা',
    'bn'    => 'বাংলা',
    'bnt'   => 'বান্টু',
    'bo'    => 'তিব্বতি',
    'br'    => 'ব্রেটোন',
    'bra'   => 'ব্রাজ',
    'brx'   => 'Bodo',
    'bs'    => 'বসনীয়',
    'btk'   => 'বাতাক',
    'bua'   => 'বুরিয়াত',
    'bug'   => 'বুগিনি',
    'byn'   => 'ব্লিন',
    'ca'    => 'কাতালান',
    'cad'   => 'ক্যাডো',
    'cai'   => "মধ্য\ যুক্তরাষ্ঠের\ আদিবাসীদের\ ভাষা",
    'car'   => 'ক্যারিব',
    'cau'   => 'ককেশীয',
    'cay'   => 'Cayuga',
    'cch'   => 'আত্সাম',
    'ce'    => 'চেচেন',
    'ceb'   => 'চেবুয়ানো',
    'cel'   => 'কেল্টিক',
    'cgg'   => 'Chiga',
    'ch'    => 'চামেরো',
    'chb'   => 'চিবচা',
    'chg'   => 'চাগাতাই',
    'chk'   => 'চুকি',
    'chm'   => 'মারি',
    'chn'   => "চিনুক\ পরিভাষা",
    'cho'   => 'চক্টো',
    'chp'   => 'চিপেওয়ান',
    'chr'   => 'চেরোকি',
    'chy'   => 'শাইয়েন',
    'cmc'   => "চামিক\ ভাষা",
    'co'    => 'কর্সিকান',
    'cop'   => 'কপটিক',
    'cpe'   => "ইংরেজি\ জাত\ ক্রেওল\ অথবা\ পিজিন",
    'cpf'   => "ফরাসি\ জাত\ ক্রেওল\ অথবা\ পিজিন",
    'cpp'   => "পোর্তুগিজ\-ভিত্তিক\ ক্রেওল\ বা\ পিজন",
    'cr'    => 'ক্রি',
    'crh'   => "ক্রিমিয়ান\ তুর্কি",
    'crp'   => "ক্রেওল\ অথবা\ পিজিন",
    'cs'    => 'চেক',
    'csb'   => 'কাশুবিয়ান',
    'cu'    => "চার্চ\ স্লাভিও",
    'cus'   => "কুশিতিক\ ভাষা",
    'cv'    => 'চুবাস',
    'cy'    => 'ওয়েলশ',
    'da'    => 'ডেনিশ',
    'dak'   => 'ডাকোটা',
    'dar'   => 'দার্গওয়া',
    'dav'   => 'Taita',
    'day'   => 'দায়াক',
    'de'    => 'জার্মান',
    'de_at' => "অস্ট্রিয়ান\ জার্মানি",
    'de_ch' => "সুইস\ উচ্চ\ জার্মানি",
    'del'   => 'ডেলাওয়ের',
    'den'   => 'স্ল্যাভ',
    'dgr'   => 'দোগ্রীব',
    'din'   => 'ডিংকা',
    'dje'   => 'Zarma',
    'doi'   => 'দোগরি',
    'dra'   => "দ্রাবীড়\ ভাষা",
    'dsb'   => "নিম্নতর\ সোর্বিয়ান",
    'dua'   => 'দুয়ালা',
    'dum'   => "মধ্য\ ডাচ",
    'dv'    => 'দিবেহি',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'ডিউলা',
    'dz'    => 'ভুটানি',
    'ebu'   => 'Embu',
    'ee'    => 'ইওয়ে',
    'efi'   => 'এফিক',
    'egy'   => "প্রাচীন\ মিশরীয়",
    'eka'   => 'ইকাজুক',
    'el'    => 'গ্রিক',
    'elx'   => 'এলামাইট',
    'en'    => 'ইংরেজি',
    'en_au' => "অস্ট্রেলীয়\ ইংরেজি",
    'en_ca' => "কানাডীয়\ ইংরেজি",
    'en_gb' => "ব্রিটিশ\ ইংরেজি",
    'en_us' => "যুক্তরাষ্ট্র\ ইংরেজি",
    'enm'   => "মধ্য\ ইংরেজি",
    'eo'    => 'এস্পেরান্তো',
    'es'    => 'স্পেনীয়',
    'es_es' => "আইবেরিয়ান\ স্প্যানিশ",
    'et'    => 'এস্তোনীয়',
    'eu'    => 'বাস্ক',
    'ewo'   => 'ইওন্ডো',
    'fa'    => 'ফার্সি',
    'fan'   => 'ফ্যাঙ্গ',
    'fat'   => 'ফান্তি',
    'ff'    => 'ফুলাহ্',
    'fi'    => 'ফিনিশ',
    'fil'   => 'ফিলিপিনো',
    'fiu'   => "ফিনো\-ইউগ্রিক",
    'fj'    => 'ফিজিও',
    'fo'    => 'ফেরাউনি',
    'fon'   => 'ফন',
    'fr'    => 'ফরাসি',
    'fr_ca' => "কানাডীয়\ ফরাসি",
    'fr_ch' => "সুইস\ ফরাসি",
    'frm'   => "মধ্য\ ফরাসি",
    'fro'   => "প্রাচীন\ ফরাসি",
    'frr'   => "উত্তরাঞ্চলীয়\ ফ্রিসিয়ান",
    'frs'   => "পূর্ব\ ফ্রিসিয়",
    'fur'   => 'ফ্রিউলিয়ান',
    'fy'    => "পশ্চিম\ ফ্রিসিয়",
    'ga'    => 'আইরিশ',
    'gaa'   => 'গা',
    'gay'   => 'গায়ো',
    'gba'   => 'বায়া',
    'gd'    => "স্কটস\-গ্যেলিক",
    'gem'   => "জার্মানিক\ ভাষা",
    'gez'   => 'গীজ',
    'gil'   => 'গিলবার্টিজ',
    'gl'    => 'গ্যালিশিয়',
    'gmh'   => "মধ্য\-উচ্চ\ জার্মানি",
    'gn'    => 'গুয়ারানি',
    'goh'   => "প্রাচীন\ উচ্চ\ জার্মানি",
    'gon'   => 'গোন্ডি',
    'gor'   => 'গোরোন্তালো',
    'got'   => 'গথিক',
    'grb'   => 'গ্রেবো',
    'grc'   => "প্রাচীন\ গ্রীক",
    'gsw'   => "সুইস\ জার্মান",
    'gu'    => 'গুজরাটি',
    'guz'   => 'Gusii',
    'gv'    => 'ম্যাঙ্কস',
    'gwi'   => 'গওইচ্’ইন',
    'ha'    => 'হাউসা',
    'hai'   => 'হাইডা',
    'haw'   => 'হাওয়াইয়ান',
    'he'    => 'হিব্রু',
    'hi'    => 'হিন্দি',
    'hil'   => 'হিলিগ্যায়নোন',
    'him'   => 'হিমাচালি',
    'hit'   => 'হিট্টিট',
    'hmn'   => 'হ্‌মোঙ',
    'ho'    => "হিরি\ মোতু",
    'hr'    => 'ক্রোয়েশীয়',
    'hsb'   => "উচ্চ\ সোর্বিয়ান",
    'ht'    => 'হাইতিয়ান',
    'hu'    => 'হাঙ্গেরীয়',
    'hup'   => 'হুপা',
    'hy'    => 'আর্মেনিয়',
    'hz'    => 'হেরেরো',
    'ia'    => 'ইন্টারলিঙ্গুয়া',
    'iba'   => 'ইবান',
    'id'    => 'ইন্দোনেশীয়',
    'ie'    => 'ইন্টারলিঙ্গ',
    'ig'    => 'ইগ্‌বো',
    'ii'    => "সিচুয়ান\ য়ি",
    'ijo'   => 'ইজো',
    'ik'    => 'ইনুপিয়াক',
    'ilo'   => 'ইলোকো',
    'inc'   => "ভারতীয়\ ভাষা",
    'ine'   => "ইন্দো\-ইউরোপীয়\ ভাষা",
    'inh'   => 'ইঙ্গুশ',
    'io'    => 'ইডো',
    'ira'   => "ইরানী\ ভাষা",
    'iro'   => "ইরোকোইয়ান\ ভাষা",
    'is'    => 'আইসল্যান্ডীয়',
    'it'    => 'ইতালীয়',
    'iu'    => 'ইনুক্টিটুট',
    'ja'    => 'জাপানি',
    'jbo'   => 'লোজবান',
    'jmc'   => 'Machame',
    'jpr'   => "জুদেও\ ফার্সি",
    'jrb'   => "জুদেও\ আরবি",
    'jv'    => 'জাভানি',
    'ka'    => 'জর্জিয়ান',
    'kaa'   => "কারা\-কাল্পাক",
    'kab'   => 'কাবাইলে',
    'kac'   => 'কাচিন',
    'kaj'   => 'অজ্জু',
    'kam'   => 'কাম্বা',
    'kar'   => 'কারেন',
    'kaw'   => 'কাউই',
    'kbd'   => 'কাবার্ডিয়ান',
    'kcg'   => 'টাইয়াপ',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'কোরো',
    'kg'    => 'কোঙ্গো',
    'kha'   => 'খাশি',
    'khi'   => "খোয়েশান\ ভাষা",
    'kho'   => 'খোটানিজ',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'কিকু্ইয়ু',
    'kj'    => 'কোয়ানিয়ামা',
    'kk'    => 'কাজাখ',
    'kl'    => 'ক্যালাল্লিসুট',
    'kln'   => 'Kalenjin',
    'km'    => 'খমের',
    'kmb'   => 'কিম্বুন্দু',
    'kn'    => 'কান্নাড়ী',
    'ko'    => 'কোরিয়ান',
    'kok'   => 'কোঙ্কানি',
    'kos'   => 'কোস্রাইন',
    'kpe'   => 'ক্‌পেল্লে',
    'kr'    => 'কানুরি',
    'krc'   => "কারচে\-বাল্কার",
    'krl'   => 'কারেলিয়ান',
    'kro'   => 'ক্রু',
    'kru'   => 'কুরুখ',
    'ks'    => 'কাশ্মীরী',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'কুর্দি',
    'kum'   => 'কুমিক',
    'kut'   => 'কুটেনাই',
    'kv'    => 'কোমি',
    'kw'    => 'কর্ণিশ',
    'ky'    => 'কির্গিজ',
    'la'    => 'লাটিন',
    'lad'   => 'লাডিনো',
    'lag'   => 'Langi',
    'lah'   => 'লান্ডা',
    'lam'   => 'লাম্বা',
    'lb'    => 'লুক্সেমবার্গীয়',
    'lez'   => 'লেজঘিয়ান',
    'lg'    => 'গ্যান্ডা',
    'li'    => 'লিম্বুর্গিশ',
    'ln'    => 'লিঙ্গালা',
    'lo'    => 'লাও',
    'lol'   => 'মোঙ্গো',
    'loz'   => 'লোজি',
    'lt'    => 'লিথুয়েনীয',
    'lu'    => "লুবা\-কাটাঙ্গা",
    'lua'   => "লুবা\-লুলুয়া",
    'lui'   => 'লুইসেনো',
    'lun'   => 'লুন্ডা',
    'luo'   => 'লুয়ো',
    'lus'   => 'লুশাই',
    'luy'   => 'Luyia',
    'lv'    => 'লাত্‌ভীয়',
    'mad'   => 'মাদুরেসে',
    'mag'   => 'মাগাহি',
    'mai'   => 'মৈথিলি',
    'mak'   => 'ম্যাকাসার',
    'man'   => 'ম্যান্ডিঙ্গো',
    'map'   => 'অস্ট্রোনেশীয়',
    'mas'   => 'মাসাই',
    'mdf'   => 'মোকশা',
    'mdr'   => 'ম্যাণ্ডার',
    'men'   => 'মেন্ডে',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'মালাগাসি',
    'mga'   => "মধ্য\ আইরিশ",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'মার্শালিজ',
    'mi'    => 'মাওরি',
    'mic'   => 'মিকম্যাক',
    'min'   => 'মিনাঙ্গ্‌কাবাউ',
    'mis'   => "বিবিধ\ ভাষা",
    'mk'    => 'ম্যাসেডোনীয',
    'mkh'   => "মন\-খমের\ ভাষা",
    'ml'    => 'মালেয়ালাম',
    'mn'    => 'মঙ্গোলিয়',
    'mnc'   => 'মাঞ্চু',
    'mni'   => 'মণিপুরী',
    'mno'   => "ম্যানোবো\ ভাষা",
    'mo'    => 'মলদাভিয়',
    'moh'   => 'মোহাওক',
    'mos'   => 'মসি',
    'mr'    => 'মারাঠি',
    'ms'    => 'মালে',
    'mt'    => 'মল্টিয়',
    'mua'   => 'Mundang',
    'mul'   => "বহুগুণিতক\ ভাষাসমূহ",
    'mun'   => "মুণ্ডা\ ভাষা",
    'mus'   => 'ক্রিক',
    'mwl'   => 'মিরান্ডিজ',
    'mwr'   => 'মারোয়ারি',
    'my'    => 'বর্মি',
    'myn'   => "মায়ান\ ভাষা",
    'myv'   => 'এরজিয়া',
    'na'    => 'নাউরু',
    'nah'   => 'নাহুৎল',
    'nai'   => "উত্তৱ\ আমেরিকার\ ইন্ডিয়ান\ ভাষা",
    'nap'   => 'নেয়াপোলিটান',
    'naq'   => 'Nama',
    'nb'    => "নরওয়ে\ বোকমাল",
    'nd'    => "উত্তর\ এন্দেবিলি",
    'nds'   => "নিম্ন\ জার্মানি",
    'ne'    => 'নেপালী',
    'new'   => 'নেওয়ারি',
    'ng'    => 'এন্দোঙ্গা',
    'nia'   => 'নিয়াস',
    'nic'   => "নাইজার\-কোর্ডোফানিয়ান\ ভাষা",
    'niu'   => 'নিউয়ান',
    'nl'    => 'ডাচ',
    'nl_be' => 'ফ্লেমিশ',
    'nmg'   => 'Kwasio',
    'nn'    => "নরওয়েজীয়ান\ নিনর্স্ক",
    'no'    => 'নরওয়েজীয়',
    'nog'   => 'নোগাই',
    'non'   => "প্রাচীন\ নর্স",
    'nqo'   => 'এন’কো',
    'nr'    => "দক্ষিণ\ এনডেবেলে",
    'nso'   => "উত্তরাঞ্চলীয়\ সোথো",
    'nub'   => "নুবিয়ান\ ভাষা",
    'nus'   => 'Nuer',
    'nv'    => 'নাভাজো',
    'nwc'   => "প্রাচীন\ নেওয়ারী",
    'ny'    => 'নায়াঞ্জা',
    'nym'   => 'ন্যায়ামওয়েজি',
    'nyn'   => 'ন্যায়াঙ্কোলে',
    'nyo'   => 'ন্যোরো',
    'nzi'   => "এন্\.জিমা",
    'oc'    => 'অক্সিটান',
    'oj'    => 'ওজিবওয়া',
    'om'    => 'অরোমো',
    'or'    => 'উড়িয়া',
    'os'    => 'ওসেটিক',
    'osa'   => 'ওসেজ',
    'ota'   => "অটোমান\ তুর্কি",
    'oto'   => "অটোমান\ ভাষা",
    'pa'    => 'পাঞ্জাবী',
    'paa'   => "পাপুয়ান\ ভাষা",
    'pag'   => 'পাঙ্গাসিনান',
    'pal'   => 'পাহ্লাভি',
    'pam'   => 'পাম্পাঙ্গা',
    'pap'   => 'পাপিয়ামেন্টো',
    'pau'   => 'পালায়ুয়ান',
    'peo'   => "প্রাচীন\ ফার্সি",
    'phi'   => "ফিলিপাইন\ ভাষা",
    'phn'   => 'ফোনিশীয়ান',
    'pi'    => 'পালি',
    'pl'    => 'পোলিশ',
    'pon'   => 'পোহ্নপেইয়ান',
    'pra'   => "প্রাকৃত\ ভাষা",
    'pro'   => "প্রাচীন\ প্রোভেনসাল",
    'ps'    => 'পুশতো',
    'pt'    => 'পর্তুগীজ',
    'pt_br' => "ব্রাজিলীয়\ পর্তুগীজ",
    'pt_pt' => "আইবেরিয়ান\ পর্তুগিজ",
    'qu'    => 'কেচুয়া',
    'raj'   => 'রাজস্থানী',
    'rap'   => 'রাপানুই',
    'rar'   => 'রারোটোংগান',
    'rm'    => "রেটো\-রোমানীয়",
    'rn'    => 'রুন্দি',
    'ro'    => 'রোমানীয়',
    'roa'   => "রোমান\ ভাষা",
    'rof'   => 'Rombo',
    'rom'   => 'রোমানি',
    'ru'    => 'রুশ',
    'rup'   => 'আরোমানিয়',
    'rw'    => 'কিনয়ারোয়ান্ডা',
    'rwk'   => 'Rwa',
    'sa'    => 'সংষ্কৃত',
    'sad'   => 'স্যান্ডাওয়ে',
    'sah'   => 'ইয়াকুট',
    'sai'   => "উত্তর\ আমেরিকান\ ইন্ডিয়ান\ ভাষা",
    'sal'   => "শালিশান\ ভাষা",
    'sam'   => "সামারিটান\ আরামিক",
    'saq'   => 'Samburu',
    'sas'   => 'সাসাক',
    'sat'   => 'সাঁওতালি',
    'sbp'   => 'Sangu',
    'sc'    => 'সার্ডিনিয়ান',
    'scn'   => 'সিসিলিয়ান',
    'sco'   => 'স্কটস',
    'sd'    => 'সিন্ধি',
    'se'    => "উত্তরাঞ্চলীয়\ সামি",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'সেল্কুপ',
    'sem'   => "সেমেটিক\ ভাষা",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'সাঙ্গো',
    'sga'   => "প্রাচীন\ আইরিশ",
    'sgn'   => "চিহ্ন\ ভাষা",
    'sh'    => "সার্বো\-ক্রোয়েশিয়",
    'shi'   => 'Tachelhit',
    'shn'   => 'শান',
    'si'    => 'সিংহলী',
    'sid'   => 'সিডামো',
    'sio'   => "সিওয়ুয়ান\ ভাষা",
    'sit'   => "সিনো\-তিব্বোতীয়\ ভাষা",
    'sk'    => 'স্লোভাক',
    'sl'    => 'স্লোভেনীয়',
    'sla'   => "স্ল্যাভিক\ ভাষা",
    'sm'    => 'সামোয়ান',
    'sma'   => "দক্ষিণাঞ্চলীয়\ সামি",
    'smi'   => "সামি\ ভাষা",
    'smj'   => "লুলে\ সামি",
    'smn'   => "ইনারি\ সামি",
    'sms'   => "স্কোল্ট\ সামি",
    'sn'    => 'শোনা',
    'snk'   => 'সোনিঙ্কে',
    'so'    => 'সোমালী',
    'sog'   => 'সোগডিয়ান',
    'son'   => 'সোঙ্গহাই',
    'sq'    => 'আলবেনীয়',
    'sr'    => 'সার্বীয়',
    'srn'   => "স্রানান\ টোঙ্গো",
    'srr'   => 'সেরের',
    'ss'    => 'সোয়াতি',
    'ssa'   => "নিলো\-সাহারান\ ভাষা",
    'ssy'   => 'Saho',
    'st'    => "দক্ষিন\ সোথো",
    'su'    => 'সুদানী',
    'suk'   => 'সুকুমা',
    'sus'   => 'সুসু',
    'sux'   => 'সুমেরীয়',
    'sv'    => 'সুইডিশ',
    'sw'    => 'সোয়াহিলি',
    'swb'   => 'কমোরিয়ান',
    'swc'   => "Congo\ Swahili",
    'syc'   => "প্রাচীন\ সিরিও",
    'syr'   => 'সিরিয়াক',
    'ta'    => 'তামিল',
    'tai'   => "তাই\ ভাষা",
    'te'    => 'তেলেগু',
    'tem'   => 'টাইম্নে',
    'teo'   => 'Teso',
    'ter'   => 'তেরেনো',
    'tet'   => 'তেতুম',
    'tg'    => 'তাজিক',
    'th'    => 'থাই',
    'ti'    => 'তিগরিনিয়া',
    'tig'   => 'টাইগ্রে',
    'tiv'   => 'টিভ',
    'tk'    => 'তুর্কমেনী',
    'tkl'   => 'টোকেলাউ',
    'tl'    => 'তাগালগ',
    'tlh'   => 'ক্লিঙ্গন',
    'tli'   => 'ত্লিঙ্গিট',
    'tmh'   => 'তামাশেক',
    'tn'    => 'সোয়ানা',
    'to'    => 'টঙ্গা',
    'tog'   => "নায়াসা\ টোঙ্গা",
    'tpi'   => "টোক\ পিসিন",
    'tr'    => 'তুর্কী',
    'trv'   => 'Taroko',
    'ts'    => 'সঙ্গা',
    'tsi'   => 'সিমশিয়ান',
    'tt'    => 'তাতার',
    'tum'   => 'তুম্বুকা',
    'tup'   => "তুপি\ ভাষা",
    'tut'   => "আলতায়ীক\ ভাষা",
    'tvl'   => 'টুভালু',
    'tw'    => 'টোয়াই',
    'twq'   => 'Tasawaq',
    'ty'    => 'তাহিতিয়ান',
    'tyv'   => 'টুভিনিয়ান',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'উডমুর্ট',
    'ug'    => 'ইউঘুর',
    'uga'   => 'উগারিটিক',
    'uk'    => 'ইউক্রেনীয়',
    'umb'   => 'উম্বুন্দু',
    'und'   => "অজানা\ বা\ ভুল\ ভাষা",
    'ur'    => 'উর্দু',
    'uz'    => 'উজবেকীয়',
    'vai'   => 'ভাই',
    've'    => 'ভেন্ডা',
    'vi'    => 'ভিয়েতনামী',
    'vo'    => 'ভোলাপুক',
    'vot'   => 'ভোটিক',
    'vun'   => 'Vunjo',
    'wa'    => 'ওয়ালুন',
    'wae'   => 'Walser',
    'wak'   => "ওয়াকাশান\ ভাষা",
    'wal'   => 'ওয়ালামো',
    'war'   => 'ওয়ারে',
    'was'   => 'ওয়াশো',
    'wen'   => "সোরবিয়ান\ ভাষা",
    'wo'    => 'উওলোফ',
    'xal'   => 'কাল্মইক',
    'xh'    => 'জোসা',
    'xog'   => 'Soga',
    'yao'   => 'ইয়াও',
    'yap'   => 'ইয়াপেসে',
    'yav'   => 'Yangben',
    'yi'    => 'য়িদ্দিশ',
    'yo'    => 'ইওরুবা',
    'ypk'   => "ইয়ুপিক\ ভাষা",
    'yue'   => 'ক্যানটোনীজ',
    'za'    => 'ঝু্য়াঙ',
    'zap'   => 'জাপোটেক',
    'zbl'   => "চিত্র\ ভাষা",
    'zen'   => 'জেনাগা',
    'zh'    => 'চীনা',
    'znd'   => 'জান্ডে',
    'zu'    => 'জুলু',
    'zun'   => 'জুনি',
    'zxx'   => "ভাষাতাত্তিক\ বিষয়সূচী\ বহির্ভুত",
    'zza'   => 'জাজা',
);

%Locales::DB::Language::bn::name_to_code = (
    'aghem'                                                                                      => 'agq',
    'asu'                                                                                        => 'asa',
    'bafia'                                                                                      => 'ksf',
    'bena'                                                                                       => 'bez',
    'bodo'                                                                                       => 'brx',
    'cayuga'                                                                                     => 'cay',
    'centralmoroccotamazight'                                                                    => 'tzm',
    'chiga'                                                                                      => 'cgg',
    'colognian'                                                                                  => 'ksh',
    'congoswahili'                                                                               => 'swc',
    'embu'                                                                                       => 'ebu',
    'gusii'                                                                                      => 'guz',
    'jolafonyi'                                                                                  => 'dyo',
    'kabuverdianu'                                                                               => 'kea',
    'kalenjin'                                                                                   => 'kln',
    'koyraborosenni'                                                                             => 'ses',
    'koyrachiini'                                                                                => 'khq',
    'kwasio'                                                                                     => 'nmg',
    'langi'                                                                                      => 'lag',
    'luyia'                                                                                      => 'luy',
    'machame'                                                                                    => 'jmc',
    'makhuwameetto'                                                                              => 'mgh',
    'makonde'                                                                                    => 'kde',
    'meru'                                                                                       => 'mer',
    'morisyen'                                                                                   => 'mfe',
    'mundang'                                                                                    => 'mua',
    'nama'                                                                                       => 'naq',
    'nuer'                                                                                       => 'nus',
    'rombo'                                                                                      => 'rof',
    'rwa'                                                                                        => 'rwk',
    'saho'                                                                                       => 'ssy',
    'samburu'                                                                                    => 'saq',
    'sangu'                                                                                      => 'sbp',
    'sena'                                                                                       => 'seh',
    'seneca'                                                                                     => 'see',
    'shambala'                                                                                   => 'ksb',
    'soga'                                                                                       => 'xog',
    'tachelhit'                                                                                  => 'shi',
    'taita'                                                                                      => 'dav',
    'taroko'                                                                                     => 'trv',
    'tasawaq'                                                                                    => 'twq',
    'teso'                                                                                       => 'teo',
    'vunjo'                                                                                      => 'vun',
    'walser'                                                                                     => 'wae',
    'yangben'                                                                                    => 'yav',
    'zarma'                                                                                      => 'dje',
    'অক্সিটান'                                                                   => 'oc',
    'অজানাবাভুলভাষা'                                                 => 'und',
    'অজ্জু'                                                                            => 'kaj',
    'অটোমানতুর্কি'                                                       => 'ota',
    'অটোমানভাষা'                                                             => 'oto',
    'অদাগ্মে'                                                                      => 'ada',
    'অফ্রোএশিয়াটিক'                                                 => 'afa',
    'অরোমো'                                                                            => 'om',
    'অস্ট্রিয়ানজার্মানি'                                  => 'de_at',
    'অস্ট্রেলিয়'                                                          => 'aus',
    'অস্ট্রেলীয়ইংরেজি'                                        => 'en_au',
    'অস্ট্রোনেশীয়'                                                    => 'map',
    'অ্যাপাচি'                                                                   => 'apa',
    'অ্যারোকেনিয়'                                                       => 'arn',
    'আইনু'                                                                               => 'ain',
    'আইবেরিয়ানপর্তুগিজ'                                     => 'pt_pt',
    'আইবেরিয়ানস্প্যানিশ'                                  => 'es_es',
    'আইরিশ'                                                                            => 'ga',
    'আইসল্যান্ডীয়'                                                    => 'is',
    'আওয়াধি'                                                                      => 'awa',
    'আকান'                                                                               => 'ak',
    'আকোলী'                                                                            => 'ach',
    'আক্কাদিয়ান'                                                          => 'akk',
    'আঙ্গীকা'                                                                      => 'anp',
    'আচিনিয়'                                                                      => 'ace',
    'আজেরি'                                                                            => 'az',
    'আত্সাম'                                                                         => 'cch',
    'আথাপাস্কান'                                                             => 'ath',
    'আদেগে'                                                                            => 'ady',
    'আফার'                                                                               => 'aa',
    'আফ্রিকান্স'                                                             => 'af',
    'আফ্রিহিলি'                                                                => 'afh',
    'আবেস্তীয়'                                                                => 'ae',
    'আব্খাজিয়'                                                                => 'ab',
    'আভেরিক'                                                                         => 'av',
    'আমহারিক'                                                                      => 'am',
    'আয়মারা'                                                                      => 'ay',
    'আরবী'                                                                               => 'ar',
    'আরাওয়াক'                                                                   => 'arw',
    'আরাপাহো'                                                                      => 'arp',
    'আরামাইক'                                                                      => 'arc',
    'আরোমানিয়'                                                                => 'rup',
    'আর্গোনিজ'                                                                   => 'an',
    'আর্মেনিয়'                                                                => 'hy',
    'আলগোঙকুইআন'                                                             => 'alg',
    'আলতায়ীকভাষা'                                                       => 'tut',
    'আলবেনীয়'                                                                   => 'sq',
    'আলেউত'                                                                            => 'ale',
    'আসামি'                                                                            => 'as',
    'আস্তুরিয়'                                                                => 'ast',
    'ইংরেজি'                                                                         => 'en',
    'ইংরেজিজাতক্রেওলঅথবাপিজিন'                   => 'cpe',
    'ইউক্রেনীয়'                                                             => 'uk',
    'ইউঘুর'                                                                            => 'ug',
    'ইওন্ডো'                                                                         => 'ewo',
    'ইওয়ে'                                                                            => 'ee',
    'ইওরুবা'                                                                         => 'yo',
    'ইকাজুক'                                                                         => 'eka',
    'ইগ্‌বো'                                                                         => 'ig',
    'ইঙ্গুশ'                                                                         => 'inh',
    'ইজো'                                                                                  => 'ijo',
    'ইডো'                                                                                  => 'io',
    'ইতালীয়'                                                                      => 'it',
    'ইনারিসামি'                                                                => 'smn',
    'ইনুক্টিটুট'                                                             => 'iu',
    'ইনুপিয়াক'                                                                => 'ik',
    'ইন্টারলিঙ্গ'                                                          => 'ie',
    'ইন্টারলিঙ্গুয়া'                                              => 'ia',
    'ইন্দোইউরোপীয়ভাষা'                                        => 'ine',
    'ইন্দোনেশীয়'                                                          => 'id',
    'ইবান'                                                                               => 'iba',
    'ইয়াও'                                                                            => 'yao',
    'ইয়াকুট'                                                                      => 'sah',
    'ইয়াপেসে'                                                                   => 'yap',
    'ইয়ুপিকভাষা'                                                          => 'ypk',
    'ইরানীভাষা'                                                                => 'ira',
    'ইরোকোইয়ানভাষা'                                                 => 'iro',
    'ইলোকো'                                                                            => 'ilo',
    'উওলোফ'                                                                            => 'wo',
    'উগারিটিক'                                                                   => 'uga',
    'উচ্চসোর্বিয়ান'                                                 => 'hsb',
    'উজবেকীয়'                                                                   => 'uz',
    'উডমুর্ট'                                                                      => 'udm',
    'উড়িয়া'                                                                      => 'or',
    'উত্তরআমেরিকানইন্ডিয়ানভাষা'             => 'sai',
    'উত্তরএন্দেবিলি'                                                 => 'nd',
    'উত্তরাঞ্চলীয়ফ্রিসিয়ান'                      => 'frr',
    'উত্তরাঞ্চলীয়সামি'                                        => 'se',
    'উত্তরাঞ্চলীয়সোথো'                                        => 'nso',
    'উত্তৱআমেরিকারইন্ডিয়ানভাষা'             => 'nai',
    'উম্বুন্দু'                                                                => 'umb',
    'উর্দু'                                                                            => 'ur',
    "এন্\.জিমা"                                                                    => 'nzi',
    'এন্দোঙ্গা'                                                                => 'ng',
    'এন’কো'                                                                            => 'nqo',
    'এফিক'                                                                               => 'efi',
    'এরজিয়া'                                                                      => 'myv',
    'এলামাইট'                                                                      => 'elx',
    'এস্তোনীয়'                                                                => 'et',
    'এস্পেরান্তো'                                                          => 'eo',
    'ওজিবওয়া'                                                                   => 'oj',
    'ওয়াকাশানভাষা'                                                    => 'wak',
    'ওয়ারে'                                                                         => 'war',
    'ওয়ালামো'                                                                   => 'wal',
    'ওয়ালুন'                                                                      => 'wa',
    'ওয়াশো'                                                                         => 'was',
    'ওয়েলশ'                                                                         => 'cy',
    'ওসেজ'                                                                               => 'osa',
    'ওসেটিক'                                                                         => 'os',
    'ককেশীয'                                                                         => 'cau',
    'কপটিক'                                                                            => 'cop',
    'কমোরিয়ান'                                                                => 'swb',
    'কর্ণিশ'                                                                         => 'kw',
    'কর্সিকান'                                                                   => 'co',
    'কাউই'                                                                               => 'kaw',
    'কাচিন'                                                                            => 'kac',
    'কাজাখ'                                                                            => 'kk',
    'কাতালান'                                                                      => 'ca',
    'কানাডীয়ইংরেজি'                                                 => 'en_ca',
    'কানাডীয়ফরাসি'                                                    => 'fr_ca',
    'কানুরি'                                                                         => 'kr',
    'কান্নাড়ী'                                                                => 'kn',
    'কাবাইলে'                                                                      => 'kab',
    'কাবার্ডিয়ান'                                                       => 'kbd',
    'কাম্বা'                                                                         => 'kam',
    'কারচেবাল্কার'                                                       => 'krc',
    'কারাকাল্পাক'                                                          => 'kaa',
    'কারেন'                                                                            => 'kar',
    'কারেলিয়ান'                                                             => 'krl',
    'কাল্মইক'                                                                      => 'xal',
    'কাশুবিয়ান'                                                             => 'csb',
    'কাশ্মীরী'                                                                   => 'ks',
    'কিকু্ইয়ু'                                                                => 'ki',
    'কিনয়ারোয়ান্ডা'                                              => 'rw',
    'কিম্বুন্দু'                                                             => 'kmb',
    'কির্গিজ'                                                                      => 'ky',
    'কুটেনাই'                                                                      => 'kut',
    'কুমিক'                                                                            => 'kum',
    'কুরুখ'                                                                            => 'kru',
    'কুর্দি'                                                                         => 'ku',
    'কুশিতিকভাষা'                                                          => 'cus',
    'কৃত্রিম'                                                                      => 'art',
    'কেচুয়া'                                                                      => 'qu',
    'কেল্টিক'                                                                      => 'cel',
    'কোঙ্কানি'                                                                   => 'kok',
    'কোঙ্গো'                                                                         => 'kg',
    'কোমি'                                                                               => 'kv',
    'কোয়ানিয়ামা'                                                       => 'kj',
    'কোরিয়ান'                                                                   => 'ko',
    'কোরো'                                                                               => 'kfo',
    'কোস্রাইন'                                                                   => 'kos',
    'ক্যাডো'                                                                         => 'cad',
    'ক্যানটোনীজ'                                                             => 'yue',
    'ক্যারিব'                                                                      => 'car',
    'ক্যালাল্লিসুট'                                                    => 'kl',
    'ক্রি'                                                                               => 'cr',
    'ক্রিক'                                                                            => 'mus',
    'ক্রিমিয়ানতুর্কি'                                           => 'crh',
    'ক্রু'                                                                               => 'kro',
    'ক্রেওলঅথবাপিজিন'                                              => 'crp',
    'ক্রোয়েশীয়'                                                          => 'hr',
    'ক্লিঙ্গন'                                                                   => 'tlh',
    'ক্‌পেল্লে'                                                                => 'kpe',
    'খমের'                                                                               => 'km',
    'খাশি'                                                                               => 'kha',
    'খোটানিজ'                                                                      => 'kho',
    'খোয়েশানভাষা'                                                       => 'khi',
    'গওইচ্’ইন'                                                                   => 'gwi',
    'গথিক'                                                                               => 'got',
    'গা'                                                                                     => 'gaa',
    'গায়ো'                                                                            => 'gay',
    'গিলবার্টিজ'                                                             => 'gil',
    'গীজ'                                                                                  => 'gez',
    'গুজরাটি'                                                                      => 'gu',
    'গুয়ারানি'                                                                => 'gn',
    'গোন্ডি'                                                                         => 'gon',
    'গোরোন্তালো'                                                             => 'gor',
    'গ্যান্ডা'                                                                   => 'lg',
    'গ্যালিশিয়'                                                             => 'gl',
    'গ্রিক'                                                                            => 'el',
    'গ্রেবো'                                                                         => 'grb',
    'চক্টো'                                                                            => 'cho',
    'চাগাতাই'                                                                      => 'chg',
    'চামিকভাষা'                                                                => 'cmc',
    'চামেরো'                                                                         => 'ch',
    'চার্চস্লাভিও'                                                       => 'cu',
    'চিত্রভাষা'                                                                => 'zbl',
    'চিনুকপরিভাষা'                                                       => 'chn',
    'চিপেওয়ান'                                                                => 'chp',
    'চিবচা'                                                                            => 'chb',
    'চিহ্নভাষা'                                                                => 'sgn',
    'চীনা'                                                                               => 'zh',
    'চুকি'                                                                               => 'chk',
    'চুবাস'                                                                            => 'cv',
    'চেক'                                                                                  => 'cs',
    'চেচেন'                                                                            => 'ce',
    'চেবুয়ানো'                                                                => 'ceb',
    'চেরোকি'                                                                         => 'chr',
    'জর্জিয়ান'                                                                => 'ka',
    'জাজা'                                                                               => 'zza',
    'জান্ডে'                                                                         => 'znd',
    'জাপানি'                                                                         => 'ja',
    'জাপোটেক'                                                                      => 'zap',
    'জাভানি'                                                                         => 'jv',
    'জার্মান'                                                                      => 'de',
    'জার্মানিকভাষা'                                                    => 'gem',
    'জুদেওআরবি'                                                                => 'jrb',
    'জুদেওফার্সি'                                                          => 'jpr',
    'জুনি'                                                                               => 'zun',
    'জুলু'                                                                               => 'zu',
    'জেনাগা'                                                                         => 'zen',
    'জোসা'                                                                               => 'xh',
    'ঝু্য়াঙ'                                                                      => 'za',
    'টঙ্গা'                                                                            => 'to',
    'টাইগ্রে'                                                                      => 'tig',
    'টাইম্নে'                                                                      => 'tem',
    'টাইয়াপ'                                                                      => 'kcg',
    'টিভ'                                                                                  => 'tiv',
    'টুভালু'                                                                         => 'tvl',
    'টুভিনিয়ান'                                                             => 'tyv',
    'টোকপিসিন'                                                                   => 'tpi',
    'টোকেলাউ'                                                                      => 'tkl',
    'টোয়াই'                                                                         => 'tw',
    'ডাকোটা'                                                                         => 'dak',
    'ডাচ'                                                                                  => 'nl',
    'ডিংকা'                                                                            => 'din',
    'ডিউলা'                                                                            => 'dyu',
    'ডেনিশ'                                                                            => 'da',
    'ডেলাওয়ের'                                                                => 'del',
    'তাইভাষা'                                                                      => 'tai',
    'তাগালগ'                                                                         => 'tl',
    'তাজিক'                                                                            => 'tg',
    'তাতার'                                                                            => 'tt',
    'তামাশেক'                                                                      => 'tmh',
    'তামিল'                                                                            => 'ta',
    'তাহিতিয়ান'                                                             => 'ty',
    'তিগরিনিয়া'                                                             => 'ti',
    'তিব্বতি'                                                                      => 'bo',
    'তুপিভাষা'                                                                   => 'tup',
    'তুম্বুকা'                                                                   => 'tum',
    'তুর্কমেনী'                                                                => 'tk',
    'তুর্কী'                                                                         => 'tr',
    'তেতুম'                                                                            => 'tet',
    'তেরেনো'                                                                         => 'ter',
    'তেলেগু'                                                                         => 'te',
    'ত্লিঙ্গিট'                                                                => 'tli',
    'থাই'                                                                                  => 'th',
    'দক্ষিণএনডেবেলে'                                                 => 'nr',
    'দক্ষিণাঞ্চলীয়সামি'                                     => 'sma',
    'দক্ষিনআলতাই'                                                          => 'alt',
    'দক্ষিনসোথো'                                                             => 'st',
    'দায়াক'                                                                         => 'day',
    'দার্গওয়া'                                                                => 'dar',
    'দিবেহি'                                                                         => 'dv',
    'দুয়ালা'                                                                      => 'dua',
    'দোগরি'                                                                            => 'doi',
    'দোগ্রীব'                                                                      => 'dgr',
    'দ্রাবীড়ভাষা'                                                       => 'dra',
    'নরওয়েজীয়'                                                             => 'no',
    'নরওয়েজীয়াননিনর্স্ক'                               => 'nn',
    'নরওয়েবোকমাল'                                                       => 'nb',
    'নাইজারকোর্ডোফানিয়ানভাষা'                   => 'nic',
    'নাউরু'                                                                            => 'na',
    'নাভাজো'                                                                         => 'nv',
    'নায়াঞ্জা'                                                                => 'ny',
    'নায়াসাটোঙ্গা'                                                    => 'tog',
    'নাহুৎল'                                                                         => 'nah',
    'নিউয়ান'                                                                      => 'niu',
    'নিম্নজার্মানি'                                                    => 'nds',
    'নিম্নতরসোর্বিয়ান'                                        => 'dsb',
    'নিয়াস'                                                                         => 'nia',
    'নিলোসাহারানভাষা'                                              => 'ssa',
    'নুবিয়ানভাষা'                                                       => 'nub',
    'নেওয়ারি'                                                                   => 'new',
    'নেপালী'                                                                         => 'ne',
    'নেয়াপোলিটান'                                                       => 'nap',
    'নোগাই'                                                                            => 'nog',
    'ন্যায়াঙ্কোলে'                                                    => 'nyn',
    'ন্যায়ামওয়েজি'                                                 => 'nym',
    'ন্যোরো'                                                                         => 'nyo',
    'পর্তুগীজ'                                                                   => 'pt',
    'পশ্চিমফ্রিসিয়'                                                 => 'fy',
    'পাঙ্গাসিনান'                                                          => 'pag',
    'পাঞ্জাবী'                                                                   => 'pa',
    'পাপিয়ামেন্টো'                                                    => 'pap',
    'পাপুয়ানভাষা'                                                       => 'paa',
    'পাম্পাঙ্গা'                                                             => 'pam',
    'পালায়ুয়ান'                                                          => 'pau',
    'পালি'                                                                               => 'pi',
    'পাহ্লাভি'                                                                   => 'pal',
    'পুশতো'                                                                            => 'ps',
    'পূর্বফ্রিসিয়'                                                    => 'frs',
    'পোর্তুগিজভিত্তিকক্রেওলবাপিজন'       => 'cpp',
    'পোলিশ'                                                                            => 'pl',
    'পোহ্নপেইয়ান'                                                       => 'pon',
    'প্রাকৃতভাষা'                                                          => 'pra',
    'প্রাচীনআইরিশ'                                                       => 'sga',
    'প্রাচীনইংরেজী'                                                    => 'ang',
    'প্রাচীনউচ্চজার্মানি'                                  => 'goh',
    'প্রাচীনগ্রীক'                                                       => 'grc',
    'প্রাচীননর্স'                                                          => 'non',
    'প্রাচীননেওয়ারী'                                              => 'nwc',
    'প্রাচীনপ্রোভেনসাল'                                        => 'pro',
    'প্রাচীনফরাসি'                                                       => 'fro',
    'প্রাচীনফার্সি'                                                    => 'peo',
    'প্রাচীনমিশরীয়'                                                 => 'egy',
    'প্রাচীনসিরিও'                                                       => 'syc',
    'ফন'                                                                                     => 'fon',
    'ফরাসি'                                                                            => 'fr',
    'ফরাসিজাতক্রেওলঅথবাপিজিন'                      => 'cpf',
    'ফান্তি'                                                                         => 'fat',
    'ফার্সি'                                                                         => 'fa',
    'ফিজিও'                                                                            => 'fj',
    'ফিনিশ'                                                                            => 'fi',
    'ফিনোইউগ্রিক'                                                          => 'fiu',
    'ফিলিপাইনভাষা'                                                       => 'phi',
    'ফিলিপিনো'                                                                   => 'fil',
    'ফুলাহ্'                                                                         => 'ff',
    'ফেরাউনি'                                                                      => 'fo',
    'ফোনিশীয়ান'                                                             => 'phn',
    'ফ্যাঙ্গ'                                                                      => 'fan',
    'ফ্রিউলিয়ান'                                                          => 'fur',
    'ফ্লেমিশ'                                                                      => 'nl_be',
    'বর্মি'                                                                            => 'my',
    'বসনীয়'                                                                         => 'bs',
    'বহুগুণিতকভাষাসমূহ'                                        => 'mul',
    'বাংলা'                                                                            => 'bn',
    'বাতাক'                                                                            => 'btk',
    'বান্টু'                                                                         => 'bnt',
    'বান্দা'                                                                         => 'bad',
    'বামবারা'                                                                      => 'bm',
    'বামিলেকেভাষা'                                                       => 'bai',
    'বায়া'                                                                            => 'gba',
    'বালিনীয়'                                                                   => 'ban',
    'বাল্টিকভাষা'                                                          => 'bat',
    'বাশকির'                                                                         => 'ba',
    'বাসা'                                                                               => 'bas',
    'বাস্ক'                                                                            => 'eu',
    'বিকোল'                                                                            => 'bik',
    'বিনি'                                                                               => 'bin',
    'বিবিধভাষা'                                                                => 'mis',
    'বিসলামা'                                                                      => 'bi',
    'বিহারি'                                                                         => 'bh',
    'বুগিনি'                                                                         => 'bug',
    'বুরিয়াত'                                                                   => 'bua',
    'বুলগেরিয়'                                                                => 'bg',
    'বেজা'                                                                               => 'bej',
    'বেম্বা'                                                                         => 'bem',
    'বেরবের'                                                                         => 'ber',
    'বেলারুশিয়'                                                             => 'be',
    'বেলুচী'                                                                         => 'bal',
    'ব্রাজ'                                                                            => 'bra',
    'ব্রাজিলীয়পর্তুগীজ'                                     => 'pt_br',
    'ব্রিটিশইংরেজি'                                                    => 'en_gb',
    'ব্রেটোন'                                                                      => 'br',
    'ব্লিন'                                                                            => 'byn',
    'ভাই'                                                                                  => 'vai',
    'ভারতীয়ভাষা'                                                          => 'inc',
    'ভাষাতাত্তিকবিষয়সূচীবহির্ভুত'       => 'zxx',
    'ভিয়েতনামী'                                                             => 'vi',
    'ভুটানি'                                                                         => 'dz',
    'ভেন্ডা'                                                                         => 've',
    'ভোজপুরি'                                                                      => 'bho',
    'ভোটিক'                                                                            => 'vot',
    'ভোলাপুক'                                                                      => 'vo',
    'মঙ্গোলিয়'                                                                => 'mn',
    'মণিপুরী'                                                                      => 'mni',
    'মধ্যআইরিশ'                                                                => 'mga',
    'মধ্যইংরেজি'                                                             => 'enm',
    'মধ্যউচ্চজার্মানি'                                           => 'gmh',
    'মধ্যডাচ'                                                                      => 'dum',
    'মধ্যফরাসি'                                                                => 'frm',
    'মধ্যযুক্তরাষ্ঠেরআদিবাসীদেরভাষা' => 'cai',
    'মনখমেরভাষা'                                                             => 'mkh',
    'মলদাভিয়'                                                                   => 'mo',
    'মল্টিয়'                                                                      => 'mt',
    'মসি'                                                                                  => 'mos',
    'মাওরি'                                                                            => 'mi',
    'মাগাহি'                                                                         => 'mag',
    'মাঞ্চু'                                                                         => 'mnc',
    'মাদুরেসে'                                                                   => 'mad',
    'মায়ানভাষা'                                                             => 'myn',
    'মারাঠি'                                                                         => 'mr',
    'মারি'                                                                               => 'chm',
    'মারোয়ারি'                                                                => 'mwr',
    'মার্শালিজ'                                                                => 'mh',
    'মালাগাসি'                                                                   => 'mg',
    'মালে'                                                                               => 'ms',
    'মালেয়ালাম'                                                             => 'ml',
    'মাসাই'                                                                            => 'mas',
    'মিকম্যাক'                                                                   => 'mic',
    'মিনাঙ্গ্‌কাবাউ'                                                 => 'min',
    'মিরান্ডিজ'                                                                => 'mwl',
    'মুণ্ডাভাষা'                                                             => 'mun',
    'মেন্ডে'                                                                         => 'men',
    'মৈথিলি'                                                                         => 'mai',
    'মোকশা'                                                                            => 'mdf',
    'মোঙ্গো'                                                                         => 'lol',
    'মোহাওক'                                                                         => 'moh',
    'ম্যাকাসার'                                                                => 'mak',
    'ম্যাঙ্কস'                                                                   => 'gv',
    'ম্যাণ্ডার'                                                                => 'mdr',
    'ম্যানোবোভাষা'                                                       => 'mno',
    'ম্যান্ডিঙ্গো'                                                       => 'man',
    'ম্যাসেডোনীয'                                                          => 'mk',
    'য়িদ্দিশ'                                                                   => 'yi',
    'যুক্তরাষ্ট্রইংরেজি'                                     => 'en_us',
    'রাজস্থানী'                                                                => 'raj',
    'রাপানুই'                                                                      => 'rap',
    'রারোটোংগান'                                                             => 'rar',
    'রুন্দি'                                                                         => 'rn',
    'রুশ'                                                                                  => 'ru',
    'রেটোরোমানীয়'                                                       => 'rm',
    'রোমানভাষা'                                                                => 'roa',
    'রোমানি'                                                                         => 'rom',
    'রোমানীয়'                                                                   => 'ro',
    'লাও'                                                                                  => 'lo',
    'লাটিন'                                                                            => 'la',
    'লাডিনো'                                                                         => 'lad',
    'লাত্‌ভীয়'                                                                => 'lv',
    'লান্ডা'                                                                         => 'lah',
    'লাম্বা'                                                                         => 'lam',
    'লিঙ্গালা'                                                                   => 'ln',
    'লিথুয়েনীয'                                                             => 'lt',
    'লিম্বুর্গিশ'                                                          => 'li',
    'লুইসেনো'                                                                      => 'lui',
    'লুক্সেমবার্গীয়'                                              => 'lb',
    'লুন্ডা'                                                                         => 'lun',
    'লুবাকাটাঙ্গা'                                                       => 'lu',
    'লুবালুলুয়া'                                                          => 'lua',
    'লুয়ো'                                                                            => 'luo',
    'লুলেসামি'                                                                   => 'smj',
    'লুশাই'                                                                            => 'lus',
    'লেজঘিয়ান'                                                                => 'lez',
    'লোজবান'                                                                         => 'jbo',
    'লোজি'                                                                               => 'loz',
    'শাইয়েন'                                                                      => 'chy',
    'শান'                                                                                  => 'shn',
    'শালিশানভাষা'                                                          => 'sal',
    'শোনা'                                                                               => 'sn',
    'সংষ্কৃত'                                                                      => 'sa',
    'সঙ্গা'                                                                            => 'ts',
    'সাঁওতালি'                                                                   => 'sat',
    'সাঙ্গো'                                                                         => 'sg',
    'সামারিটানআরামিক'                                              => 'sam',
    'সামিভাষা'                                                                   => 'smi',
    'সামোয়ান'                                                                   => 'sm',
    'সার্ডিনিয়ান'                                                       => 'sc',
    'সার্বীয়'                                                                   => 'sr',
    'সার্বোক্রোয়েশিয়'                                        => 'sh',
    'সাসাক'                                                                            => 'sas',
    'সিংহলী'                                                                         => 'si',
    'সিওয়ুয়ানভাষা'                                                 => 'sio',
    'সিকসিকা'                                                                      => 'bla',
    'সিচুয়ানয়ি'                                                          => 'ii',
    'সিডামো'                                                                         => 'sid',
    'সিনোতিব্বোতীয়ভাষা'                                     => 'sit',
    'সিন্ধি'                                                                         => 'sd',
    'সিমশিয়ান'                                                                => 'tsi',
    'সিরিয়াক'                                                                   => 'syr',
    'সিসিলিয়ান'                                                             => 'scn',
    'সুইডিশ'                                                                         => 'sv',
    'সুইসউচ্চজার্মানি'                                           => 'de_ch',
    'সুইসজার্মান'                                                          => 'gsw',
    'সুইসফরাসি'                                                                => 'fr_ch',
    'সুকুমা'                                                                         => 'suk',
    'সুদানী'                                                                         => 'su',
    'সুমেরীয়'                                                                   => 'sux',
    'সুসু'                                                                               => 'sus',
    'সেমেটিকভাষা'                                                          => 'sem',
    'সেরের'                                                                            => 'srr',
    'সেল্কুপ'                                                                      => 'sel',
    'সোগডিয়ান'                                                                => 'sog',
    'সোঙ্গহাই'                                                                   => 'son',
    'সোনিঙ্কে'                                                                   => 'snk',
    'সোমালী'                                                                         => 'so',
    'সোয়াতি'                                                                      => 'ss',
    'সোয়ানা'                                                                      => 'tn',
    'সোয়াহিলি'                                                                => 'sw',
    'সোরবিয়ানভাষা'                                                    => 'wen',
    'স্কটস'                                                                            => 'sco',
    'স্কটসগ্যেলিক'                                                       => 'gd',
    'স্কোল্টসামি'                                                          => 'sms',
    'স্পেনীয়'                                                                   => 'es',
    'স্যান্ডাওয়ে'                                                       => 'sad',
    'স্রানানটোঙ্গো'                                                    => 'srn',
    'স্লোভাক'                                                                      => 'sk',
    'স্লোভেনীয়'                                                             => 'sl',
    'স্ল্যাভ'                                                                      => 'den',
    'স্ল্যাভিকভাষা'                                                    => 'sla',
    'হাইডা'                                                                            => 'hai',
    'হাইতিয়ান'                                                                => 'ht',
    'হাউসা'                                                                            => 'ha',
    'হাওয়াইয়ান'                                                          => 'haw',
    'হাঙ্গেরীয়'                                                             => 'hu',
    'হিট্টিট'                                                                      => 'hit',
    'হিন্দি'                                                                         => 'hi',
    'হিব্রু'                                                                         => 'he',
    'হিমাচালি'                                                                   => 'him',
    'হিরিমোতু'                                                                   => 'ho',
    'হিলিগ্যায়নোন'                                                    => 'hil',
    'হুপা'                                                                               => 'hup',
    'হেরেরো'                                                                         => 'hz',
    'হ্‌মোঙ'                                                                         => 'hmn',
);

1;
