/*  $Id: conf.h,v 1.13 2005/01/26 22:22:25 marcusva Exp $
 *
 *  This file is part of LingoTeach, the Language Teaching program 
 *  Copyright (C) 2001-2003 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by 
 *  the Free Software Foundation; either version 2 of the License, or 
 *  (at your option) any later version.  
 *
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *  GNU General Public License for more details.  
 *
 *  You should have received a copy of the GNU General Public License 
 *  along with this program; if not, write to the Free Software 
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#ifndef LING_CONF_H
#define LING_CONF_H 1

#include <libxml/xpath.h>

/* private data structure containing the language xml document pointer and
 * the DTD specs. Used by lingConfig  as lingConfig->pdata
 */
typedef struct
{
     xmlXPathContextPtr lang;       /* pointer to the language xml */
     xmlDtdPtr          lang_dtd;   /* the language DTD */
     xmlDtdPtr          lesson_dtd; /* the DTD for lesson files */
} lingPrivateConfig;


#endif /* LING_CONF_H */
