/*
 * Copyright (C) 2012  Christian Mollekopf <mollekopf@kolabsys.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef KOLABCOMMONCONVERSION_H
#define KOLABCOMMONCONVERSION_H

#include <KDE/KDateTime>
#include <QStringList>
#include <kolab/kolabcontainers.h>


namespace Kolab {
    namespace Conversion {
        KDateTime toDate(const Kolab::cDateTime &dt);
        cDateTime fromDate(const KDateTime &dt);
        QStringList toStringList(const std::vector<std::string> &l);
        std::vector<std::string> fromStringList(const QStringList &l);
    };
};

#endif