/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.InputStreamSetterArgs;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TDSChannel;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;

final class TDSWriter {
    private static Logger logger;
    private final boolean isLoggable = logger.isLoggable(Level.FINEST);
    private final TDSChannel tdsChannel;
    private final SQLServerConnection con;
    private boolean dataIsLoggable = true;
    private byte tdsMessageType;
    private static final byte TDS_MESSAGE_STATUS_NORMAL = 0;
    private static final byte TDS_MESSAGE_STATUS_EOM = 1;
    private static final byte TDS_MESSAGE_STATUS_ATTENTION = 2;
    private static final byte TDS_MESSAGE_STATUS_RESET_CONN = 8;
    private boolean atEOM = false;
    private volatile boolean attentionRaised = false;
    private SQLServerException attentionReason = null;
    private int currentPacketSize = 0;
    private static final int TDS_PACKET_HEADER_SIZE = 8;
    private static final byte[] placeholderHeader;
    private byte[] valueBytes = new byte[256];
    private int packetNum = 0;
    private ByteBuffer stagingBuffer;
    private ByteBuffer socketBuffer;
    private ByteBuffer logBuffer;
    static final /* synthetic */ boolean $assertionsDisabled;

    final String toLogString() {
        return "TDSWriter@" + Integer.toHexString(this.hashCode()) + " (" + this.con.toLogString() + ")";
    }

    void setDataLoggable(boolean bl) {
        this.dataIsLoggable = bl;
    }

    TDSWriter(TDSChannel tDSChannel, SQLServerConnection sQLServerConnection) {
        this.tdsChannel = tDSChannel;
        this.con = sQLServerConnection;
    }

    void preparePacket() throws SQLServerException {
        if (this.atEOM) {
            return;
        }
        if (this.tdsChannel.isLoggingPackets()) {
            Arrays.fill(this.logBuffer.array(), (byte)-2);
            this.logBuffer.clear();
        }
        this.writeBytes(placeholderHeader);
    }

    void writeMessageHeader() throws SQLServerException {
        if ((1 == this.tdsMessageType || 14 == this.tdsMessageType || 3 == this.tdsMessageType) && this.con.isYukonOrLater()) {
            this.writeInt(22);
            this.writeInt(18);
            this.writeShort((short)2);
            this.writeBytes(this.con.getTransactionDescriptor());
            this.writeInt(1);
        }
    }

    TDSWriter startMessage(byte by) throws SQLServerException {
        this.tdsMessageType = by;
        this.atEOM = false;
        if (6 != by) {
            this.attentionRaised = false;
            this.attentionReason = null;
        }
        this.packetNum = 0;
        this.dataIsLoggable = true;
        int n = this.con.getTDSPacketSize();
        if (this.currentPacketSize != n) {
            this.socketBuffer = ByteBuffer.allocate(n).order(ByteOrder.LITTLE_ENDIAN);
            this.stagingBuffer = ByteBuffer.allocate(n).order(ByteOrder.LITTLE_ENDIAN);
            this.logBuffer = ByteBuffer.allocate(n).order(ByteOrder.LITTLE_ENDIAN);
            this.tdsChannel.setSendBufferSize(n);
            this.currentPacketSize = n;
        }
        this.socketBuffer.position(this.socketBuffer.limit());
        this.stagingBuffer.clear();
        this.preparePacket();
        this.writeMessageHeader();
        return this;
    }

    final void endMessage() throws SQLServerException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toLogString() + " Finishing TDS message");
        }
        this.writePacket(1);
    }

    final void raiseAttention(SQLServerException sQLServerException) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toLogString() + " Raising attention reason:" + sQLServerException.getMessage());
        }
        if (!$assertionsDisabled && 1 != sQLServerException.getDriverErrorCode()) {
            throw new AssertionError();
        }
        this.attentionReason = sQLServerException;
        this.attentionRaised = true;
    }

    void writeByte(byte by) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 1) {
            this.stagingBuffer.put(by);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.put(by);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 1);
                }
            }
        } else {
            this.valueBytes[0] = by;
            this.writeWrappedBytes(this.valueBytes, 1);
        }
    }

    void writeTinyInt(short s) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 1) {
            this.stagingBuffer.put((byte)(s & 0xFF));
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.put((byte)(s & 0xFF));
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 1);
                }
            }
        } else {
            this.valueBytes[0] = (byte)(s & 0xFF);
            this.writeWrappedBytes(this.valueBytes, 1);
        }
    }

    void writeChar(char c) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 2) {
            this.stagingBuffer.putChar(c);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.putChar(c);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 2);
                }
            }
        } else {
            Util.writeShort((short)c, this.valueBytes, 0);
            this.writeWrappedBytes(this.valueBytes, 2);
        }
    }

    void writeShort(short s) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 2) {
            this.stagingBuffer.putShort(s);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.putShort(s);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 2);
                }
            }
        } else {
            Util.writeShort(s, this.valueBytes, 0);
            this.writeWrappedBytes(this.valueBytes, 2);
        }
    }

    void writeInt(int n) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 4) {
            this.stagingBuffer.putInt(n);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.putInt(n);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 4);
                }
            }
        } else {
            Util.writeInt(n, this.valueBytes, 0);
            this.writeWrappedBytes(this.valueBytes, 4);
        }
    }

    void writeLong(long l) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 8) {
            this.stagingBuffer.putLong(l);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.putLong(l);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 8);
                }
            }
        } else {
            this.valueBytes[0] = (byte)(l >> 0 & 0xFFL);
            this.valueBytes[1] = (byte)(l >> 8 & 0xFFL);
            this.valueBytes[2] = (byte)(l >> 16 & 0xFFL);
            this.valueBytes[3] = (byte)(l >> 24 & 0xFFL);
            this.valueBytes[4] = (byte)(l >> 32 & 0xFFL);
            this.valueBytes[5] = (byte)(l >> 40 & 0xFFL);
            this.valueBytes[6] = (byte)(l >> 48 & 0xFFL);
            this.valueBytes[7] = (byte)(l >> 56 & 0xFFL);
            this.writeWrappedBytes(this.valueBytes, 8);
        }
    }

    void writeBytes(byte[] byArray) throws SQLServerException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    void writeBytes(byte[] byArray, int n, int n2) throws SQLServerException {
        int n3;
        int n4 = 0;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toLogString() + " Writing " + n2 + " bytes");
        }
        while ((n3 = n2 - n4) > 0) {
            if (0 == this.stagingBuffer.remaining()) {
                this.writePacket(0);
            }
            if (n3 > this.stagingBuffer.remaining()) {
                n3 = this.stagingBuffer.remaining();
            }
            this.stagingBuffer.put(byArray, n + n4, n3);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.put(byArray, n + n4, n3);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + n3);
                }
            }
            n4 += n3;
        }
    }

    void writeChars(char[] cArray, int n) throws SQLServerException {
        byte[] byArray = new byte[8000];
        int n2 = 0;
        do {
            int n3 = 0;
            while (n2 < n && n3 < byArray.length) {
                byArray[n3++] = (byte)(cArray[n2] >> 0 & 0xFF);
                byArray[n3++] = (byte)(cArray[n2] >> 8 & 0xFF);
                ++n2;
            }
            this.writeBytes(byArray, 0, n3);
        } while (n2 < n);
    }

    void writeWrappedBytes(byte[] byArray, int n) throws SQLServerException {
        int n2 = this.stagingBuffer.remaining();
        if (n2 > 0) {
            this.stagingBuffer.put(byArray, 0, n2);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.put(byArray, 0, n2);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + n2);
                }
            }
        }
        this.writePacket(0);
        this.stagingBuffer.put(byArray, n2, n - n2);
        if (this.tdsChannel.isLoggingPackets()) {
            if (this.dataIsLoggable) {
                this.logBuffer.put(byArray, n2, n - n2);
            } else {
                this.logBuffer.position(this.logBuffer.position() + n2);
            }
        }
    }

    void writeString(String string) throws SQLServerException {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3 = 2 * (n2 - n);
            if (n3 > this.valueBytes.length) {
                n3 = this.valueBytes.length;
            }
            int n4 = 0;
            while (n4 < n3) {
                char c = string.charAt(n++);
                this.valueBytes[n4++] = (byte)(c >> 0 & 0xFF);
                this.valueBytes[n4++] = (byte)(c >> 8 & 0xFF);
            }
            this.writeBytes(this.valueBytes, 0, n4);
        }
    }

    void writeStream(InputStream inputStream, long l, boolean bl) throws SQLServerException {
        int n;
        long l2 = 0L;
        byte[] byArray = new byte[8000];
        int n2 = 0;
        do {
            for (n = 0; -1 != n2 && n < byArray.length; n += n2) {
                try {
                    n2 = inputStream.read(byArray, n, byArray.length - n);
                }
                catch (IOException iOException) {
                    this.error(iOException.getMessage());
                }
                if (-1 == n2) break;
                if (n2 >= 0 && n2 <= byArray.length - n) continue;
                this.error(SQLServerException.getErrString("R_unexpectedIOExceptionProcessingInputStream"));
            }
            if (bl) {
                this.writeInt(n);
            }
            this.writeBytes(byArray, 0, n);
            l2 += (long)n;
        } while (-1 != n2 || n > 0);
        if (-1L != l && l2 != l) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_mismatchedStreamLength"));
            Object[] objectArray = new Object[]{new Long(l), new Long(l2)};
            this.error(messageFormat.format(objectArray));
        }
    }

    void writeReader(Reader reader, long l, boolean bl) throws SQLServerException {
        int n;
        if (!$assertionsDisabled && l < -1L) {
            throw new AssertionError();
        }
        long l2 = 0L;
        char[] cArray = new char[4000];
        int n2 = 0;
        do {
            for (n = 0; -1 != n2 && n < cArray.length; n += n2) {
                try {
                    n2 = reader.read(cArray, n, cArray.length - n);
                }
                catch (IOException iOException) {
                    this.error(iOException.getMessage());
                }
                if (-1 == n2) break;
                if (n2 >= 0 && n2 <= cArray.length - n) continue;
                this.error(SQLServerException.getErrString("R_unexpectedIOExceptionProcessingReader"));
            }
            if (bl) {
                this.writeInt(2 * n);
            }
            this.writeChars(cArray, n);
            l2 += (long)n;
        } while (-1 != n2 || n > 0);
        if (-1L != l && l2 != l) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_mismatchedStreamLength"));
            Object[] objectArray = new Object[]{new Long(l), new Long(l2)};
            this.error(messageFormat.format(objectArray));
        }
    }

    final void error(String string) throws SQLServerException {
        this.raiseAttention(SQLServerException.makeInterruptException(string));
        this.endMessage();
    }

    private final void writePacket(int n) throws SQLServerException {
        if (this.atEOM) {
            if (this.isLoggable) {
                logger.finest(this.toLogString() + ": Dropping packet...");
            }
            return;
        }
        if (6 != this.tdsMessageType && this.attentionRaised) {
            if (0 != this.packetNum) {
                ++this.tdsChannel.numMsgsSent;
            }
            if (this.isLoggable) {
                logger.finest(this.toLogString() + ": throwing interrupt exception, reason=" + this.attentionReason.getMessage());
            }
            throw this.attentionReason;
        }
        this.writePacketHeader(n);
        this.flush();
        if (this.atEOM) {
            this.flush();
            ++this.tdsChannel.numMsgsSent;
        }
        if (16 == this.tdsMessageType && 1 == this.packetNum && 0 == this.con.getNegotiatedEncryptionLevel()) {
            this.tdsChannel.disableSSL();
        }
    }

    final boolean sendAttention() throws SQLServerException {
        if (0 == this.packetNum) {
            return false;
        }
        if (this.isLoggable) {
            logger.finest(this.toLogString() + ": sending attention signal to server");
        }
        this.startMessage((byte)6).endMessage();
        if (this.isLoggable) {
            logger.finest(this.toLogString() + ": sent attention signal to server");
        }
        return true;
    }

    private final void writePacketHeader(int n) {
        int n2 = this.stagingBuffer.position();
        ++this.packetNum;
        this.stagingBuffer.put(0, this.tdsMessageType);
        this.stagingBuffer.put(1, (byte)n);
        this.stagingBuffer.put(2, (byte)(n2 >> 8 & 0xFF));
        this.stagingBuffer.put(3, (byte)(n2 >> 0 & 0xFF));
        this.stagingBuffer.putShort(4, (short)0);
        this.stagingBuffer.put(6, (byte)(this.packetNum % 256));
        this.stagingBuffer.put(7, (byte)0);
        if (this.tdsChannel.isLoggingPackets()) {
            this.logBuffer.put(0, this.tdsMessageType);
            this.logBuffer.put(1, (byte)n);
            this.logBuffer.put(2, (byte)(n2 >> 8 & 0xFF));
            this.logBuffer.put(3, (byte)(n2 >> 0 & 0xFF));
            this.logBuffer.putShort(4, (short)0);
            this.logBuffer.put(6, (byte)(this.packetNum % 256));
            this.logBuffer.put(7, (byte)0);
        }
        if (1 == (1 & n)) {
            this.atEOM = true;
        }
    }

    void flush() throws SQLServerException {
        this.tdsChannel.write(this.socketBuffer.array(), this.socketBuffer.position(), this.socketBuffer.remaining());
        this.socketBuffer.position(this.socketBuffer.limit());
        if (this.stagingBuffer.position() >= 8) {
            ByteBuffer byteBuffer = this.stagingBuffer;
            this.stagingBuffer = this.socketBuffer;
            this.socketBuffer = byteBuffer;
            this.socketBuffer.flip();
            this.stagingBuffer.clear();
            if (this.tdsChannel.isLoggingPackets()) {
                this.tdsChannel.logPacket(this.logBuffer.array(), 0, this.socketBuffer.limit(), this.toLogString() + " sending packet (" + this.socketBuffer.limit() + " bytes)");
            }
            this.preparePacket();
            this.tdsChannel.write(this.socketBuffer.array(), this.socketBuffer.position(), this.socketBuffer.remaining());
            this.socketBuffer.position(this.socketBuffer.limit());
        }
    }

    private void writeRPCNameValType(String string, boolean bl, int n) throws SQLServerException {
        int n2 = 0;
        if (null != string) {
            n2 = string.length() + 1;
        }
        this.writeByte((byte)n2);
        if (n2 > 0) {
            this.writeChar('@');
            this.writeString(string);
        }
        this.writeByte((byte)(bl ? 1 : 0));
        this.writeByte((byte)n);
    }

    void writeRPCBit(String string, Boolean bl, boolean bl2) throws SQLServerException {
        this.writeRPCNameValType(string, bl2, 104);
        this.writeByte((byte)1);
        if (null == bl) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)1);
            this.writeByte((byte)(bl != false ? 1 : 0));
        }
    }

    void writeRPCByte(String string, Byte by, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, 38);
        this.writeByte((byte)1);
        if (null == by) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)1);
            this.writeTinyInt(by.byteValue());
        }
    }

    void writeRPCShort(String string, Short s, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, 38);
        this.writeByte((byte)2);
        if (null == s) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)2);
            this.writeShort(s);
        }
    }

    void writeRPCInt(String string, Integer n, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, 38);
        this.writeByte((byte)4);
        if (null == n) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)4);
            this.writeInt(n);
        }
    }

    void writeRPCLong(String string, Long l, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, 38);
        this.writeByte((byte)8);
        if (null == l) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)8);
            this.writeLong(l);
        }
    }

    void writeRPCReal(String string, Float f, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, 109);
        if (null == f) {
            this.writeByte((byte)4);
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)4);
            this.writeByte((byte)4);
            this.writeInt(Float.floatToRawIntBits(f.floatValue()));
        }
    }

    void writeRPCDouble(String string, Double d, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, 109);
        int n = 8;
        this.writeByte((byte)n);
        if (null == d) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)n);
            long l = Double.doubleToLongBits(d);
            long l2 = 255L;
            int n2 = 0;
            for (int i = 0; i < 8; ++i) {
                this.writeByte((byte)((l & l2) >> n2));
                n2 += 8;
                l2 <<= 8;
            }
        }
    }

    void writeRPCBigDecimal(String string, BigDecimal bigDecimal, int n, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, 106);
        this.writeByte((byte)17);
        this.writeByte((byte)38);
        byte[] byArray = DDC.convertBigDecimalToBytes(bigDecimal, n);
        this.writeBytes(byArray, 0, byArray.length);
    }

    void writeVMaxHeader(long l, boolean bl, boolean bl2) throws SQLServerException {
        this.writeShort((short)-1);
        if (bl2) {
            this.con.getDatabaseCollation().writeCollation(this);
        }
        if (bl) {
            this.writeLong(-1L);
        } else if (-1L == l) {
            this.writeLong(-2L);
        } else {
            this.writeLong(l);
        }
    }

    void writeRPCString(String string) throws SQLServerException {
        this.writeRPCString(null, string, false, 12);
    }

    void writeRPCString(String string, String string2, boolean bl, int n) throws SQLServerException {
        boolean bl2;
        boolean bl3 = string2 == null;
        int n2 = bl3 ? 0 : 2 * string2.length();
        boolean bl4 = n2 <= 8000;
        boolean bl5 = bl2 = this.con.isYukonOrLater() && (!bl4 || bl);
        if (bl2) {
            this.writeRPCNameValType(string, bl, 231);
            this.writeVMaxHeader(n2, bl3, true);
            if (!bl3) {
                if (n2 > 0) {
                    this.writeInt(n2);
                    this.writeString(string2);
                }
                this.writeInt(0);
            }
        } else {
            if (bl4) {
                this.writeRPCNameValType(string, bl, 231);
                this.writeShort((short)8000);
            } else {
                this.writeRPCNameValType(string, bl, 99);
                this.writeInt(Integer.MAX_VALUE);
            }
            this.con.getDatabaseCollation().writeCollation(this);
            if (bl3) {
                this.writeShort((short)-1);
            } else {
                if (bl4) {
                    this.writeShort((short)n2);
                } else {
                    this.writeInt(n2);
                }
                if (0 != n2) {
                    this.writeString(string2);
                }
            }
        }
    }

    void writeRPCByteArray(String string, byte[] byArray, boolean bl, int n) throws SQLServerException {
        boolean bl2;
        boolean bl3 = byArray == null;
        int n2 = bl3 ? 0 : byArray.length;
        boolean bl4 = n2 <= 8000;
        boolean bl5 = bl2 = this.con.isYukonOrLater() && (!bl4 || bl);
        if (bl2) {
            this.writeRPCNameValType(string, bl, DataTypes.isBinaryJDBCType(n) ? 165 : 167);
            this.writeVMaxHeader(n2, bl3, !DataTypes.isBinaryJDBCType(n));
            if (!bl3) {
                if (n2 > 0) {
                    this.writeInt(n2);
                    this.writeBytes(byArray);
                }
                this.writeInt(0);
            }
        } else {
            if (bl4) {
                this.writeRPCNameValType(string, bl, DataTypes.isBinaryJDBCType(n) ? 165 : 167);
                this.writeShort((short)8000);
            } else {
                this.writeRPCNameValType(string, bl, DataTypes.isBinaryJDBCType(n) ? 34 : 35);
                this.writeInt(Integer.MAX_VALUE);
            }
            if (!DataTypes.isBinaryJDBCType(n)) {
                this.con.getDatabaseCollation().writeCollation(this);
            }
            if (bl3) {
                this.writeShort((short)-1);
            } else {
                if (bl4) {
                    this.writeShort((short)n2);
                } else {
                    this.writeInt(n2);
                }
                if (0 != n2) {
                    this.writeBytes(byArray);
                }
            }
        }
    }

    void writeRPCTimestamp(String string, Calendar calendar, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, 111);
        this.writeByte((byte)8);
        if (null == calendar) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)8);
            Util.writeTimestamp(calendar, this);
        }
    }

    void writeRPCInputStream(String string, InputStream inputStream, InputStreamSetterArgs inputStreamSetterArgs, boolean bl) throws SQLServerException {
        boolean bl2;
        if (!$assertionsDisabled && inputStreamSetterArgs.length < -1L) {
            throw new AssertionError();
        }
        boolean bl3 = inputStream == null;
        boolean bl4 = bl2 = 1 == inputStreamSetterArgs.streamType;
        if (this.con.isYukonOrLater() && !bl3 && (-1L == inputStreamSetterArgs.length || inputStreamSetterArgs.length > 8000L)) {
            if (inputStreamSetterArgs.length > 0x7FFFFFFDL) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
                Object[] objectArray = new Object[]{new Long(inputStreamSetterArgs.length)};
                this.error(messageFormat.format(objectArray));
            }
            this.writeRPCNameValType(string, bl, bl2 ? 165 : 167);
            this.writeVMaxHeader(inputStreamSetterArgs.length, false, !bl2);
            this.writeStream(inputStream, inputStreamSetterArgs.length, true);
        } else {
            boolean bl5;
            if (!$assertionsDisabled && !bl3 && inputStreamSetterArgs.length < 0L) {
                throw new AssertionError();
            }
            if (!bl3 && inputStreamSetterArgs.length > Integer.MAX_VALUE) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
                Object[] objectArray = new Object[]{new Long(inputStreamSetterArgs.length)};
                this.error(messageFormat.format(objectArray));
            }
            boolean bl6 = bl5 = bl3 || inputStreamSetterArgs.length <= 8000L;
            this.writeRPCNameValType(string, bl, bl2 ? (bl5 ? 165 : 34) : (bl5 ? 167 : 35));
            if (bl5) {
                this.writeShort((short)8000);
            } else {
                this.writeInt(Integer.MAX_VALUE);
            }
            if (!bl2) {
                this.con.getDatabaseCollation().writeCollation(this);
            }
            if (bl3) {
                this.writeShort((short)-1);
            } else {
                if (bl5) {
                    this.writeShort((short)inputStreamSetterArgs.length);
                } else {
                    this.writeInt((int)inputStreamSetterArgs.length);
                }
                this.writeStream(inputStream, inputStreamSetterArgs.length, false);
            }
        }
    }

    void writeRPCReader(String string, Reader reader, long l, boolean bl, int n) throws SQLServerException {
        boolean bl2;
        if (!$assertionsDisabled && l < -1L) {
            throw new AssertionError();
        }
        boolean bl3 = bl2 = reader == null;
        if (this.con.isYukonOrLater() && !bl2 && (-1L == l || l > 4000L)) {
            if (l > 0x3FFFFFFDL) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
                Object[] objectArray = new Object[]{new Long(l)};
                this.error(messageFormat.format(objectArray));
            }
            this.writeRPCNameValType(string, bl, 231);
            this.writeVMaxHeader(-1L == l ? -1L : 2L * l, false, true);
            this.writeReader(reader, l, true);
        } else {
            if (!$assertionsDisabled && !bl2 && l < 0L) {
                throw new AssertionError();
            }
            if (l > 0x3FFFFFFFL) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
                Object[] objectArray = new Object[]{new Long(l)};
                this.error(messageFormat.format(objectArray));
            }
            boolean bl4 = bl2 || l <= 4000L;
            this.writeRPCNameValType(string, bl, bl4 ? 231 : 99);
            if (bl4) {
                this.writeShort((short)8000);
            } else {
                this.writeInt(0x3FFFFFFF);
            }
            this.con.getDatabaseCollation().writeCollation(this);
            if (bl2) {
                this.writeShort((short)-1);
            } else {
                if (bl4) {
                    this.writeShort((short)(2L * l));
                } else {
                    this.writeInt((int)(2L * l));
                }
                this.writeReader(reader, l, false);
            }
        }
    }

    static {
        $assertionsDisabled = !TDSWriter.class.desiredAssertionStatus();
        logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.TDSWriter");
        placeholderHeader = new byte[8];
    }
}

