/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 *
 *   In addition, as a special exception, the copyright holders give	   *
 *   permission to link the code of portions of this program with the	   *
 *   OpenSSL library under certain conditions as described in each	   *
 *   individual source file, and distribute linked combinations		   *
 *   including the two.							   *
 *   You must obey the GNU General Public License in all respects	   *
 *   for all of the code used other than OpenSSL.  If you modify	   *
 *   file(s) with this exception, you may extend this exception to your	   *
 *   version of the file(s), but you are not obligated to do so.  If you   *
 *   do not wish to do so, delete this exception statement from your	   *
 *   version.  If you delete this exception statement from all source	   *
 *   files in the program, then also delete it here.			   *
 ***************************************************************************/

#ifndef ISDRECORDINGMETAINFO_H
#define ISDRECORDINGMETAINFO_H

/**
 * Class that holds the general meta info of a recording.
 *
 * @author Bram Biesbrouck <b@beligum.org>
 */

#include <string>
#include <glibmm/ustring.h>
#include <list>

#include <libinstrudeo/isdobject.h>

using namespace std;

class ISDWSPlatform;
class ISDWSCategory;

class ISDRecordingMetaInfo : public ISDObject
{
 public:
    //-----CONSTRUCTOR-----
    ISDRecordingMetaInfo();

    ~ISDRecordingMetaInfo();

    //-----SETTERS/GETTERS-----
    /**
     * Sets the version number of the meta-info file.
     *
     * @param version The version number string.
     */
    void setVersionNumberString(Glib::ustring& value);

    /**
     * Returns the version number of the meta-info file
     * as a string.
     *
     * @return The version number-string
     */
    Glib::ustring& getVersionNumberString();

    /**
     * Sets the title of the recording.
     *
     * @param value The title string
     */
    void setTitle(Glib::ustring& value);

    /**
     * Returns the title of the recording.
     *
     * @return The title string
     */
    Glib::ustring& getTitle();

    /**
     * Sets a general question to which this recording the answer is.
     *
     * @param value The question string
     */
    void setQuestion(Glib::ustring& value);

    /**
     * Returns a general question to which this recording the answer is.
     *
     * @return The question string
     */
    Glib::ustring& getQuestion();

     /**
     * Set the description of the recording.
     *
     * @param value The description string
     */
    void setDescription(Glib::ustring& value);

    /**
     * Returns the description of the recording.
     *
     * @return The description string
     */
    Glib::ustring& getDescription();

    /**
     * Appends a platform to the platform-list.
     *
     * @param cat The platform to append.
     */
    void addPlatform(ISDWSPlatform* cat);

    /**
     * Empty the platform-list.
     */
    void deleteAllPlatforms();

    /**
     * Returns all platforms in the order they were added.
     *
     * @return The list of platforms.
     */
    list<ISDWSPlatform*> getAllPlatforms();

    /**
     * Appends a category to the category-list.
     *
     * @param cat The category to append.
     */
    void addCategory(ISDWSCategory* cat);

    /**
     * Empty the category-list.
     */
    void deleteAllCategories();

    /**
     * Returns all categories in the order they were added.
     *
     * @return The list of categories.
     */
    list<ISDWSCategory*> getAllCategories();

 protected:
    //-----VARIABLES-----
    Glib::ustring versionNumber;
    Glib::ustring title;
    Glib::ustring question;
    Glib::ustring description;
    list<ISDWSPlatform*> platformList;
    list<ISDWSCategory*> categoryList;
};

#endif
