/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 *
 *   In addition, as a special exception, the copyright holders give	   *
 *   permission to link the code of portions of this program with the	   *
 *   OpenSSL library under certain conditions as described in each	   *
 *   individual source file, and distribute linked combinations		   *
 *   including the two.							   *
 *   You must obey the GNU General Public License in all respects	   *
 *   for all of the code used other than OpenSSL.  If you modify	   *
 *   file(s) with this exception, you may extend this exception to your	   *
 *   version of the file(s), but you are not obligated to do so.  If you   *
 *   do not wish to do so, delete this exception statement from your	   *
 *   version.  If you delete this exception statement from all source	   *
 *   files in the program, then also delete it here.			   *
 ***************************************************************************/

#include <cstdio>
#include <cstdlib>

#include <libinstrudeo/isdutils.h>
#include <libinstrudeo/isdlogger.h>
#include <libinstrudeo/isdrectangle.h>
#include <libinstrudeo/isddatafile.h>
#include <libinstrudeo/isdimporter.h>

#undef LOG_HEADER
#define LOG_HEADER "Error while importing a foreign file: \n"
#include <libinstrudeo/isdloggermacros.h>

//-----CONSTRUCTORS-----
ISDImporter::ISDImporter(const string inputFileName)
    : ISDObject(), 
      inputFileName(inputFileName),
      defaultRectEncoding(ISDDataFile::ISD_RECT_ENCODING_RLE),
      rectListHead(NULL),
      rectListTail(NULL)
{
    inputFileSize = ISDUtils::getInstance()->getFileSizeInBytes((string&)inputFileName);
}

//-----DESTRUCTORS-----
ISDImporter::~ISDImporter()
{
    //delete the rectlist
    ISDRectangle* iterRect = rectListHead;
    ISDRectangle* bakRect = rectListHead;
    while (iterRect!=NULL){
	bakRect = iterRect->getNext();
	delete iterRect;
	iterRect = bakRect;
    }
}

//-----PROTECTED FUNCTIONS-----
ISDObject::ISDErrorCode ISDImporter::calcSeekBackRects(ISDRectangle* rect)
{
    //this function should be called after list-initialisation
    if (rectListHead!=NULL) {
	return seekBackCalculator.calcSeekBack(rect);
    }
    else {
	RETURN_ERROR(ISD_INIT_ERROR);
    }
}
ISDObject::ISDErrorCode ISDImporter::appendRectToList(ISDRectangle* rect)
{
    //check for errors
    if (rect==NULL) {
	LOG_WARNING("Trying to append a rect to the rectList without initialising it.");
	RETURN_ERROR(ISD_INIT_ERROR);
    }

    //check if the list is empty and this is the first insertion
    if (rectListHead==NULL) {
	//the list points to the first rect
	rectListHead = rect;
	rect->setPrevious(NULL);
	rectListTail = rect;
	rect->setNext(NULL);
    }
    else {
	//add a new rect to the end of the double linked list
	rect->setPrevious(rectListTail);
	rect->setNext(NULL);
	rectListTail->setNext(rect);
	rectListTail = rect;
    }

    RETURN_SUCCESS;
}
