/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 *
 *   In addition, as a special exception, the copyright holders give	   *
 *   permission to link the code of portions of this program with the	   *
 *   OpenSSL library under certain conditions as described in each	   *
 *   individual source file, and distribute linked combinations		   *
 *   including the two.							   *
 *   You must obey the GNU General Public License in all respects	   *
 *   for all of the code used other than OpenSSL.  If you modify	   *
 *   file(s) with this exception, you may extend this exception to your	   *
 *   version of the file(s), but you are not obligated to do so.  If you   *
 *   do not wish to do so, delete this exception statement from your	   *
 *   version.  If you delete this exception statement from all source	   *
 *   files in the program, then also delete it here.			   *
 ***************************************************************************/

#include <cstdio>
#include <cstdlib>
#include <iostream>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <GL/gl.h>
#include <GL/glx.h>

#include <libinstrudeo/isdrectangle.h>
#include <libinstrudeo/isdcommentbox.h>
#include <libinstrudeo/isdlogger.h>
#include <libinstrudeo/isdvideoproperties.h>
#include <libinstrudeo/isdvideocanvas.h>
#include <libinstrudeo/isdrecording.h>
#include <libinstrudeo/isdexporter.h>

#undef LOG_HEADER
#define LOG_HEADER "Error while exporting recording: \n"
#include <libinstrudeo/isdloggermacros.h>

//-----CONSTRUCTOR-----
ISDExporter::ISDExporter(string outFileName, ISDRecording* rec,
			 Glib::ustring* lang, ISDProgressCallback* callbackClass,
			 int quality, float framerate)
    : ISDObject(),
      fileName(outFileName),
      recording(rec),
      quality(quality),
      framerate(framerate),
      initOK(false),
      lang(lang),
      callbackClass(callbackClass)
{
}

//-----DESTRUCTOR-----
ISDExporter::~ISDExporter()
{
    cleanup();
}

//-----PUBLIC METHODS-----
ISDObject::ISDErrorCode ISDExporter::exportRecording(char* pixelBuffer)
{
    return doExport(pixelBuffer);
}

//-----PROTECTED METHODS-----
void ISDExporter::cleanup()
{
    recording = NULL;
}
bool ISDExporter::intersects(ISDRectangle* rect, ISDCommentbox* comment)
{
    int commentPos[2];
    int commentSize[2];
    comment->getPosition(commentPos);
    comment->getSize(commentSize);
    
    int rectBottom = rect->y + rect->height;
    int rectRight = rect->x + rect->width;
    int commentBottom = commentPos[1] + commentSize[1];
    int commentRight = commentPos[0] + commentSize[0];
    
    /*
     * (Partly copied from isdseekbackcalculator.cpp)
     * Two rects DON'T overlap if any of these is true:
     *
     * 1. The right side of commentbox is to the left (or the same) of the left side of rect
     * 2. The left side of commentbox is to the right (or the same) of the right side of rect
     * 3. The upper side of commentbox is below (or the same) the lower side of rect
     * 4. The lower side of commentbox is above (or the same) the upper side of rect
     *
     * In all other cases, they overlap.
     */
    return 
	!(
	  (commentRight <= rect->x) ||
	  (commentPos[0] >= rectRight) ||
	  (commentPos[1] >= rectBottom) ||
	  (commentBottom <= rect->y)
	  );
}
