/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 *
 *   In addition, as a special exception, the copyright holders give	   *
 *   permission to link the code of portions of this program with the	   *
 *   OpenSSL library under certain conditions as described in each	   *
 *   individual source file, and distribute linked combinations		   *
 *   including the two.							   *
 *   You must obey the GNU General Public License in all respects	   *
 *   for all of the code used other than OpenSSL.  If you modify	   *
 *   file(s) with this exception, you may extend this exception to your	   *
 *   version of the file(s), but you are not obligated to do so.  If you   *
 *   do not wish to do so, delete this exception statement from your	   *
 *   version.  If you delete this exception statement from all source	   *
 *   files in the program, then also delete it here.			   *
 ***************************************************************************/

#include <cstdio>
#include <cstdlib>
#include <iostream>

#include <libinstrudeo/isdlogger.h>
#include <libinstrudeo/isdglobjfile.h>
#include <libinstrudeo/isdcaptoverlay.h>

#undef LOG_HEADER
#define LOG_HEADER "Error while accessing a captoverlay commentbox: \n"
#include <libinstrudeo/isdloggermacros.h>

ISDGLObjFile* ISDCaptoverlay::objFile = NULL;//init instance

//-----CONSTRUCTORS-----
ISDCaptoverlay::ISDCaptoverlay(ISDVideoCanvas* parent, int id)
 : ISDCommentbox(parent, id)
{
    initGL();
    
    //see constructor of superclass for a note why these must be called here
    setPosition(DEFAULT_CAPTOVERLAY_X, DEFAULT_CAPTOVERLAY_Y);
    setSize(DEFAULT_CAPTOVERLAY_WIDTH, DEFAULT_CAPTOVERLAY_HEIGHT);
    setColor(DEFAULT_CAPTOVERLAY_COLOR_R,
	     DEFAULT_CAPTOVERLAY_COLOR_G,
	     DEFAULT_CAPTOVERLAY_COLOR_B,
	     DEFAULT_CAPTOVERLAY_COLOR_A);
    setTextColor(DEFAULT_CAPTOVERLAY_TEXTCOLOR_R,
		 DEFAULT_CAPTOVERLAY_TEXTCOLOR_G,
		 DEFAULT_CAPTOVERLAY_TEXTCOLOR_B,
		 DEFAULT_CAPTOVERLAY_TEXTCOLOR_A);
}

//-----DESTRUCTOR-----
ISDCaptoverlay::~ISDCaptoverlay()
{
    /*
     * Note: don't destroy the objFile,
     * since it is shared between instances
     * TODO: count the instances and destroy the object when not needed
     *       anymore.
     */
}

//-----PUBLIC METHODS----
int ISDCaptoverlay::getType()
{
    return ISDCommentbox::ISD_COMMENT_CAPTOVERLAY_TYPE;
}
ISDGLObjFile* ISDCaptoverlay::getObjFile()
{
    //create the .obj file if needed
    if (objFile==NULL) {
	objFile = new ISDGLObjFile(CAPTOVERLAY_OBJ_FILENAME,
				   CAPTOVERLAY_MESH_OBJ_NAME,
				   CAPTOVERLAY_TEXTBOX_OBJ_NAME);

	if (objFile==NULL || objFile->error()) {
	    LOG_WARNING("Error while initialising the .obj file for the captoverlay commentbox.");
	    lastError = ISD_INIT_ERROR;
	    return NULL;
	}
    }

    return objFile;
}
void ISDCaptoverlay::setColor(float r, float g, float b, float a)
{
    //save the color with the superclass method
    this->ISDCommentbox::setColor(r, g, b, a);

    ISDGLObjFile* objFile = this->getObjFile();
    if (objFile==NULL || objFile->error()) {
	LOG_WARNING("Couldn't get the .obj file class wrapper in captoverlay.");
	return;
    }
    
    GLMmodel* model = objFile->getMainModel();
    if (model==NULL) {
	LOG_WARNING("Could not get a reference to the main model to adjust the color in the captoverlay commentbox.");
	lastError = ISD_INIT_ERROR;
	return;
    }

    GLMobject* meshObject = objFile->getMeshObject();
    if (meshObject==NULL) {
	LOG_WARNING("Could not get a reference to the mesh model to adjust the color in the captoverlay commentbox.");
	lastError = ISD_INIT_ERROR;
	return;
    }

    setMeshColor(model, meshObject);
}

//-----PROTECTED METHODS-----
void ISDCaptoverlay::displayModel()
{
    ISDGLObjFile* objFile = this->getObjFile();
    if (objFile==NULL || objFile->error()) {
	LOG_WARNING("Couldn't get the .obj file class wrapper in captoverlay.");
	return;
    }

    /*
     * set the color of the model to the current color
     * Note: we don't perform the NULL-check here; it passed the setColor()
     *       so it will pass this method too. (I think :-))
     */
    GLMmodel* model = objFile->getMainModel();
    GLMobject* meshObject = objFile->getMeshObject();
    setMeshColor(model, meshObject);
    
    objFile->drawModel(GLM_SMOOTH | GLM_COLOR);
}
void ISDCaptoverlay::getScalesTweakValues(float values[3])
{
    values[0] = 1.0;
    values[1] = 1.0;
    values[2] = 1.0;
}
void ISDCaptoverlay::setMeshColor(GLMmodel* model, GLMobject* meshObject)
{
    /*
     * we use a material in the captoverlay comment, so adjust the different colors with 
     * the new color.
     */
    
    //Note: there's only one group in the captoverlay .obj file mesh.
    GLMgroup* group = meshObject->groups;

    //we use GLM_COLOR mode, this only uses diffuse colors
    model->materials[group->material].diffuse[0] = color[0];
    model->materials[group->material].diffuse[1] = color[1];
    model->materials[group->material].diffuse[2] = color[2];
    model->materials[group->material].diffuse[3] = color[3];
}
