#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.04';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Canon::CameraInfo',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo2',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorBalance1',
	'Image::ExifTool::Canon::ColorBalance2',
	'Image::ExifTool::Canon::ColorBalance3',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ColorInfoD30',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PreviewImage',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::Raw',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::Microsoft',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'abspeakaudiofilepath' => { 164 => 'absPeakAudioFilePath' },
	'accessorytype' => { 126 => 0x53 },
	'actionadvised' => { 54 => 0x2a },
	'activearea' => { 48 => 0xc68d },
	'addaspectratioinfo' => { 25 => 0x80e },
	'addoriginaldecisiondata' => { 25 => 0x80f, 26 => 0x11, 27 => 0x13, 30 => 0x14 },
	'address' => { 75 => 'Address' },
	'adjustmentmode' => { 146 => [0x15,0x22] },
	'advancedraw' => { 109 => 0x76a43203 },
	'advisory' => { 162 => 'Advisory' },
	'ae_iso' => { 128 => 0x2 },
	'aeaperture' => { 128 => 0x1 },
	'aebautocancel' => { 25 => 0x104 },
	'aebbracketvalue' => { 22 => 0x11 },
	'aebsequence' => { 23 => 0x9, 24 => 0x9, 25 => 0x105, 26 => 0x8, 27 => 0x9, 30 => 0x9, 31 => 0x7 },
	'aebshotcount' => { 25 => 0x106 },
	'aebxv' => { 128 => 0x4 },
	'aeexposuretime' => { 128 => 0x0 },
	'aeextra' => { 128 => 0x7 },
	'aeflashtv' => { 128 => 0x5 },
	'aelock' => { 115 => 0x201 },
	'aemeteringsegments' => { 134 => 0x209 },
	'aeprogrammode' => { 128 => 0x6 },
	'aesetting' => { 4 => 0x21 },
	'aexv' => { 128 => 0x3 },
	'afareamode' => { 92 => 0x0 },
	'afareas' => { 115 => 0x304 },
	'afassist' => { 23 => 0x5, 31 => 0x5 },
	'afassistbeam' => { 25 => 0x50e, 26 => 0x4, 27 => 0x5, 28 => 0x4, 29 => 0x4, 30 => 0x5 },
	'afduringliveview' => { 25 => 0x511 },
	'afexpansionwithselectedpoint' => { 25 => 0x508 },
	'afmicroadjustment' => { 25 => 0x507 },
	'afmode' => { 126 => 0xf, 146 => 0x5 },
	'afonaelockbuttonswitch' => { 25 => 0x702 },
	'afpoint' => { 4 => 0x13, 44 => 0x18, 92 => 0x1, 118 => 0x308 },
	'afpointactivationarea' => { 24 => 0x11, 30 => 0x11 },
	'afpointautoselection' => { 25 => 0x50b },
	'afpointbrightness' => { 25 => 0x50d },
	'afpointdisplayduringfocus' => { 25 => 0x50c },
	'afpointillumination' => { 24 => 0xa },
	'afpointregistration' => { 23 => 0x7 },
	'afpoints' => { 86 => 0x10 },
	'afpointselected' => { 134 => 0xe },
	'afpointselection' => { 24 => 0xb },
	'afpointselectionmethod' => { 25 => 0x50f, 26 => 0xc, 27 => 0xd, 30 => 0xd },
	'afpointsinfocus' => { 22 => 0xe, 92 => 0x2, 129 => 0xb, 134 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 1 => 0x38 },
	'afpointspotmetering' => { 24 => 0xd },
	'afresponse' => { 98 => 0xad },
	'afresult' => { 120 => 0x1038 },
	'afsearch' => { 115 => 0x303 },
	'aiservoimagepriority' => { 25 => 0x503 },
	'aiservotrackingmethod' => { 25 => 0x504 },
	'aiservotrackingsensitivity' => { 24 => 0x14, 25 => 0x502 },
	'album' => { 164 => 'album' },
	'alreadyapplied' => { 154 => 'AlreadyApplied' },
	'alttapename' => { 164 => 'altTapeName' },
	'alttimecodetimeformat' => { 164 => 'altTimecodeTimeFormat' },
	'alttimecodetimevalue' => { 164 => 'altTimecodeTimeValue' },
	'antialiasstrength' => { 48 => 0xc632 },
	'aperturerange' => { 25 => 0x10d },
	'aperturevalue' => { 48 => 0x9202, 120 => 0x1002, 157 => 'ApertureValue' },
	'applicationrecordversion' => { 54 => 0x0 },
	'applyshootingmeteringmode' => { 25 => 0x10e },
	'armidentifier' => { 55 => 0x78 },
	'armversion' => { 55 => 0x7a },
	'artist' => { 48 => 0x13b, 125 => 'Artist', 161 => 'Artist', 164 => 'artist' },
	'asshoticcprofile' => { 48 => 0xc68f },
	'asshotpreprofilematrix' => { 48 => 0xc690 },
	'asshotwhitexy' => { 48 => 0xc629 },
	'assistbuttonfunction' => { 23 => 0xd },
	'audio' => { 126 => 0x20 },
	'audiochanneltype' => { 164 => 'audioChannelType' },
	'audiocompression' => { 69 => 'Compression' },
	'audiocompressor' => { 164 => 'audioCompressor' },
	'audioduration' => { 54 => 0x99 },
	'audiomoddate' => { 164 => 'audioModDate' },
	'audiooutcue' => { 54 => 0x9a },
	'audiosamplerate' => { 164 => 'audioSampleRate' },
	'audiosampletype' => { 164 => 'audioSampleType' },
	'audiosamplingrate' => { 54 => 0x97 },
	'audiosamplingresolution' => { 54 => 0x98 },
	'audiotype' => { 54 => 0x96 },
	'author' => { 71 => 'Author', 125 => 'Author', 142 => 'Author', 159 => 'Author' },
	'authorsposition' => { 160 => 'AuthorsPosition' },
	'autobracket' => { 146 => 0x19 },
	'autobracketing' => { 52 => 0x1100, 134 => 0x18 },
	'autobracketrelease' => { 98 => 0x8a },
	'autobrightness' => { 154 => 'AutoBrightness' },
	'autocontrast' => { 154 => 'AutoContrast' },
	'autoexposure' => { 154 => 'AutoExposure' },
	'autoexposurebracketing' => { 22 => 0x10 },
	'autofocus' => { 118 => 0x209 },
	'autoiso' => { 22 => 0x1, 45 => 0x3008 },
	'autorotate' => { 22 => 0x1b },
	'autoshadows' => { 154 => 'AutoShadows' },
	'auxiliarylens' => { 98 => 0x82 },
	'avsettingwithoutlens' => { 25 => 0x707 },
	'avvalue' => { 34 => 0x2 },
	'azimuth' => { 79 => 'Azimuth' },
	'babyage' => { 126 => [0x8010,0x33] },
	'baseiso' => { 22 => 0x2, 38 => 0x101c },
	'baselineexposure' => { 48 => 0xc62a },
	'baselinenoise' => { 48 => 0xc62b },
	'baselinesharpness' => { 48 => 0xc62c },
	'baseurl' => { 162 => 'BaseURL' },
	'batteryadbodyload' => { 130 => 0x3 },
	'batteryadbodynoload' => { 130 => 0x2 },
	'batteryadgripload' => { 130 => 0x5 },
	'batteryadgripnoload' => { 130 => 0x4 },
	'batterybodygripstates' => { 130 => 0x1 },
	'batterytype' => { 130 => 0x0 },
	'bayergreensplit' => { 48 => 0xc62d },
	'bayerpattern' => { 58 => 0xf902, 89 => 0x17 },
	'beatspliceparamsriseindecibel' => { 164 => 'beatSpliceParamsRiseInDecibel' },
	'beatspliceparamsriseintimeduration' => { 164 => 'beatSpliceParamsRiseInTimeDuration' },
	'beatspliceparamsusefilebeatsmarker' => { 164 => 'beatSpliceParamsUseFileBeatsMarker' },
	'bestqualityscale' => { 48 => 0xc65c },
	'bestshotmode' => { 45 => 0x3007 },
	'bitdepth' => { 76 => 'BitDepth', 89 => 0x11, 102 => 0x41 },
	'bitspercomponent' => { 56 => 0x87 },
	'bitspersample' => { 48 => 0x102, 161 => 'BitsPerSample' },
	'blacklevel' => { 120 => 0x1012 },
	'blacklevel2' => { 123 => 0x600 },
	'blackpoint' => { 134 => 0x200 },
	'bluebalance' => { 120 => 0x1018, 127 => 0x12, 134 => 0x1b },
	'bluecurvelimits' => { 42 => 0x1fe },
	'bluecurvepoints' => { 42 => 0x1d4 },
	'bluehue' => { 154 => 'BlueHue' },
	'bluesaturation' => { 154 => 'BlueSaturation' },
	'blurwarning' => { 52 => 0x1300 },
	'bodyfirmwareversion' => { 116 => 0x104, 117 => 0x100, 120 => 0x104 },
	'bracketmode' => { 13 => 0x3 },
	'bracketsequence' => { 45 => 0x301d },
	'bracketshotnumber' => { 13 => 0x5 },
	'bracketstep' => { 84 => 0xe },
	'bracketvalue' => { 13 => 0x4 },
	'brightness' => { 48 => 0xfe53, 70 => 'Brightness', 84 => 0x2c, 154 => 'Brightness' },
	'brightnessadj' => { 42 => 0x114, 104 => 0x0 },
	'brightnessvalue' => { 48 => 0x9203, 120 => 0x1003, 157 => 'BrightnessValue' },
	'bulbduration' => { 22 => 0x18 },
	'burstmode' => { 59 => 0xa, 126 => 0x2a },
	'burstmode2' => { 59 => 0x18 },
	'buttonfunctioncontroloff' => { 25 => 0x70a },
	'bwfilter' => { 84 => 0x2a, 90 => 0x39 },
	'bwmode' => { 120 => 0x203 },
	'by-line' => { 54 => 0x50 },
	'by-linetitle' => { 54 => 0x55 },
	'calibrationilluminant1' => { 48 => 0xc65a },
	'calibrationilluminant2' => { 48 => 0xc65b },
	'cameraid' => { 120 => 0x209, 145 => 0x209 },
	'cameraiso' => { 4 => 0x10 },
	'cameraparameters' => { 120 => 0x2050 },
	'cameraprofile' => { 154 => 'CameraProfile' },
	'cameraprofiledigest' => { 154 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 48 => 0xc62f, 151 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 115 => 0x0 },
	'cameratemperature' => { 134 => 0x47 },
	'cameratype' => { 22 => 0x1a, 120 => 0x207 },
	'cameratype2' => { 116 => 0x100 },
	'canonexposuremode' => { 4 => 0x14 },
	'canonfiledescription' => { 38 => 0x805 },
	'canonfilelength' => { 16 => 0xe },
	'canonfirmwareversion' => { 16 => 0x7, 38 => 0x80b },
	'canonflashinfo' => { 38 => 0x1028 },
	'canonflashmode' => { 4 => 0x4 },
	'canonimagesize' => { 4 => 0xa },
	'canonimagetype' => { 16 => 0x6, 38 => 0x815 },
	'canonmodelid' => { 16 => 0x10, 38 => 0x1834 },
	'canonvrd' => { 49 => 'CanonVRD' },
	'caption-abstract' => { 54 => 0x78 },
	'captionwriter' => { 160 => 'CaptionWriter' },
	'casioimagesize' => { 45 => 0x9 },
	'catalogsets' => { 150 => 'CatalogSets' },
	'category' => { 54 => 0xf, 160 => 'Category' },
	'ccdscanmode' => { 120 => 0x1039 },
	'ccdsensitivity' => { 103 => 0x6 },
	'celllength' => { 48 => 0x109 },
	'cellwidth' => { 48 => 0x108 },
	'certificate' => { 167 => 'Certificate' },
	'cfapattern' => { 48 => 0xa302 },
	'cfapatterncolumns' => { 157 => 'CFAPatternColumns' },
	'cfapatternrows' => { 157 => 'CFAPatternRows' },
	'cfapatternvalues' => { 157 => 'CFAPatternValues' },
	'channels' => { 69 => 'Channels' },
	'checkmark' => { 42 => 0x26a },
	'chromablurradius' => { 48 => 0xc631 },
	'chromaticaberrationb' => { 154 => 'ChromaticAberrationB' },
	'chromaticaberrationr' => { 154 => 'ChromaticAberrationR' },
	'chrominancenoisereduction' => { 43 => 0xbc },
	'chrominancenr_tiff_jpeg' => { 43 => 0xc0 },
	'city' => { 54 => 0x5a, 75 => 'City', 160 => 'City' },
	'clarity' => { 154 => 'Clarity' },
	'classifystate' => { 54 => 0xe1 },
	'cmcontrast' => { 123 => 0x2022 },
	'cmexposurecompensation' => { 123 => 0x2000 },
	'cmhue' => { 123 => 0x2021 },
	'cmsaturation' => { 123 => 0x2020 },
	'cmsharpness' => { 123 => 0x2023 },
	'cmwhitebalance' => { 123 => 0x2001 },
	'cmwhitebalancecomp' => { 123 => 0x2002 },
	'cmwhitebalancegraypoint' => { 123 => 0x2010 },
	'codec' => { 83 => 'Codec' },
	'codedcharacterset' => { 55 => 0x5a },
	'coloraberrationcontrol' => { 109 => 0xc89224b },
	'coloradjustment' => { 146 => 0x14 },
	'coloradjustmentmode' => { 145 => 0x210 },
	'colorantsa' => { 168 => 'ColorantsA' },
	'colorantsb' => { 168 => 'ColorantsB' },
	'colorantsblack' => { 168 => 'ColorantsBlack' },
	'colorantsblue' => { 168 => 'ColorantsBlue' },
	'colorantscyan' => { 168 => 'ColorantsCyan' },
	'colorantsgreen' => { 168 => 'ColorantsGreen' },
	'colorantsl' => { 168 => 'ColorantsL' },
	'colorantsmagenta' => { 168 => 'ColorantsMagenta' },
	'colorantsmode' => { 168 => 'ColorantsMode' },
	'colorantsred' => { 168 => 'ColorantsRed' },
	'colorantsswatchname' => { 168 => 'ColorantsSwatchName' },
	'colorantstype' => { 168 => 'ColorantsType' },
	'colorantsyellow' => { 168 => 'ColorantsYellow' },
	'colorbalance' => { 70 => 'ColorBalance' },
	'colorbalance1' => { 98 => 0xc },
	'colorbalanceadj' => { 109 => 0x76a43202 },
	'colorbalanceblue' => { 84 => 0x1e },
	'colorbalancegreen' => { 84 => 0x1d },
	'colorbalancered' => { 84 => 0x1c },
	'colorbooster' => { 109 => 0x5f0e7d23 },
	'colorboostlevel' => { 105 => 0x1 },
	'colorboosttype' => { 105 => 0x0 },
	'colorclass' => { 137 => 0xde },
	'colorcontrol' => { 120 => 0x102b },
	'coloreffect' => { 126 => 0x28 },
	'colorfilter' => { 44 => 0x17, 84 => 0x29, 90 => 0x38, 136 => 0x17 },
	'colorgain' => { 102 => 0x51 },
	'colorhue' => { 9 => 0x2, 98 => 0x8d },
	'colormatrix' => { 10 => 0xa, 119 => 0x200, 120 => 0x1011 },
	'colormatrix2' => { 123 => 0x200 },
	'colormatrixnumber' => { 120 => 0x1019 },
	'colormode' => { 45 => 0x3015, 52 => 0x1210, 59 => 0x66, 84 => 0x28, 87 => 0x16, 88 => 0x101, 90 => 0x7, 98 => 0x3, 103 => 0x4, 120 => 0x101, 126 => 0x32, 147 => 0xb029, 160 => 'ColorMode' },
	'colormoirereduction' => { 110 => 0x5 },
	'colornoisereduction' => { 154 => 'ColorNoiseReduction' },
	'colorplanes' => { 51 => 0x2 },
	'colorprofile' => { 84 => 0x33 },
	'colorrepresentation' => { 56 => 0x3c },
	'colorsequence' => { 56 => 0x41 },
	'colorspace' => { 9 => 0x3, 16 => 0xb4, 38 => 0x10b4, 48 => 0xa001, 76 => 'ColorSpace', 86 => 0x25, 98 => 0x1e, 115 => 0x507, 134 => 0x37, 146 => 0xb, 157 => 'ColorSpace' },
	'colortempasshot' => { 6 => 0x1d, 7 => 0x1c, 8 => 0x43 },
	'colortempauto' => { 6 => 0x22, 7 => 0x26, 8 => 0x48 },
	'colortempcloudy' => { 6 => 0x31, 7 => 0x35, 8 => 0x5c },
	'colortempcustom' => { 8 => 0x84 },
	'colortempcustom1' => { 6 => 0x45 },
	'colortempcustom2' => { 6 => 0x4a },
	'colortempdaylight' => { 6 => 0x27, 7 => 0x2b, 8 => 0x52 },
	'colortemperature' => { 10 => 0x9, 16 => 0xae, 21 => 0x9, 38 => 0x10ae, 52 => 0x1005, 70 => 'ColorTemperature', 85 => [0x6e,0x49], 86 => 0x3f, 87 => 0x5e, 88 => 0x10b, 90 => 0x3c },
	'colortemperaturebg' => { 120 => 0x1013 },
	'colortemperaturerg' => { 120 => 0x1014 },
	'colortempflash' => { 6 => 0x40, 7 => 0x49, 8 => 0x70 },
	'colortempfluorescent' => { 6 => 0x3b, 7 => 0x3f, 8 => 0x66 },
	'colortempkelvin' => { 7 => 0x44, 8 => 0x6b },
	'colortempmeasured' => { 8 => 0x4d },
	'colortemppc1' => { 7 => 0x94, 8 => 0x75 },
	'colortemppc2' => { 7 => 0x99, 8 => 0x7a },
	'colortemppc3' => { 7 => 0x9e, 8 => 0x7f },
	'colortempshade' => { 6 => 0x2c, 7 => 0x30, 8 => 0x57 },
	'colortemptungsten' => { 6 => 0x36, 7 => 0x3a, 8 => 0x61 },
	'colortempunknown' => { 7 => 0x21 },
	'colortempunknown10' => { 7 => 0x76 },
	'colortempunknown11' => { 7 => 0x7b },
	'colortempunknown12' => { 7 => 0x80 },
	'colortempunknown13' => { 7 => 0x85 },
	'colortempunknown14' => { 7 => 0x8a },
	'colortempunknown15' => { 7 => 0x8f },
	'colortempunknown16' => { 7 => 0xa3 },
	'colortempunknown2' => { 7 => 0x4e },
	'colortempunknown3' => { 7 => 0x53 },
	'colortempunknown4' => { 7 => 0x58 },
	'colortempunknown5' => { 7 => 0x5d },
	'colortempunknown6' => { 7 => 0x62 },
	'colortempunknown7' => { 7 => 0x67 },
	'colortempunknown8' => { 7 => 0x6c },
	'colortempunknown9' => { 7 => 0x71 },
	'colortone' => { 4 => 0x2a },
	'colortoneadj' => { 42 => 0x11e },
	'colortonefaithful' => { 1 => 0x107 },
	'colortonelandscape' => { 1 => 0x105 },
	'colortoneneutral' => { 1 => 0x106 },
	'colortoneportrait' => { 1 => 0x104 },
	'colortonestandard' => { 1 => 0x103 },
	'colortoneuserdef1' => { 1 => 0x109 },
	'colortoneuserdef2' => { 1 => 0x10a },
	'colortoneuserdef3' => { 1 => 0x10b },
	'comment' => { 0 => 0x2, 49 => 'Comment', 71 => 'Comment', 125 => 'Comment' },
	'componentsconfiguration' => { 48 => 0x9101, 76 => 'Components', 157 => 'ComponentsConfiguration' },
	'componentversion' => { 38 => 0x80c },
	'composer' => { 164 => 'composer' },
	'compressedbitsperpixel' => { 48 => 0x9102, 157 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 88 => 0x40, 120 => 0x40 },
	'compression' => { 48 => 0x103, 161 => 'Compression' },
	'compressionfactor' => { 115 => 0x50d },
	'compressionratio' => { 76 => 'Compression', 120 => 0x1034 },
	'constrainedcropheight' => { 42 => 0x266, 137 => 0xd6 },
	'constrainedcropwidth' => { 42 => 0x262, 137 => 0xd5 },
	'contact' => { 54 => 0x76 },
	'contentlocationcode' => { 54 => 0x1a },
	'contentlocationname' => { 54 => 0x1b },
	'continuousdrive' => { 4 => 0x5 },
	'continuousshootingspeed' => { 25 => 0x610 },
	'continuousshotlimit' => { 25 => 0x611 },
	'contrast' => { 4 => 0xd, 44 => 0xc, 45 => [0x3012,0x20], 48 => [0xa408,0xfe54], 52 => 0x1004, 70 => 'Contrast', 84 => 0x20, 85 => 0x31, 86 => 0x27, 87 => 0x19, 90 => 0x2, 120 => 0x1029, 126 => 0x2c, 134 => 0x20, 136 => 0xc, 146 => 0xd, 154 => 'Contrast', 157 => 'Contrast' },
	'contrastadj' => { 42 => 0x115 },
	'contrastfaithful' => { 1 => 0xec },
	'contrastlandscape' => { 1 => 0xea },
	'contrastmonochrome' => { 1 => 0xed },
	'contrastneutral' => { 1 => 0xeb },
	'contrastportrait' => { 1 => 0xe9 },
	'contrastsetting' => { 115 => 0x505, 123 => 0x1012 },
	'contraststandard' => { 1 => 0xe8 },
	'contrastuserdef1' => { 1 => 0xee },
	'contrastuserdef2' => { 1 => 0xef },
	'contrastuserdef3' => { 1 => 0xf0 },
	'contributedmediaduration' => { 164 => 'contributedMediaDuration' },
	'contributedmediamanaged' => { 164 => 'contributedMediaManaged' },
	'contributedmediapath' => { 164 => 'contributedMediaPath' },
	'contributedmediastarttime' => { 164 => 'contributedMediaStartTime' },
	'contributedmediatrack' => { 164 => 'contributedMediaTrack' },
	'contributedmediawebstatement' => { 164 => 'contributedMediaWebStatement' },
	'contributor' => { 155 => 'contributor' },
	'contributors' => { 71 => 'Contributors' },
	'conversionlens' => { 126 => 0x35 },
	'converter' => { 48 => 0xfe4d, 103 => 0xb },
	'converttograyscale' => { 154 => 'ConvertToGrayscale' },
	'copyright' => { 0 => 0x3, 48 => 0x8298, 71 => 'Copyright', 125 => 'Copyright', 142 => 'Copyright', 161 => 'Copyright', 164 => 'copyright' },
	'copyrightflag' => { 140 => 0x40a },
	'copyrightnotice' => { 54 => 0x74 },
	'coringfilter' => { 120 => 0x102d, 123 => 0x310 },
	'coringvalues' => { 123 => 0x311 },
	'country' => { 75 => 'Country', 160 => 'Country' },
	'country-primarylocationcode' => { 54 => 0x64 },
	'country-primarylocationname' => { 54 => 0x65 },
	'countrycode' => { 138 => 'CountryCode', 158 => 'CountryCode' },
	'coverage' => { 155 => 'coverage' },
	'crc32' => { 156 => 'crc32' },
	'createdate' => { 48 => 0x9004, 71 => 'CreateDate', 142 => 'CreationDate', 162 => 'CreateDate' },
	'creationdate' => { 159 => 'CreationDate' },
	'creationtime' => { 125 => 'Creation Time' },
	'creator' => { 142 => 'Creator', 155 => 'creator', 159 => 'Creator' },
	'creatorcontactinfociadrcity' => { 158 => 'CreatorContactInfoCiAdrCity' },
	'creatorcontactinfociadrctry' => { 158 => 'CreatorContactInfoCiAdrCtry' },
	'creatorcontactinfociadrextadr' => { 158 => 'CreatorContactInfoCiAdrExtadr' },
	'creatorcontactinfociadrpcode' => { 158 => 'CreatorContactInfoCiAdrPcode' },
	'creatorcontactinfociadrregion' => { 158 => 'CreatorContactInfoCiAdrRegion' },
	'creatorcontactinfociemailwork' => { 158 => 'CreatorContactInfoCiEmailWork' },
	'creatorcontactinfocitelwork' => { 158 => 'CreatorContactInfoCiTelWork' },
	'creatorcontactinfociurlwork' => { 158 => 'CreatorContactInfoCiUrlWork' },
	'creatortool' => { 162 => 'CreatorTool' },
	'credit' => { 54 => 0x6e, 160 => 'Credit' },
	'creditlinereq' => { 166 => 'CreditLineReq' },
	'cropactive' => { 42 => 0x244 },
	'cropangle' => { 154 => 'CropAngle' },
	'cropaspectratio' => { 42 => 0x260 },
	'cropbottom' => { 51 => 0x9, 106 => 0x36, 137 => 0xdc, 154 => 'CropBottom' },
	'cropheight' => { 42 => 0x24c, 154 => 'CropHeight' },
	'crophispeed' => { 98 => 0x1b },
	'cropleft' => { 42 => 0x246, 51 => 0x6, 106 => 0x1e, 137 => 0xd9, 154 => 'CropLeft' },
	'cropoutputscale' => { 106 => 0xbe },
	'cropright' => { 51 => 0x8, 106 => 0x2e, 137 => 0xdb, 154 => 'CropRight' },
	'croprotation' => { 51 => 0xb },
	'croptop' => { 42 => 0x248, 51 => 0x7, 106 => 0x26, 137 => 0xda, 154 => 'CropTop' },
	'cropunits' => { 154 => 'CropUnits' },
	'cropwidth' => { 42 => 0x24a, 154 => 'CropWidth' },
	'currenticcprofile' => { 48 => 0xc691 },
	'currentpreprofilematrix' => { 48 => 0xc692 },
	'curves' => { 109 => 0x76a43201 },
	'customrendered' => { 48 => 0xa401, 157 => 'CustomRendered' },
	'customsaturation' => { 115 => 0x503 },
	'd-lightinghq' => { 109 => 0x2175eb78 },
	'd-lightinghqselected' => { 109 => 0x6a6e36b6 },
	'd-lightinghs' => { 109 => 0xce5554aa },
	'd-lightinghsadjustment' => { 108 => 0x0 },
	'd-lightinghscolorboost' => { 107 => 0x2, 108 => 0x1 },
	'd-lightinghshighlight' => { 107 => 0x1 },
	'd-lightinghsshadow' => { 107 => 0x0 },
	'datacompressionmethod' => { 56 => 0x6e },
	'dataimprint' => { 84 => 0x34 },
	'date' => { 134 => 0x6, 155 => 'date' },
	'dateacquired' => { 151 => 'DateAcquired' },
	'datecreated' => { 54 => 0x37, 160 => 'DateCreated' },
	'datesent' => { 55 => 0x46 },
	'datestampmode' => { 16 => 0x1c },
	'datetime' => { 161 => 'DateTime' },
	'datetimedigitized' => { 157 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 41 => 0x0, 48 => 0x9003, 71 => 'OriginalDate', 157 => 'DateTimeOriginal' },
	'datetimestamp' => { 59 => 0x64 },
	'declination' => { 79 => 'Declination' },
	'decposition' => { 84 => 0x32 },
	'defaultcroporigin' => { 48 => 0xc61f },
	'defaultcropsize' => { 48 => 0xc620 },
	'defaultscale' => { 48 => 0xc61e },
	'defringe' => { 154 => 'Defringe' },
	'deletedimagecount' => { 98 => 0xa6 },
	'derivedfromdocumentid' => { 165 => 'DerivedFromDocumentID' },
	'derivedfrominstanceid' => { 165 => 'DerivedFromInstanceID' },
	'derivedfrommanager' => { 165 => 'DerivedFromManager' },
	'derivedfrommanagervariant' => { 165 => 'DerivedFromManagerVariant' },
	'derivedfrommanageto' => { 165 => 'DerivedFromManageTo' },
	'derivedfrommanageui' => { 165 => 'DerivedFromManageUI' },
	'derivedfromrenditionclass' => { 165 => 'DerivedFromRenditionClass' },
	'derivedfromrenditionparams' => { 165 => 'DerivedFromRenditionParams' },
	'derivedfromversionid' => { 165 => 'DerivedFromVersionID' },
	'description' => { 125 => 'Description', 155 => 'description' },
	'destination' => { 55 => 0x5 },
	'destinationcity' => { 134 => 0x24 },
	'destinationcitycode' => { 136 => 0x1001 },
	'destinationdst' => { 134 => 0x26 },
	'developmentdynamicrange' => { 52 => 0x1403 },
	'devicesettingdescriptioncolumns' => { 157 => 'DeviceSettingDescriptionColumns' },
	'devicesettingdescriptionrows' => { 157 => 'DeviceSettingDescriptionRows' },
	'devicesettingdescriptionsettings' => { 157 => 'DeviceSettingDescriptionSettings' },
	'dialdirectiontvav' => { 25 => 0x706 },
	'digitalcreationdate' => { 54 => 0x3e },
	'digitalcreationtime' => { 54 => 0x3f },
	'digitalgain' => { 21 => 0xb },
	'digitalgem' => { 96 => 0x0 },
	'digitalice' => { 102 => 0x100 },
	'digitalroc' => { 101 => 0x0 },
	'digitalzoom' => { 4 => 0xc, 44 => 0xa, 59 => 0x68, 70 => 'DigitalZoom', 84 => 0xc, 98 => 0x86, 103 => 0xa, 120 => 0x204, 134 => 0x1e, 136 => 0xa, 145 => 0x204 },
	'digitalzoomon' => { 145 => 0x21b },
	'digitalzoomratio' => { 48 => 0xa404, 157 => 'DigitalZoomRatio' },
	'directory' => { 49 => 'Directory' },
	'disclaimer' => { 125 => 'Disclaimer' },
	'displayaperture' => { 4 => 0x23 },
	'displayedunitsx' => { 141 => 0x2 },
	'displayedunitsy' => { 141 => 0x6 },
	'distance1' => { 59 => 0x28 },
	'distance2' => { 59 => 0x2c },
	'distance3' => { 59 => 0x30 },
	'distance4' => { 59 => 0x34 },
	'distortioncorrection' => { 115 => 0x50b },
	'distortioncorrection2' => { 119 => 0x1011 },
	'dngbackwardversion' => { 48 => 0xc613 },
	'dnglensinfo' => { 48 => 0xc630 },
	'dngversion' => { 48 => 0xc612 },
	'document' => { 125 => 'Document' },
	'documenthistory' => { 54 => 0xe7 },
	'documentid' => { 165 => 'DocumentID' },
	'documentname' => { 48 => 0x10d },
	'documentnotes' => { 54 => 0xe6 },
	'dotrange' => { 48 => 0x150 },
	'drivemode' => { 84 => 0x6, 87 => 0x1e, 115 => 0x600, 134 => 0x34, 146 => 0x3 },
	'duration' => { 69 => 'Duration', 83 => 'Duration', 164 => 'duration' },
	'dynamicrange' => { 52 => 0x1400 },
	'dynamicrangemax' => { 42 => 0x7c },
	'dynamicrangemin' => { 42 => 0x7a },
	'dynamicrangesetting' => { 52 => 0x1402 },
	'easymode' => { 4 => 0xb },
	'edgenoisereduction' => { 110 => 0x4 },
	'editorialupdate' => { 54 => 0x8 },
	'editstatus' => { 54 => 0x7, 138 => 'EditStatus' },
	'elevation' => { 79 => 'Elevation' },
	'email' => { 71 => 'EMail' },
	'engineer' => { 164 => 'engineer' },
	'enhancedarktones' => { 104 => 0x8 },
	'enhancement' => { 44 => 0x16, 45 => 0x3016 },
	'envelopenumber' => { 55 => 0x28 },
	'envelopepriority' => { 55 => 0x3c },
	'enveloperecordversion' => { 55 => 0x0 },
	'epsonimageheight' => { 120 => 0x20c },
	'epsonimagewidth' => { 120 => 0x20b },
	'epsonsoftware' => { 120 => 0x20d },
	'equipmentinstitution' => { 148 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 148 => 'EquipmentManufacturer' },
	'equipmentversion' => { 116 => 0x0 },
	'ettlii' => { 25 => 0x304, 26 => 0xd, 27 => 0xe, 28 => 0x7, 29 => 0x7, 30 => 0xe },
	'event' => { 150 => 'Event' },
	'excursiontolerance' => { 56 => 0x82 },
	'exifbyteorder' => { 49 => 'ExifByteOrder' },
	'exifcamerainfo' => { 54 => 0xe8 },
	'exifimagelength' => { 48 => 0xa003, 157 => 'PixelYDimension' },
	'exifimagewidth' => { 48 => 0xa002, 157 => 'PixelXDimension' },
	'exifversion' => { 48 => 0x9000, 157 => 'ExifVersion' },
	'expirationdate' => { 54 => 0x25 },
	'expirationtime' => { 54 => 0x26 },
	'exposure' => { 48 => 0xfe51, 154 => 'Exposure' },
	'exposurebracketvalue' => { 98 => 0x19 },
	'exposurecompensation' => { 22 => 0x6, 34 => 0x0, 48 => 0x9204, 59 => 0x24, 70 => 'ExposureComp', 84 => 0xd, 85 => 0x53, 86 => 0x1e, 87 => 0x1, 120 => 0x1006, 134 => 0x16, 146 => [0xc,0x35], 157 => 'ExposureBiasValue' },
	'exposuredifference' => { 98 => 0xe },
	'exposureindex' => { 48 => 0xa215, 157 => 'ExposureIndex' },
	'exposurelevelincrements' => { 23 => 0x6, 24 => 0x6, 25 => 0x101, 26 => 0x5, 27 => 0x6, 28 => 0x5, 29 => 0x5, 30 => 0x6, 31 => 0x4 },
	'exposuremode' => { 48 => 0xa402, 70 => 'ExposureMode', 84 => 0x1, 85 => 0xa, 86 => 0x0, 87 => 0x0, 115 => 0x200, 146 => 0x8, 157 => 'ExposureMode' },
	'exposuremodeinmanual' => { 25 => 0x10b },
	'exposureprogram' => { 48 => 0x8822, 157 => 'ExposureProgram' },
	'exposuretime' => { 1 => 0x4, 2 => 0x4, 3 => 0x6, 22 => 0x16, 48 => 0x829a, 58 => 0xfd05, 59 => 0x20, 60 => 0xfa24, 62 => 0xf104, 66 => 0x38, 70 => 'ExposureTime', 84 => 0x9, 85 => 0x35, 86 => 0x48, 134 => 0x12, 146 => 0x32, 157 => 'ExposureTime' },
	'exposurewarning' => { 52 => 0x1302 },
	'extender' => { 116 => 0x301 },
	'extenderfirmwareversion' => { 116 => 0x304 },
	'extendermagnification' => { 72 => 'Magnification' },
	'extendermake' => { 72 => 'Make' },
	'extendermodel' => { 72 => 'Model', 116 => 0x303 },
	'extenderserialnumber' => { 72 => 'SerialNumber', 116 => 0x302 },
	'externalflash' => { 118 => 0x1201 },
	'externalflashae1' => { 120 => 0x101f },
	'externalflashae1_0' => { 120 => 0x101b },
	'externalflashae2' => { 120 => 0x1020 },
	'externalflashae2_0' => { 120 => 0x101c },
	'externalflashbounce' => { 118 => 0x1204, 120 => 0x1026 },
	'externalflashguidenumber' => { 118 => 0x1203 },
	'externalflashgvalue' => { 120 => 0x1025 },
	'externalflashmode' => { 120 => 0x1028, 132 => 0x2 },
	'externalflashzoom' => { 118 => 0x1205, 120 => 0x1027 },
	'face0position' => { 11 => 0x8 },
	'face1position' => { 11 => 0xa },
	'face2position' => { 11 => 0xc },
	'face3position' => { 11 => 0xe },
	'face4position' => { 11 => 0x10 },
	'face5position' => { 11 => 0x12 },
	'face6position' => { 11 => 0x14 },
	'face7position' => { 11 => 0x16 },
	'face8position' => { 11 => 0x18 },
	'facedetectframeheight' => { 11 => 0x4 },
	'facedetectframewidth' => { 11 => 0x3 },
	'facesdetected' => { 11 => 0x2, 12 => 0x2 },
	'ffid' => { 156 => 'ffid' },
	'fieldcount' => { 120 => 0x103f },
	'filedatarate' => { 164 => 'fileDataRate' },
	'fileformat' => { 36 => 0x0, 55 => 0x14 },
	'filemodifydate' => { 49 => 'FileModifyDate' },
	'filename' => { 49 => 'FileName' },
	'filenumber' => { 2 => 0x172, 13 => 0x1, 16 => 0x8, 38 => 0x1817 },
	'filenumbermemory' => { 84 => 0x1a },
	'filesource' => { 48 => 0xa300, 52 => 0x8000, 157 => 'FileSource' },
	'fileversion' => { 55 => 0x16 },
	'fillflashautoreduction' => { 23 => 0xe, 24 => 0xe, 31 => 0xa },
	'filllight' => { 154 => 'FillLight' },
	'fillorder' => { 48 => 0x10a },
	'filmmode' => { 52 => 0x1401, 126 => 0x42 },
	'filmtype' => { 102 => 0x2 },
	'filter' => { 45 => 0x3017 },
	'filtereffect' => { 13 => 0xe },
	'filtereffectmonochrome' => { 1 => 0xff },
	'finalimageheight' => { 123 => 0x615 },
	'finalimagewidth' => { 123 => 0x614 },
	'finderdisplayduringexposure' => { 24 => 0x1 },
	'firmware' => { 120 => 0x405, 146 => [0x17,0x3b], 152 => 'Firmware' },
	'firmwaredate' => { 45 => 0x2001 },
	'firmwareid' => { 89 => 0x0 },
	'firmwarerevision' => { 1 => 0xa4, 16 => 0x1e },
	'firmwareversion' => { 70 => 'FirmwareVersion', 126 => 0x2 },
	'fixtureidentifier' => { 54 => 0x16 },
	'flash' => { 48 => 0x9209, 85 => 0x1f, 86 => 0x15 },
	'flashactivity' => { 4 => 0x1c },
	'flashadump' => { 134 => 0x20a },
	'flashbdump' => { 134 => 0x20b },
	'flashbias' => { 126 => 0x24 },
	'flashbits' => { 4 => 0x1d },
	'flashchargelevel' => { 120 => 0x1010 },
	'flashcompensation' => { 152 => 'FlashCompensation' },
	'flashdevice' => { 120 => 0x1005 },
	'flashdistance' => { 45 => 0x2034 },
	'flashenergy' => { 48 => 0xa20b, 157 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 98 => 0x18 },
	'flashexposurecomp' => { 22 => 0xf, 73 => 'ExposureComp', 84 => 0x23, 88 => 0x104, 98 => 0x12, 120 => 0x1023, 134 => 0x4d, 146 => 0x3a },
	'flashexposurecompensation' => { 115 => 0x401 },
	'flashfired' => { 59 => 0x5d, 73 => 'Fired', 84 => 0x14, 157 => 'FlashFired' },
	'flashfiring' => { 25 => 0x306, 26 => 0x6, 27 => 0x7, 30 => 0x7 },
	'flashfirmwareversion' => { 116 => 0x1002 },
	'flashfunction' => { 157 => 'FlashFunction' },
	'flashguidenumber' => { 22 => 0xd, 35 => 0x0, 73 => 'GuideNumber' },
	'flashintensity' => { 44 => [0x19,0x5] },
	'flashmake' => { 73 => 'Make' },
	'flashmanufacturer' => { 151 => 'FlashManufacturer' },
	'flashmetering' => { 84 => 0x3f },
	'flashmode' => { 44 => 0x4, 59 => 0x5c, 73 => 'Mode', 84 => 0x2, 98 => 0x87, 115 => 0x400, 120 => 0x1004, 134 => 0xc, 136 => 0x4, 143 => 0x20, 145 => 0x225, 157 => 'FlashMode' },
	'flashmodecode' => { 132 => 0x1 },
	'flashmodel' => { 73 => 'Model', 116 => 0x1001, 151 => 'FlashModel' },
	'flashoutput' => { 22 => 0x21 },
	'flashpixversion' => { 48 => 0xa000, 157 => 'FlashpixVersion' },
	'flashredeyemode' => { 157 => 'FlashRedEyeMode' },
	'flashreturn' => { 157 => 'FlashReturn' },
	'flashserialnumber' => { 73 => 'SerialNumber', 116 => 0x1003 },
	'flashsetting' => { 98 => 0x8 },
	'flashstatus' => { 132 => 0x0 },
	'flashstrength' => { 52 => 0x1011 },
	'flashsyncspeedav' => { 23 => 0x3, 25 => 0x10f, 26 => 0x2, 27 => 0x3, 28 => 0x2, 29 => 0x2, 30 => 0x3, 31 => 0x6 },
	'flashthreshold' => { 35 => 0x1 },
	'flashtype' => { 73 => 'Type', 98 => 0x9, 116 => 0x1000 },
	'flickerreduce' => { 145 => 0x218 },
	'fliphorizontal' => { 109 => 0x76a43206 },
	'fnumber' => { 1 => 0x3, 2 => 0x3, 3 => 0x5, 22 => 0x15, 48 => 0x829d, 58 => 0xfd04, 59 => 0x1e, 60 => 0xfa23, 62 => 0xf103, 66 => 0x3c, 77 => 'FNumber', 84 => 0xa, 85 => 0x36, 86 => 0x47, 134 => 0x13, 146 => 0x31, 157 => 'FNumber' },
	'focallength' => { 1 => 0x9, 2 => 0x1d, 15 => 0x1, 45 => 0x1d, 48 => 0x920a, 77 => 'FocalLength', 84 => 0x12, 134 => 0x1d, 157 => 'FocalLength' },
	'focallengthin35mmformat' => { 48 => 0xa405, 157 => 'FocalLengthIn35mmFilm' },
	'focalplanediagonal' => { 116 => 0x103, 120 => 0x205 },
	'focalplaneresolutionunit' => { 48 => 0xa210, 157 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 48 => 0xa20e, 157 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 15 => 0x2 },
	'focalplaneyresolution' => { 48 => 0xa20f, 157 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 15 => 0x3 },
	'focaltype' => { 1 => 0x2d, 15 => 0x0 },
	'focalunits' => { 4 => 0x19 },
	'focus' => { 103 => 0x8 },
	'focusarea' => { 84 => 0x31 },
	'focuscontinuous' => { 4 => 0x20 },
	'focusdistance' => { 77 => 'FocusDistance', 84 => 0x13, 118 => 0x305 },
	'focusdistancelower' => { 22 => 0x14 },
	'focusdistanceupper' => { 22 => 0x13 },
	'focusinfoversion' => { 118 => 0x0 },
	'focusingscreen' => { 24 => 0x0, 25 => 0x80b, 30 => 0x0 },
	'focusmode' => { 4 => 0x7, 44 => 0x3, 45 => [0x3003,0xd], 52 => 0x1021, 59 => 0x38, 70 => 'FocusMode', 84 => 0x30, 86 => 0xe, 98 => 0x7, 115 => 0x301, 120 => 0x100b, 126 => 0x7, 134 => 0xd, 136 => 0x3 },
	'focuspixel' => { 52 => 0x1023 },
	'focusposition' => { 134 => 0x10 },
	'focusprocess' => { 115 => 0x302 },
	'focusrange' => { 4 => 0x12, 120 => 0x100a },
	'focussetting' => { 146 => 0x6 },
	'focusstepcount' => { 118 => 0x301, 120 => 0x100e },
	'focuswarning' => { 52 => 0x1301 },
	'foldername' => { 84 => 0x27 },
	'fontschildfontfiles' => { 168 => 'FontsChildFontFiles' },
	'fontscomposite' => { 168 => 'FontsComposite' },
	'fontsfontface' => { 168 => 'FontsFontFace' },
	'fontsfontfamily' => { 168 => 'FontsFontFamily' },
	'fontsfontfilename' => { 168 => 'FontsFontFileName' },
	'fontsfontname' => { 168 => 'FontsFontName' },
	'fontsfonttype' => { 168 => 'FontsFontType' },
	'fontsversionstring' => { 168 => 'FontsVersionString' },
	'for' => { 142 => 'For' },
	'format' => { 155 => 'format' },
	'framenum' => { 137 => 0xd7 },
	'framenumber' => { 52 => 0x8003, 134 => 0x29 },
	'freebytes' => { 38 => 0x1 },
	'freememorycardimages' => { 85 => [0x37,0x54], 86 => [0x2d,0x4a] },
	'fujiflashmode' => { 52 => 0x1010 },
	'fullsizeimage' => { 76 => 'data' },
	'fullsizeimagename' => { 76 => '1Name' },
	'fullsizeimagetype' => { 76 => '0Type' },
	'gaincontrol' => { 48 => 0xa407, 157 => 'GainControl' },
	'gamma' => { 48 => 0xa500 },
	'gammacompensatedvalue' => { 56 => 0x91 },
	'genre' => { 164 => 'genre' },
	'globalaltitude' => { 140 => 0x419 },
	'globalangle' => { 140 => 0x40d },
	'gpsaltitude' => { 53 => 0x6, 74 => 'Altitude', 157 => 'GPSAltitude' },
	'gpsaltituderef' => { 53 => 0x5, 157 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 53 => 0x1c, 157 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 53 => 0x1d },
	'gpsdatetime' => { 74 => 'DateTime' },
	'gpsdestbearing' => { 53 => 0x18, 74 => 'Bearing', 157 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 53 => 0x17, 157 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 53 => 0x1a, 74 => 'Distance', 157 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 53 => 0x19, 157 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 53 => 0x14, 157 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 53 => 0x13 },
	'gpsdestlongitude' => { 53 => 0x16, 157 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 53 => 0x15 },
	'gpsdifferential' => { 53 => 0x1e, 74 => 'Differential', 157 => 'GPSDifferential' },
	'gpsdop' => { 53 => 0xb, 157 => 'GPSDOP' },
	'gpsimgdirection' => { 53 => 0x11, 157 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 53 => 0x10, 157 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 53 => 0x2, 74 => 'Latitude', 157 => 'GPSLatitude' },
	'gpslatituderef' => { 53 => 0x1 },
	'gpslongitude' => { 53 => 0x4, 74 => 'Longitude', 157 => 'GPSLongitude' },
	'gpslongituderef' => { 53 => 0x3 },
	'gpsmapdatum' => { 53 => 0x12, 74 => 'Datum', 157 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 53 => 0xa, 74 => 'MeasureMode', 157 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 53 => 0x1b, 157 => 'GPSProcessingMethod' },
	'gpssatellites' => { 53 => 0x8, 74 => 'Satellites', 157 => 'GPSSatellites' },
	'gpsspeed' => { 53 => 0xd, 74 => 'Speed', 157 => 'GPSSpeed' },
	'gpsspeedref' => { 53 => 0xc, 157 => 'GPSSpeedRef' },
	'gpsstatus' => { 53 => 0x9, 157 => 'GPSStatus' },
	'gpstimestamp' => { 53 => 0x7, 157 => 'GPSTimeStamp' },
	'gpstrack' => { 53 => 0xf, 74 => 'Heading', 157 => 'GPSTrack' },
	'gpstrackref' => { 53 => 0xe, 157 => 'GPSTrackRef' },
	'gpsversionid' => { 53 => 0x0, 157 => 'GPSVersionID' },
	'gradation' => { 115 => 0x50f },
	'grayresponseunit' => { 48 => 0x122 },
	'greencurvelimits' => { 42 => 0x1c4 },
	'greencurvepoints' => { 42 => 0x19a },
	'greenhue' => { 154 => 'GreenHue' },
	'greensaturation' => { 154 => 'GreenSaturation' },
	'halftonehints' => { 48 => 0x141 },
	'hascrop' => { 154 => 'HasCrop' },
	'hassettings' => { 154 => 'HasSettings' },
	'headline' => { 54 => 0x69, 160 => 'Headline' },
	'hierarchicalsubject' => { 149 => 'hierarchicalSubject' },
	'highisonoisereduction' => { 25 => 0x202, 98 => 0xb1 },
	'highlight' => { 146 => 0xf },
	'highlightrecovery' => { 154 => 'HighlightRecovery' },
	'highlighttonepriority' => { 25 => 0x203 },
	'history' => { 160 => 'History' },
	'historyaction' => { 165 => 'HistoryAction' },
	'historyinstanceid' => { 165 => 'HistoryInstanceID' },
	'historyparameters' => { 165 => 'HistoryParameters' },
	'historysoftwareagent' => { 165 => 'HistorySoftwareAgent' },
	'historywhen' => { 165 => 'HistoryWhen' },
	'hometowncity' => { 45 => 0x3006, 134 => 0x23 },
	'hometowncitycode' => { 136 => 0x1000 },
	'hometowndst' => { 134 => 0x25 },
	'hostcomputer' => { 48 => 0x13c },
	'hue' => { 90 => 0x3b },
	'hueadjustment' => { 98 => 0x92 },
	'hueadjustmentaqua' => { 154 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 154 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 154 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 154 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 154 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 154 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 154 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 154 => 'HueAdjustmentYellow' },
	'huesetting' => { 123 => 0x1011 },
	'icc_profile' => { 49 => 'ICC_Profile' },
	'iccprofilename' => { 160 => 'ICCProfile' },
	'identifier' => { 155 => 'identifier', 162 => 'Identifier' },
	'imageadjustment' => { 98 => 0x80, 103 => 0x5 },
	'imageareaoffset' => { 134 => 0x38 },
	'imageauthentication' => { 98 => 0x20 },
	'imageboundary' => { 98 => 0x16 },
	'imagecount' => { 98 => 0xa5 },
	'imagedatasize' => { 98 => 0xa2 },
	'imagedescription' => { 48 => 0x10e, 161 => 'ImageDescription' },
	'imagedustoff' => { 109 => 0xfe443a45 },
	'imageheight' => { 48 => 0x101, 89 => 0xc, 161 => 'ImageLength' },
	'imagehistory' => { 48 => 0x9213 },
	'imagenumber' => { 1 => 0xd0, 48 => 0x9211, 70 => 'ImageNumber', 85 => 0xae, 86 => 0x5e, 152 => 'ImageNumber' },
	'imagenumber2' => { 86 => 0x62 },
	'imageoptimization' => { 98 => 0xa9 },
	'imageorientation' => { 54 => 0x83 },
	'imageprocessing' => { 98 => 0x1a, 134 => 0x32 },
	'imageprocessingversion' => { 119 => 0x0 },
	'imagequality' => { 70 => 'ImageQuality', 126 => 0x1 },
	'imagequality2' => { 115 => 0x603 },
	'imagesize' => { 76 => 'ImageSize' },
	'imagesourcedata' => { 48 => 0x935c },
	'imagestabilization' => { 4 => 0x22, 45 => 0x3020, 70 => 'ImageStabilization', 85 => 0xbd, 86 => 0x71, 87 => 0x87, 88 => [0x18,0x107,0x113], 98 => 0xac, 118 => 0x1600, 126 => 0x1a },
	'imagetone' => { 134 => 0x4f },
	'imagetype' => { 54 => 0x82 },
	'imageuniqueid' => { 48 => 0xa420, 157 => 'ImageUniqueID' },
	'imagewidth' => { 48 => 0x100, 89 => 0xe, 161 => 'ImageWidth' },
	'incrementaltemperature' => { 154 => 'IncrementalTemperature' },
	'incrementaltint' => { 154 => 'IncrementalTint' },
	'infinitylensstep' => { 120 => 0x103b },
	'infobuttonwhenshooting' => { 25 => 0x409 },
	'inkset' => { 48 => 0x14c },
	'instanceid' => { 165 => 'InstanceID' },
	'instructions' => { 160 => 'Instructions' },
	'instrument' => { 164 => 'instrument' },
	'intellectualgenre' => { 158 => 'IntellectualGenre' },
	'interchangecolorspace' => { 56 => 0x40 },
	'internalflash' => { 84 => 0x2b, 118 => 0x1208 },
	'internalflashae1' => { 120 => 0x1021 },
	'internalflashae1_0' => { 120 => 0x101d },
	'internalflashae2' => { 120 => 0x1022 },
	'internalflashae2_0' => { 120 => 0x101e },
	'internalflashmagni' => { 132 => 0x3 },
	'internalflashtable' => { 120 => 0x1024 },
	'internalserialnumber' => { 16 => 0x96, 52 => 0x10, 116 => 0x102, 126 => 0x25, 131 => 0x4 },
	'interopindex' => { 48 => 0x1 },
	'interopversion' => { 48 => 0x2 },
	'intervallength' => { 84 => 0x10 },
	'intervalmode' => { 84 => 0x26 },
	'intervalnumber' => { 84 => 0x11 },
	'introtime' => { 164 => 'introTime' },
	'iptc-naa' => { 48 => 0x83bb },
	'iptcbitspersample' => { 56 => 0x56 },
	'iptcimageheight' => { 56 => 0x1e },
	'iptcimagerotation' => { 56 => 0x66 },
	'iptcimagewidth' => { 56 => 0x14 },
	'iptcpicturenumber' => { 56 => 0xa },
	'iptcpixelheight' => { 56 => 0x32 },
	'iptcpixelwidth' => { 56 => 0x28 },
	'iso' => { 1 => 0x6, 2 => 0x6, 3 => 0x0, 44 => 0x14, 45 => [0x3014,0x14], 48 => 0x8827, 58 => 0xfd06, 59 => 0x60, 60 => [0xfa2e,0xfa46], 61 => [0x27,0x28], 62 => 0xf105, 66 => 0x4e, 70 => 'ISO', 84 => 0x8, 98 => 0x2, 127 => 0x17, 134 => 0x14, 136 => 0x14, 157 => 'ISOSpeedRatings' },
	'isoexpansion' => { 25 => 0x103, 26 => 0x7, 27 => 0x8, 30 => 0x8 },
	'isoselection' => { 98 => 0xf },
	'isosetting' => { 59 => 0x5e, 70 => 'ISOSetting', 84 => 0x24, 85 => 0x26, 86 => 0x1c, 90 => 0x6, 98 => 0x13, 143 => 0x27 },
	'isospeedexpansion' => { 24 => 0x3 },
	'isospeedincrements' => { 25 => 0x102 },
	'isospeedrange' => { 25 => 0x103 },
	'isovalue' => { 120 => 0x1001 },
	'jobid' => { 54 => 0xb8 },
	'jobrefid' => { 163 => 'JobRefId' },
	'jobrefname' => { 163 => 'JobRefName' },
	'jobrefurl' => { 163 => 'JobRefUrl' },
	'jpgfromraw' => { 38 => 0x2007, 46 => 'JpgFromRaw' },
	'jpgfromrawlength' => { 48 => [0x117,0x202] },
	'jpgfromrawstart' => { 48 => [0x111,0x201] },
	'key' => { 164 => 'key' },
	'keywords' => { 54 => 0x19, 71 => 'Keywords', 142 => 'Keywords', 159 => 'Keywords' },
	'kodakimageheight' => { 58 => 0xf908, 59 => 0xe, 60 => [0xfa1e,0xfa52], 65 => 0x70 },
	'kodakimagewidth' => { 58 => 0xf907, 59 => 0xc, 60 => [0xfa1d,0xfa51], 65 => 0x6c },
	'kodakinfotype' => { 58 => 0xfa00 },
	'kodakmaker' => { 65 => 0x8 },
	'kodakmodel' => { 59 => 0x0, 65 => 0x28 },
	'label' => { 125 => 'Label', 162 => 'Label' },
	'language' => { 155 => 'language' },
	'languageidentifier' => { 54 => 0x87 },
	'lastfilenumber' => { 84 => 0x1b },
	'lastkeywordiptc' => { 151 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 151 => 'LastKeywordXMP' },
	'lasturl' => { 165 => 'LastURL' },
	'lcddisplayatpoweron' => { 29 => 0xa },
	'lcddisplayreturntoshoot' => { 30 => 0x12 },
	'lcdilluminationduringbulb' => { 25 => 0x408 },
	'lcdpanels' => { 24 => 0x8 },
	'lcheditor' => { 109 => 0x8ae85e },
	'legacyiptcdigest' => { 160 => 'LegacyIPTCDigest' },
	'lens' => { 48 => 0xfdea, 98 => 0x84, 146 => 0xa, 152 => 'Lens' },
	'lensafstopbutton' => { 23 => 0x11, 24 => 0x13, 25 => 0x506, 26 => 0x10, 27 => 0x12, 30 => 0x13, 31 => 0x9 },
	'lensaperturerange' => { 146 => 0x30 },
	'lenscodes' => { 133 => [0x4,0x5] },
	'lensdataversion' => { 97 => 0x0 },
	'lensdistortionparams' => { 120 => 0x206 },
	'lensdrivenoaf' => { 25 => 0x505 },
	'lensfirmwareversion' => { 116 => 0x204 },
	'lensfstops' => { 97 => 0x7, 98 => 0x8b },
	'lensid' => { 88 => 0x10c },
	'lensidnumber' => { 97 => 0x6 },
	'lensinfo' => { 152 => 'LensInfo' },
	'lensmake' => { 77 => 'Make' },
	'lensmanufacturer' => { 151 => 'LensManufacturer' },
	'lensmodel' => { 77 => 'Model', 151 => 'LensModel' },
	'lensproperties' => { 116 => 0x20b },
	'lensserialnumber' => { 77 => 'SerialNumber', 116 => 0x202, 126 => 0x52 },
	'lenstemperature' => { 120 => 0x1008 },
	'lenstype' => { 1 => 0xd, 4 => 0x16, 16 => 0x95, 98 => 0x83, 116 => 0x201, 126 => 0x51, 133 => 0x0, 134 => 0x3f },
	'license' => { 153 => 'license' },
	'licensetype' => { 156 => 'licensetype' },
	'lightcondition' => { 120 => 0x1009 },
	'lightsource' => { 48 => 0x9208, 98 => 0x90, 123 => 0x1000, 157 => 'LightSource' },
	'lightsourcespecial' => { 145 => 0x21d },
	'lightvaluecenter' => { 120 => 0x103d },
	'lightvalueperiphery' => { 120 => 0x103e },
	'linearresponselimit' => { 48 => 0xc62e },
	'liveviewexposuresimulation' => { 25 => 0x810 },
	'localcaption' => { 54 => 0x79 },
	'localizedcameramodel' => { 48 => 0xc615 },
	'location' => { 150 => 'Location', 158 => 'Location' },
	'lockmicrophonebutton' => { 25 => 0x709 },
	'logcomment' => { 164 => 'logComment' },
	'longexposurenoisereduction' => { 25 => 0x201, 26 => 0x1, 27 => 0x2, 28 => 0x1, 29 => 0x1, 30 => 0x2, 31 => 0x1 },
	'longfocal' => { 1 => 0x13, 2 => 0x115, 4 => 0x17 },
	'loop' => { 164 => 'loop' },
	'luminanceadjustmentaqua' => { 154 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 154 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 154 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 154 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 154 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 154 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 154 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 154 => 'LuminanceAdjustmentYellow' },
	'luminancenoisereduction' => { 43 => 0xbe },
	'luminancesmoothing' => { 154 => 'LuminanceSmoothing' },
	'macro' => { 52 => 0x1020, 120 => 0x202, 143 => 0x21, 145 => 0x202 },
	'macromode' => { 4 => 0x1, 84 => 0xb, 115 => 0x300, 126 => 0x1c },
	'magnifiedview' => { 27 => 0x11, 29 => 0x9 },
	'make' => { 39 => 0x0, 48 => 0x10f, 70 => 'Make', 125 => 'Make', 127 => 0x10f, 161 => 'Make' },
	'makernote' => { 157 => 'MakerNote' },
	'makernotecanon' => { 47 => 'MakN', 48 => 0x927c },
	'makernotecasio' => { 47 => 'MakN', 48 => 0x927c },
	'makernotecasio2' => { 47 => 'MakN', 48 => 0x927c },
	'makernotefujifilm' => { 47 => 'MakN', 48 => 0x927c },
	'makernotehp' => { 47 => 'MakN', 48 => 0x927c },
	'makernotehp2' => { 47 => 'MakN', 48 => 0x927c },
	'makernotehp4' => { 47 => 'MakN', 48 => 0x927c },
	'makernotehp6' => { 47 => 'MakN', 48 => 0x927c },
	'makernotejvc' => { 47 => 'MakN', 48 => 0x927c },
	'makernotejvctext' => { 47 => 'MakN', 48 => 0x927c },
	'makernotekodak1a' => { 47 => 'MakN', 48 => 0x927c },
	'makernotekodak1b' => { 47 => 'MakN', 48 => 0x927c },
	'makernotekodak2' => { 47 => 'MakN', 48 => 0x927c },
	'makernotekodak3' => { 47 => 'MakN', 48 => 0x927c },
	'makernotekodak4' => { 47 => 'MakN', 48 => 0x927c },
	'makernotekodak5' => { 47 => 'MakN', 48 => 0x927c },
	'makernotekodak6a' => { 47 => 'MakN', 48 => 0x927c },
	'makernotekodak6b' => { 47 => 'MakN', 48 => 0x927c },
	'makernotekodak7' => { 47 => 'MakN', 48 => 0x927c },
	'makernotekodakifd' => { 47 => 'MakN', 48 => 0x927c },
	'makernotekodakunknown' => { 47 => 'MakN', 48 => 0x927c },
	'makernotekyocera' => { 47 => 'MakN', 48 => 0x927c },
	'makernoteleica' => { 47 => 'MakN', 48 => 0x927c },
	'makernoteminolta' => { 47 => 'MakN', 48 => 0x927c },
	'makernoteminolta2' => { 47 => 'MakN', 48 => 0x927c },
	'makernoteminolta3' => { 47 => 'MakN', 48 => 0x927c },
	'makernotenikon' => { 47 => 'MakN', 48 => 0x927c },
	'makernotenikon2' => { 47 => 'MakN', 48 => 0x927c },
	'makernotenikon3' => { 47 => 'MakN', 48 => 0x927c },
	'makernoteoffset' => { 145 => 0xff },
	'makernoteolympus' => { 47 => 'MakN', 48 => 0x927c },
	'makernoteolympus2' => { 47 => 'MakN', 48 => 0x927c },
	'makernotepanasonic' => { 47 => 'MakN', 48 => 0x927c },
	'makernotepanasonic2' => { 47 => 'MakN', 48 => 0x927c },
	'makernotepentax' => { 47 => 'MakN', 48 => 0x927c },
	'makernotepentax2' => { 47 => 'MakN', 48 => 0x927c },
	'makernotepentax3' => { 47 => 'MakN', 48 => 0x927c },
	'makernotepentax4' => { 47 => 'MakN', 48 => 0x927c },
	'makernotericoh' => { 47 => 'MakN', 48 => 0x927c },
	'makernotericohtext' => { 47 => 'MakN', 48 => 0x927c },
	'makernotesafety' => { 48 => 0xc635 },
	'makernotesanyo' => { 47 => 'MakN', 48 => 0x927c },
	'makernotesanyoc4' => { 47 => 'MakN', 48 => 0x927c },
	'makernotesanyopatch' => { 47 => 'MakN', 48 => 0x927c },
	'makernotesigma' => { 47 => 'MakN', 48 => 0x927c },
	'makernotesony' => { 47 => 'MakN', 48 => 0x927c },
	'makernotesonysr2' => { 47 => 'MakN', 48 => 0x927c },
	'makernotesonysrf' => { 47 => 'MakN', 48 => 0x927c },
	'makernotetype' => { 144 => 0x1 },
	'makernoteunknown' => { 47 => 'MakN', 48 => 0x927c },
	'makernoteversion' => { 88 => 0x0, 98 => 0x1, 120 => 0x0, 126 => 0x8000, 144 => 0x2, 146 => 0x1d },
	'managedfromdocumentid' => { 165 => 'ManagedFromDocumentID' },
	'managedfrominstanceid' => { 165 => 'ManagedFromInstanceID' },
	'managedfrommanager' => { 165 => 'ManagedFromManager' },
	'managedfrommanagervariant' => { 165 => 'ManagedFromManagerVariant' },
	'managedfrommanageto' => { 165 => 'ManagedFromManageTo' },
	'managedfrommanageui' => { 165 => 'ManagedFromManageUI' },
	'managedfromrenditionclass' => { 165 => 'ManagedFromRenditionClass' },
	'managedfromrenditionparams' => { 165 => 'ManagedFromRenditionParams' },
	'managedfromversionid' => { 165 => 'ManagedFromVersionID' },
	'manager' => { 165 => 'Manager' },
	'managervariant' => { 165 => 'ManagerVariant' },
	'manageto' => { 165 => 'ManageTo' },
	'manageui' => { 165 => 'ManageUI' },
	'manometerreading' => { 115 => 0x901 },
	'manualflash' => { 118 => 0x1209 },
	'manualflashoutput' => { 4 => 0x29 },
	'manualfocusdistance' => { 98 => 0x85, 120 => 0x100c, 145 => 0x223 },
	'manualtv' => { 24 => 0x5, 25 => 0x705 },
	'manufacturedate' => { 131 => 0x1 },
	'marked' => { 167 => 'Marked' },
	'markerscomment' => { 164 => 'markersComment' },
	'markersduration' => { 164 => 'markersDuration' },
	'markerslocation' => { 164 => 'markersLocation' },
	'markersname' => { 164 => 'markersName' },
	'markersstarttime' => { 164 => 'markersStartTime' },
	'markerstarget' => { 164 => 'markersTarget' },
	'markerstype' => { 164 => 'markersType' },
	'maskedareas' => { 48 => 0xc68e },
	'masterdocumentid' => { 54 => 0xb9 },
	'mastergain' => { 102 => 0x50 },
	'maxaperture' => { 4 => 0x1a, 62 => 0x6103, 77 => 'MaxAperture', 84 => 0x17 },
	'maxapertureatcurrentfocal' => { 116 => 0x20a },
	'maxapertureatmaxfocal' => { 52 => 0x1407, 77 => 'MaxApertureAtMaxFocal', 97 => 0xb, 116 => 0x206 },
	'maxapertureatminfocal' => { 52 => 0x1406, 97 => 0xa, 116 => 0x205 },
	'maxaperturevalue' => { 48 => 0x9205, 157 => 'MaxApertureValue' },
	'maxfocallength' => { 52 => 0x1405, 77 => 'MaxFocalLength', 97 => 0x9, 116 => 0x208 },
	'maximumdensityrange' => { 56 => 0x8c },
	'maxpagesizeh' => { 168 => 'MaxPageSizeH' },
	'maxpagesizeunit' => { 168 => 'MaxPageSizeUnit' },
	'maxpagesizew' => { 168 => 'MaxPageSizeW' },
	'maxsamplevalue' => { 48 => 0x119 },
	'mcuversion' => { 97 => 0xc },
	'md5digest' => { 78 => 'zmd5' },
	'measuredev' => { 22 => 0x3, 38 => 0x1814, 70 => 'MeasuredEV' },
	'menubuttondisplayposition' => { 23 => 0xb, 26 => 0xa, 27 => 0xb, 30 => 0xb },
	'menubuttonreturn' => { 31 => 0xb },
	'metadatadate' => { 162 => 'MetadataDate' },
	'metadatamoddate' => { 164 => 'metadataModDate' },
	'meteringmode' => { 4 => 0x11, 48 => 0x9207, 59 => 0x1c, 84 => 0x7, 85 => 0x25, 115 => 0x202, 134 => 0x17, 146 => 0x9, 157 => 'MeteringMode' },
	'mieversion' => { 78 => '0Vers' },
	'minaperture' => { 4 => 0x1b, 77 => 'MinAperture' },
	'minfocallength' => { 52 => 0x1404, 77 => 'MinFocalLength', 97 => 0x8, 116 => 0x207 },
	'minoltadate' => { 84 => 0x15 },
	'minoltaimagesize' => { 84 => 0x4, 85 => 0xc, 86 => 0x2, 88 => 0x103 },
	'minoltamodelid' => { 84 => 0x25 },
	'minoltaquality' => { 84 => 0x5, 85 => 0xd, 86 => 0x3, 88 => [0x102,0x103], 120 => [0x102,0x103] },
	'minoltatime' => { 84 => 0x16 },
	'minsamplevalue' => { 48 => 0x118 },
	'mirrorlockup' => { 23 => 0xc, 24 => 0xc, 25 => 0x60f, 26 => 0xb, 27 => 0xc, 28 => 0x6, 29 => 0x6, 30 => 0xc, 31 => 0x3 },
	'moddate' => { 159 => 'ModDate' },
	'model' => { 39 => 0x6, 48 => 0x110, 70 => 'Model', 125 => 'Model', 127 => 0x110, 161 => 'Model' },
	'modelrevision' => { 131 => 0x2 },
	'modifiedcolortemp' => { 17 => 0x9 },
	'modifieddigitalgain' => { 17 => 0xb },
	'modifiedparamflag' => { 14 => 0x1 },
	'modifiedpicturestyle' => { 17 => 0xa },
	'modifiedsaturation' => { 115 => 0x504 },
	'modifiedsensorbluelevel' => { 17 => 0x5 },
	'modifiedsensorredlevel' => { 17 => 0x4 },
	'modifiedsharpness' => { 17 => 0x2 },
	'modifiedsharpnessfreq' => { 17 => 0x3 },
	'modifiedtonecurve' => { 17 => 0x1 },
	'modifiedwhitebalance' => { 17 => 0x8 },
	'modifiedwhitebalanceblue' => { 17 => 0x7 },
	'modifiedwhitebalancered' => { 17 => 0x6 },
	'modifydate' => { 48 => 0x132, 71 => 'ModifyDate', 124 => 'tIME', 142 => 'ModDate', 162 => 'ModifyDate' },
	'moirefilter' => { 48 => 0xfe58 },
	'monochromecontrast' => { 43 => 0x78 },
	'monochromefiltereffect' => { 43 => 0x74 },
	'monochromelinear' => { 43 => 0x7a },
	'monochromesharpness' => { 43 => 0x7c },
	'monochrometoningeffect' => { 43 => 0x76 },
	'monthdaycreated' => { 59 => 0x12, 66 => 0xe },
	'multiexposureautogain' => { 99 => 0x3 },
	'multiexposuremode' => { 99 => 0x1 },
	'multiexposureshots' => { 99 => 0x2 },
	'multiexposureversion' => { 99 => 0x0 },
	'multisample' => { 102 => 0x40 },
	'mycolormode' => { 18 => 0x2 },
	'nativedigest' => { 157 => 'NativeDigest', 161 => 'NativeDigest' },
	'ndfilter' => { 22 => 0x1c },
	'nearlensstep' => { 120 => 0x103c },
	'newsphotoversion' => { 56 => 0x0 },
	'nickname' => { 162 => 'Nickname' },
	'nikoncaptureversion' => { 98 => 0xe09 },
	'noisefilter' => { 115 => 0x527 },
	'noisereduction' => { 13 => 0x8, 85 => 0xb0, 86 => 0x60, 87 => 0x3f, 98 => 0x95, 109 => 0x753dcbc0, 115 => 0x50a, 120 => 0x103a, 126 => 0x2d, 134 => 0x49 },
	'noisereduction2' => { 119 => 0x1010 },
	'noisereductionintensity' => { 110 => 0x9 },
	'noisereductionmethod' => { 110 => 0x11 },
	'noisereductionsharpness' => { 110 => 0xd },
	'npages' => { 168 => 'NPages' },
	'nullrecord' => { 38 => 0x0 },
	'numberofbeats' => { 164 => 'numberOfBeats' },
	'numindexentries' => { 56 => 0x54 },
	'objectattributereference' => { 54 => 0x4 },
	'objectcycle' => { 54 => 0x4b },
	'objectdistance' => { 44 => 0x6, 45 => 0x2022 },
	'objectname' => { 54 => 0x5 },
	'objectpreviewdata' => { 54 => 0xca },
	'objectpreviewfileformat' => { 54 => 0xc8 },
	'objectpreviewfileversion' => { 54 => 0xc9 },
	'objecttypereference' => { 54 => 0x3 },
	'oecfcolumns' => { 157 => 'OECFColumns' },
	'oecfnames' => { 157 => 'OECFNames' },
	'oecfrows' => { 157 => 'OECFRows' },
	'oecfvalues' => { 157 => 'OECFValues' },
	'offsetschema' => { 48 => 0xea1d },
	'oldsubfiletype' => { 48 => 0xff },
	'olympusimageheight' => { 120 => 0x102f },
	'olympusimageheight2' => { 119 => 0x615 },
	'olympusimagewidth' => { 120 => 0x102e },
	'olympusimagewidth2' => { 119 => 0x614 },
	'onetouchwb' => { 120 => 0x302 },
	'opticalzoom' => { 60 => 0xfa3d, 62 => [0x6006,0xf006], 63 => 0x1000, 64 => 0xf, 66 => 0x1e, 77 => 'OpticalZoom' },
	'opticalzoomcode' => { 22 => 0xa },
	'opticalzoommode' => { 126 => 0x34 },
	'opticalzoomon' => { 145 => 0x219 },
	'ordernumber' => { 52 => 0x8002 },
	'orientation' => { 48 => 0x112, 127 => 0x112, 161 => 'Orientation' },
	'originaldecisiondata' => { 16 => 0x83 },
	'originalfilename' => { 38 => 0x816, 67 => 0x20 },
	'originalimageheight' => { 51 => 0x1 },
	'originalimagewidth' => { 51 => 0x0 },
	'originalrawfiledata' => { 48 => 0xc68c },
	'originalrawfilename' => { 48 => 0xc68b },
	'originaltransmissionreference' => { 54 => 0x67 },
	'originatingprogram' => { 54 => 0x41 },
	'os' => { 156 => 'os' },
	'outcue' => { 164 => 'outCue' },
	'outputheight' => { 106 => 0xce },
	'outputheightinches' => { 106 => 0x96 },
	'outputpixels' => { 106 => 0xd6 },
	'outputresolution' => { 106 => 0xb6 },
	'outputwidth' => { 106 => 0xc6 },
	'outputwidthinches' => { 106 => 0x8e },
	'owner' => { 167 => 'Owner' },
	'ownerid' => { 54 => 0xbc },
	'ownername' => { 16 => 0x9, 38 => 0x810, 48 => 0xfde8, 70 => 'OwnerName', 152 => 'OwnerName' },
	'pagename' => { 48 => 0x11d },
	'pagenumber' => { 48 => 0x129 },
	'panasonicexifversion' => { 126 => 0x26 },
	'panasonicrawversion' => { 127 => 0x1 },
	'panoramadirection' => { 19 => 0x5 },
	'panoramaframe' => { 19 => 0x2 },
	'panoramamode' => { 59 => 0x3c, 115 => 0x601 },
	'parametricdarks' => { 154 => 'ParametricDarks' },
	'parametrichighlights' => { 154 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 154 => 'ParametricHighlightSplit' },
	'parametriclights' => { 154 => 'ParametricLights' },
	'parametricmidtonesplit' => { 154 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 154 => 'ParametricShadows' },
	'parametricshadowsplit' => { 154 => 'ParametricShadowSplit' },
	'patientid' => { 148 => 'PatientID' },
	'patientsbirthdate' => { 148 => 'PatientDOB' },
	'patientsname' => { 148 => 'PatientName' },
	'patientssex' => { 148 => 'PatientSex' },
	'pdfversion' => { 159 => 'PDFVersion' },
	'pentaximagesize' => { 134 => 0x9 },
	'pentaxmodelid' => { 131 => 0x0, 134 => 0x5 },
	'pentaxmodeltype' => { 134 => 0x1 },
	'pentaxversion' => { 134 => 0x0 },
	'people' => { 150 => 'People' },
	'pf0customfuncregistration' => { 33 => 0x1 },
	'pf10retainprogramshift' => { 33 => 0xb },
	'pf13drivepriority' => { 33 => 0xe },
	'pf14disablefocussearch' => { 33 => 0xf },
	'pf15disableafassistbeam' => { 33 => 0x10 },
	'pf16autofocuspointshoot' => { 33 => 0x11 },
	'pf17disableafpointsel' => { 33 => 0x12 },
	'pf18enableautoafpointsel' => { 33 => 0x13 },
	'pf19continuousshootspeed' => { 33 => 0x14 },
	'pf19shootingspeedhigh' => { 32 => 0xa },
	'pf19shootingspeedlow' => { 32 => 0x9 },
	'pf1disableshootingmodes' => { 33 => 0x2 },
	'pf1value' => { 32 => 0x1 },
	'pf20limitcontinousshots' => { 33 => 0x15 },
	'pf20maxcontinousshots' => { 32 => 0xb },
	'pf21enablequietoperation' => { 33 => 0x16 },
	'pf23felocktime' => { 32 => 0xd },
	'pf23postreleasetime' => { 32 => 0xe },
	'pf23settimerlengths' => { 33 => 0x18 },
	'pf23shutterbuttontime' => { 32 => 0xc },
	'pf24lightlcdduringbulb' => { 33 => 0x19 },
	'pf25aemode' => { 32 => 0xf },
	'pf25afmode' => { 32 => 0x12 },
	'pf25afpointsel' => { 32 => 0x13 },
	'pf25colormatrix' => { 32 => 0x17 },
	'pf25defaultclearsettings' => { 33 => 0x1a },
	'pf25drivemode' => { 32 => 0x11 },
	'pf25imagesize' => { 32 => 0x14 },
	'pf25meteringmode' => { 32 => 0x10 },
	'pf25parameters' => { 32 => 0x16 },
	'pf25wbmode' => { 32 => 0x15 },
	'pf26shortenreleaselag' => { 33 => 0x1b },
	'pf27reversedialrotation' => { 33 => 0x1c },
	'pf27value' => { 32 => 0x18 },
	'pf28noquickdialexpcomp' => { 33 => 0x1d },
	'pf29quickdialswitchoff' => { 33 => 0x1e },
	'pf2disablemeteringmodes' => { 33 => 0x3 },
	'pf2value' => { 32 => 0x2 },
	'pf30enlargementmode' => { 33 => 0x1f },
	'pf31originaldecisiondata' => { 33 => 0x20 },
	'pf3manualexposuremetering' => { 33 => 0x4 },
	'pf3value' => { 32 => 0x3 },
	'pf4exposuretimelimits' => { 33 => 0x5 },
	'pf4exposuretimemax' => { 32 => 0x5 },
	'pf4exposuretimemin' => { 32 => 0x4 },
	'pf5aperturelimits' => { 33 => 0x6 },
	'pf5aperturemax' => { 32 => 0x7 },
	'pf5aperturemin' => { 32 => 0x6 },
	'pf6presetshootingmodes' => { 33 => 0x7 },
	'pf7bracketcontinuousshoot' => { 33 => 0x8 },
	'pf8bracketshots' => { 32 => 0x8 },
	'pf8setbracketshots' => { 33 => 0x9 },
	'pf9changebracketsequence' => { 33 => 0xa },
	'phonenumber' => { 71 => 'Phone' },
	'photoeffect' => { 4 => 0x28 },
	'photoeffects' => { 109 => 0xab5eca5e },
	'photoeffectsblue' => { 111 => 0x8 },
	'photoeffectsgreen' => { 111 => 0x6 },
	'photoeffectsred' => { 111 => 0x4 },
	'photoeffectstype' => { 111 => 0x0 },
	'photometricinterpretation' => { 48 => 0x106, 161 => 'PhotometricInterpretation' },
	'photoshopquality' => { 139 => 0x0 },
	'pictinfo' => { 145 => 0x208 },
	'picturemode' => { 52 => 0x1031, 115 => 0x520, 134 => [0xb,0x33] },
	'picturemodebwfilter' => { 115 => 0x525 },
	'picturemodecontrast' => { 115 => 0x523 },
	'picturemodehue' => { 115 => 0x522 },
	'picturemodesaturation' => { 115 => 0x521 },
	'picturemodesharpness' => { 115 => 0x524 },
	'picturemodetone' => { 115 => 0x526 },
	'picturestyle' => { 1 => 0x6c, 2 => 0x86, 21 => 0xa, 43 => 0x4 },
	'planarconfiguration' => { 48 => 0x11c, 161 => 'PlanarConfiguration' },
	'platenames' => { 168 => 'PlateNames' },
	'pngwarning' => { 125 => 'Warning' },
	'postalcode' => { 75 => 'PostalCode' },
	'precaptureframes' => { 120 => 0x300 },
	'predictor' => { 48 => 0x13d },
	'prefs' => { 54 => 0xdd, 138 => 'Prefs' },
	'preservedfilename' => { 165 => 'PreservedFileName' },
	'previewfocalplanexresolution' => { 20 => 0x6 },
	'previewfocalplaneyresolution' => { 20 => 0x8 },
	'previewheight' => { 60 => 0xfa58 },
	'previewimage' => { 45 => 0x2000, 46 => 'PreviewImage', 47 => 'MakN', 48 => 0x927c, 50 => 0x4, 80 => 'data', 88 => 0x81, 120 => 0x280 },
	'previewimageheight' => { 20 => 0x4 },
	'previewimagelength' => { 20 => 0x2, 45 => 0x3, 48 => [0x117,0x202], 88 => 0x89, 100 => 0x202, 115 => 0x102, 120 => 0x1037, 134 => 0x3, 143 => 0x1e },
	'previewimagename' => { 80 => '1Name' },
	'previewimagesize' => { 45 => 0x2, 80 => 'ImageSize', 134 => 0x2 },
	'previewimagestart' => { 20 => 0x5, 45 => 0x4, 48 => [0x111,0x201], 88 => 0x88, 100 => 0x201, 115 => 0x101, 120 => 0x1036, 134 => 0x4, 143 => 0x1c },
	'previewimagetype' => { 80 => '0Type' },
	'previewimagevalid' => { 115 => 0x100, 120 => 0x1035 },
	'previewimagewidth' => { 20 => 0x3 },
	'previewquality' => { 20 => 0x1 },
	'previewwidth' => { 60 => 0xfa57 },
	'primarychromaticities' => { 48 => 0x13f, 161 => 'PrimaryChromaticities' },
	'printim' => { 48 => 0xc4a5 },
	'privatertkinfo' => { 149 => 'privateRTKInfo' },
	'processingsoftware' => { 48 => 0xb },
	'producer' => { 159 => 'Producer' },
	'productid' => { 55 => 0x32 },
	'programiso' => { 126 => 0x3c },
	'programmode' => { 90 => 0x5 },
	'programshift' => { 98 => 0xd },
	'programversion' => { 54 => 0x46 },
	'projectrefpath' => { 164 => 'projectRefPath' },
	'projectreftype' => { 164 => 'projectRefType' },
	'province-state' => { 54 => 0x5f },
	'publisher' => { 155 => 'publisher' },
	'pulldown' => { 164 => 'pullDown' },
	'quality' => { 0 => 0x1, 4 => 0x3, 44 => 0x2, 45 => 0x3002, 52 => 0x1000, 59 => 0x9, 98 => 0x4, 103 => 0x3, 120 => 0x201, 134 => 0x8, 136 => 0x2, 146 => 0x16 },
	'qualitymode' => { 45 => 0x8 },
	'quantizationmethod' => { 56 => 0x78 },
	'quickcontroldialinmeter' => { 25 => 0x703 },
	'quickshot' => { 145 => 0x213 },
	'rasterizedcaption' => { 54 => 0x7d },
	'rating' => { 48 => 0x4746, 137 => 0xdf, 156 => 'rating', 162 => 'Rating' },
	'ratingpercent' => { 48 => 0x4749, 151 => 'Rating' },
	'rawandjpgrecording' => { 23 => 0x8 },
	'rawbrightnessadj' => { 42 => 0x38 },
	'rawcoloradj' => { 42 => 0x2e },
	'rawcolortoneadj' => { 43 => 0x1a },
	'rawcontrastadj' => { 43 => 0x1e },
	'rawcropbottom' => { 137 => 0xd4 },
	'rawcropleft' => { 137 => 0xd1 },
	'rawcropright' => { 137 => 0xd3 },
	'rawcroptop' => { 137 => 0xd2 },
	'rawcustomsaturation' => { 42 => 0x30 },
	'rawcustomtone' => { 42 => 0x34 },
	'rawdatauniqueid' => { 48 => 0xc65d },
	'rawdepth' => { 89 => 0x10 },
	'rawdevcolorspace' => { 121 => 0x108, 122 => 0x109 },
	'rawdevcontrastvalue' => { 121 => 0x106, 122 => 0x105 },
	'rawdeveditstatus' => { 121 => 0x10b },
	'rawdevengine' => { 121 => 0x109, 122 => 0x10b },
	'rawdevexposurebiasvalue' => { 121 => 0x100, 122 => 0x100 },
	'rawdevgradation' => { 122 => 0x112 },
	'rawdevgraypoint' => { 121 => 0x103, 122 => 0x104 },
	'rawdevmemorycoloremphasis' => { 121 => 0x105, 122 => 0x108 },
	'rawdevnoisereduction' => { 121 => 0x10a, 122 => 0x10a },
	'rawdevpicturemode' => { 122 => 0x10c },
	'rawdevpm_bwfilter' => { 122 => 0x110 },
	'rawdevpmcontrast' => { 122 => 0x10e },
	'rawdevpmpicturetone' => { 122 => 0x111 },
	'rawdevpmsaturation' => { 122 => 0x10d },
	'rawdevpmsharpness' => { 122 => 0x10f },
	'rawdevsaturationemphasis' => { 121 => 0x104, 122 => 0x107 },
	'rawdevsettings' => { 121 => 0x10c },
	'rawdevsharpnessvalue' => { 121 => 0x107, 122 => 0x106 },
	'rawdevversion' => { 121 => 0x0, 122 => 0x0 },
	'rawdevwbfineadjustment' => { 121 => 0x102, 122 => 0x103 },
	'rawdevwhitebalance' => { 122 => 0x101 },
	'rawdevwhitebalancevalue' => { 121 => 0x101, 122 => 0x102 },
	'rawfile' => { 48 => 0xfe4c },
	'rawfilename' => { 154 => 'RawFileName' },
	'rawhighlightpoint' => { 43 => 0x24 },
	'rawimagecenter' => { 98 => 0x99 },
	'rawimagesize' => { 134 => 0x39 },
	'rawinfoversion' => { 123 => 0x0 },
	'rawjpgheight' => { 40 => 0x4 },
	'rawjpgquality' => { 13 => 0x6, 40 => 0x1 },
	'rawjpgsize' => { 13 => 0x7, 40 => 0x2 },
	'rawjpgwidth' => { 40 => 0x3 },
	'rawlinear' => { 43 => 0x20 },
	'rawsaturationadj' => { 43 => 0x1c },
	'rawshadowpoint' => { 43 => 0x26 },
	'rawsharpnessadj' => { 43 => 0x22 },
	'recordid' => { 38 => 0x1804 },
	'recordingmode' => { 44 => 0x1, 136 => 0x1 },
	'recordmode' => { 4 => 0x9, 45 => 0x3000 },
	'recordshutterrelease' => { 145 => 0x217 },
	'redbalance' => { 120 => 0x1017, 127 => 0x11, 134 => 0x1c },
	'redcurvelimits' => { 42 => 0x18a },
	'redcurvepoints' => { 42 => 0x160 },
	'redeyecorrection' => { 112 => 0x0 },
	'redhue' => { 154 => 'RedHue' },
	'redsaturation' => { 154 => 'RedSaturation' },
	'referenceblackwhite' => { 48 => 0x214, 161 => 'ReferenceBlackWhite' },
	'referencedate' => { 54 => 0x2f },
	'referencenumber' => { 54 => 0x32 },
	'references' => { 71 => 'References' },
	'referenceservice' => { 54 => 0x2d },
	'relatedaudiofile' => { 69 => 'data' },
	'relatedaudiofilename' => { 69 => '1Name' },
	'relatedaudiofiletype' => { 69 => '0Type' },
	'relatedimagefileformat' => { 48 => 0x1000 },
	'relatedimagelength' => { 48 => 0x1002 },
	'relatedimagewidth' => { 48 => 0x1001 },
	'relatedsoundfile' => { 48 => 0xa004, 157 => 'RelatedSoundFile' },
	'relatedvideofile' => { 83 => 'data' },
	'relatedvideofilename' => { 83 => '1Name' },
	'relatedvideofiletype' => { 83 => '0Type' },
	'relation' => { 155 => 'relation' },
	'relativepeakaudiofilepath' => { 164 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 164 => 'relativeTimestamp' },
	'releasedate' => { 54 => 0x1e, 164 => 'releaseDate' },
	'releasesetting' => { 38 => 0x1016 },
	'releasetime' => { 54 => 0x23 },
	'renditionclass' => { 165 => 'RenditionClass' },
	'renditionofdocumentid' => { 165 => 'RenditionOfDocumentID' },
	'renditionofinstanceid' => { 165 => 'RenditionOfInstanceID' },
	'renditionofmanager' => { 165 => 'RenditionOfManager' },
	'renditionofmanagervariant' => { 165 => 'RenditionOfManagerVariant' },
	'renditionofmanageto' => { 165 => 'RenditionOfManageTo' },
	'renditionofmanageui' => { 165 => 'RenditionOfManageUI' },
	'renditionofrenditionclass' => { 165 => 'RenditionOfRenditionClass' },
	'renditionofrenditionparams' => { 165 => 'RenditionOfRenditionParams' },
	'renditionofversionid' => { 165 => 'RenditionOfVersionID' },
	'renditionparams' => { 165 => 'RenditionParams' },
	'resampleparamsquality' => { 164 => 'resampleParamsQuality' },
	'resaved' => { 145 => 0x21e },
	'resolution' => { 76 => 'Resolution' },
	'resolutionmode' => { 146 => 0x4 },
	'resolutionunit' => { 48 => 0x128, 57 => 0x2, 161 => 'ResolutionUnit' },
	'reuseallowed' => { 166 => 'ReuseAllowed' },
	'revision' => { 156 => 'revision' },
	'rgbcurvelimits' => { 42 => 0x238 },
	'rgbcurvepoints' => { 42 => 0x20e },
	'ricohdate' => { 143 => 0x6 },
	'ricohimageheight' => { 143 => 0x2 },
	'ricohimagewidth' => { 143 => 0x0 },
	'rightascension' => { 79 => 'RightAscension' },
	'rights' => { 155 => 'rights' },
	'romoperationmode' => { 38 => 0x80d },
	'rotation' => { 3 => 0x17, 37 => 0x3, 42 => 0x26e, 51 => 0x4, 79 => 'Rotation', 85 => 0x50, 86 => 0x46, 87 => 0x5a, 109 => 0x76a43207, 126 => 0x30, 137 => 0xd8 },
	'routing' => { 142 => 'Routing' },
	'rowsperstrip' => { 48 => 0x116 },
	'safetyshift' => { 25 => 0x108 },
	'safetyshiftinavortv' => { 23 => 0x10, 24 => 0x10, 26 => 0xf, 27 => 0x10, 30 => 0x10 },
	'samplebits' => { 69 => 'SampleBits' },
	'samplerate' => { 69 => 'SampleRate' },
	'samplesperpixel' => { 48 => 0x115, 161 => 'SamplesPerPixel' },
	'samplestructure' => { 56 => 0x5a },
	'sanyoquality' => { 145 => 0x201 },
	'sanyothumbnail' => { 145 => 0x100 },
	'saturation' => { 4 => 0xe, 9 => 0x1, 44 => 0xd, 45 => [0x3013,0x1f], 48 => [0xa409,0xfe55], 52 => 0x1003, 70 => 'Saturation', 84 => 0x1f, 85 => 0x32, 86 => 0x28, 87 => 0x1a, 90 => 0x1, 98 => [0x94,0xaa], 134 => 0x1f, 136 => 0xd, 143 => 0x28, 146 => 0x10, 154 => 'Saturation', 157 => 'Saturation' },
	'saturationadj' => { 42 => 0x116 },
	'saturationadjustmentaqua' => { 154 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 154 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 154 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 154 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 154 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 154 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 154 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 154 => 'SaturationAdjustmentYellow' },
	'saturationfaithful' => { 1 => 0xfe },
	'saturationlandscape' => { 1 => 0xfc },
	'saturationneutral' => { 1 => 0xfd },
	'saturationportrait' => { 1 => 0xfb },
	'saturationsetting' => { 123 => 0x1010 },
	'saturationstandard' => { 1 => 0xfa },
	'saturationuserdef1' => { 1 => 0x100 },
	'saturationuserdef2' => { 1 => 0x101 },
	'saturationuserdef3' => { 1 => 0x102 },
	'saveid' => { 165 => 'SaveID' },
	'scaledresolution' => { 106 => 0x9e },
	'scaletype' => { 164 => 'scaleType' },
	'scanningdirection' => { 56 => 0x64 },
	'scene' => { 158 => 'Scene', 164 => 'scene' },
	'scenearea' => { 120 => 0x1031 },
	'scenecapturetype' => { 48 => 0xa406, 157 => 'SceneCaptureType' },
	'scenedetect' => { 120 => 0x1030 },
	'scenedetectarea' => { 120 => 0x1033 },
	'scenemode' => { 60 => 0xfa02, 88 => 0x100, 98 => 0x8f, 115 => 0x509, 120 => 0x403, 126 => 0x8001 },
	'scenemodeused' => { 62 => [0x6002,0xf002] },
	'sceneselect' => { 145 => 0x21f },
	'scenetype' => { 48 => 0xa301, 157 => 'SceneType' },
	'securityclassification' => { 48 => 0x9212 },
	'selectableafpoint' => { 25 => 0x509 },
	'self-timer' => { 4 => 0x2 },
	'self-timer2' => { 22 => 0x1d },
	'selftimer' => { 45 => 0x3001, 126 => 0x2e, 145 => 0x214 },
	'selftimermode' => { 48 => 0x882b },
	'selftimertime' => { 38 => 0x1806 },
	'seminfo' => { 48 => 0x8546 },
	'sensingmethod' => { 48 => 0xa217, 157 => 'SensingMethod' },
	'sensorbluelevel' => { 21 => 0x5 },
	'sensorcleaning' => { 31 => 0xd },
	'sensorfullheight' => { 58 => 0xf904 },
	'sensorfullwidth' => { 58 => 0xf903 },
	'sensorheight' => { 58 => 0xf901, 60 => 0xfa21, 89 => 0x8 },
	'sensorpixelsize' => { 98 => 0x9a },
	'sensorredlevel' => { 21 => 0x4 },
	'sensorsize' => { 70 => 'SensorSize' },
	'sensortemperature' => { 118 => 0x1500, 120 => 0x1007 },
	'sensorwidth' => { 58 => 0xf900, 60 => 0xfa20, 89 => 0xa },
	'sequencenumber' => { 22 => 0x9, 45 => 0x301c, 52 => 0x1101, 59 => 0x1d, 126 => 0x2b },
	'sequenceshotinterval' => { 145 => 0x224 },
	'sequentialshot' => { 145 => 0x20e },
	'serialnumber' => { 16 => 0xc, 38 => 0x180b, 48 => 0xfde9, 58 => 0xfa04, 60 => 0xfa19, 68 => 0x0, 70 => 'SerialNumber', 98 => 0xa0, 116 => 0x101, 120 => [0x404,0x101a], 146 => 0x2, 152 => 'SerialNumber' },
	'serialnumberformat' => { 16 => 0x15, 38 => 0x183b },
	'seriesdatetime' => { 148 => 'SeriesDateTime' },
	'seriesdescription' => { 148 => 'SeriesDescription' },
	'seriesmodality' => { 148 => 'SeriesModality' },
	'seriesnumber' => { 148 => 'SeriesNumber' },
	'serviceidentifier' => { 55 => 0x1e },
	'setbuttoncrosskeysfunc' => { 28 => 0x0, 29 => 0x0 },
	'setbuttonfunction' => { 23 => 0x1, 31 => 0xc },
	'setbuttonwhenshooting' => { 25 => 0x704 },
	'setfunctionwhenshooting' => { 26 => 0x0, 27 => 0x1, 30 => 0x1 },
	'shadingcompensation' => { 115 => 0x50c },
	'shadingcompensation2' => { 119 => 0x1012 },
	'shadow' => { 146 => 0xe },
	'shadows' => { 48 => 0xfe52, 154 => 'Shadows' },
	'shadowscale' => { 48 => 0xc633 },
	'shadowtint' => { 154 => 'ShadowTint' },
	'shakereduction' => { 135 => 0x1 },
	'sharpendetail' => { 154 => 'SharpenDetail' },
	'sharpenedgemasking' => { 154 => 'SharpenEdgeMasking' },
	'sharpenradius' => { 154 => 'SharpenRadius' },
	'sharpness' => { 4 => 0xf, 21 => 0x2, 44 => 0xb, 45 => [0x3011,0x21], 48 => [0xa40a,0xfe56], 52 => 0x1001, 59 => 0x6b, 66 => 0x37, 70 => 'Sharpness', 84 => 0x21, 85 => 0x30, 86 => 0x26, 87 => 0x18, 90 => 0x3, 98 => 0x6, 120 => 0x100f, 134 => 0x21, 136 => 0xb, 143 => 0x22, 144 => 0x1003, 146 => 0x11, 154 => 'Sharpness', 157 => 'Sharpness' },
	'sharpnessfactor' => { 120 => 0x102a },
	'sharpnessfaithful' => { 1 => 0xf5 },
	'sharpnessfrequency' => { 21 => 0x3 },
	'sharpnesslandscape' => { 1 => 0xf3 },
	'sharpnessmonochrome' => { 1 => 0xf6 },
	'sharpnessneutral' => { 1 => 0xf4 },
	'sharpnessportrait' => { 1 => 0xf2 },
	'sharpnesssetting' => { 115 => 0x506, 123 => 0x1013 },
	'sharpnessstandard' => { 1 => 0xf1 },
	'sharpnessuserdef1' => { 1 => 0xf7 },
	'sharpnessuserdef2' => { 1 => 0xf8 },
	'sharpnessuserdef3' => { 1 => 0xf9 },
	'shootingmode' => { 70 => 'ShootingMode', 98 => 0x89, 126 => 0x1f },
	'shortdescription' => { 156 => 'shortdescription' },
	'shortdocumentid' => { 54 => 0xba },
	'shortfocal' => { 1 => 0x11, 2 => 0x113, 4 => 0x18 },
	'shortownername' => { 1 => 0xac },
	'shortreleasetimelag' => { 25 => 0x80d },
	'shotdate' => { 164 => 'shotDate' },
	'shotlocation' => { 164 => 'shotLocation' },
	'shotname' => { 164 => 'shotName' },
	'shutter-aelock' => { 23 => 0x4, 26 => 0x3, 27 => 0x4, 28 => 0x3, 29 => 0x3, 30 => 0x4, 31 => 0x2 },
	'shutteraelbutton' => { 24 => 0x4 },
	'shutterbuttonafonbutton' => { 25 => 0x701 },
	'shuttercount' => { 2 => 0x176, 13 => 0x1, 134 => 0x5d },
	'shuttercurtainsync' => { 23 => 0xf, 24 => 0xf, 25 => 0x305, 26 => 0xe, 27 => 0xf, 28 => 0x8, 29 => 0x8, 30 => 0xf, 31 => 0x8 },
	'shuttermode' => { 59 => 0x1b },
	'shutterreleasemethod' => { 38 => 0x1010 },
	'shutterreleasenocfcard' => { 23 => 0x2, 24 => 0x2, 31 => 0xf },
	'shutterreleasetiming' => { 38 => 0x1011 },
	'shutterspeedrange' => { 25 => 0x10c },
	'shutterspeedvalue' => { 48 => 0x9201, 120 => 0x1000, 157 => 'ShutterSpeedValue' },
	'sidecarforextension' => { 160 => 'SidecarForExtension' },
	'similarityindex' => { 54 => 0xe4 },
	'slowshutter' => { 22 => 0x8 },
	'slowsync' => { 52 => 0x1030 },
	'smoothingparameter1' => { 119 => 0x300 },
	'smoothingparameter2' => { 119 => 0x310 },
	'smoothingthreshold2' => { 119 => 0x610 },
	'smoothingthresholds' => { 119 => 0x600 },
	'smoothness' => { 48 => 0xfe57 },
	'software' => { 48 => 0x131, 71 => 'Software', 125 => 'Software', 146 => 0x18, 161 => 'Software' },
	'softwareversion' => { 145 => 0x207 },
	'source' => { 54 => 0x73, 125 => 'Source', 155 => 'source', 156 => 'source', 160 => 'Source' },
	'sourceresolution' => { 106 => 0xae },
	'spatialfrequencyresponsecolumns' => { 157 => 'SpatialFrequencyResponseColumns' },
	'spatialfrequencyresponsenames' => { 157 => 'SpatialFrequencyResponseNames' },
	'spatialfrequencyresponserows' => { 157 => 'SpatialFrequencyResponseRows' },
	'spatialfrequencyresponsevalues' => { 157 => 'SpatialFrequencyResponseValues' },
	'speakerplacement' => { 164 => 'speakerPlacement' },
	'specialinstructions' => { 54 => 0x28 },
	'specialmode' => { 120 => 0x200, 145 => 0x200 },
	'spectralsensitivity' => { 48 => 0x8824, 157 => 'SpectralSensitivity' },
	'splittoningbalance' => { 154 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 154 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 154 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 154 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 154 => 'SplitToningShadowSaturation' },
	'spotfocuspointx' => { 84 => 0x2d },
	'spotfocuspointy' => { 84 => 0x2e },
	'spotmeterlinktoafpoint' => { 25 => 0x107 },
	'sr_swstoswrtime' => { 135 => 0x2 },
	'srresult' => { 135 => 0x0 },
	'startoffsetx' => { 123 => 0x612 },
	'startoffsety' => { 123 => 0x613 },
	'starttimecodetimeformat' => { 164 => 'startTimecodeTimeFormat' },
	'starttimecodetimevalue' => { 164 => 'startTimecodeTimeValue' },
	'state' => { 75 => 'State', 160 => 'State' },
	'status' => { 150 => 'Status' },
	'storagemethod' => { 89 => 0x12 },
	'straightenangle' => { 109 => 0x2fc08431 },
	'stretchmode' => { 164 => 'stretchMode' },
	'studydatetime' => { 148 => 'StudyDateTime' },
	'studydescription' => { 148 => 'StudyDescription' },
	'studyid' => { 148 => 'StudyID' },
	'studyphysician' => { 148 => 'StudyPhysician' },
	'sub-location' => { 54 => 0x5c },
	'subfiledata' => { 78 => 'data' },
	'subfiledirectory' => { 78 => '1Directory' },
	'subfilemimetype' => { 78 => '2MIME' },
	'subfilename' => { 78 => '1Name' },
	'subfileresource' => { 78 => 'rsrc' },
	'subfiletype' => { 48 => 0xfe, 78 => '0Type' },
	'subject' => { 142 => 'Subject', 155 => 'subject', 159 => 'Subject' },
	'subjectarea' => { 157 => 'SubjectArea' },
	'subjectcode' => { 158 => 'SubjectCode' },
	'subjectdistance' => { 48 => 0x9206, 59 => 0x3e, 157 => 'SubjectDistance' },
	'subjectdistancerange' => { 48 => 0xa40c, 157 => 'SubjectDistanceRange' },
	'subjectlocation' => { 48 => [0x9214,0xa214], 157 => 'SubjectLocation' },
	'subjectprogram' => { 84 => 0x22 },
	'subjectreference' => { 54 => 0xc },
	'subsectime' => { 48 => 0x9290 },
	'subsectimedigitized' => { 48 => 0x9292 },
	'subsectimeoriginal' => { 48 => 0x9291 },
	'superimposeddisplay' => { 23 => 0xa, 25 => 0x510, 26 => 0x9, 27 => 0xa, 30 => 0xa, 31 => 0xe },
	'supplementalcategories' => { 54 => 0x14, 160 => 'SupplementalCategories' },
	'supplementaltype' => { 56 => 0x37 },
	'switchtoregisteredafpoint' => { 24 => 0x12, 25 => 0x50a },
	'tagged' => { 137 => 0xdd },
	'tapename' => { 164 => 'tapeName' },
	'targetaperture' => { 22 => 0x4 },
	'targetcompressionratio' => { 36 => 0x1 },
	'targetdistancesetting' => { 38 => 0x1807 },
	'targetexposuretime' => { 22 => 0x5 },
	'targetimagetype' => { 38 => 0x100a },
	'temperature' => { 154 => 'Temperature' },
	'tempo' => { 164 => 'tempo' },
	'thresholding' => { 48 => 0x107 },
	'thumbnailfilename' => { 38 => 0x817 },
	'thumbnailheight' => { 60 => 0xfa55 },
	'thumbnailimage' => { 38 => 0x2008, 46 => 'ThumbnailImage', 50 => 0x3, 81 => 'data', 120 => 0x100 },
	'thumbnailimagename' => { 81 => '1Name' },
	'thumbnailimagesize' => { 81 => 'ImageSize' },
	'thumbnailimagetype' => { 81 => '0Type' },
	'thumbnaillength' => { 48 => 0x202 },
	'thumbnailoffset' => { 48 => 0x201 },
	'thumbnailsformat' => { 162 => 'ThumbnailsFormat' },
	'thumbnailsheight' => { 162 => 'ThumbnailsHeight' },
	'thumbnailsimage' => { 162 => 'ThumbnailsImage' },
	'thumbnailswidth' => { 162 => 'ThumbnailsWidth' },
	'thumbnailwidth' => { 60 => 0xfa54 },
	'tilelength' => { 48 => 0x143 },
	'tilewidth' => { 48 => 0x142 },
	'time' => { 134 => 0x7 },
	'timecreated' => { 54 => 0x3c, 59 => 0x14, 66 => 0x10, 138 => 'TimeCreated' },
	'timerlength' => { 25 => 0x80c },
	'timescaleparamsframeoverlappingpercentage' => { 164 => 'timeScaleParamsFrameOverlappingPercentage' },
	'timescaleparamsframesize' => { 164 => 'timeScaleParamsFrameSize' },
	'timescaleparamsquality' => { 164 => 'timeScaleParamsQuality' },
	'timesent' => { 55 => 0x50 },
	'timesignature' => { 164 => 'timeSignature' },
	'timesincepoweron' => { 126 => 0x29 },
	'timestamp' => { 1 => 0x11c, 2 => 0x45e, 125 => 'TimeStamp' },
	'timezonecode' => { 41 => 0x1 },
	'timezoneinfo' => { 41 => 0x2 },
	'timezoneoffset' => { 48 => 0x882a },
	'tint' => { 154 => 'Tint' },
	'title' => { 71 => 'Title', 125 => 'Title', 142 => 'Title', 155 => 'title', 159 => 'Title' },
	'tonecomp' => { 98 => 0x81 },
	'tonecurve' => { 21 => 0x1, 134 => 0x402, 154 => 'ToneCurve' },
	'tonecurveactive' => { 42 => 0x110 },
	'tonecurvename' => { 154 => 'ToneCurveName' },
	'tonecurveproperty' => { 42 => 0x3c },
	'tonecurves' => { 134 => 0x403 },
	'toningeffect' => { 13 => 0xf },
	'toningeffectmonochrome' => { 1 => 0x108 },
	'totalzoom' => { 59 => 0x62 },
	'tracknumber' => { 164 => 'trackNumber' },
	'trailersignature' => { 78 => 'zmie' },
	'transferfunction' => { 161 => 'TransferFunction' },
	'transmissionreference' => { 160 => 'TransmissionReference' },
	'travelday' => { 126 => 0x36 },
	'ttl_da_adown' => { 132 => 0x5 },
	'ttl_da_aup' => { 132 => 0x4 },
	'ttl_da_bdown' => { 132 => 0x7 },
	'ttl_da_bup' => { 132 => 0x6 },
	'tvvalue' => { 34 => 0x1 },
	'type' => { 155 => 'type' },
	'uniquecameramodel' => { 48 => 0xc614 },
	'uniquedocumentid' => { 54 => 0xbb },
	'uniqueobjectname' => { 55 => 0x64 },
	'unknownblock' => { 119 => 0x1103 },
	'unknowncompensation' => { 146 => 0xc },
	'unsharp1color' => { 113 => 0x13 },
	'unsharp1halowidth' => { 113 => 0x19 },
	'unsharp1intensity' => { 113 => 0x17 },
	'unsharp1threshold' => { 113 => 0x1b },
	'unsharp2color' => { 113 => 0x2e },
	'unsharp2halowidth' => { 113 => 0x34 },
	'unsharp2intensity' => { 113 => 0x32 },
	'unsharp2threshold' => { 113 => 0x36 },
	'unsharp3color' => { 113 => 0x49 },
	'unsharp3halowidth' => { 113 => 0x4f },
	'unsharp3intensity' => { 113 => 0x4d },
	'unsharp3threshold' => { 113 => 0x51 },
	'unsharp4color' => { 113 => 0x64 },
	'unsharp4halowidth' => { 113 => 0x6a },
	'unsharp4intensity' => { 113 => 0x68 },
	'unsharp4threshold' => { 113 => 0x6c },
	'unsharpcount' => { 113 => 0x0 },
	'unsharpmask' => { 109 => 0x76a43200 },
	'urgency' => { 54 => 0xa, 160 => 'Urgency' },
	'url' => { 71 => 'URL', 125 => 'URL', 140 => 0x40b },
	'usablemeteringmodes' => { 25 => 0x10a },
	'usableshootingmodes' => { 25 => 0x109 },
	'usageterms' => { 167 => 'UsageTerms' },
	'usercomment' => { 38 => 0x805, 48 => 0x9286, 157 => 'UserComment' },
	'userdef1picturestyle' => { 1 => 0x10c },
	'userdef2picturestyle' => { 1 => 0x10e },
	'userdef3picturestyle' => { 1 => 0x110 },
	'userfields' => { 150 => 'UserFields' },
	'usmlenselectronicmf' => { 24 => 0x7, 25 => 0x501 },
	'utmeasting' => { 82 => 'Easting' },
	'utmmapdatum' => { 82 => 'Datum' },
	'utmnorthing' => { 82 => 'Northing' },
	'utmzone' => { 82 => 'Zone' },
	'validbits' => { 119 => 0x611, 120 => 0x102c },
	'validpixeldepth' => { 123 => 0x611 },
	'variousmodes' => { 59 => 0x26 },
	'variousmodes2' => { 59 => 0x3a },
	'variprogram' => { 98 => 0xab },
	'version' => { 52 => 0x0, 142 => 'Version', 154 => 'Version' },
	'versionid' => { 165 => 'VersionID' },
	'versionscomments' => { 165 => 'VersionsComments' },
	'versionseventaction' => { 165 => 'VersionsEventAction' },
	'versionseventinstanceid' => { 165 => 'VersionsEventInstanceID' },
	'versionseventparameters' => { 165 => 'VersionsEventParameters' },
	'versionseventsoftwareagent' => { 165 => 'VersionsEventSoftwareAgent' },
	'versionseventwhen' => { 165 => 'VersionsEventWhen' },
	'versionsmodifier' => { 165 => 'VersionsModifier' },
	'versionsmodifydate' => { 165 => 'VersionsModifyDate' },
	'versionsversion' => { 165 => 'VersionsVersion' },
	'vibrance' => { 154 => 'Vibrance' },
	'videoalphamode' => { 164 => 'videoAlphaMode' },
	'videoalphapremultiplecolora' => { 164 => 'videoAlphaPremultipleColorA' },
	'videoalphapremultiplecolorb' => { 164 => 'videoAlphaPremultipleColorB' },
	'videoalphapremultiplecolorblack' => { 164 => 'videoAlphaPremultipleColorBlack' },
	'videoalphapremultiplecolorblue' => { 164 => 'videoAlphaPremultipleColorBlue' },
	'videoalphapremultiplecolorcyan' => { 164 => 'videoAlphaPremultipleColorCyan' },
	'videoalphapremultiplecolorgreen' => { 164 => 'videoAlphaPremultipleColorGreen' },
	'videoalphapremultiplecolorl' => { 164 => 'videoAlphaPremultipleColorL' },
	'videoalphapremultiplecolormagenta' => { 164 => 'videoAlphaPremultipleColorMagenta' },
	'videoalphapremultiplecolormode' => { 164 => 'videoAlphaPremultipleColorMode' },
	'videoalphapremultiplecolorred' => { 164 => 'videoAlphaPremultipleColorRed' },
	'videoalphapremultiplecolorswatchname' => { 164 => 'videoAlphaPremultipleColorSwatchName' },
	'videoalphapremultiplecolortype' => { 164 => 'videoAlphaPremultipleColorType' },
	'videoalphapremultiplecoloryellow' => { 164 => 'videoAlphaPremultipleColorYellow' },
	'videoalphaunityistransparent' => { 164 => 'videoAlphaUnityIsTransparent' },
	'videocolorspace' => { 164 => 'videoColorSpace' },
	'videocompressor' => { 164 => 'videoCompressor' },
	'videofieldorder' => { 164 => 'videoFieldOrder' },
	'videoframerate' => { 164 => 'videoFrameRate' },
	'videoframesizeh' => { 164 => 'videoFrameSizeH' },
	'videoframesizeunit' => { 164 => 'videoFrameSizeUnit' },
	'videoframesizew' => { 164 => 'videoFrameSizeW' },
	'videomoddate' => { 164 => 'videoModDate' },
	'videopixelaspectratio' => { 164 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 164 => 'videoPixelDepth' },
	'viewinfoduringexposure' => { 25 => 0x407 },
	'vignetteamount' => { 154 => 'VignetteAmount' },
	'vignettecontrol' => { 109 => 0x76a43205 },
	'vignettecontrolintensity' => { 109 => 0xac6bd5c0 },
	'vignettemidpoint' => { 154 => 'VignetteMidpoint' },
	'voicememo' => { 145 => 0x216 },
	'vrdoffset' => { 16 => 0xd0 },
	'wb_rbgglevels' => { 93 => 0x0 },
	'wb_rblevels' => { 119 => 0x100 },
	'wb_rblevelsauto' => { 123 => 0x110 },
	'wb_rblevelscloudy' => { 123 => 0x121 },
	'wb_rblevelscoolwhitefluor' => { 123 => 0x132 },
	'wb_rblevelsdaylightfluor' => { 123 => 0x130 },
	'wb_rblevelsdaywhitefluor' => { 123 => 0x131 },
	'wb_rblevelseveningsunlight' => { 123 => 0x124 },
	'wb_rblevelsfineweather' => { 123 => 0x122 },
	'wb_rblevelsshade' => { 123 => 0x120 },
	'wb_rblevelstungsten' => { 123 => 0x123 },
	'wb_rblevelsused' => { 123 => 0x100 },
	'wb_rblevelswhitefluorescent' => { 123 => 0x133 },
	'wb_rgbglevels' => { 95 => 0x0 },
	'wb_rggblevels' => { 94 => 0x0 },
	'wb_rggblevelsasshot' => { 6 => 0x19, 7 => 0x18, 8 => 0x3f },
	'wb_rggblevelsauto' => { 5 => 0x0, 6 => 0x1e, 7 => 0x22, 8 => 0x44 },
	'wb_rggblevelscloudy' => { 5 => 0xc, 6 => 0x2d, 7 => 0x31, 8 => 0x58, 134 => 0x20f },
	'wb_rggblevelscustom' => { 5 => 0x1c, 8 => 0x80 },
	'wb_rggblevelscustom1' => { 6 => 0x41 },
	'wb_rggblevelscustom2' => { 6 => 0x46 },
	'wb_rggblevelsdaylight' => { 5 => 0x4, 6 => 0x23, 7 => 0x27, 8 => 0x4e, 134 => 0x20d },
	'wb_rggblevelsflash' => { 5 => 0x18, 6 => 0x3c, 7 => 0x45, 8 => 0x6c, 134 => 0x214 },
	'wb_rggblevelsfluorescent' => { 5 => 0x14, 6 => 0x37, 7 => 0x3b, 8 => 0x62 },
	'wb_rggblevelsfluorescentd' => { 134 => 0x211 },
	'wb_rggblevelsfluorescentn' => { 134 => 0x212 },
	'wb_rggblevelsfluorescentw' => { 134 => 0x213 },
	'wb_rggblevelskelvin' => { 5 => 0x20, 7 => 0x40, 8 => 0x67 },
	'wb_rggblevelsmeasured' => { 8 => 0x49 },
	'wb_rggblevelspc1' => { 7 => 0x90, 8 => 0x71 },
	'wb_rggblevelspc2' => { 7 => 0x95, 8 => 0x76 },
	'wb_rggblevelspc3' => { 7 => 0x9a, 8 => 0x7b },
	'wb_rggblevelsshade' => { 5 => 0x8, 6 => 0x28, 7 => 0x2c, 8 => 0x53, 134 => 0x20e },
	'wb_rggblevelstungsten' => { 5 => 0x10, 6 => 0x32, 7 => 0x36, 8 => 0x5d, 134 => 0x210 },
	'wb_rggblevelsunknown' => { 7 => 0x1d },
	'wb_rggblevelsunknown10' => { 7 => 0x72 },
	'wb_rggblevelsunknown11' => { 7 => 0x77 },
	'wb_rggblevelsunknown12' => { 7 => 0x7c },
	'wb_rggblevelsunknown13' => { 7 => 0x81 },
	'wb_rggblevelsunknown14' => { 7 => 0x86 },
	'wb_rggblevelsunknown15' => { 7 => 0x8b },
	'wb_rggblevelsunknown16' => { 7 => 0x9f },
	'wb_rggblevelsunknown2' => { 7 => 0x4a },
	'wb_rggblevelsunknown3' => { 7 => 0x4f },
	'wb_rggblevelsunknown4' => { 7 => 0x54 },
	'wb_rggblevelsunknown5' => { 7 => 0x59 },
	'wb_rggblevelsunknown6' => { 7 => 0x5e },
	'wb_rggblevelsunknown7' => { 7 => 0x63 },
	'wb_rggblevelsunknown8' => { 7 => 0x68 },
	'wb_rggblevelsunknown9' => { 7 => 0x6d },
	'wbadjbluebalance' => { 114 => 0x8 },
	'wbadjcolortemp' => { 42 => 0x1a },
	'wbadjlighting' => { 114 => 0x15 },
	'wbadjmode' => { 114 => 0x10 },
	'wbadjredbalance' => { 114 => 0x0 },
	'wbadjrgblevels' => { 42 => 0x8 },
	'wbadjtemperature' => { 114 => 0x18 },
	'wbadjustab' => { 126 => 0x46 },
	'wbadjustgm' => { 126 => 0x47 },
	'wbbluelevel' => { 126 => 0x8006, 127 => 0x26 },
	'wbbracketmode' => { 13 => 0x9 },
	'wbbracketvalueab' => { 13 => 0xc },
	'wbbracketvaluegm' => { 13 => 0xd },
	'wbfinetuneactive' => { 42 => 0x24 },
	'wbfinetunesaturation' => { 42 => 0x28 },
	'wbfinetunetone' => { 42 => 0x2c },
	'wbgreenlevel' => { 126 => 0x8005, 127 => 0x25 },
	'wblevels' => { 91 => 0x4 },
	'wbmediaimagesizesetting' => { 25 => 0x708 },
	'wbmode' => { 90 => 0x4, 120 => 0x1015 },
	'wbredlevel' => { 126 => 0x8004, 127 => 0x24 },
	'wbscale' => { 91 => 0x0 },
	'wbshiftab' => { 21 => 0xc },
	'wbshiftgm' => { 21 => 0xd },
	'webstatement' => { 167 => 'WebStatement' },
	'whitebalance' => { 21 => 0x8, 22 => 0x7, 44 => 0x7, 45 => [0x19,0x2012], 48 => [0xa403,0xfe4e], 52 => 0x1002, 59 => 0x40, 84 => 0x3, 85 => 0xe, 86 => 0x4, 87 => 0xb, 98 => 0x5, 103 => 0x7, 126 => 0x3, 134 => 0x19, 136 => 0x7, 143 => 0x26, 146 => [0x3c,0x7], 154 => 'WhiteBalance', 157 => 'WhiteBalance' },
	'whitebalance2' => { 115 => 0x500 },
	'whitebalanceadj' => { 42 => 0x18, 109 => 0x76a43204 },
	'whitebalancebias' => { 45 => 0x2011, 120 => 0x304, 126 => 0x23 },
	'whitebalanceblue' => { 21 => 0x7 },
	'whitebalancebracket' => { 115 => 0x502, 120 => 0x303 },
	'whitebalancecomp' => { 123 => 0x1001 },
	'whitebalancefinetune' => { 98 => 0xb },
	'whitebalancemode' => { 134 => 0x1a },
	'whitebalancered' => { 21 => 0x6 },
	'whitebalancetemperature' => { 115 => 0x501 },
	'whiteboard' => { 120 => 0x301 },
	'whitepoint' => { 48 => 0x13e, 134 => 0x201, 161 => 'WhitePoint' },
	'widefocuszone' => { 84 => 0x2f },
	'widerange' => { 145 => 0x20f },
	'workcolorspace' => { 42 => 0x270 },
	'worldtimelocation' => { 126 => 0x3a, 134 => 0x22 },
	'writer-editor' => { 54 => 0x7a },
	'x3filllight' => { 146 => 0x12 },
	'xmp' => { 49 => 'XMP' },
	'xpauthor' => { 48 => 0x9c9d },
	'xpcomment' => { 48 => 0x9c9c },
	'xpkeywords' => { 48 => 0x9c9e },
	'xposition' => { 48 => 0x11e },
	'xpsubject' => { 48 => 0x9c9f },
	'xptitle' => { 48 => 0x9c9b },
	'xresolution' => { 48 => 0x11a, 57 => 0x3, 141 => 0x0, 161 => 'XResolution' },
	'xyresolution' => { 51 => 0x3 },
	'ycbcrcoefficients' => { 48 => 0x211, 161 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 48 => 0x213, 161 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 48 => 0x212, 161 => 'YCbCrSubSampling' },
	'yearcreated' => { 59 => 0x10, 66 => 0xc },
	'yposition' => { 48 => 0x11f },
	'yresolution' => { 48 => 0x11b, 57 => 0x5, 141 => 0x4, 161 => 'YResolution' },
	'zonematching' => { 88 => 0x10a, 90 => 0x3a },
	'zonematchingon' => { 86 => 0x75 },
	'zoomsourcewidth' => { 4 => 0x24 },
	'zoomstepcount' => { 118 => 0x300, 120 => 0x100d },
	'zoomtargetwidth' => { 4 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'abstract' => 1,
	'adobe' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobemrw' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'aeinfo' => 1,
	'afaperture' => 1,
	'afarea' => 1,
	'afareaheight' => 1,
	'afareaheights' => 1,
	'afareawidth' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afimageheight' => 1,
	'afimagewidth' => 1,
	'afinfo' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afpointsinfocus1d' => 1,
	'afpointsselected' => 1,
	'albumartist' => 1,
	'albumcoverurl' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'aliaslayermetadata' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphasample' => 1,
	'analogbalance' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'applestoreid' => 1,
	'applicationnotes' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectratio' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'asshotneutral' => 1,
	'association' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'audiences' => 1,
	'audiobitrate' => 1,
	'audiobytes' => 1,
	'audiochannels' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecname' => 1,
	'audiodelay' => 1,
	'audioencoding' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audioinfo' => 1,
	'audiolayer' => 1,
	'audiomode' => 1,
	'audiosamplebits' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorurl' => 1,
	'aux' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'badfaxlines' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'basisobject' => 1,
	'batteryinfo' => 1,
	'batterylevel' => 1,
	'beatsperminute' => 1,
	'binaryfilter' => 1,
	'bitrate' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperrunlength' => 1,
	'blackleveldeltah' => 1,
	'blackleveldeltav' => 1,
	'blacklevelrepeatdim' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blocksperframe' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'bufferaverage' => 1,
	'burstshot' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calibrationdatetime' => 1,
	'camera' => 1,
	'camerabacktype' => 1,
	'cameracalibration1' => 1,
	'cameracalibration2' => 1,
	'cameradatetime' => 1,
	'camerainfo' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraowner' => 1,
	'cameraprofileversion' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasetup' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo2' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerainfounknown8' => 1,
	'canoncamerasettings' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canseektoend' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'casio' => 1,
	'cc' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfapattern2' => 1,
	'cfaplanecolor' => 1,
	'cfarepeatpatterndim' => 1,
	'channelmode' => 1,
	'charcount' => 1,
	'charcountwithspaces' => 1,
	'charset' => 1,
	'chartarget' => 1,
	'chromaticadaptation' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'ciff' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanfaxdata' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'cmmflags' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codingmethods' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance2' => 1,
	'colorbalance3' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcomponents' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorinfo' => 1,
	'colorinfod30' => 1,
	'colormap' => 1,
	'colormatrix1' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'company' => 1,
	'compatibility' => 1,
	'compilation' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compressed' => 1,
	'compressedtext' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressor' => 1,
	'compressorid' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'cont' => 1,
	'containerformat' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contenttype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'cpuversions' => 1,
	'crdinfo' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'cropdata' => 1,
	'cropped' => 1,
	'cross-reference' => 1,
	'crs' => 1,
	'cuepoint' => 1,
	'currentbitrate' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'data' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datareference' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datetimecreated' => 1,
	'dc' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'depth' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicesettingdescription' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'dinf' => 1,
	'director' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'distribution' => 1,
	'dngadobedata' => 1,
	'dngpentaxdata' => 1,
	'dngprivatedata' => 1,
	'docclass' => 1,
	'docrights' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'ducky' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustremovaldata' => 1,
	'dvdid' => 1,
	'dynamicrangeoptimizer' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'edittagarray' => 1,
	'effectivebw' => 1,
	'effectivemaxaperture' => 1,
	'effectsvisible' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedusing' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingprocess' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encryption' => 1,
	'endpoints' => 1,
	'eppim' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipment2' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'evalstate' => 1,
	'events' => 1,
	'exif' => 1,
	'exif_profile' => 1,
	'exifinfo' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'exitpupilposition' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposureadjust' => 1,
	'exposureinfo' => 1,
	'extcache' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedstreamprops' => 1,
	'extenderstatus' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extrasamples' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fileid' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileowner' => 1,
	'fileproperties' => 1,
	'filerul' => 1,
	'files' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filetype' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filtering' => 1,
	'finalframeblocks' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flags' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashon' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'focallength35efl' => 1,
	'focusinfo' => 1,
	'focusinfo2' => 1,
	'focuspos' => 1,
	'footnotes' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'fotostation' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framecount' => 1,
	'framepriority' => 1,
	'framerate' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'frametype' => 1,
	'free' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'fujifilm' => 1,
	'fujilayout' => 1,
	'gain' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'generator' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gps' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'graphicconverter' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasaudio' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hcusage' => 1,
	'hdrl' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightendpoints' => 1,
	'http-equiv' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'id' => 1,
	'id3' => 1,
	'id3v1' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'identification' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'image' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imageoffset' => 1,
	'imageprintstatus' => 1,
	'imageprocessing2' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'index' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'infolist' => 1,
	'information' => 1,
	'initialkey' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputprofile' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'iptc' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isospeed' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'kbytesize' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'kids' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakeffectsifd' => 1,
	'konicaminolta' => 1,
	'languagelist' => 1,
	'lastkeyframetime' => 1,
	'lastmodifier' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdataunknown' => 1,
	'lensfocalrange' => 1,
	'lensshading' => 1,
	'lensspec' => 1,
	'lightness' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationtable' => 1,
	'lines' => 1,
	'linksuptodate' => 1,
	'lit' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'lyrics_synchronised' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'makeandmodel' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'marker' => 1,
	'markerid' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxsubfilesize' => 1,
	'maxval' => 1,
	'mcdi' => 1,
	'mdat' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaindex' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'microsoft' => 1,
	'mie' => 1,
	'mimetype' => 1,
	'minf' => 1,
	'minimumbitrate' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsa100' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'modeextension' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modenumber' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'mood' => 1,
	'mosaicpattern' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'movieheader' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'msstereo' => 1,
	'multiexposure' => 1,
	'multimediatype' => 1,
	'multiquality' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'namelength' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nefcurve1' => 1,
	'nefcurve2' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikoncapturedata' => 1,
	'nikoncaptureoffsets' => 1,
	'nikonpreview' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nomssmarttags' => 1,
	'notes' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofinks' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'objecttype' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'offsetorigin' => 1,
	'offsetxy' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2200' => 1,
	'olympus2300' => 1,
	'olympus2400' => 1,
	'olympus2500' => 1,
	'olympus2600' => 1,
	'olympus2700' => 1,
	'olympus2800' => 1,
	'olympus2900' => 1,
	'opacity' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optimalbitrate' => 1,
	'opto-electricconvfactor' => 1,
	'orderingrestrictions' => 1,
	'organization' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'otherimage' => 1,
	'otherimagelength' => 1,
	'otherimagestart' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'packets' => 1,
	'padding' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagenormal' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'palette' => 1,
	'palettehistogram' => 1,
	'panasonic' => 1,
	'paragraphs' => 1,
	'parameter' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'partialpalette' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'patternangle' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'peakbitrate' => 1,
	'peakvalue' => 1,
	'pentax' => 1,
	'pentaxtags' => 1,
	'performer' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'period' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'photoeffectsdata' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopbgrthumbnail' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'pictureinfo' => 1,
	'pieceinfo' => 1,
	'pixelaspectratio' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'places' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playselection' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'pragma' => 1,
	'preferredrate' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewdescription' => 1,
	'previewduration' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewmimetype' => 1,
	'previewpict' => 1,
	'previewtime' => 1,
	'previewtype' => 1,
	'previewversion' => 1,
	'primaryafpoint' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printquality' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'private' => 1,
	'proccessinginfo' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'product' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecopyright' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profilesequencedesc' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'ps2crdvmsize' => 1,
	'ps2renteringintent' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'quickmaskinfo' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rasterpadding' => 1,
	'rawdata' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2_2' => 1,
	'rawdevelopment' => 1,
	'rawdevelopment2' => 1,
	'rawimagefullsize' => 1,
	'rawimagemode' => 1,
	'rawinfo' => 1,
	'rawinfo2' => 1,
	'rawjpginfo' => 1,
	'readerrequirements' => 1,
	'recengineer' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redeyedata' => 1,
	'redeyereduction' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'reductionmatrix1' => 1,
	'reductionmatrix2' => 1,
	'redx' => 1,
	'redy' => 1,
	'refresh' => 1,
	'relatedimagefile' => 1,
	'renderingintent' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'requirements' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohdatetime1' => 1,
	'ricohdatetime2' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'sampleformat' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scandate' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerserialnumber' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'scriptcommand' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'sensorbottomborder' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'shadowendpoints' => 1,
	'shakereductioninfo' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'significantbits' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'softedit' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimagevolumename' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spatialfrequencyresponse' => 1,
	'spatialorientation' => 1,
	'specialeffectsopticalfilter' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2_key' => 1,
	'srgbrendering' => 1,
	'stamptoolcount' => 1,
	'startofframe' => 1,
	'stbl' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitrateprops' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'stridable' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsecdatetimeoriginal' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'suggestedpalette' => 1,
	'summaryinfo' => 1,
	't4options' => 1,
	't6options' => 1,
	'taggingtime' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetprinter' => 1,
	'targetxy' => 1,
	'technician' => 1,
	'technology' => 1,
	'template' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textinfo' => 1,
	'textualdata' => 1,
	'things' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeoffset' => 1,
	'timescale' => 1,
	'titlelen' => 1,
	'titleofparts' => 1,
	'titlesortorder' => 1,
	'tocitems' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totaledittime' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'track' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackcreatedate' => 1,
	'trackduration' => 1,
	'trackheader' => 1,
	'trackid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackmodifydate' => 1,
	'trackversion' => 1,
	'trackvolume' => 1,
	'transferrange' => 1,
	'transfomation' => 1,
	'transform' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapped' => 1,
	'typeoforiginal' => 1,
	'ucrbg' => 1,
	'uncompressed' => 1,
	'unicodealphanames' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknownblock1' => 1,
	'unknownblock2' => 1,
	'unknowntags' => 1,
	'unsharpdata' => 1,
	'unused' => 1,
	'url_list' => 1,
	'usedextensionnumbers' => 1,
	'useradjsba_rgbshifts' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'userselectgrouptitle' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'utm' => 1,
	'uuid-exif' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-unknown' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'vary' => 1,
	'vbrpeak' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticalunits' => 1,
	'vibrationreduction' => 1,
	'video' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoheight' => 1,
	'videomode' => 1,
	'videoquality' => 1,
	'videosize' => 1,
	'videowidth' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'visibleoutputs' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vr_0x66' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'wb_grbglevels' => 1,
	'wb_grgblevels' => 1,
	'wbadjdata' => 1,
	'wcsprofiles' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whitelevel' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'wide' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windowtarget' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wordcount' => 1,
	'workflowurl' => 1,
	'workingpath' => 1,
	'writer' => 1,
	'xclippathunits' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xml' => 1,
	'xmldata' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'ytarget' => 1,
	'zoom' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

# insert any user-defined tags into our tag lookup
if (defined %Image::ExifTool::UserDefined) {
    my ($table, %tableNum, $tagID);
    my $tnum = 0; # make hash lookup to get table numbers
    foreach $table (@tableList) {
        $tableNum{$table} = $tnum++;
    }
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        $tnum = $tableNum{$table};
        unless ($tnum) {
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $userTable = $Image::ExifTool::UserDefined{$table};
        foreach $tagID (Image::ExifTool::TagTableKeys($userTable)) {
            my $newInfo = $$userTable{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
            } else {
                $newInfo = $$userTable{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc($$newInfo{Name});
            # add to lookup even though we don't know it is writable
            # (to save speed by not having to load the module)
            my $lookup = $tagLookup{$lcTag};
            $lookup or $lookup = $tagLookup{$lcTag} = { };
            if ($$lookup{$tnum}) {
                my $le = $$lookup{$tnum};
                my @ids = (ref $le eq 'ARRAY') ? @{$le} : ( $le );
                # only add new tag ID if it didn't already exist
                next if grep /^$tagID$/, @ids;
                push @ids, $tagID;
                $$lookup{$tnum} = \@ids;
            } else {
                $$lookup{$tnum} = $tagID;
            }
            # add any new subdirectory tables
            next unless $$newInfo{SubDirectory};
            my $subTable = $newInfo->{SubDirectory}->{TagTable};
            next unless $subTable and not defined $tableNum{$subTable};
            next if $Image::ExifTool::UserDefined{$subTable};
            no strict 'refs';
            next unless defined %$subTable;
            $Image::ExifTool::UserDefined{$subTable} = \%$subTable;
            push @userTables, $subTable;
            # save parent table name so we can load it when necessary
            $$subTable{PARENT} = $table;
        }
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2007, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
