/*******************************************************************************************************************************************
 chscale.c
*******************************************************************************************************************************************/

#include "chscale.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//-----------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_DYNAMIC_METACLASS (CHScale);

//-----------------------------------------------------------------------------------------------------------------------------------------
// constructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CHScale::CHScale (CContainer *inOwner, const CScaleListener *inListener)
	:CScale	 (inOwner, inListener)
{
	// launch the gtk instanciation process
	if (inOwner != NULL) CWidget::CreateWidget (this);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// destructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CHScale::~CHScale ()
{
	// gtk deletion coherence requested
	CWidget::DestroyWidget (this);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// gtk instanciation
//-----------------------------------------------------------------------------------------------------------------------------------------
GtkWidget * CHScale::PerformWidgetInstanciate ()
{
	// ok
	return ::gtk_hscale_new_with_range (m_Min, m_Max, m_Step);
}

