/******************************************************************************************************************************************
 cscrollview.h

 CClass						CClass
 |--CSerialized					|--CSerialized
    |--CMetaModule				   |--CMetaModule
       |--CObject				      |--CObjectListener
          |--CComponent				      	 |
             |--CControl				 |
                |--CWidget				 |--CWidgetListener
                   |--CContainer			    |
                      |--CScrollView			    |--CScrollViewListener

 GtkScrolledWindow mapping.
******************************************************************************************************************************************/

#ifndef __CSCROLLVIEW_H__
#define __CSCROLLVIEW_H__

#include "ccontainer.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// cscrollview xml serialization constants
//-----------------------------------------------------------------------------------------------------------------------------------------
// <cscrollview horizontal="automatic|always|never" vertical="automatic|always|never">
//   ...
// </cscrollview>
//-----------------------------------------------------------------------------------------------------------------------------------------
static CString XML_SCROLLVIEW_ELEMENT		("cscrollview");
static CString XML_SCROLLVIEW_ATTR_HPOLICY	("horizontal");
static CString XML_SCROLLVIEW_ATTR_VPOLICY	("vertical");

//-----------------------------------------------------------------------------------------------------------------------------------------
// CScrollViewListener class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CScrollViewListener : public CWidgetListener
{
	// instanciation section
	public :

		CScrollViewListener		();
		virtual ~CScrollViewListener	() =0;

	// specific listening interface
	public :

		// called on the inSender scroll view when its child is scrolled
		virtual void			OnScroll	(CObject *inSender, const GtkScrollType inScrollType)	{ }
	
		// metaclass association
		SECTION_GENERIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_GENERIC_METACLASS ('_slw', CScrollViewListener, CWidgetListener);

//-----------------------------------------------------------------------------------------------------------------------------------------
// CScrollView class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CScrollView : public CContainer
{
	// instanciation section
	public :

		CScrollView			(CContainer *inOwner=NULL, const CWidgetListener *inListener=NULL);
		virtual ~CScrollView		();

	// protected specific gtk widget requests handling
	protected :

		// gtk widget instanciation and initialization
		virtual GtkWidget *		PerformWidgetInstanciate	();
		virtual void			PerformWidgetInitialize		();

	// protected container process handling
	protected :

		// child addon / removal request handling
		virtual void			PerformContainerAdd		(CWidget *inChild);
		virtual void			PerformContainerRemove		(CWidget *inChild);

	// specific widget functions
	public :

		// scroll bars policy access : horizontal first, vertical second
		virtual void			SetPolicies			(const GtkPolicyType, const GtkPolicyType);
		GtkPolicyType			GetHPolicy			() const;
		GtkPolicyType			GetVPolicy			() const;

		// shadow type
		virtual void			SetShadowType			(const GtkShadowType);
		GtkShadowType			GetShadowType			() const;

	// CSerialized redefinition
	public :

		// scroll view xml serialization
		virtual void			Serialize			(CXMLElementNode *&ioXMLElementNode, const int inMode)
										 THROWABLE;
	
	// protected section
	protected :

		// static event connection
		static void 			OnScroll 			(GtkScrolledWindow *, GtkScrollType, gboolean, gpointer);

		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_DYNAMIC_METACLASS ('sclw', CScrollView, CContainer);

#endif



