/*******************************************************************************************************************************************
 cscale.h
 
 CClass					CClass
 |--CSerialized				|--CSerialized
    |--CMetaModule			   |--CMetaModule
       |--CObject			      |--CObjectListener
          |--CComponent			         |
	     |--CControl			 |
	        |--CWidget			 |--CWidgetListener
		   |--CRange			    |--CRangeListener
		      |--CScale			       |--CScaleListener

 Abstract class for horizontal and vertical scale global definitions.
*******************************************************************************************************************************************/

#ifndef __CSCALE_H__
#define __CSCALE_H__

#include "crange.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// cscale xml serialization constant definition
//-----------------------------------------------------------------------------------------------------------------------------------------
// <cscale digits="UInt8" draw-value="true|false" value-position="left|right|top|bottom">
//   ...
// </cscale>
//-----------------------------------------------------------------------------------------------------------------------------------------
static CString XML_SCALE_ELEMENT		("cscale");
static CString XML_SCALE_ATTR_DIGITS		("digits");
static CString XML_SCALE_ATTR_DRAW_VALUE	("draw-value");
static CString XML_SCALE_ATTR_VALUE_POSITION	("value-position");

//-----------------------------------------------------------------------------------------------------------------------------------------
// CScaleListener class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CScaleListener : public CRangeListener
{
	// instanciation section
	public :

		CScaleListener			();
		virtual ~CScaleListener		() =0;

	// specific listener section
	public :

		// called to change how the scale value is displayed by the inSender scale by formatting the given ioString depending on
		// the given inValue such as adding decimal definition or displaying a metric...
		virtual void			OnValueQueryFormat	(CObject *inSender, Float64 inValue, CString &ioString)	{ }

		// metaclass association
		SECTION_GENERIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_GENERIC_METACLASS ('_scl', CScaleListener, CRangeListener);

//-----------------------------------------------------------------------------------------------------------------------------------------
// CScale class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CScale : public CRange
{
	// instanciation section
	public :

		CScale				(CContainer *inOwner=NULL, const CScaleListener *inListener=NULL);
		virtual ~CScale			() =0;

	// protected cobject redefinition
	protected :

		// expected listener type : CScaleListener
		virtual CMetaClass *		ListenerMustBe		() const;

	// protected gtk section
	protected :

		// cscale associated gtk widget initialization
		virtual void			PerformWidgetInitialize		();

	// specific api section
	public :

		// the precision to be displayed by the scale
		virtual void			SetDigits			(const UInt8 inDigits);
		UInt8				GetDigits			() const;

		// whether the current value is displayed as a string next to the slider
		virtual void			SetDrawValue			(const bool inDrawValue);
		bool				GetDrawValue			() const;

		// the position in which the current value is displayed
		virtual void			SetValuePosition		(const GtkPositionType inGtkPositionType);
		GtkPositionType			GetValuePosition		() const;

	// serialization
	public :

		// scale layer gtkol serialization
		virtual void			Serialize			(CXMLElementNode *&ioXMLElementNode, const int inMode)
										 THROWABLE;

	// protected section
	protected :

		static gchar *			OnValueQueryFormat		(GtkScale *, gdouble, gpointer); 

		// metaclass association
		SECTION_GENERIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_GENERIC_METACLASS ('scle', CScale, CRange);

#endif
