/*******************************************************************************************************************************************
 cform.h
 
 CClass					CClass
 |--CSerialized				|--CSerialized
    |--CMetaModule			   |--CMetaModule
       |--CObject			      |--CObjectListener
          |--CComponent			         |
	     |--CControl			 |
	        |--CWidget			 |--CWidgetListener
		   |--CContainer		    |
		      |--CForm			    |--CFormListener

 Gtkol basic form layer. CForm implements the GtkWindow widget.
*******************************************************************************************************************************************/

#ifndef __CFORM_H__
#define __CFORM_H__

#include "ccontainer.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// form state definition
//-----------------------------------------------------------------------------------------------------------------------------------------
typedef enum
{
	FORMSTATE_ICONIFIED			=1,	// the form is iconified
	FORMSTATE_MAXIMIZED			=2,	// the form is maximized

	FORMSTATE_STICKY			=4,	// the form is displayed on all desktops

	FORMSTATE_FULLSCREEN			=8,	// the form is in full screen mode

	FORMSTATE_ABOVE				=16,	// the form is kept above all other forms
	FORMSTATE_BELOW				=32	// the form is kept below all other forms
} TFormState;

//-----------------------------------------------------------------------------------------------------------------------------------------
// form properties definition
//-----------------------------------------------------------------------------------------------------------------------------------------
typedef enum
{
	FORMPROPERTIE_RESIZEABLE		=1,	// the form can be resized
	FORMPROPERTIE_DECORATED			=2,	// the form is decorated, i.e. has a title border, resize controls and so on...
	FORMPROPERTIE_TASKBARHINT		=4,	// the form is present in the desktop taskbar
	FORMPROPERTIE_PAGERHINT			=8	// the form is present in the desktop pager
} TFormProperties;

//-----------------------------------------------------------------------------------------------------------------------------------------
// form xml constants
//-----------------------------------------------------------------------------------------------------------------------------------------
// <cform caption="string" maximize="bool" minimize="bool" fullscreen="bool" sticky="bool" above="bool" below="bool" resizeable="bool"
//        decorated="bool" taskbar-hint="bool" pager-hint="bool">
//    ...
// </cform>
//-----------------------------------------------------------------------------------------------------------------------------------------
static CString XML_FORM_ELEMENT			("cform");
static CString XML_FORM_ATTR_CAPTION		("caption");
static CString XML_FORM_ATTR_MAXIMIZE		("maximize");
static CString XML_FORM_ATTR_MINIMIZE		("minimize");
static CString XML_FORM_ATTR_FULLSCREEN		("fullscreen");
static CString XML_FORM_ATTR_STICKY		("sticky");
static CString XML_FORM_ATTR_ABOVE		("above");
static CString XML_FORM_ATTR_BELOW		("below");
static CString XML_FORM_ATTR_RESIZEABLE		("resizeable");
static CString XML_FORM_ATTR_DECORATED		("decorated");
static CString XML_FORM_ATTR_TASKBARHINT	("taskbar-hint");
static CString XML_FORM_ATTR_PAGERHINT		("pager-hint");

//-----------------------------------------------------------------------------------------------------------------------------------------
// CFormListener class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CFormListener : public CWidgetListener
{
	// instanciation section
	public :

		CFormListener			();
		virtual ~CFormListener		() =0;

	// specific form listener functions
	public :

		// called to get permission to close the inSender form
		virtual void			OnQueryClose			(CObject *inSender, Bool &ioDoClose)			{ }

		// called when the inSender form is closed
		virtual void			OnClose				(CObject *inSender)					{ }

		// called when the state of the inSender form changes (see TFormState)
		virtual void			OnStateChange			(CObject *inSender, int inNewState)			{ }

		// metaclass association
		SECTION_GENERIC_METACLASS;
};

// class tag and metaclass declarations
DECLARE_GENERIC_METACLASS ('_fom', CFormListener, CWidgetListener);

//-----------------------------------------------------------------------------------------------------------------------------------------
// CForm class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CForm : public CContainer
{
	// instanciation section
	public :

		CForm				(CComponent *inOwner=NULL, const CFormListener *inListener=NULL);
		virtual ~CForm			();

	// specific form wigdet generic instanciation process requests handling
	protected :

		// gtk widget instanciation and initialization
		virtual GtkWidget *		PerformWidgetInstanciate	();
		virtual void			PerformWidgetInitialize		();

	// CObject redefintion
	protected :

		// gtkol widget listener affectation; should be derived from CFormListener
		virtual const CMetaClass *	ListenerMustBe			() const;

	// CComponent redefinition
	public :

		// expected owner type __metaclasses(CComponent)
		virtual CMetaClasses		OwnerMustBe			() const;

	// CControl redefinition
	public :

		// bounds affectation
		virtual void			SetBounds			(const TBounds &inBounds);

	// cform specific functions
	public :

		// common hotkeys table access
		static GtkAccelGroup *		GetAccelGroup			();

		// form caption
		virtual void			SetCaption			(const CString &inCaption);
		CString				GetCaption			() const;

		// maximize, minimize, restore
		virtual void			Maximize			();
		virtual void			Minimize			();
		virtual void			FullScreen			();
		virtual void			Restore				();

		// multi desktops (window manager dependant, some may unstick it right after)
		virtual void			Stick				();
		virtual void			UnStick				();

		// keep above, keep below
		virtual void			KeepAbove			(const bool inAbove);
		virtual void			KeepBelow			(const bool inBelow);

		// form properties
		virtual void			SetProperties			(const int inFormProperties);
		int				GetProperties			() const;

		// current form state (see TFormState)
		int				GetState			() const;

		// close the form (main form would result in application ending, all others in a hide call)
		virtual void			Close				();

	// CSerialized redefinition
	public :

		// xml cform serialization
		virtual void			Serialize			(CXMLElementNode *&ioXMLElementNode, 
										 const int inMode) THROWABLE;

	// protected attributes
	protected :

		// common hotkeys table
		static GtkAccelGroup *		m_AccelGroup;

		// form state, properties
		int				m_FormState;

		// static listeners redefinitions ans specific ones
		static gboolean			OnQueryDestroy			(GtkWidget *, GdkEvent *, gpointer);
		static void			OnDestroy			(GtkWidget *, gpointer);
		static gboolean			OnConfigure			(GtkWidget *, GdkEventConfigure	*, gpointer);
		static gboolean			OnStateEvent			(GtkWidget *, GdkEvent *, gpointer);

		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// class tag and metaclass declarations
DECLARE_DYNAMIC_METACLASS ('form', CForm, CContainer);

#endif
