/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4 c-style: "K&R" -*- */

/*-----------------------------------------------------------------------------
   libgpiv - library for Particle Image Velocimetry

   Copyright (C) 2002, 2003, 2004 Gerber van der Graaf

   This file is part of libgpiv.

   Libgpiv is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  



-------------------------------------------------------------------------------
FILENAME:                gpiv.h
LIBRARY:                 libgpiv

EXTERNAL FUNCTIONS:

LAST MODIFICATION DATE: $Id: gpiv.h,v 1.19 2006/01/31 13:30:12 gerber Exp $
 --------------------------------------------------------------------------- */
#ifndef __LIBGPIV_H__
#define __LIBGPIV_H__

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <gsl/gsl_fit.h>
#include <assert.h>

#include <time.h>
#include <fftw.h>
#include <rfftw.h>
/* BUGFIX: to be done: #include <fftw3.h> */
#include <hdf5.h>
#include <glib.h>
#ifndef DISABLE_DAC
#include <libraw1394/raw1394.h>
#include <libdc1394/dc1394_control.h>
#endif /* DISABLE_DAC */


#define LIBNAME "LIBGPIV"	        /* Library name */
#define GPIV_SYSTEM_RSC_FILE "gpiv.conf"/* System wide parameter resources file */
#define GPIV_HOME_RSC_FILE ".gpivrc"	/* home parameter resources file */
#define GPIV_NIMG_MAX 40                /* maximum number of images to be retrieved */
#define GPIV_MAX_CHARS 80		/* Maximum number of characters on a line */
#define GPIV_MAX_LINES 6400		/* Maximum number of lines in a datafile */
#define GPIV_MAX_LINES_C 20		/* Maximum number of comment lines in a datafile */
#define GPIV_MAX_IMG_SIZE 2000          /* Maximum size of image */
#define GPIV_MAX_IMG_DEPTH 16           /* Maximum image depth (in bits) */
#define GPIV_MIN_INTERR_SIZE 4	        /* Minimum size of interrogation area */
#define GPIV_MAX_INTERR_SIZE 128	/* Maximum size of interrogation area */
#define GPIV_NBINS_MAX 100		/* maximum bins for histogram  */
#define GPIV_NBINS_DEFAULT 10           /* Default number of nbins */
#define GPIV_SNR_NAN 99.0               /* snr value for disabled estimator (tested on isnan) */

#ifndef SYSTEM_RSC_DIR
#define SYSTEM_RSC_DIR "/etc"	/* System wide resource directory */
#endif  /* SYSTEM_RSC_DIR */


/*
 * Data declarations
 */

/*
 * __GpivPivData holds teh variables of the PIV data estimators and some
 * ststistics, like mean, minimum, maximum and standard deviation ro rms 
 * values
 */
typedef struct __GpivPivData GpivPivData;
struct __GpivPivData {		/* Data structure of PIV data */
    int nx;			/* number of data in x-direction */
    int ny;			/* number of data in y-direction */
    float **point_x;		/* position of data point in x-direction */
    float **point_y;		/* position of data point in y-direction */
    float **dx;			/* particle image displacement in x-direction */
    float **dy;			/* particle image displacement in y-direction */
    float **snr;		/* signal to noise ratio */
    int **peak_no;		/* N-highest covariance peak number */
    float **scalar;		/* scalar value representing vorticity in 
                                   z-direction, shear strain or normal strain */
    gfloat mean_dx;             /* mean value in x-displacements */
    gfloat sdev_dx;             /* rms value in x-displacements */
    gfloat min_dx;              /* minimum value in x-displacements */
    gfloat max_dx;              /* maximum value in x-displacements */

    gfloat mean_dy;             /* mean value in y-displacements */
    gfloat sdev_dy;             /* rms value in y-displacements */
    gfloat min_dy;              /* minimum value in y-displacements */
    gfloat max_dy;              /* maximum value in y-displacements */
};

/*
 * __GpivScalarData holds scalar data, mostly derived values from  
 * __GpivPivData 
*/
typedef struct __GpivScalarData GpivScalarData;
struct __GpivScalarData {		/* Data structure of PIV data */
    int nx;			/* number of data in x-direction */
    int ny;			/* number of data in y-direction */
    float **point_x;		/* position of data point in x-direction */
    float **point_y;		/* position of data point in y-direction */
    float **scalar;		/* scalar value representing vorticity in z-direction, shear strain or 
				   normal strain */
    int **flag;		        /* a flag; always nice, used for whatever it may be (disabel data) */
};


/*
 * __GpivBinData are used for making up histograms in bins or klasses
 */
typedef struct __GpivBinData GpivBinData;
struct __GpivBinData {		/* Data structure of histogram bins */
    int nbins;			/* number of bins in histogram, to be read as a parameter */
    int nbins_logic;		/* check if nbins parameter has been read */
    int *count;			/* value containing number of occurences at bin# */
    float *bound;		/* lower boundary of bin# */
    float *centre;		/* centre point of bin# */
    float min;		        /* minimum value of input data */
    float max;		        /* maximum value of input data */
};



#ifndef DISABLE_DAC
#include <gpiv/dac.h>
#endif /* DISABLE_DAC */
#include <gpiv/img.h>
#include <gpiv/imgproc.h>
#include <gpiv/eval.h>
#include <gpiv/eval_speed.h>
#include <gpiv/valid.h>
#include <gpiv/post.h>
#include <gpiv/io.h>
#include <gpiv/utils.h>

#ifndef GPIV_DISABLE_DEPRECATED
#include <gpiv/back_intface.h>
#endif


#endif /* __LIBGPIV_H__ */
