/* GNOME DB library
 * Copyright (C) 1999 - 2007 The GNOME Foundation.
 *
 * AUTHORS:
 * 	Rodrigo Moya <rodrigo@gnome-db.org>
 *      Vivien Malerba <malerba@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
 
#ifndef __LIBGNOME_DB_H_
#define __LIBGNOME_DB_H_

#include <libgda/libgda.h>
#include <libgnomedb/gnome-db-decl.h>
#include <libgnomedb/gnome-db-tools.h>

/* interfaces */
#include <libgnomedb/gnome-db-data-entry.h>
#include <libgnomedb/gnome-db-data-widget.h>

/* data data-entries widgets and cell renderers */
#include <libgnomedb/data-entries/gnome-db-data-cell-renderer-boolean.h>
#include <libgnomedb/data-entries/gnome-db-data-cell-renderer-combo.h>
#include <libgnomedb/data-entries/gnome-db-data-cell-renderer-info.h>
#include <libgnomedb/data-entries/gnome-db-data-cell-renderer-textual.h>
#include <libgnomedb/data-entries/gnome-db-entry-boolean.h>
#include <libgnomedb/data-entries/gnome-db-entry-combo.h>
#include <libgnomedb/data-entries/gnome-db-entry-none.h>
#include <libgnomedb/data-entries/gnome-db-entry-shell.h>
#include <libgnomedb/data-entries/gnome-db-entry-string.h>
#include <libgnomedb/data-entries/gnome-db-entry-common-time.h>
#include <libgnomedb/data-entries/gnome-db-entry-time.h>
#include <libgnomedb/data-entries/gnome-db-entry-date.h>
#include <libgnomedb/data-entries/gnome-db-entry-timestamp.h>
#include <libgnomedb/data-entries/gnome-db-entry-wrapper.h>
#include <libgnomedb/data-entries/gnome-db-format-entry.h>

/* widgets and objects */
#include <libgnomedb/gnome-db-basic-form.h>
#include <libgnomedb/gnome-db-combo.h>
#include <libgnomedb/gnome-db-connection-properties.h>
#include <libgnomedb/gnome-db-data-source-selector.h>
#include <libgnomedb/gnome-db-data-store.h>
#include <libgnomedb/gnome-db-form.h>
#include <libgnomedb/gnome-db-data-import.h>
#include <libgnomedb/gnome-db-data-widget-info.h>
#include <libgnomedb/gnome-db-dsn-editor.h>
#include <libgnomedb/gnome-db-dsn-spec.h>
#include <libgnomedb/gnome-db-raw-form.h>
#include <libgnomedb/gnome-db-raw-grid.h>
#include <libgnomedb/gnome-db-grid.h>
#include <libgnomedb/gnome-db-find-dialog.h>
#include <libgnomedb/gnome-db-login-dialog.h>
#include <libgnomedb/gnome-db-login.h>
#include <libgnomedb/gnome-db-provider-selector.h>
#include <libgnomedb/gnome-db-stock.h>
#include <libgnomedb/gnome-db-server-operation.h>
#include <libgnomedb/gnome-db-transaction-status.h>
#include <libgnomedb/gnome-db-dsn-assistant.h>

G_BEGIN_DECLS

void         gnome_db_init             (const gchar *app_id, const gchar *version, gint nargs, gchar *args[]);
void         gnome_db_main_run         (GdaInitFunc init_func, gpointer user_data);
void         gnome_db_main_quit        (void);

G_END_DECLS

#endif
