/* $Id: move.c,v 1.2 2005/05/21 19:44:21 cegger Exp $
******************************************************************************

   Graphics library for GGI. WMH stuff.

   Copyright (C) 2004 Peter Ekberg	[peda@lysator.liu.se]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "config.h"
#include "pseudostubswmh.h"

int GGIwmh_pseudo_stubs_move(ggi_visual *vis,int x,int y)
{
	wmhpriv *priv = LIBGGI_WMHEXT(vis);

	return ggiWmhMove(priv->priv, x, y);
}

int GGIwmh_pseudo_stubs_getpos(ggi_visual *vis,int *x,int *y)
{
	wmhpriv *priv = LIBGGI_WMHEXT(vis);

	return ggiWmhGetPos(priv->priv, x, y);
}

int GGIwmh_pseudo_stubs_getsize(ggi_visual *vis,int *x,int *y)
{
	wmhpriv *priv = LIBGGI_WMHEXT(vis);

	return ggiWmhGetSize(priv->priv, x, y);
}

int GGIwmh_pseudo_stubs_resize(ggi_visual *vis,int x,int y)
{
	wmhpriv *priv = LIBGGI_WMHEXT(vis);

	return ggiWmhResize(priv->priv, x, y);
}

int GGIwmh_pseudo_stubs_allowresize(ggi_visual *vis, int xmin, int ymin,
			 int xmax, int ymax, int xstep, int ystep)
{
	wmhpriv *priv = LIBGGI_WMHEXT(vis);

	return ggiWmhAllowResize(priv->priv, xmin, ymin, xmax, ymax, xstep, ystep);
}

int GGIwmh_pseudo_stubs_maximize(ggi_visual *vis,int x,int y)
{
	wmhpriv *priv = LIBGGI_WMHEXT(vis);

	return ggiWmhMaximize(priv->priv, x, y);
}

int GGIwmh_pseudo_stubs_moveicon(ggi_visual *vis,int x,int y)
{
	wmhpriv *priv = LIBGGI_WMHEXT(vis);

	return ggiWmhMoveIcon(priv->priv, x, y);
}
